/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mibmgr;

import java.io.IOException;
import se.ericsson.cello.ncli.mibmgr.DiskCleaner;
import se.ericsson.cello.ncli.mibmgr.DumpFileWriter;
import se.ericsson.cello.ncli.mibmgr.InputFileReader;
import se.ericsson.cello.ncli.mibmgr.MibDumpListener;
import se.ericsson.cello.ncli.mibmgr.MoAttribute;
import se.ericsson.cello.ncli.mibmgr.MoAttributesCollector;
import se.ericsson.cello.ncli.server.logging.Log;

public class MibDumpHandler {
    private String lastDumpFile;
    private boolean lastDumpSuccessful = false;
    private final Integer STOP_FLAG = new Integer(1);

    public void generateDump(String string, int n, MibDumpListener mibDumpListener) {
        InputFileReader inputFileReader = new InputFileReader(string);
        DumpFileWriter dumpFileWriter = new DumpFileWriter(n);
        MoAttribute moAttribute = null;
        try {
            dumpFileWriter.init();
            DiskCleaner.getInstance().removeAllDumpFiles(dumpFileWriter.getFileName());
            while ((moAttribute = inputFileReader.getNextEntry()) != null) {
                MoAttributesCollector.collectAttributes(moAttribute, dumpFileWriter);
            }
            Log.trace(this.getClass(), "Stop dump file writer");
            dumpFileWriter.writeMoData(this.STOP_FLAG);
            dumpFileWriter.waitForCompletion(600000);
        }
        catch (IOException iOException) {
            Log.trace(this.getClass(), "IOException while generating mib dump file: " + iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            Log.trace(this.getClass(), "Exception handling " + moAttribute != null ? moAttribute.getLdn() : "null");
        }
        mibDumpListener.dumpStatus(dumpFileWriter.getFileName(), dumpFileWriter.isFileCompleted());
    }

    public boolean isLastDumpSuccessful() {
        return this.lastDumpSuccessful;
    }
}

