/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.fm.FmService;
import se.ericsson.cello.neal.fm.SeverityInfo;

public class AlarmSevCommand
extends CSCommand {
    private boolean setFlag = false;
    private boolean removeFlag = false;
    private List severityInfo = new ArrayList(0);

    public AlarmSevCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void setSetFlag(boolean bl) {
        this.setFlag = bl;
    }

    public void setRemoveFlag(boolean bl) {
        this.removeFlag = bl;
    }

    public void setSeverityInfo(List list) {
        this.severityInfo = list;
    }

    public void execute() {
        Log.trace(AlarmSevCommand.class, "execute");
        this.printout = PrintoutFactory.createPrintout(false, "ALARMSEV");
        FmService fmService = this.nodeServices.getFm();
        try {
            if (this.setFlag) {
                if (this.severityInfo.isEmpty()) {
                    this.printout.addErrorText("No severity configuration provided");
                } else {
                    this.setSeverity(fmService);
                }
            } else if (this.removeFlag) {
                if (this.severityInfo.isEmpty()) {
                    this.printout.addErrorText("No specific problems provided");
                } else {
                    this.removeSeverity(fmService);
                }
            } else {
                Log.trace(AlarmSevCommand.class, "Listing severity configuration");
                SeverityInfo[] severityInfoArray = fmService.getAllModifiedSeverity();
                this.printout.addSeverityConfigHeader();
                this.printout.addSeverityInfo(severityInfoArray);
                this.printout.addEndText();
            }
        }
        catch (Exception exception) {
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
        }
        this.resultListener.sendResponse(this.printout);
    }

    private boolean alreadyExist(SeverityInfo severityInfo, FmService fmService) {
        boolean bl = false;
        for (int i = 0; i < fmService.getAllModifiedSeverity().length; ++i) {
            String string = fmService.getAllModifiedSeverity()[i].getSpecificProblem();
            if (!severityInfo.getSpecificProblem().equalsIgnoreCase(string)) continue;
            bl = true;
        }
        return bl;
    }

    public void setSeverity(FmService fmService) {
        SeverityInfo severityInfo = (SeverityInfo)this.severityInfo.get(0);
        if (severityInfo.getSpecificProblem().trim().length() == 0) {
            this.printout.addErrorText("Specific problem can not be an empty string");
        } else {
            if (this.alreadyExist(severityInfo, fmService)) {
                fmService.removeSeverityConfiguration(new String[]{severityInfo.getSpecificProblem()});
            }
            Log.trace(AlarmSevCommand.class, "Setting severity for " + severityInfo.getSpecificProblem() + " to " + severityInfo.getSeverity());
            fmService.setSeverity(severityInfo);
            this.printout.addExecutedString();
        }
    }

    public void removeSeverity(FmService fmService) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.severityInfo.size(); ++i) {
            SeverityInfo severityInfo = (SeverityInfo)this.severityInfo.get(i);
            if (!this.alreadyExist(severityInfo, fmService)) continue;
            arrayList.add(severityInfo.getSpecificProblem());
        }
        if (arrayList.size() == 0) {
            this.printout.addErrorText("Problem does not exist and can not be removed");
        } else {
            Log.trace(AlarmSevCommand.class, "Removing severity configuration for " + this.severityInfo.size() + " specific problems");
            fmService.removeSeverityConfiguration(arrayList.toArray(new String[0]));
            this.printout.addExecutedString();
        }
    }
}

