/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.GroupExecutor;
import se.ericsson.cello.ncli.server.command.implementors.MoSearchableCommand;
import se.ericsson.cello.ncli.server.command.mogroup.MoGroup;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Transaction;

public class GetCommand
extends MoSearchableCommand
implements GroupExecutor {
    private boolean attribute;
    private boolean children;
    private ArrayList childList;
    private String range;
    private boolean groupFlag = false;
    private boolean recursiveFlag = false;
    private boolean expressionFlag = false;
    private boolean xmlFlag = false;
    private boolean pmFlag = false;

    public GetCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public boolean isExpressionFlag() {
        return this.expressionFlag;
    }

    public void setExpressionFlag(boolean bl) {
        this.expressionFlag = bl;
    }

    public void setPmFlag(boolean bl) {
        this.pmFlag = bl;
    }

    public boolean getPmFlag() {
        return this.pmFlag;
    }

    public boolean isRecursiveFlag() {
        return this.recursiveFlag;
    }

    public boolean isPmAttr(NameValue nameValue) {
        if (nameValue != null) {
            String string = nameValue.getName();
            return string.startsWith("pm");
        }
        return false;
    }

    public void setRecursiveFlag(boolean bl) {
        this.recursiveFlag = bl;
    }

    protected void printAllOrNoAttributes(Mo mo, boolean bl) throws NcliException {
    }

    public void setChildFlag(boolean bl) {
        this.children = bl;
    }

    public void setGroupFlag(boolean bl) {
        this.groupFlag = bl;
    }

    public void setRange(String string) {
        this.range = string;
    }

    public void setChildList(ArrayList arrayList) {
        this.childList = arrayList;
    }

    public void setAttrFlag(boolean bl) {
        this.attribute = bl;
    }

    public void execute() {
        block9: {
            Log.trace(GetCommand.class, "execute()");
            try {
                this.printout = PrintoutFactory.createPrintout(this.xmlFlag, "GET");
                Transaction transaction = this.transactionHandler.getCurrentTransaction();
                if (this.range != null) {
                    this.executeGroupRange(this.range, transaction);
                    break block9;
                }
                if (this.groupFlag) {
                    this.executeEntireGroup(transaction);
                    break block9;
                }
                if (this.expressionFlag) {
                    this.executeSearchCriteriaGet(transaction);
                    break block9;
                }
                if (this.recursiveFlag) {
                    this.executeRecursiveGet(transaction);
                    break block9;
                }
                String string = null;
                string = this.getLdn();
                try {
                    this.executeSingleMo(string, transaction);
                }
                catch (Exception exception) {
                    this.printout = PrintoutFactory.createPrintout(this.xmlFlag, "GET");
                    this.printout.addMoStart(this.ldn);
                    this.printout.addErrorText(new NcliException(exception));
                    this.printout.addMoEnd();
                    if (this.xmlFlag) {
                        this.printout.addEndText();
                    }
                    this.sendResponse();
                    return;
                }
                this.printout.addEndText();
                this.sendResponse();
            }
            catch (Exception exception) {
                this.printout.addNotAcceptedString();
                this.printout.addErrorText(ExceptionHandler.map(exception, ""));
                this.sendResponse();
                return;
            }
        }
    }

    private void executeSearchCriteriaGet(Transaction transaction) throws NcliException {
        Log.trace(GetCommand.class, "executeSearchCriteriaGet()");
        try {
            Mo[] moArray = this.searchMos();
            if (moArray == null) {
                this.sendResponse();
                return;
            }
            this.sendResponse();
            this.printout.clearPrintoutBuf();
            for (int i = 0; i < moArray.length; ++i) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                try {
                    this.executeSingleMo(moArray[i].getLdn(), transaction);
                }
                catch (Exception exception) {
                    this.printout.clearPrintoutBuf();
                    this.printout.addMoStart(this.ldn);
                    this.printout.addErrorText(new NcliException(exception));
                    this.printout.addMoEnd();
                }
                this.printout.addParagraphSeparator();
                if (this.checkForCancellation()) {
                    this.sendResponse();
                    return;
                }
                this.sendResponse();
                this.printout.clearPrintoutBuf();
            }
            this.printout.addEndText();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    private void executeRecursiveGet(Transaction transaction) throws NcliException {
        try {
            this.getLdn();
            this.sendResponse();
            this.printout.clearPrintoutBuf();
            try {
                this.executeSingleMo(this.ldn, transaction);
                this.sendResponse();
                this.printout.clearPrintoutBuf();
            }
            catch (Exception exception) {
                this.printout.clearPrintoutBuf();
                this.printout.addMoStart(this.ldn);
                this.printout.addErrorText(new NcliException(exception));
                this.printout.addMoEnd();
            }
            this.printout.addParagraphSeparator();
            Mo[] moArray = this.nodeServices.getCm().getMo(this.ldn).getChildren("", "", Scope.ALL_LEVELS, transaction);
            for (int i = 0; i < moArray.length; ++i) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                try {
                    this.executeSingleMo(moArray[i].getLdn(), transaction);
                }
                catch (Exception exception) {
                    this.printout.clearPrintoutBuf();
                    this.printout.addMoStart(moArray[i].getLdn());
                    this.printout.addErrorText(new NcliException(exception));
                    this.printout.addMoEnd();
                }
                this.printout.addParagraphSeparator();
                if (this.checkForCancellation()) {
                    this.sendResponse();
                    return;
                }
                this.sendResponse();
                this.printout.clearPrintoutBuf();
            }
            this.printout.addEndText();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public boolean checkForCancellation() {
        if (this.checkCancellation()) {
            this.printout.addInhibitedString();
            this.commandCancelled();
            return true;
        }
        return false;
    }

    public void executeEntireGroup(Transaction transaction) throws NcliException {
        try {
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            List list = moGroup.getGroupMembers();
            Iterator iterator = list.iterator();
            String string = null;
            this.sendResponse();
            this.printout.clearPrintoutBuf();
            while (iterator.hasNext()) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                string = (String)iterator.next();
                if (string != null) {
                    try {
                        this.executeSingleMo(string, transaction);
                    }
                    catch (Exception exception) {
                        this.printout.clearPrintoutBuf();
                        this.printout.addMoStart(string);
                        this.printout.addErrorText(new NcliException(exception));
                        this.printout.addMoEnd();
                    }
                    this.printout.addParagraphSeparator();
                } else {
                    Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$GetCommand == null ? GetCommand.class$("se.ericsson.cello.ncli.server.command.implementors.GetCommand") : class$se$ericsson$cello$ncli$server$command$implementors$GetCommand, "Encountered null element in group, ignoring.");
                }
                if (this.checkForCancellation()) {
                    this.sendResponse();
                    return;
                }
                this.sendResponse();
                this.printout.clearPrintoutBuf();
            }
            this.printout.addEndText();
            this.sendResponse();
        }
        catch (Exception exception) {
            this.printout.addNotAcceptedString();
            this.printout.addErrorText(ExceptionHandler.map(exception, ""));
            this.sendResponse();
            return;
        }
    }

    public void executeGroupRange(String string, Transaction transaction) throws NcliException {
        try {
            MoGroup moGroup = this.nodeServices.getMoGroupHandler().getDefaultGroup();
            int n = moGroup.getSize();
            Log.trace(GetCommand.class, "Size of group is " + n);
            int[] nArray = this.nodeServices.getAddressResolver().resolveIndexFromRange(string, n);
            Log.trace(GetCommand.class, "Length of indicies is " + nArray.length);
            String string2 = null;
            this.sendResponse();
            this.printout.clearPrintoutBuf();
            for (int i = 0; i < nArray.length; ++i) {
                this.nodeServices.getMemoryChecker().memoryIsEnough(1024L);
                string2 = moGroup.getLdnAtIndex(nArray[i]);
                if (string2 == null) {
                    Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$GetCommand == null ? GetCommand.class$("se.ericsson.cello.ncli.server.command.implementors.GetCommand") : class$se$ericsson$cello$ncli$server$command$implementors$GetCommand, "Encountered null element in group, ignoring.");
                } else {
                    try {
                        this.executeSingleMo(string2, transaction);
                    }
                    catch (Exception exception) {
                        this.printout.clearPrintoutBuf();
                        this.printout.addMoStart(string2);
                        this.printout.addErrorText(new NcliException(exception));
                        this.printout.addMoEnd();
                    }
                    this.printout.addParagraphSeparator();
                }
                if (this.checkForCancellation()) {
                    this.sendResponse();
                    return;
                }
                this.sendResponse();
                this.printout.clearPrintoutBuf();
            }
            this.printout.addEndText();
            this.sendResponse();
        }
        catch (Exception exception) {
            throw new NcliException(exception);
        }
    }

    public void executeSingleMo(String string, Transaction transaction) throws NcliException {
        String[] stringArray = null;
        try {
            if (string == null || string.equals(".") || string.equals("")) {
                string = this.nodeServices.getWorkingMo().getLdn();
            }
            this.printout.addMoStart(string);
            Log.trace(GetCommand.class, "executeSingleMo moAddress: " + string);
            Mo mo = this.nodeServices.getCm().getMo(string);
            this.validateMo(mo);
            if (this.myAttributeSeq != null && !this.myAttributeSeq.isEmpty()) {
                this.attribute = true;
            }
            if (this.pmFlag) {
                if (this.myAttributeSeq != null && !this.myAttributeSeq.isEmpty()) {
                    this.printout.addAttributesString();
                    Iterator iterator = this.myAttributeSeq.iterator();
                    NameValue nameValue = null;
                    while (iterator.hasNext()) {
                        nameValue = mo.getAttribute((String)iterator.next(), transaction);
                        this.printout.addAttrResult(nameValue);
                    }
                    this.printAllOrNoAttributes(mo, false);
                } else {
                    this.printAllOrNoAttributes(mo, true);
                }
            } else if (!this.attribute && !this.children) {
                if (this.myAttributeSeq != null && !this.myAttributeSeq.isEmpty()) {
                    this.printout.addAttributesString();
                    Iterator iterator = this.myAttributeSeq.iterator();
                    NameValue nameValue = null;
                    while (iterator.hasNext()) {
                        nameValue = mo.getAttribute((String)iterator.next(), transaction);
                        this.printout.addAttrResult(nameValue);
                    }
                } else {
                    Mo[] moArray = null;
                    moArray = mo.getChildren(transaction);
                    if (moArray != null && moArray.length > 0) {
                        this.printout.addChildrenString();
                        this.printout.addResultAsRdn(moArray);
                    }
                    this.printAllOrNoAttributes(mo, true);
                }
            } else if (this.attribute && this.children) {
                Object object;
                if (this.childList != null && !this.childList.isEmpty()) {
                    this.printout.addChildrenString();
                    object = null;
                    stringArray = new String[this.childList.size()];
                    this.childList.toArray(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].indexOf("=") != -1) {
                            object = new Mo[]{this.getCS().getCm().getMo(string.concat(",").concat(stringArray[i]))};
                            if (!object[0].exists()) {
                                throw new NcliException("The MO \"" + stringArray[i] + "\" does not exist.");
                            }
                        } else {
                            Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$GetCommand == null ? GetCommand.class$("se.ericsson.cello.ncli.server.command.implementors.GetCommand") : class$se$ericsson$cello$ncli$server$command$implementors$GetCommand, "type = " + stringArray[i]);
                            object = mo.getChildren(stringArray[i], "", Scope.ONE_LEVEL, transaction);
                        }
                        this.printout.addResultAsRdn((Mo[])object);
                    }
                } else {
                    object = mo.getChildren(transaction);
                    if (object != null && ((Mo[])object).length > 0) {
                        this.printout.addChildrenString();
                        this.printout.addResultAsRdn((Mo[])object);
                    }
                }
                if (this.myAttributeSeq != null && !this.myAttributeSeq.isEmpty()) {
                    this.printout.addAttributesString();
                    object = this.myAttributeSeq.iterator();
                    NameValue nameValue = null;
                    while (object.hasNext()) {
                        nameValue = mo.getAttribute((String)object.next(), transaction);
                        this.printout.addAttrResult(nameValue);
                    }
                    if (this.pmFlag) {
                        this.printAllOrNoAttributes(mo, false);
                    }
                } else {
                    this.printAllOrNoAttributes(mo, true);
                }
            } else if (this.attribute && !this.children) {
                if (this.myAttributeSeq != null && !this.myAttributeSeq.isEmpty()) {
                    this.printout.addAttributesString();
                    Iterator iterator = this.myAttributeSeq.iterator();
                    NameValue nameValue = null;
                    while (iterator.hasNext()) {
                        nameValue = mo.getAttribute((String)iterator.next(), transaction);
                        this.printout.addAttrResult(nameValue);
                    }
                    if (this.pmFlag) {
                        this.printAllOrNoAttributes(mo, false);
                    }
                } else {
                    this.printAllOrNoAttributes(mo, true);
                }
            } else if (!this.attribute && this.children) {
                if (this.childList != null && !this.childList.isEmpty()) {
                    this.printout.addChildrenString();
                    Mo[] moArray = null;
                    stringArray = new String[this.childList.size()];
                    this.childList.toArray(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].indexOf("=") != -1) {
                            moArray = new Mo[]{this.getCS().getCm().getMo(string.concat(",").concat(stringArray[i]))};
                            if (!moArray[0].exists()) {
                                throw new NcliException("The MO \"" + stringArray[i] + "\" does not exist.");
                            }
                        } else {
                            Log.trace(class$se$ericsson$cello$ncli$server$command$implementors$GetCommand == null ? GetCommand.class$("se.ericsson.cello.ncli.server.command.implementors.GetCommand") : class$se$ericsson$cello$ncli$server$command$implementors$GetCommand, "type = " + stringArray[i]);
                            moArray = mo.getChildren(stringArray[i], "", Scope.ONE_LEVEL, transaction);
                        }
                        this.printout.addResultAsRdn(moArray);
                    }
                } else {
                    Mo[] moArray = mo.getChildren(transaction);
                    if (moArray != null && moArray.length > 0) {
                        this.printout.addChildrenString();
                        this.printout.addResultAsRdn(moArray);
                    }
                }
            }
            this.printout.addMoEnd();
            return;
        }
        catch (Exception exception) {
            this.printout.addMoEnd();
            throw new NcliException(exception);
        }
    }

    public void setXmlFag(boolean bl) {
        this.xmlFlag = bl;
    }
}

