/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAssociationEnd;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomParameter;
import se.ericsson.cello.mimparser.MomRange;
import se.ericsson.cello.mimparser.MomRelationship;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructMember;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.ncli.server.command.implementors.ActionCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFormatter;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.IllegalTypeException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Value;
import se.ericsson.cello.neal.fm.Alarm;
import se.ericsson.cello.neal.fm.AlarmCounter;
import se.ericsson.cello.neal.fm.SeverityInfo;

public class PlainTextFormatter
implements PrintoutFormatter {
    private static final String DISTURBANCES = "disturbances: ";
    private static final String TAKES_EFFECTS = "takesEffects: ";
    private static final String SIDE_EFFECTS = "sideEffects: ";
    private static final String DEPENDENCIES = "dependencies: ";
    private static final String PRE_CONDITION = "preCondition: ";
    private static final String CONDITION = "condition: ";
    private static final String COUNTER_TYPE = "counterType: ";
    private static final String SAMPLING_RATE = "samplingRate: ";
    private static final String SPECIFICATION = "specification: ";
    private static final String SCANNER = "scanner: ";
    private static final String COUNTER_CONTEXT = "counterContext: ";
    private static final String STATIC = "static";
    private static final String LOCAL = "local";
    private static final String UNDEFINED_VALUE = "undefinedValue: ";
    private static final String DEPRECATED_COLON = "deprecated: ";
    private static final String LOCK_BEFORE_MODIFY = "lockBeforeModify";
    private static final String DEPRECATED = "deprecated";
    private static final String SOFT_LINK_PARENTS = "SoftLink parents:";
    private static final String SOFT_LINK_CHILDREN = "SoftLink children:";
    private static final String SUPPORTED = "Supported:";
    private static final String SUPPORTERS = "Supporters:";
    private static final String WITH_ATTRIBUTE = " with attribute ";
    private int indent = 0;
    private static final char LINE_SEPARATOR = '\n';
    private static final String EMPTY_STRING = "";
    private static final String EQUAL_SIGN = "=";
    private static final String CURLY_OPEN = "{";
    private static final String CURLY_CLOSE = "}";
    private static final String INDENT = "   ";
    private static final String READ_ONLY = "readOnly";
    private static final String MANDATORY = "mandatory";
    private static final String RESTRICTED = "restricted";
    private static final String NO_NOTIFICATION = "noNotification";
    private static final String NON_PERISTENT = "nonPersistent";
    private static final String VOID = "void";
    private static final String GROUP = "GROUP";
    private static final String INDEX_LDN = "INDEX    LDN";

    public StringBuffer format(NameValue nameValue) {
        if (this.indent == 0) {
            ++this.indent;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = nameValue.getType();
        if (n != 11 && n != 13) {
            stringBuffer.append(this.addIndentation());
            stringBuffer.append(nameValue.getName());
            stringBuffer.append(EQUAL_SIGN);
        }
        if (n == 13) {
            stringBuffer.append(this.formatArray(nameValue));
        } else if (n == 11) {
            stringBuffer.append(this.formatStruct(nameValue.getStructValue(), nameValue.getName()));
        } else if (n == 6) {
            stringBuffer.append("(Long)");
            stringBuffer.append(nameValue.getLongValue());
            stringBuffer.append('\n');
        } else if (n == 1) {
            stringBuffer.append("(boolean)");
            stringBuffer.append(nameValue.getBooleanValue());
            stringBuffer.append('\n');
        } else if (n == 7) {
            stringBuffer.append("(float)");
            stringBuffer.append(nameValue.getFloatValue());
            stringBuffer.append('\n');
        } else if (n == 5) {
            stringBuffer.append("(int)");
            stringBuffer.append(nameValue.getIntValue());
            stringBuffer.append('\n');
        } else if (n == 12) {
            stringBuffer.append("(Ref)");
            Mo[] moArray = new Mo[]{nameValue.getMoValue()};
            stringBuffer.append(this.format(moArray));
        } else if (n == 9) {
            stringBuffer.append("(String)");
            stringBuffer.append("\"");
            stringBuffer.append(nameValue.getStringValue());
            stringBuffer.append("\"");
            stringBuffer.append('\n');
        } else if (n == 14) {
            stringBuffer.append("(ldn)");
            stringBuffer.append(nameValue.getStringValue());
            stringBuffer.append('\n');
        } else if (n == 0) {
            stringBuffer.append("(void)");
            stringBuffer.append('\n');
        } else {
            stringBuffer.append(this.format(nameValue));
        }
        if (this.indent == 1) {
            --this.indent;
        }
        return stringBuffer;
    }

    public StringBuffer format(Mo[] moArray) {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.indent;
        for (int i = 0; i < moArray.length; ++i) {
            if (moArray[i] != null) {
                stringBuffer.append(this.addIndentation());
                stringBuffer.append(moArray[i].getLdn());
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append('\n');
        }
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatRdn(Mo[] moArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (moArray == null || moArray.length == 0) {
            return stringBuffer;
        }
        ArrayList<String> arrayList = new ArrayList<String>(0);
        for (int i = 0; i < moArray.length; ++i) {
            String string = moArray[i].getLdn();
            arrayList.add(string.substring(string.lastIndexOf(44) + 1));
        }
        Collections.sort(arrayList);
        ++this.indent;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.addIndentation());
            stringBuffer.append((String)iterator.next());
            stringBuffer.append('\n');
        }
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatLDN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LDN\n");
        ++this.indent;
        stringBuffer.append(this.addIndentation()).append(string).append('\n');
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatMoStart(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LDN\n");
        ++this.indent;
        stringBuffer.append(this.addIndentation()).append(string).append('\n');
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatMoEnd() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    public StringBuffer formatAlarm(Alarm alarm) throws NcliException {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.indent;
        try {
            NameValue[] nameValueArray = alarm.getAdditionalInfo();
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("ALARM DATA");
            stringBuffer.append('\n');
            ++this.indent;
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Alarm Id                = ");
            stringBuffer.append(alarm.getAlarmId());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Probable Cause          = ");
            stringBuffer.append(alarm.getProbableCause());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Probable Cause Code     = ");
            stringBuffer.append(alarm.getProbableCauseDef());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Event Time              = ");
            stringBuffer.append(alarm.getEventTime());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Perceived Severity      = ");
            stringBuffer.append(alarm.getPerceivedSeverity());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Perceived Severity Code = ");
            stringBuffer.append(alarm.getPerceivedSeverityDef());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Specific Problem        = ");
            stringBuffer.append(alarm.getSpecificProblem());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Managed Object Class    = ");
            stringBuffer.append(alarm.getManagedObjectClass());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Managed Object Instance = ");
            stringBuffer.append(alarm.getManagedObjectInstance());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Additional Text         = ");
            stringBuffer.append(alarm.getAdditionalText());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Ack User Id             = ");
            stringBuffer.append(alarm.getAckUserId());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Ack Time                = ");
            if (alarm.isAcked()) {
                stringBuffer.append(alarm.getAckTime());
                stringBuffer.append('\n');
            } else {
                stringBuffer.append("Not acknowledged");
                stringBuffer.append('\n');
            }
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Notification Id         = ");
            stringBuffer.append(alarm.getNotificationId());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("System Dn               = ");
            stringBuffer.append(alarm.getSystemDN());
            stringBuffer.append('\n');
            boolean bl = false;
            if (nameValueArray != null && nameValueArray.length != 0) {
                for (int i = 0; i < nameValueArray.length; ++i) {
                    if (nameValueArray[i].getName().equalsIgnoreCase("a") || nameValueArray[i].getName().equalsIgnoreCase("b") || nameValueArray[i].getName().equalsIgnoreCase("c") || nameValueArray[i].getName().equalsIgnoreCase("d") || nameValueArray[i].getName().equalsIgnoreCase("e") || nameValueArray[i].getName().equalsIgnoreCase("f") || nameValueArray[i].getName().equalsIgnoreCase("g") || nameValueArray[i].getName().equalsIgnoreCase("h") || nameValueArray[i].getName().equalsIgnoreCase("i") || nameValueArray[i].getName().equalsIgnoreCase("j") || nameValueArray[i].getName().equalsIgnoreCase("k") || nameValueArray[i].getName().equalsIgnoreCase("l") || nameValueArray[i].getName().equalsIgnoreCase("m") || nameValueArray[i].getName().equalsIgnoreCase("n") || nameValueArray[i].getName().equalsIgnoreCase("o") || nameValueArray[i].getName().equalsIgnoreCase("p") || nameValueArray[i].getName().equalsIgnoreCase("q") || nameValueArray[i].getName().equalsIgnoreCase("r") || nameValueArray[i].getName().equalsIgnoreCase("s") || nameValueArray[i].getName().equalsIgnoreCase("t") || nameValueArray[i].getName().equalsIgnoreCase("u") || nameValueArray[i].getName().equalsIgnoreCase("v") || nameValueArray[i].getName().equalsIgnoreCase("NEAL.fixed_header.domain_name") || nameValueArray[i].getName().equalsIgnoreCase("NEAL.fixed_header.type_name") || nameValueArray[i].getName().equalsIgnoreCase("NEAL.fixed_header.event_name")) continue;
                    if (!bl) {
                        --this.indent;
                        stringBuffer.append(this.addIndentation());
                        stringBuffer.append("ADDITIONAL DATA");
                        stringBuffer.append('\n');
                        ++this.indent;
                        bl = true;
                    }
                    stringBuffer.append(this.format(nameValueArray[i]));
                }
            }
            --this.indent;
        }
        catch (Exception exception) {
            throw ExceptionHandler.map(exception, EMPTY_STRING);
        }
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatAlarmCounter(AlarmCounter alarmCounter) throws NcliException {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.indent;
        try {
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Critical Count=");
            stringBuffer.append(alarmCounter.getCriticalCount());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Major Count=");
            stringBuffer.append(alarmCounter.getMajorCount());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Minor Count=");
            stringBuffer.append(alarmCounter.getMinorCount());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Warning Count=");
            stringBuffer.append(alarmCounter.getWarningCount());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Indeterminate Count=");
            stringBuffer.append(alarmCounter.getIndeterminateCount());
            stringBuffer.append('\n');
            stringBuffer.append(this.addIndentation());
            stringBuffer.append("Cleared Count=");
            stringBuffer.append(alarmCounter.getClearedCount());
            stringBuffer.append('\n');
        }
        catch (Exception exception) {
            throw ExceptionHandler.map(exception, EMPTY_STRING);
        }
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer format(NameValue[] nameValueArray) throws NcliException {
        ++this.indent;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < nameValueArray.length; ++i) {
                if (nameValueArray[i].getType() == 11) {
                    ++this.indent;
                    stringBuffer.append(this.formatStruct(nameValueArray[i].getStructValue(), nameValueArray[i].getName()));
                    --this.indent;
                    continue;
                }
                stringBuffer.append(this.format(nameValueArray[i]));
            }
        }
        catch (IllegalTypeException illegalTypeException) {
            throw ExceptionHandler.map((Exception)((Object)illegalTypeException), EMPTY_STRING);
        }
        catch (Exception exception) {
            throw ExceptionHandler.map(exception, EMPTY_STRING);
        }
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer format(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addIndentation());
        stringBuffer.append(string);
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public StringBuffer formatStringNv(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addIndentation());
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        return stringBuffer;
    }

    public StringBuffer formatError(NcliException ncliException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ncliException.getMessage()).append('\n');
        return stringBuffer;
    }

    public StringBuffer formatStruct(Struct struct, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = struct.getMemberNames();
        stringBuffer.append(this.addIndentation());
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(EQUAL_SIGN);
        }
        stringBuffer.append(CURLY_OPEN);
        stringBuffer.append('\n');
        ++this.indent;
        int n = struct.getSize();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.format(struct.getMember(stringArray[i])));
        }
        --this.indent;
        stringBuffer.append(this.addIndentation()).append(CURLY_CLOSE);
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public StringBuffer formatArray(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addIndentation());
        stringBuffer.append(nameValue.getName());
        stringBuffer.append(EQUAL_SIGN);
        int n = nameValue.getArrayType();
        ++this.indent;
        if (n != 13) {
            if (n == 11) {
                stringBuffer.append("(Struct){");
                stringBuffer.append('\n');
                Struct[] structArray = nameValue.getStructArrayValue();
                for (int i = 0; i < structArray.length; ++i) {
                    stringBuffer.append(this.formatStruct(structArray[i], null));
                }
            } else if (n == 1) {
                boolean[] blArray = nameValue.getBooleanArrayValue();
                stringBuffer.append("(boolean){").append('\n');
                for (int i = 0; i < blArray.length; ++i) {
                    stringBuffer.append(this.addIndentation());
                    if (blArray[i]) {
                        stringBuffer.append("true");
                    } else {
                        stringBuffer.append("false");
                    }
                    stringBuffer.append('\n');
                }
            } else if (n != 14) {
                if (n == 7) {
                    float[] fArray = nameValue.getFloatArrayValue();
                    stringBuffer.append("(Float){").append('\n');
                    for (int i = 0; i < fArray.length; ++i) {
                        stringBuffer.append(this.addIndentation());
                        stringBuffer.append(fArray[i]);
                        stringBuffer.append('\n');
                    }
                } else if (n == 5) {
                    int[] nArray = nameValue.getIntArrayValue();
                    stringBuffer.append("(int){").append('\n');
                    for (int i = 0; i < nArray.length; ++i) {
                        stringBuffer.append(this.addIndentation());
                        stringBuffer.append(nArray[i]);
                        stringBuffer.append('\n');
                    }
                } else if (n == 6) {
                    long[] lArray = nameValue.getLongArrayValue();
                    stringBuffer.append("(Long){").append('\n');
                    for (int i = 0; i < lArray.length; ++i) {
                        stringBuffer.append(this.addIndentation());
                        stringBuffer.append(lArray[i]);
                        stringBuffer.append('\n');
                    }
                } else if (n == 12) {
                    stringBuffer.append("(Ref){").append('\n');
                    stringBuffer.append(this.format(nameValue.getMoArrayValue()));
                } else if (n == 9) {
                    String[] stringArray = nameValue.getStringArrayValue();
                    stringBuffer.append("(String){").append('\n');
                    ++this.indent;
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(this.formatStringNv(stringArray[i]));
                        stringBuffer.append("\n");
                    }
                    --this.indent;
                } else if (n == 0) {
                    // empty if block
                }
            }
        }
        --this.indent;
        stringBuffer.append(this.addIndentation()).append(CURLY_CLOSE).append('\n');
        return stringBuffer;
    }

    private String addIndentation() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indent; ++i) {
            stringBuffer.append(INDENT);
        }
        return stringBuffer.toString();
    }

    public StringBuffer formatHeader(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.indent = n;
        stringBuffer.append(this.addIndentation());
        stringBuffer.append(string);
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public StringBuffer formatClass(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.formatDescription(momClass));
        stringBuffer.append(this.formatExtendedDescription(momClass));
        stringBuffer.append(this.format("RELATIONS"));
        stringBuffer.append(this.formatParentsRelation(momClass));
        stringBuffer.append(this.formatChildrenRelation(momClass));
        stringBuffer.append(this.formatReferensesFromRelations(momClass));
        stringBuffer.append(this.formatReferensesToRelations(momClass));
        stringBuffer.append(this.formatSupporters(momClass));
        stringBuffer.append(this.formatSupported(momClass));
        stringBuffer.append(this.formatSoftLinkParents(momClass));
        stringBuffer.append(this.formatSoftLinkChildren(momClass));
        stringBuffer.append(this.formatActions(momClass));
        stringBuffer.append(this.formatAttributes(momClass));
        stringBuffer.append('\n');
        return stringBuffer;
    }

    StringBuffer formatExtendedDescription(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        if (momClass.getDeprecated() != null || momClass.isLockBeforeDelete() || momClass.isNonPersistent()) {
            stringBuffer.append(this.formatDeprecated(momClass));
            stringBuffer.append(this.formatLockBeforeDelete(momClass));
            stringBuffer.append(this.formatNonPersistant(momClass));
        }
        return stringBuffer;
    }

    StringBuffer formatNonPersistant(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.indent;
        if (momClass.isNonPersistent()) {
            stringBuffer.append(this.format("nonPersistant:"));
            ++this.indent;
            stringBuffer.append(this.format("true"));
            --this.indent;
        }
        --this.indent;
        return stringBuffer;
    }

    private StringBuffer formatLockBeforeDelete(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.indent;
        if (momClass.isLockBeforeDelete()) {
            stringBuffer.append(this.format("lockBeforeDelete:"));
            ++this.indent;
            stringBuffer.append(this.format("true"));
            --this.indent;
        }
        --this.indent;
        return stringBuffer;
    }

    private StringBuffer formatDeprecated(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.indent;
        if (momClass.getDeprecated() != null) {
            stringBuffer.append(this.format("Deprecated: "));
            ++this.indent;
            stringBuffer.append(this.format(momClass.getDeprecated()));
            --this.indent;
        }
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatEnum(MomEnum momEnum) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.formatDescription(momEnum));
        stringBuffer.append(this.formatEnumDetails(momEnum));
        return stringBuffer;
    }

    public StringBuffer formatStruct(MomStruct momStruct) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.formatDescription(momStruct));
        stringBuffer.append(this.formatStructMembers(momStruct));
        return stringBuffer;
    }

    public StringBuffer formatActionDetails(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        MomAction momAction = null;
        MomParameter momParameter = null;
        Iterator iterator2 = null;
        if (iterator.hasNext()) {
            stringBuffer.append(this.format("ACTIONS"));
            ++this.indent;
            stringBuffer.append('\n');
            while (iterator.hasNext()) {
                momAction = (MomAction)iterator.next();
                StringBuffer stringBuffer2 = new StringBuffer();
                if (momAction.getReturnType() == null) {
                    stringBuffer2.append(VOID);
                } else {
                    stringBuffer2.append(this.getAttributeTypeString(momAction.getReturnType()));
                }
                stringBuffer2.append(" ");
                stringBuffer2.append(momAction.getName());
                stringBuffer2.append(" (");
                iterator2 = momAction.getParameters();
                while (iterator2.hasNext()) {
                    momParameter = (MomParameter)iterator2.next();
                    stringBuffer2.append("  ");
                    stringBuffer2.append(this.getAttributeTypeString(momParameter.getType()));
                    stringBuffer2.append("  ");
                    stringBuffer2.append(momParameter.getName());
                    if (!iterator2.hasNext()) continue;
                    stringBuffer2.append(" ,");
                }
                stringBuffer2.append(" )");
                stringBuffer.append(this.format(stringBuffer2.toString()));
                if (momAction.getDescription() != null) {
                    stringBuffer.append(this.format("DESCRIPTION"));
                    ++this.indent;
                    stringBuffer.append(this.format(momAction.getDescription()));
                    --this.indent;
                }
                stringBuffer.append(this.formatExtendedDescription(momAction));
                stringBuffer.append('\n');
            }
            --this.indent;
        }
        return stringBuffer;
    }

    private StringBuffer formatExtendedDescription(MomAction momAction) {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.indent;
        if (momAction.getDeprecated() != null) {
            stringBuffer.append(this.format(DEPRECATED_COLON + momAction.getDeprecated()));
        }
        if (momAction.getDisturbances() != null) {
            stringBuffer.append(this.format(DISTURBANCES + momAction.getDisturbances()));
        }
        if (momAction.getTakesEffect() != null) {
            stringBuffer.append(this.format(TAKES_EFFECTS + momAction.getTakesEffect()));
        }
        if (momAction.getSideEffects() != null) {
            stringBuffer.append(this.format(SIDE_EFFECTS + momAction.getSideEffects()));
        }
        if (momAction.getDependencies() != null) {
            stringBuffer.append(this.format(DEPENDENCIES + momAction.getDependencies()));
        }
        if (momAction.getPreCondition() != null) {
            stringBuffer.append(this.format(PRE_CONDITION + momAction.getPreCondition()));
        }
        if (momAction.getCondition() != null) {
            stringBuffer.append(this.format(CONDITION + momAction.getCondition()));
        }
        if (momAction.getSpecification() != null) {
            stringBuffer.append(this.format(SPECIFICATION + momAction.getSpecification()));
        }
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatAttributeDetails(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        MomAttribute momAttribute = null;
        if (iterator.hasNext()) {
            stringBuffer.append(this.format("ATTRIBUTES"));
            ++this.indent;
            stringBuffer.append('\n');
            while (iterator.hasNext()) {
                momAttribute = (MomAttribute)iterator.next();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(this.getAttributeTypeString(momAttribute.getType()));
                stringBuffer2.append(" ");
                stringBuffer2.append(momAttribute.getName());
                stringBuffer2.append(" ");
                if (momAttribute.getDeprecated() != null) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(DEPRECATED);
                }
                if (momAttribute.isLocal()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(LOCAL);
                }
                if (momAttribute.isStatic()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(STATIC);
                }
                if (momAttribute.isMandatory()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(MANDATORY);
                }
                if (momAttribute.isNoNotification()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(NO_NOTIFICATION);
                }
                if (!momAttribute.isPersistent()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(NON_PERISTENT);
                }
                if (momAttribute.isReadOnly()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(READ_ONLY);
                }
                if (momAttribute.isRestricted()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(RESTRICTED);
                }
                if (momAttribute.isLockBeforeModify()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append(LOCK_BEFORE_MODIFY);
                }
                if (momAttribute.isCounterReset()) {
                    stringBuffer2.append(" ");
                    stringBuffer2.append("counterReset");
                }
                stringBuffer.append(this.format(stringBuffer2.toString()));
                if (momAttribute.getDescription() != null) {
                    stringBuffer.append(this.format("DESCRIPTION"));
                    ++this.indent;
                    stringBuffer.append(this.format(momAttribute.getDescription()));
                    --this.indent;
                }
                stringBuffer.append(this.formatExtendedDescription(momAttribute));
                stringBuffer.append('\n');
            }
            --this.indent;
        }
        return stringBuffer;
    }

    private StringBuffer formatExtendedDescription(MomAttribute momAttribute) {
        StringBuffer stringBuffer = new StringBuffer();
        ++this.indent;
        if (momAttribute.getDeprecated() != null) {
            stringBuffer.append(this.format(DEPRECATED_COLON + momAttribute.getDeprecated()));
        }
        if (momAttribute.getUndefinedValue() != null) {
            stringBuffer.append(this.format(UNDEFINED_VALUE + momAttribute.getUndefinedValue()));
        }
        if (momAttribute.getDisturbances() != null) {
            stringBuffer.append(this.format(DISTURBANCES + momAttribute.getDisturbances()));
        }
        if (momAttribute.getTakesEffect() != null) {
            stringBuffer.append(this.format(TAKES_EFFECTS + momAttribute.getTakesEffect()));
        }
        if (momAttribute.getSideEffects() != null) {
            stringBuffer.append(this.format(SIDE_EFFECTS + momAttribute.getSideEffects()));
        }
        if (momAttribute.getDependencies() != null) {
            stringBuffer.append(this.format(DEPENDENCIES + momAttribute.getDependencies()));
        }
        if (momAttribute.getPreCondition() != null) {
            stringBuffer.append(this.format(PRE_CONDITION + momAttribute.getPreCondition()));
        }
        if (momAttribute.getCondition() != null) {
            stringBuffer.append(this.format(CONDITION + momAttribute.getCondition()));
        }
        if (momAttribute.getCounterType() != null) {
            stringBuffer.append(this.format(COUNTER_TYPE + momAttribute.getCounterType()));
        }
        if (momAttribute.getSamplingRate() != null) {
            stringBuffer.append(this.format(SAMPLING_RATE + momAttribute.getSamplingRate()));
        }
        if (momAttribute.getSpecification() != null) {
            stringBuffer.append(this.format(SPECIFICATION + momAttribute.getSpecification()));
        }
        if (momAttribute.getScanner() != null) {
            stringBuffer.append(this.format(SCANNER + momAttribute.getScanner()));
        }
        if (momAttribute.getCounterContext() != null) {
            stringBuffer.append(this.format(COUNTER_CONTEXT + momAttribute.getCounterContext()));
        }
        --this.indent;
        return stringBuffer;
    }

    StringBuffer formatEnumDetails(MomEntity momEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        MomEnumMember momEnumMember = null;
        MomEnum momEnum = (MomEnum)momEntity;
        Iterator iterator = momEnum.getMembers();
        stringBuffer.append(this.format("DETAILS"));
        stringBuffer.append('\n');
        if (iterator.hasNext()) {
            ++this.indent;
            while (iterator.hasNext()) {
                momEnumMember = (MomEnumMember)iterator.next();
                stringBuffer.append(this.format(momEnumMember.getValue().toString() + INDENT + momEnumMember.getName()));
                if (momEnumMember.getDescription() == null) continue;
                ++this.indent;
                ++this.indent;
                stringBuffer.append(this.format(momEnumMember.getDescription()));
                --this.indent;
                --this.indent;
            }
            --this.indent;
        }
        stringBuffer.append('\n');
        return stringBuffer;
    }

    StringBuffer formatStructDetails(MomEntity momEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        MomStructMember momStructMember = null;
        MomStruct momStruct = (MomStruct)momEntity;
        Iterator iterator = momStruct.getMembers();
        stringBuffer.append(this.format("DETAILS"));
        stringBuffer.append('\n');
        if (iterator.hasNext()) {
            ++this.indent;
            while (iterator.hasNext()) {
                StringBuffer stringBuffer2 = new StringBuffer();
                momStructMember = (MomStructMember)iterator.next();
                stringBuffer2.append(this.getAttributeTypeString(momStructMember.getValue()));
                stringBuffer2.append(" ");
                stringBuffer2.append(momStructMember.getName());
                if (momStructMember.getValue() != null) {
                    // empty if block
                }
                if (momStructMember.getValue() instanceof MomCorbaTypeAttribute) {
                    stringBuffer2.append(this.getDefaultValue((MomCorbaTypeAttribute)momStructMember.getValue()));
                    stringBuffer2.append(this.getRangeString((MomCorbaTypeAttribute)momStructMember.getValue()));
                }
                stringBuffer.append(this.format(stringBuffer2.toString()));
                stringBuffer.append('\n');
                if (momStructMember.getDescription() == null) continue;
                stringBuffer.append(this.format(momStructMember.getDescription()));
                stringBuffer.append('\n');
            }
            --this.indent;
        }
        stringBuffer.append('\n');
        return stringBuffer;
    }

    StringBuffer formatDescription(MomEntity momEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.format("DESCRIPTION"));
        stringBuffer.append('\n');
        ++this.indent;
        stringBuffer.append(this.format(momEntity.getXmlType() + " " + momEntity.getName()));
        stringBuffer.append('\n');
        String string = momEntity.getDescription();
        if (string != null) {
            stringBuffer.append(this.format(string));
        }
        --this.indent;
        return stringBuffer;
    }

    StringBuffer formatStructMembers(MomStruct momStruct) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = momStruct.getMembers();
        MomStructMember momStructMember = null;
        if (iterator.hasNext()) {
            stringBuffer.append(this.format("MEMBERS"));
            ++this.indent;
            while (iterator.hasNext()) {
                momStructMember = (MomStructMember)iterator.next();
                stringBuffer.append(this.format(this.getAttributeTypeString(momStructMember.getValue()) + " " + momStructMember.getName()));
            }
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatActions(MomEntity momEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        MomClass momClass = (MomClass)momEntity;
        Iterator iterator = momClass.getActions();
        if (iterator.hasNext()) {
            stringBuffer.append(this.format("ACTIONS"));
            ++this.indent;
            while (iterator.hasNext()) {
                stringBuffer.append(this.format(((MomEntity)iterator.next()).getName()));
            }
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatAttributes(MomEntity momEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        MomClass momClass = (MomClass)momEntity;
        Iterator iterator = momClass.getAttributes();
        if (iterator.hasNext()) {
            stringBuffer.append(this.format("ATTRIBUTES"));
            ++this.indent;
            MomAttribute momAttribute = null;
            while (iterator.hasNext()) {
                momAttribute = (MomAttribute)iterator.next();
                stringBuffer.append(this.format(this.getAttributeTypeString(momAttribute.getType()) + " " + momAttribute.getName()));
            }
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatParentsRelation(MomEntity momEntity) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        MomClass momClass = (MomClass)momEntity;
        Iterator iterator = momClass.getContainmentParents();
        if (iterator.hasNext()) {
            ++this.indent;
            stringBuffer.append(this.format("Possible parents:"));
            ++this.indent;
            while (iterator.hasNext()) {
                string = ((MomEntity)iterator.next()).getName();
                if (string.equals(EMPTY_STRING)) continue;
                stringBuffer.append(this.format(string));
            }
            --this.indent;
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatChildrenRelation(MomEntity momEntity) {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        MomClass momClass = (MomClass)momEntity;
        Iterator iterator = momClass.getContainmentChildren();
        if (iterator.hasNext()) {
            ++this.indent;
            stringBuffer.append(this.format("Possible children:"));
            ++this.indent;
            while (iterator.hasNext()) {
                string = ((MomEntity)iterator.next()).getName();
                if (string.equals(EMPTY_STRING)) continue;
                stringBuffer.append(this.format(string));
            }
            --this.indent;
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatReferensesFromRelations(MomEntity momEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        MomClass momClass = (MomClass)momEntity;
        Iterator iterator = momClass.getAssociationEndsFrom();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                MomAssociationEnd momAssociationEnd = (MomAssociationEnd)iterator.next();
                String string = momAssociationEnd.getName();
                String string2 = momAssociationEnd.getHasClass().getName();
                if (stringBuffer.toString().indexOf("References from:") == -1) {
                    ++this.indent;
                    stringBuffer.append(this.format("References from:"));
                    ++this.indent;
                }
                stringBuffer.append(this.format(string2 + WITH_ATTRIBUTE + string));
            }
        }
        if (stringBuffer.toString().indexOf("References from:") != -1) {
            --this.indent;
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatReferensesToRelations(MomEntity momEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        MomClass momClass = (MomClass)momEntity;
        Iterator iterator = momClass.getAssociationEndsTo();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                MomAssociationEnd momAssociationEnd = (MomAssociationEnd)iterator.next();
                String string = momAssociationEnd.getName();
                String string2 = momAssociationEnd.getHasClass().getName();
                if (stringBuffer.toString().indexOf("References to:") == -1) {
                    ++this.indent;
                    stringBuffer.append(this.format("References to:"));
                    ++this.indent;
                }
                stringBuffer.append(this.format(string2 + WITH_ATTRIBUTE + string));
            }
        }
        if (stringBuffer.toString().indexOf("References to:") != -1) {
            --this.indent;
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatSupporters(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = momClass.getSupporters();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                MomClass momClass2 = (MomClass)iterator.next();
                String string = momClass2.getName();
                if (stringBuffer.toString().indexOf(SUPPORTERS) == -1) {
                    ++this.indent;
                    stringBuffer.append(this.format(SUPPORTERS));
                    ++this.indent;
                }
                stringBuffer.append(this.format(string));
            }
        }
        if (stringBuffer.toString().indexOf(SUPPORTERS) != -1) {
            --this.indent;
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatSupported(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = momClass.getSupported();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                MomClass momClass2 = (MomClass)iterator.next();
                String string = momClass2.getName();
                if (stringBuffer.toString().indexOf(SUPPORTED) == -1) {
                    ++this.indent;
                    stringBuffer.append(this.format(SUPPORTED));
                    ++this.indent;
                }
                stringBuffer.append(this.format(string));
            }
        }
        if (stringBuffer.toString().indexOf(SUPPORTED) != -1) {
            --this.indent;
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatSoftLinkChildren(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = momClass.getSoftLinkChildren();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                MomClass momClass2 = (MomClass)iterator.next();
                String string = momClass2.getName();
                if (stringBuffer.toString().indexOf(SOFT_LINK_CHILDREN) == -1) {
                    ++this.indent;
                    stringBuffer.append(this.format(SOFT_LINK_CHILDREN));
                    ++this.indent;
                }
                stringBuffer.append(this.format(string));
            }
        }
        if (stringBuffer.toString().indexOf(SOFT_LINK_CHILDREN) != -1) {
            --this.indent;
            --this.indent;
        }
        return stringBuffer;
    }

    StringBuffer formatSoftLinkParents(MomClass momClass) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = momClass.getSoftLinkParents();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                MomClass momClass2 = (MomClass)iterator.next();
                String string = momClass2.getName();
                if (stringBuffer.toString().indexOf(SOFT_LINK_PARENTS) == -1) {
                    ++this.indent;
                    stringBuffer.append(this.format(SOFT_LINK_PARENTS));
                    ++this.indent;
                }
                stringBuffer.append(this.format(string));
            }
        }
        if (stringBuffer.toString().indexOf(SOFT_LINK_PARENTS) != -1) {
            --this.indent;
            --this.indent;
        }
        return stringBuffer;
    }

    protected String getAttributeTypeString(MomEntity momEntity) {
        String string = EMPTY_STRING;
        if (momEntity instanceof MomCorbaTypeAttribute) {
            string = momEntity.getXmlType();
        } else if (momEntity instanceof MomStruct) {
            string = ((MomStruct)momEntity).getName();
        } else if (momEntity instanceof MomStructRef) {
            string = ((MomStructRef)momEntity).getName();
        } else if (momEntity instanceof MomEnum) {
            string = ((MomEnum)momEntity).getName();
        } else if (momEntity instanceof MomEnumRef) {
            string = this.getAttributeTypeString(((MomEnumRef)momEntity).getEnum());
        } else if (!(momEntity instanceof MomRelationship)) {
            if (momEntity instanceof MomClass) {
                string = ((MomClass)momEntity).getName();
            } else if (momEntity instanceof MomSequence) {
                string = this.getAttributeTypeString(((MomSequence)momEntity).getType()) + "[]";
            }
        }
        return string;
    }

    String getRangeString(MomCorbaTypeAttribute momCorbaTypeAttribute) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = momCorbaTypeAttribute.getRanges();
        while (iterator.hasNext()) {
            MomRange momRange = (MomRange)iterator.next();
            stringBuffer.append(" [ ");
            stringBuffer.append(momRange.getMin().toString());
            stringBuffer.append(" .. ");
            stringBuffer.append(momRange.getMax().toString());
            stringBuffer.append(" ]");
        }
        return stringBuffer.toString();
    }

    private String getDefaultValue(MomCorbaTypeAttribute momCorbaTypeAttribute) {
        StringBuffer stringBuffer = new StringBuffer();
        if (momCorbaTypeAttribute.getDefault() != null) {
            stringBuffer.append(" = ");
            stringBuffer.append(momCorbaTypeAttribute.getDefault().toString());
        }
        return stringBuffer.toString();
    }

    public StringBuffer formatDescriptionSection(MomEntity momEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.format("DESCRIPTION"));
        stringBuffer.append('\n');
        ++this.indent;
        stringBuffer.append(this.format(momEntity.getXmlType() + " " + momEntity.getName()));
        --this.indent;
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public StringBuffer formatGroupName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.format(GROUP));
        ++this.indent;
        stringBuffer.append(this.format(string));
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatGroupMembers(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.format(INDEX_LDN));
        if (list != null) {
            int n = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (string == null) {
                    ++n;
                    continue;
                }
                String string2 = String.valueOf(n);
                stringBuffer.append(string2);
                int n2 = 9 - string2.length();
                for (int i = 0; i < n2; ++i) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(string);
                stringBuffer.append('\n');
                ++n;
            }
        }
        return stringBuffer;
    }

    public StringBuffer formatStructDetails(Iterator iterator) {
        StringBuffer stringBuffer = new StringBuffer();
        MomStructMember momStructMember = null;
        if (iterator.hasNext()) {
            stringBuffer.append(this.format("MEMBERS"));
            ++this.indent;
            stringBuffer.append('\n');
            while (iterator.hasNext()) {
                momStructMember = (MomStructMember)iterator.next();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append(this.getAttributeTypeString(momStructMember.getValue()));
                stringBuffer2.append(" ");
                stringBuffer2.append(momStructMember.getName());
                stringBuffer.append(this.format(stringBuffer2.toString()));
                if (momStructMember.getDescription() != null) {
                    stringBuffer.append(this.format(momStructMember.getDescription()));
                }
                stringBuffer.append('\n');
            }
            --this.indent;
        }
        return stringBuffer;
    }

    public StringBuffer formatLDN(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LDN\n");
        ++this.indent;
        int n = 1;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(this.addIndentation()).append("MO" + n + ": " + string).append('\n');
            ++n;
        }
        --this.indent;
        return stringBuffer;
    }

    public StringBuffer formatAttr(NameValue nameValue) {
        return this.format(nameValue);
    }

    public StringBuffer formatCmdNameHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    public StringBuffer formatEnd() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addIndentation());
        stringBuffer.append("END");
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public StringBuffer formatParagraphSeparator() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        return stringBuffer;
    }

    public StringBuffer formatActionResult(String string, Value value, NameValueFactory nameValueFactory) {
        StringBuffer stringBuffer = new StringBuffer();
        NameValue nameValue = null;
        block0 : switch (value.getType()) {
            case 0: {
                nameValue = nameValueFactory.create(string);
                break;
            }
            case 9: {
                nameValue = nameValueFactory.create(string, value.getStringValue());
                break;
            }
            case 6: {
                nameValue = nameValueFactory.create(string, value.getLongValue());
                break;
            }
            case 7: {
                nameValue = nameValueFactory.create(string, value.getFloatValue());
                break;
            }
            case 5: {
                nameValue = nameValueFactory.create(string, value.getIntValue());
                break;
            }
            case 1: {
                nameValue = nameValueFactory.create(string, value.getBooleanValue());
                break;
            }
            case 14: {
                nameValue = nameValueFactory.create(string, value.getStringValue());
                break;
            }
            case 12: {
                nameValue = nameValueFactory.create(string, value.getMoValue());
                break;
            }
            case 11: {
                nameValue = nameValueFactory.create(string, value.getStructValue());
                break;
            }
            case 13: {
                Log.trace(ActionCommand.class, "Array of type:" + value.getArrayType());
                switch (value.getArrayType()) {
                    case 9: {
                        nameValue = nameValueFactory.create(string, value.getStringArrayValue());
                        break block0;
                    }
                    case 6: {
                        nameValue = nameValueFactory.create(string, value.getLongArrayValue());
                        break block0;
                    }
                    case 7: {
                        nameValue = nameValueFactory.create(string, value.getFloatArrayValue());
                        break block0;
                    }
                    case 5: {
                        nameValue = nameValueFactory.create(string, value.getIntArrayValue());
                        break block0;
                    }
                    case 1: {
                        nameValue = nameValueFactory.create(string, value.getBooleanArrayValue());
                        break block0;
                    }
                    case 12: {
                        nameValue = nameValueFactory.create(string, value.getMoArrayValue());
                        break block0;
                    }
                    case 11: {
                        nameValue = nameValueFactory.create(string, value.getStructArrayValue());
                    }
                }
            }
        }
        stringBuffer.append(this.format(nameValue));
        return stringBuffer;
    }

    public StringBuffer formatDiff(Mo[] moArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < moArray.length; ++i) {
            NameValue nameValue = moArray[i].getAttribute(string, null);
            if (nameValue.getType() == 11) {
                return this.formatStructDiff(moArray, string);
            }
            if (this.indent == 0) {
                ++this.indent;
            }
            stringBuffer.append(this.addIndentation());
            int n = i + 1;
            stringBuffer.append("MO" + n + ": " + this.format(nameValue).delete(0, 3));
        }
        if (this.indent == 1) {
            --this.indent;
        }
        return stringBuffer;
    }

    public StringBuffer formatStructDiff(Mo[] moArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Struct[] structArray = new Struct[moArray.length];
        for (int i = 0; i < moArray.length; ++i) {
            structArray[i] = moArray[i].getAttribute(string, null).getStructValue();
        }
        Struct struct = structArray[0];
        NameValue[] nameValueArray = struct.getNameValueArray();
        boolean bl = false;
        block1: for (int i = 0; i < nameValueArray.length; ++i) {
            NameValue nameValue = nameValueArray[i];
            String string2 = nameValue.getName();
            for (int j = 1; j < structArray.length; ++j) {
                Struct struct2 = structArray[j];
                NameValue nameValue2 = struct2.getMember(string2);
                if (nameValue.equals(nameValue2)) continue;
                if (bl) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(this.formatStructMemberDiff(structArray, string, string2));
                bl = true;
                continue block1;
            }
        }
        return stringBuffer;
    }

    public StringBuffer formatStructMemberDiff(Struct[] structArray, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < structArray.length; ++i) {
            NameValue nameValue = structArray[i].getMember(string2);
            if (this.indent == 0) {
                ++this.indent;
            }
            int n = i + 1;
            stringBuffer.append(this.addIndentation() + "MO" + n + ": " + string + "." + this.format(nameValue).delete(0, 3));
        }
        return stringBuffer;
    }

    public StringBuffer formatSeverityInfo(SeverityInfo severityInfo) {
        if (this.indent == 0) {
            ++this.indent;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addIndentation());
        if (severityInfo.getSpecificProblem().length() > 40) {
            stringBuffer.append(severityInfo.getSpecificProblem().substring(0, 37));
            stringBuffer.append("...");
        } else {
            stringBuffer.append(severityInfo.getSpecificProblem());
            for (int i = 0; i < 40 - severityInfo.getSpecificProblem().length(); ++i) {
                stringBuffer.append(' ');
            }
        }
        stringBuffer.append(' ').append(severityInfo.getSeverity()).append('\n');
        if (this.indent != 0) {
            --this.indent;
        }
        return stringBuffer;
    }
}

