/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.ncli.server.command.implementors.ActionCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFormatter;
import se.ericsson.cello.ncli.server.exceptions.ExceptionHandler;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Value;
import se.ericsson.cello.neal.fm.Alarm;
import se.ericsson.cello.neal.fm.AlarmCounter;
import se.ericsson.cello.neal.fm.SeverityInfo;

public class XmlFormatter
implements PrintoutFormatter {
    private int indent = 0;
    private static final String INDENT = "   ";
    private String myCmdName = "";

    public StringBuffer formatCmdNameHeader(String string) {
        this.myCmdName = string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("PRINTOUT") + "\n");
        ++this.indent;
        stringBuffer.append(this.startTag(this.myCmdName) + "\n");
        ++this.indent;
        return stringBuffer;
    }

    public StringBuffer formatEnd() {
        StringBuffer stringBuffer = new StringBuffer();
        --this.indent;
        stringBuffer.append(this.endTag(this.myCmdName) + "\n");
        --this.indent;
        stringBuffer.append(this.endTag("PRINTOUT") + "\n");
        return stringBuffer;
    }

    public String startTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addIndentation() + "<");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String endTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addIndentation() + "</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public String nealTypeToString(int n) {
        String string = "";
        if (13 == n) {
            string = "array";
        } else if (1 == n) {
            string = "boolean";
        } else if (14 == n) {
            string = "fdn";
        } else if (7 == n) {
            string = "float";
        } else if (5 == n) {
            string = "integer";
        } else if (6 == n) {
            string = "long";
        } else if (12 == n) {
            string = "mo";
        } else if (9 == n) {
            string = "string";
        } else if (11 == n) {
            string = "struct";
        } else if (0 == n) {
            string = "void";
        }
        return string;
    }

    private String addIndentation() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.indent; ++i) {
            stringBuffer.append(INDENT);
        }
        return stringBuffer.toString();
    }

    public StringBuffer formatAttr(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("attribute name=\"" + nameValue.getName() + "\"") + "\n");
        ++this.indent;
        stringBuffer.append(this.formatDataType(nameValue));
        --this.indent;
        stringBuffer.append(this.endTag("attribute") + "\n");
        return stringBuffer;
    }

    public StringBuffer formatNameValue(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("NameValue name=\"" + nameValue.getName() + "\"") + "\n");
        ++this.indent;
        stringBuffer.append(this.formatDataType(nameValue));
        --this.indent;
        stringBuffer.append(this.endTag("NameValue") + "\n");
        return stringBuffer;
    }

    public StringBuffer formatDataType(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nameValue.getType() != 13 && nameValue.getType() != 11 && nameValue.getType() != 0) {
            stringBuffer.append(this.startTag("dataType") + "\n");
            ++this.indent;
            stringBuffer.append(this.startTag(this.nealTypeToString(nameValue.getType())) + "\n");
            ++this.indent;
            stringBuffer.append(this.startTag("value") + nameValue.valueToString() + "</value>\n");
            --this.indent;
            stringBuffer.append(this.endTag(this.nealTypeToString(nameValue.getType())) + "\n");
            --this.indent;
            stringBuffer.append(this.endTag("dataType") + "\n");
        } else if (nameValue.getType() == 13) {
            stringBuffer.append(this.formatArrayDataType(nameValue));
        } else if (nameValue.getType() == 11) {
            stringBuffer.append(this.formatStructDataType(nameValue));
        } else if (nameValue.getType() == 0) {
            stringBuffer.append(this.startTag("dataType") + "\n");
            ++this.indent;
            stringBuffer.append(this.startTag(this.nealTypeToString(nameValue.getType())));
            stringBuffer.append("</" + this.nealTypeToString(nameValue.getType()) + ">\n");
            --this.indent;
            stringBuffer.append(this.endTag("dataType") + "\n");
        }
        return stringBuffer;
    }

    public StringBuffer formatArrayDataType(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("dataType") + "\n");
        ++this.indent;
        stringBuffer.append(this.startTag("sequence type=\"" + this.nealTypeToString(nameValue.getArrayType()) + "\"") + "\n");
        ++this.indent;
        if (nameValue.getArrayType() != 13) {
            if (nameValue.getArrayType() == 11) {
                stringBuffer.append(this.formatArrayStructDataType(nameValue));
            } else if (nameValue.getArrayType() == 1) {
                boolean[] blArray = nameValue.getBooleanArrayValue();
                for (int i = 0; i < blArray.length; ++i) {
                    stringBuffer.append(this.startTag("boolean") + "\n");
                    ++this.indent;
                    stringBuffer.append(this.startTag("value") + blArray[i]);
                    stringBuffer.append("</value>\n");
                    --this.indent;
                    stringBuffer.append(this.endTag("boolean") + "\n");
                }
            } else if (nameValue.getArrayType() != 14) {
                if (nameValue.getArrayType() == 7) {
                    float[] fArray = nameValue.getFloatArrayValue();
                    for (int i = 0; i < fArray.length; ++i) {
                        stringBuffer.append(this.startTag("float") + "\n");
                        ++this.indent;
                        stringBuffer.append(this.startTag("value") + fArray[i]);
                        stringBuffer.append("</value>\n");
                        --this.indent;
                        stringBuffer.append(this.endTag("float") + "\n");
                    }
                } else if (nameValue.getArrayType() == 5) {
                    int[] nArray = nameValue.getIntArrayValue();
                    for (int i = 0; i < nArray.length; ++i) {
                        stringBuffer.append(this.startTag("integer") + "\n");
                        ++this.indent;
                        stringBuffer.append(this.startTag("value") + nArray[i]);
                        stringBuffer.append("</value>\n");
                        --this.indent;
                        stringBuffer.append(this.endTag("integer") + "\n");
                    }
                } else if (nameValue.getArrayType() == 6) {
                    long[] lArray = nameValue.getLongArrayValue();
                    for (int i = 0; i < lArray.length; ++i) {
                        stringBuffer.append(this.startTag("long") + "\n");
                        ++this.indent;
                        stringBuffer.append(this.startTag("value") + lArray[i]);
                        stringBuffer.append("</value>\n");
                        --this.indent;
                        stringBuffer.append(this.endTag("long") + "\n");
                    }
                } else if (nameValue.getArrayType() == 12) {
                    Mo[] moArray = nameValue.getMoArrayValue();
                    for (int i = 0; i < moArray.length; ++i) {
                        stringBuffer.append(this.startTag("Ref") + "\n");
                        ++this.indent;
                        if (moArray[i] != null) {
                            stringBuffer.append(this.startTag("value") + moArray[i]);
                            stringBuffer.append("</value>\n");
                        }
                        --this.indent;
                        stringBuffer.append(this.endTag("Ref") + "\n");
                    }
                } else if (nameValue.getArrayType() == 9) {
                    String[] stringArray = nameValue.getStringArrayValue();
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer.append(this.startTag("string") + "\n");
                        ++this.indent;
                        if (stringArray[i] != null) {
                            stringBuffer.append(this.startTag("value") + stringArray[i]);
                            stringBuffer.append("</value>\n");
                        }
                        --this.indent;
                        stringBuffer.append(this.endTag("string") + "\n");
                    }
                } else if (nameValue.getArrayType() == 0) {
                    // empty if block
                }
            }
        }
        --this.indent;
        stringBuffer.append(this.endTag("sequence") + "\n");
        --this.indent;
        stringBuffer.append(this.endTag("dataType") + "\n");
        return stringBuffer;
    }

    public StringBuffer formatStructDataType(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("dataType") + "\n");
        ++this.indent;
        stringBuffer.append(this.formatStructValue(nameValue.getStructValue()));
        --this.indent;
        stringBuffer.append(this.endTag("dataType") + "\n");
        return stringBuffer;
    }

    public StringBuffer formatStructValue(Struct struct) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("struct") + "\n");
        ++this.indent;
        NameValue[] nameValueArray = struct.getNameValueArray();
        for (int i = 0; i < nameValueArray.length; ++i) {
            stringBuffer.append(this.formatStructMember(nameValueArray[i]) + "\n");
        }
        --this.indent;
        stringBuffer.append(this.endTag("struct") + "\n");
        return stringBuffer;
    }

    public StringBuffer formatStructMember(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("structMember name=\"" + nameValue.getName() + "\"") + "\n");
        ++this.indent;
        stringBuffer.append(this.formatDataType(nameValue));
        --this.indent;
        stringBuffer.append(this.endTag("structMember"));
        return stringBuffer;
    }

    public StringBuffer formatArrayStructDataType(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        Struct[] structArray = nameValue.getStructArrayValue();
        for (int i = 0; i < structArray.length; ++i) {
            stringBuffer.append(this.formatStructValue(structArray[i]));
        }
        return stringBuffer;
    }

    public StringBuffer format(NameValue nameValue) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("attribute name=\"" + nameValue.getName() + "\" type=\"" + this.nealTypeToString(nameValue.getType()) + "\""));
        stringBuffer.append(nameValue.valueToString());
        stringBuffer.append(this.endTag("attribute"));
        return stringBuffer;
    }

    public StringBuffer format(NameValue[] nameValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nameValueArray.length; ++i) {
            stringBuffer.append(this.format(nameValueArray[i]));
        }
        return stringBuffer;
    }

    public StringBuffer format(Mo[] moArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < moArray.length; ++i) {
            stringBuffer.append(this.formatLDN(moArray[i].getLdn()));
        }
        return stringBuffer;
    }

    public StringBuffer format(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    public StringBuffer formatAlarm(Alarm alarm) throws NcliException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            NameValue[] nameValueArray = alarm.getAdditionalInfo();
            stringBuffer.append(this.startTag("ALARM_DATA") + "\n");
            ++this.indent;
            stringBuffer.append(this.startTag("AlarmId") + alarm.getAlarmId() + "</AlarmId>" + "\n");
            stringBuffer.append(this.startTag("ProbableCause") + alarm.getProbableCause() + "</ProbableCause>" + "\n");
            stringBuffer.append(this.startTag("ProbableCauseCode") + alarm.getProbableCauseDef() + "</ProbableCauseCode>" + "\n");
            stringBuffer.append(this.startTag("EventTime") + alarm.getEventTime() + "</EventTime>" + "\n");
            stringBuffer.append(this.startTag("PerceivedSeverity") + alarm.getPerceivedSeverity() + "</PerceivedSeverity>" + "\n");
            stringBuffer.append(this.startTag("PerceivedSeverityCode") + alarm.getPerceivedSeverityDef() + "</PerceivedSeverityCode>" + "\n");
            stringBuffer.append(this.startTag("SpecificProblem") + alarm.getSpecificProblem() + "</SpecificProblem>" + "\n");
            stringBuffer.append(this.startTag("ManagedObjectClass") + alarm.getManagedObjectClass() + "</ManagedObjectClass>" + "\n");
            stringBuffer.append(this.startTag("ManagedObjectInstance") + alarm.getManagedObjectInstance() + "</ManagedObjectInstance>" + "\n");
            stringBuffer.append(this.startTag("AdditionalText") + alarm.getAdditionalText() + "</AdditionalText>" + "\n");
            stringBuffer.append(this.startTag("AckUserId") + alarm.getAckUserId() + "</AckUserId>" + "\n");
            stringBuffer.append(this.startTag("AckTime"));
            if (alarm.isAcked()) {
                stringBuffer.append(alarm.getAckTime() + "</AckTime>" + "\n");
            } else {
                stringBuffer.append("Not acknowledged</AckTime>\n");
            }
            stringBuffer.append(this.startTag("NotificationId") + alarm.getNotificationId() + "</NotificationId>" + "\n");
            stringBuffer.append(this.startTag("SystemDn") + alarm.getSystemDN() + "</SystemDn>" + "\n");
            boolean bl = false;
            if (nameValueArray != null && nameValueArray.length != 0) {
                for (int i = 0; i < nameValueArray.length; ++i) {
                    if (nameValueArray[i].getName().equalsIgnoreCase("a") || nameValueArray[i].getName().equalsIgnoreCase("b") || nameValueArray[i].getName().equalsIgnoreCase("c") || nameValueArray[i].getName().equalsIgnoreCase("d") || nameValueArray[i].getName().equalsIgnoreCase("e") || nameValueArray[i].getName().equalsIgnoreCase("f") || nameValueArray[i].getName().equalsIgnoreCase("g") || nameValueArray[i].getName().equalsIgnoreCase("h") || nameValueArray[i].getName().equalsIgnoreCase("i") || nameValueArray[i].getName().equalsIgnoreCase("j") || nameValueArray[i].getName().equalsIgnoreCase("k") || nameValueArray[i].getName().equalsIgnoreCase("l") || nameValueArray[i].getName().equalsIgnoreCase("m") || nameValueArray[i].getName().equalsIgnoreCase("n") || nameValueArray[i].getName().equalsIgnoreCase("o") || nameValueArray[i].getName().equalsIgnoreCase("p") || nameValueArray[i].getName().equalsIgnoreCase("q") || nameValueArray[i].getName().equalsIgnoreCase("r") || nameValueArray[i].getName().equalsIgnoreCase("s") || nameValueArray[i].getName().equalsIgnoreCase("t") || nameValueArray[i].getName().equalsIgnoreCase("u") || nameValueArray[i].getName().equalsIgnoreCase("v") || nameValueArray[i].getName().equalsIgnoreCase("NEAL.fixed_header.domain_name") || nameValueArray[i].getName().equalsIgnoreCase("NEAL.fixed_header.type_name") || nameValueArray[i].getName().equalsIgnoreCase("NEAL.fixed_header.event_name")) continue;
                    if (!bl) {
                        stringBuffer.append(this.startTag("ADDITIONAL_DATA") + "\n");
                        ++this.indent;
                        bl = true;
                    }
                    stringBuffer.append(this.formatNameValue(nameValueArray[i]));
                }
                if (bl) {
                    --this.indent;
                    stringBuffer.append(this.endTag("ADDITIONAL_DATA") + "\n");
                }
            }
            --this.indent;
            stringBuffer.append(this.endTag("ALARM_DATA") + "\n");
        }
        catch (Exception exception) {
            throw ExceptionHandler.map(exception, "");
        }
        return stringBuffer;
    }

    public StringBuffer formatAlarmCounter(AlarmCounter alarmCounter) throws NcliException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(this.startTag("ALARM COUNT") + "\n");
            ++this.indent;
            stringBuffer.append(this.startTag("CriticalCount") + alarmCounter.getCriticalCount() + "</CriticalCount>" + "\n");
            stringBuffer.append(this.startTag("MajorCount") + alarmCounter.getMajorCount() + "</MajorCount>" + "\n");
            stringBuffer.append(this.startTag("MinorCount") + alarmCounter.getMinorCount() + "</MinorCount>" + "\n");
            stringBuffer.append(this.startTag("WarningCount") + alarmCounter.getWarningCount() + "</WarningCount>" + "\n");
            stringBuffer.append(this.startTag("IndeterminateCount") + alarmCounter.getIndeterminateCount() + "</IndeterminateCount>" + "\n");
            stringBuffer.append(this.startTag("ClearedCount") + alarmCounter.getClearedCount() + "</ClearedCount>" + "\n");
            --this.indent;
            stringBuffer.append(this.endTag("ALARM COUNT") + "\n");
        }
        catch (Exception exception) {
            throw ExceptionHandler.map(exception, "");
        }
        return stringBuffer;
    }

    public StringBuffer formatError(NcliException ncliException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("error") + ncliException.getMessage() + "</error>" + "\n");
        return stringBuffer;
    }

    public StringBuffer formatHeader(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    public StringBuffer formatLDN(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("LDN") + string);
        stringBuffer.append("</LDN>\n");
        return stringBuffer;
    }

    public StringBuffer formatMoStart(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startTag("MO ldn=\"" + string + "\"") + "\n");
        ++this.indent;
        return stringBuffer;
    }

    public StringBuffer formatMoEnd() {
        StringBuffer stringBuffer = new StringBuffer();
        --this.indent;
        stringBuffer.append(this.endTag("MO") + "\n");
        return stringBuffer;
    }

    public StringBuffer formatLDN(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer;
    }

    public StringBuffer formatRdn(Mo[] moArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (moArray == null || moArray.length == 0) {
            return stringBuffer;
        }
        ArrayList<String> arrayList = new ArrayList<String>(0);
        for (int i = 0; i < moArray.length; ++i) {
            String string = moArray[i].getLdn();
            arrayList.add(string.substring(string.lastIndexOf(44) + 1));
        }
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.startTag("childRdn"));
            stringBuffer.append((String)iterator.next());
            stringBuffer.append("</childRdn>\n");
        }
        return stringBuffer;
    }

    public StringBuffer formatActionResult(String string, Value value, NameValueFactory nameValueFactory) {
        StringBuffer stringBuffer = new StringBuffer();
        NameValue nameValue = null;
        block0 : switch (value.getType()) {
            case 0: {
                nameValue = nameValueFactory.create(string);
                break;
            }
            case 9: {
                nameValue = nameValueFactory.create(string, value.getStringValue());
                break;
            }
            case 6: {
                nameValue = nameValueFactory.create(string, value.getLongValue());
                break;
            }
            case 7: {
                nameValue = nameValueFactory.create(string, value.getFloatValue());
                break;
            }
            case 5: {
                nameValue = nameValueFactory.create(string, value.getIntValue());
                break;
            }
            case 1: {
                nameValue = nameValueFactory.create(string, value.getBooleanValue());
                break;
            }
            case 14: {
                nameValue = nameValueFactory.create(string, value.getStringValue());
                break;
            }
            case 12: {
                nameValue = nameValueFactory.create(string, value.getMoValue());
                break;
            }
            case 11: {
                nameValue = nameValueFactory.create(string, value.getStructValue());
                break;
            }
            case 13: {
                Log.trace(ActionCommand.class, "Array of type:" + value.getArrayType());
                switch (value.getArrayType()) {
                    case 9: {
                        nameValue = nameValueFactory.create(string, value.getStringArrayValue());
                        break block0;
                    }
                    case 6: {
                        nameValue = nameValueFactory.create(string, value.getLongArrayValue());
                        break block0;
                    }
                    case 7: {
                        nameValue = nameValueFactory.create(string, value.getFloatArrayValue());
                        break block0;
                    }
                    case 5: {
                        nameValue = nameValueFactory.create(string, value.getIntArrayValue());
                        break block0;
                    }
                    case 1: {
                        nameValue = nameValueFactory.create(string, value.getBooleanArrayValue());
                        break block0;
                    }
                    case 12: {
                        nameValue = nameValueFactory.create(string, value.getMoArrayValue());
                        break block0;
                    }
                    case 11: {
                        nameValue = nameValueFactory.create(string, value.getStructArrayValue());
                    }
                }
            }
        }
        stringBuffer.append(this.startTag("actionName") + string + "</actionName>\n");
        stringBuffer.append(this.startTag("actionResult") + "\n");
        ++this.indent;
        stringBuffer.append(this.formatDataType(nameValue));
        --this.indent;
        stringBuffer.append(this.endTag("actionResult") + "\n");
        return stringBuffer;
    }

    public StringBuffer formatStruct(MomStruct momStruct) {
        return new StringBuffer();
    }

    public StringBuffer formatStructDetails(Iterator iterator) {
        return new StringBuffer();
    }

    public StringBuffer formatActionDetails(Iterator iterator) {
        return new StringBuffer();
    }

    public StringBuffer formatAttributeDetails(Iterator iterator) {
        return new StringBuffer();
    }

    public StringBuffer formatClass(MomClass momClass) {
        return new StringBuffer();
    }

    public StringBuffer formatDescriptionSection(MomEntity momEntity) {
        return new StringBuffer();
    }

    public StringBuffer formatEnum(MomEnum momEnum) {
        return new StringBuffer();
    }

    public StringBuffer formatGroupMembers(List list) {
        return new StringBuffer();
    }

    public StringBuffer formatGroupName(String string) {
        return new StringBuffer();
    }

    public StringBuffer formatParagraphSeparator() {
        return new StringBuffer();
    }

    public StringBuffer formatDiff(Mo[] moArray, String string) {
        return new StringBuffer();
    }

    public StringBuffer formatSeverityInfo(SeverityInfo severityInfo) {
        return new StringBuffer();
    }
}

