/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.completion.completers;

import java.util.ArrayList;
import java.util.StringTokenizer;
import se.ericsson.cello.ncli.server.completion.Completer;
import se.ericsson.cello.ncli.server.completion.CompleterFactory;
import se.ericsson.cello.ncli.server.completion.CsCmdCompleter;
import se.ericsson.cello.ncli.server.completion.SearchExpressionCompleter;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.logging.Log;

public class CmdGetCompleter
extends CsCmdCompleter {
    static final String CHILD_FLAG = "-c";
    static final String ATTRIBUTE_FLAG = "-a";
    static final String PM_FLAG = "-pm";
    static final String EXPRESSION_FLAG = "-e(";

    public CmdGetCompleter(NodeServices nodeServices) {
        super(nodeServices);
    }

    public void completeString(String string) {
        Log.trace(CmdGetCompleter.class, "completeString(" + string + ")");
        super.completeString(string);
    }

    protected boolean completeFirstToken(String string, StringTokenizer stringTokenizer, String string2) {
        if (!stringTokenizer.hasMoreTokens()) {
            if (string2.endsWith(" ")) {
                boolean bl = this.completeMoAddress("", stringTokenizer, string2);
                this.completionOptionList.add(EXPRESSION_FLAG);
                return bl;
            }
            Log.trace(CmdGetCompleter.class, ".completeFirstToken(), this GetCmdCompleter should not have been called.");
            return false;
        }
        string = stringTokenizer.nextToken();
        if (string2.indexOf(EXPRESSION_FLAG) > -1) {
            return this.completeExpressionFlag(string, stringTokenizer, string2);
        }
        return this.completeMoAddress(string, stringTokenizer, string2);
    }

    protected boolean completeFlag(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdGetCompleter.class, "completeFlag() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (string.startsWith(ATTRIBUTE_FLAG)) {
            return this.completeAttributeFlag(string, stringTokenizer, string2);
        }
        if (string.startsWith(CHILD_FLAG)) {
            return this.completeChildrenFlag(string, stringTokenizer, string2);
        }
        if (string.startsWith(EXPRESSION_FLAG)) {
            return this.completeExpressionFlag(string, stringTokenizer, string2);
        }
        this.completedString = string2;
        this.addFlagsToOptions(string2);
        return true;
    }

    protected boolean completeExpressionFlag(String string, StringTokenizer stringTokenizer, String string2) {
        boolean bl = true;
        String string3 = string2.substring(0, string2.indexOf(EXPRESSION_FLAG) + 3);
        String string4 = string2.substring(string2.indexOf(EXPRESSION_FLAG) + 3);
        SearchExpressionCompleter searchExpressionCompleter = new SearchExpressionCompleter(this.nodeServices);
        searchExpressionCompleter.completeString(string4);
        this.completedString = string3 + searchExpressionCompleter.getCompletedString();
        this.completionOptionList = searchExpressionCompleter.getCompletionOptionList();
        return bl;
    }

    protected boolean completeMoAddress(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdGetCompleter.class, "completeMoAddress() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        boolean bl = super.completeMoAddress(string, stringTokenizer, string2);
        if (bl) {
            return true;
        }
        string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
        return this.completeAttrName(string, stringTokenizer, string2);
    }

    protected boolean completeAttrName(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdGetCompleter.class, "completeAttrName() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (string.startsWith("-")) {
            return this.completeFlag(string, stringTokenizer, string2);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            return this.completeAttrName(string, stringTokenizer, string2);
        }
        String string3 = string;
        if (string2.endsWith(" ")) {
            string3 = "";
        }
        String string4 = null;
        String[] stringArray = null;
        if (!this.globalAddr) {
            string4 = this.nodeServices.getAddressResolver().resolveAddress(this.moAddress);
        } else {
            stringArray = this.nodeServices.getAddressResolver().getGlobalAddress(this.moAddress);
            if (stringArray != null && stringArray.length > 0) {
                string4 = stringArray[0];
            }
        }
        Completer completer = CompleterFactory.createAttrNameCompleter(this.nodeServices, string4, true, true);
        int n = string2.lastIndexOf(string3);
        String string5 = string2.substring(0, n);
        completer.completeString(string3);
        if (completer.getCompletionOptionList().size() == 0) {
            this.completedString = string5.concat(completer.getCompletedString());
        } else if (completer.getCompletionOptionList().size() == 1) {
            this.completedString = string5.concat(completer.getCompletedString()).concat(" ");
            this.completionOptionList.clear();
        } else if (completer.getCompletionOptionList().size() > 1) {
            this.completedString = string5.concat(completer.getCompletedString());
            this.completionOptionList = completer.getCompletionOptionList();
        }
        if (string2.endsWith(" ")) {
            this.addFlagsToOptions(string2);
            return true;
        }
        return true;
    }

    protected boolean completeChildrenFlag(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdGetCompleter.class, "completeChildrenFlag() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            return this.completeChildren(string, stringTokenizer, string2);
        }
        if (string2.endsWith(" ")) {
            string = "";
            return this.completeChildren(string, stringTokenizer, string2);
        }
        if (string2.equals(CHILD_FLAG)) {
            this.completedString = string2.concat(" ");
            return true;
        }
        int n = string2.lastIndexOf(string);
        String string3 = string2.substring(0, n);
        String string4 = "-c ";
        if (string.length() == 0 || string4.toLowerCase().startsWith(string)) {
            this.completedString = string3.concat(string4);
            return true;
        }
        return false;
    }

    protected boolean completeAttributeFlag(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdGetCompleter.class, "completeAttributeFlag() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            return this.completeChildrenFlag(string, stringTokenizer, string2);
        }
        if (string2.endsWith(" ") && string2.indexOf(CHILD_FLAG) == -1) {
            this.completedString = string2;
            this.completionOptionList.add(CHILD_FLAG);
            return true;
        }
        int n = string2.lastIndexOf(string);
        String string3 = string2.substring(0, n);
        String string4 = ATTRIBUTE_FLAG;
        if (string.length() == 0 || string4.toLowerCase().startsWith(string)) {
            this.completedString = string3.concat(string4);
            return true;
        }
        return false;
    }

    protected boolean completeChildren(String string, StringTokenizer stringTokenizer, String string2) {
        Log.trace(CmdGetCompleter.class, "completeChildren() currToken='" + string + "', aStringToComplete ='" + string2 + "'");
        this.completionOptionList = new ArrayList();
        if (string.startsWith("-")) {
            return this.completeFlag(string, stringTokenizer, string2);
        }
        if (string2.endsWith(" ")) {
            string = "";
            this.addFlagsToOptions(string2);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            return this.completeChildren(string, stringTokenizer, string2);
        }
        String string3 = null;
        String[] stringArray = null;
        if (!this.globalAddr) {
            string3 = this.nodeServices.getAddressResolver().resolveAddress(this.moAddress);
        } else {
            stringArray = this.nodeServices.getAddressResolver().getGlobalAddress(this.moAddress);
            if (stringArray != null && stringArray.length > 0) {
                string3 = stringArray[0];
            }
        }
        Log.trace(CmdGetCompleter.class, "Resolved LDN = " + string3);
        Completer completer = CompleterFactory.createChildCompleter(this.nodeServices, this.moAddress);
        int n = string2.lastIndexOf(string);
        String string4 = string2.substring(0, n);
        completer.completeString(string);
        this.completedString = string4.concat(completer.getCompletedString());
        this.completionOptionList.addAll(completer.getCompletionOptionList());
        return true;
    }

    protected void addFlagsToOptions(String string) {
        if (string.indexOf(PM_FLAG) == -1) {
            if (string.indexOf(ATTRIBUTE_FLAG) == -1) {
                this.completionOptionList.add(ATTRIBUTE_FLAG);
            }
            if (string.indexOf(CHILD_FLAG) == -1) {
                this.completionOptionList.add(CHILD_FLAG);
            }
            if (string.indexOf(CHILD_FLAG) == -1 && string.indexOf(ATTRIBUTE_FLAG) == -1) {
                this.completionOptionList.add(PM_FLAG);
            }
        }
    }
}

