/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.cs.momfilter;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomRange;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructMember;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredException;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredMo;
import se.ericsson.cello.ncli.server.cs.momfilter.MomFilteredNode;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NotificationType;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.neal.cm.Value;

public class MomFilteredMoImpl
implements MomFilteredMo {
    private Mo mo;
    private MomFilteredNode filteredNode;
    private MimModel mim;
    private boolean verifiedInMom = false;
    private boolean checkPerformed = false;
    private String moError = "The LDN is not defined in the MOM: ";

    public MomFilteredMoImpl(Mo mo, MomFilteredNode momFilteredNode, MimModel mimModel, boolean bl) {
        this.mo = mo;
        this.filteredNode = momFilteredNode;
        this.mim = mimModel;
        this.verifiedInMom = bl;
    }

    public Value action(String string, NameValue[] nameValueArray, Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        if (this.actionAllowed(string)) {
            return this.mo.action(string, nameValueArray, transaction);
        }
        throw new MomFilteredException("The action " + string + " was not found in the MOM");
    }

    public int compareTo(Object object) {
        return this.mo.compareTo(object);
    }

    public Mo createChild(String string, String string2, NameValue[] nameValueArray, Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        if (!this.checkChildAllowed(string2)) {
            throw new MomFilteredException("The Mo Class " + string2 + " is not a valid child");
        }
        if (nameValueArray != null) {
            String[] stringArray = new String[nameValueArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = nameValueArray[i].getName();
            }
        }
        this.checkAllAttributesAllowed(string2, nameValueArray);
        return new MomFilteredMoImpl(this.mo.createChild(string, string2, nameValueArray, transaction), this.filteredNode, this.mim, true);
    }

    public Mo createChild(String string, String string2, Mo mo, NameValue[] nameValueArray, Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        if (!this.checkChildAllowed(string2)) {
            throw new MomFilteredException("The Mo Class " + string2 + " is not a valid child");
        }
        if (nameValueArray != null) {
            String[] stringArray = new String[nameValueArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = nameValueArray[i].getName();
            }
        }
        this.checkAllAttributesAllowed(string2, nameValueArray);
        return new MomFilteredMoImpl(this.mo.createChild(string, string2, mo, nameValueArray, transaction), this.filteredNode, this.mim, true);
    }

    public void delete(Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        this.mo.delete(transaction);
    }

    public void delete(String string, String string2, Scope scope, Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        if (!this.checkIfMoAccepted(string)) {
            throw new MomFilteredException("The Mo Class " + string + " is not defined in the MOM");
        }
        this.mo.delete(string, string2, scope, transaction);
    }

    public boolean exists() {
        if (this.checkIfMoAccepted(this.mo)) {
            return this.mo.exists();
        }
        return false;
    }

    public NameValue getAttribute(String string, Transaction transaction) {
        String[] stringArray = new String[]{string};
        return this.getAttributes(stringArray, transaction)[0];
    }

    public NameValue[] getAttributes(String[] stringArray, Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        this.checkAllAttributesAllowed(this.getType(), stringArray);
        return this.mo.getAttributes(stringArray, transaction);
    }

    public Mo[] getChildren(Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        ArrayList<MomFilteredMoImpl> arrayList = new ArrayList<MomFilteredMoImpl>();
        Mo[] moArray = this.mo.getChildren(transaction);
        for (int i = 0; i < moArray.length; ++i) {
            if (!this.checkIfMoAccepted(moArray[i].getType())) continue;
            arrayList.add(new MomFilteredMoImpl(moArray[i], this.filteredNode, this.mim, true));
        }
        return arrayList.toArray(new Mo[arrayList.size()]);
    }

    public Mo[] getChildren(String string, String string2, Scope scope, Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        ArrayList<MomFilteredMoImpl> arrayList = new ArrayList<MomFilteredMoImpl>();
        Mo[] moArray = this.mo.getChildren(string, string2, scope, transaction);
        for (int i = 0; i < moArray.length; ++i) {
            if (!this.checkIfMoAccepted(moArray[i].getType())) continue;
            arrayList.add(new MomFilteredMoImpl(moArray[i], this.filteredNode, this.mim, true));
        }
        return arrayList.toArray(new Mo[arrayList.size()]);
    }

    public String getFdn() {
        return this.mo.getFdn();
    }

    public String getLdn() {
        return this.mo.getLdn();
    }

    public String getMibPrefix() {
        return this.mo.getMibPrefix();
    }

    public String getName() {
        return this.mo.getName();
    }

    public Node getNode() {
        return this.filteredNode;
    }

    public Mo getParent(Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        Mo mo = this.mo.getParent(transaction);
        if (!this.checkIfMoAccepted(mo)) {
            throw new MomFilteredException("The parent Mo Class " + mo.getName() + " is not defined in the MOM for LDN: " + this.getLdn());
        }
        return new MomFilteredMoImpl(mo, this.filteredNode, this.mim, false);
    }

    public String getType() {
        return this.mo.getType();
    }

    public boolean hasChildren(Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        Mo[] moArray = this.getChildren(transaction);
        return moArray.length != 0;
    }

    public void resetCache() {
        this.mo.resetCache();
    }

    public void setAttribute(NameValue nameValue, Transaction transaction) {
        NameValue[] nameValueArray = new NameValue[]{nameValue};
        this.setAttributes(nameValueArray, transaction);
    }

    public void setAttributes(NameValue[] nameValueArray, Transaction transaction) {
        if (!this.isThisMoAllowed()) {
            throw new MomFilteredException(this.moError + this.getLdn());
        }
        this.checkAllAttributesAllowed(this.getType(), nameValueArray);
        this.checkAllAttributesNonReadOnly(this.getType(), nameValueArray);
        this.mo.setAttributes(nameValueArray, transaction);
    }

    public CmSubscription subscribe(NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer) {
        return this.mo.subscribe(notificationType, cmNotificationConsumer);
    }

    public CmSubscription subscribe(Scope scope, NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer) {
        return this.mo.subscribe(scope, notificationType, cmNotificationConsumer);
    }

    public CmSubscription subscribe(Scope scope, String[] stringArray, NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer) {
        return this.mo.subscribe(scope, stringArray, notificationType, cmNotificationConsumer);
    }

    private boolean checkIfMoAccepted(Mo mo) {
        return this.mim.getClass(mo.getType()) != null;
    }

    private boolean checkIfMoAccepted(String string) {
        return this.mim.getClass(string) != null;
    }

    private boolean isThisMoAllowed() {
        if (!this.checkPerformed) {
            this.verifiedInMom = this.checkIfMoAccepted(this.mo);
            this.checkPerformed = true;
        }
        return this.verifiedInMom;
    }

    private boolean checkChildAllowed(String string) {
        Iterator iterator = this.mim.getClass(this.mo.getType()).getContainmentChildren();
        MomClass momClass = null;
        while (iterator.hasNext()) {
            momClass = (MomClass)iterator.next();
            if (!momClass.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private boolean actionAllowed(String string) {
        Iterator iterator = this.mim.getClass(this.getType()).getActions();
        MomAction momAction = null;
        while (iterator.hasNext()) {
            momAction = (MomAction)iterator.next();
            if (!momAction.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void checkAllAttributesAllowed(String string, NameValue[] nameValueArray) throws MomFilteredException {
        MomClass momClass = this.mim.getClass(string);
        MomAttribute momAttribute = null;
        for (int i = 0; i < nameValueArray.length; ++i) {
            momAttribute = momClass.getAttribute(nameValueArray[i].getName());
            if (momAttribute == null) {
                throw new MomFilteredException("The attribute " + nameValueArray[i].getName() + " is not defined in the MOM for LDN: " + this.getLdn());
            }
            if (this.isValidRange(momAttribute, nameValueArray[i])) continue;
            throw new MomFilteredException("The attribute " + nameValueArray[i].getName() + " is out of range according to the MOM for LDN: " + this.getLdn());
        }
    }

    private void checkAllAttributesNonReadOnly(String string, NameValue[] nameValueArray) throws MomFilteredException {
        MomClass momClass = this.mim.getClass(string);
        MomAttribute momAttribute = null;
        for (int i = 0; i < nameValueArray.length; ++i) {
            momAttribute = momClass.getAttribute(nameValueArray[i].getName());
            if (momAttribute == null) {
                throw new MomFilteredException("The attribute " + nameValueArray[i].getName() + " is not defined in the MOM for LDN: " + this.getLdn());
            }
            if (!momAttribute.isReadOnly()) continue;
            throw new MomFilteredException("The attribute " + nameValueArray[i].getName() + " is defined as readonly in the MOM for LDN: " + this.getLdn());
        }
    }

    private void checkAllAttributesAllowed(String string, String[] stringArray) throws MomFilteredException {
        MomClass momClass = this.mim.getClass(string);
        MomAttribute momAttribute = null;
        for (int i = 0; i < stringArray.length; ++i) {
            momAttribute = momClass.getAttribute(stringArray[i]);
            if (momAttribute != null) continue;
            throw new MomFilteredException("The attribute " + stringArray[i] + " is not defined in the MOM for LDN: " + this.getLdn());
        }
    }

    private boolean isValidRange(MomEntity momEntity, NameValue nameValue) {
        if (momEntity != null) {
            if (momEntity instanceof MomAttribute) {
                momEntity = ((MomAttribute)momEntity).getType();
            }
            if (momEntity instanceof MomCorbaTypeAttribute) {
                return this.isValidSimpleAttribute((MomCorbaTypeAttribute)momEntity, nameValue);
            }
            if (momEntity instanceof MomStruct) {
                return this.isValidStruct((MomStruct)momEntity, nameValue.getStructValue());
            }
            if (momEntity instanceof MomSequence) {
                return this.isValidSequence((MomSequence)momEntity, nameValue);
            }
            if (momEntity instanceof MomClass) {
                return this.checkIfMoAccepted(momEntity.getName());
            }
            if (momEntity instanceof MomEnumRef) {
                return this.isValidEnumRef((MomEnumRef)momEntity, nameValue.getIntegerValue());
            }
        } else {
            return true;
        }
        return true;
    }

    private boolean isValidEnumRef(MomEnumRef momEnumRef, Integer n) {
        Iterator iterator = momEnumRef.getEnum().getMembers();
        while (iterator != null && iterator.hasNext()) {
            if (!((MomEnumMember)iterator.next()).getValue().equals(n)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidSimpleAttribute(MomCorbaTypeAttribute momCorbaTypeAttribute, NameValue nameValue) {
        boolean bl = false;
        Iterator iterator = momCorbaTypeAttribute.getRanges();
        String string = momCorbaTypeAttribute.getType();
        if (!iterator.hasNext()) {
            return true;
        }
        if (string.equalsIgnoreCase("String")) {
            bl = this.checkStringRange(iterator, nameValue.getStringValue());
        } else if (string.equalsIgnoreCase("Integer")) {
            bl = this.checkIntegerRange(iterator, (Number)nameValue.getIntegerValue());
        } else if (string.equalsIgnoreCase("boolean")) {
            bl = this.checkBooleanRange(iterator, nameValue.getBooleanValue());
        } else if (string.equalsIgnoreCase("long")) {
            bl = this.checkLongRange(iterator, nameValue.getLongValue());
        } else if (string.equalsIgnoreCase("float")) {
            bl = this.checkFloatRange(iterator, nameValue.getFloatValue());
        } else {
            Log.trace(MomFilteredMoImpl.class, "isValidSimpleAttribute, Did not recognize the type: " + string);
            return true;
        }
        return bl;
    }

    boolean isValidSequence(MomSequence momSequence, NameValue nameValue) {
        if (momSequence.getType() instanceof MomCorbaTypeAttribute) {
            return this.isValidSequenceValue((MomCorbaTypeAttribute)momSequence.getType(), nameValue);
        }
        if (momSequence.getType() instanceof MomEnumRef) {
            int[] nArray = nameValue.getIntArrayValue();
            for (int i = 0; i < nArray.length; ++i) {
                if (this.isValidEnumRef((MomEnumRef)momSequence.getType(), new Integer(nArray[i]))) continue;
                return false;
            }
        } else if (momSequence.getType() instanceof MomStruct) {
            Struct[] structArray = nameValue.getStructArrayValue();
            for (int i = 0; i < structArray.length; ++i) {
                if (this.isValidStruct((MomStruct)momSequence.getType(), structArray[i])) continue;
                return false;
            }
        } else if (momSequence.getType() instanceof MomClass && !this.checkIfMoAccepted(momSequence.getType().getName())) {
            return false;
        }
        return true;
    }

    boolean isValidSequenceValue(MomCorbaTypeAttribute momCorbaTypeAttribute, NameValue nameValue) {
        Iterator iterator = momCorbaTypeAttribute.getRanges();
        if (!iterator.hasNext()) {
            return true;
        }
        switch (nameValue.getArrayType()) {
            case 9: {
                String[] stringArray = nameValue.getStringArrayValue();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (this.checkStringRange(momCorbaTypeAttribute.getRanges(), stringArray[i])) continue;
                    return false;
                }
                break;
            }
            case 6: {
                long[] lArray = nameValue.getLongArrayValue();
                for (int i = 0; i < lArray.length; ++i) {
                    if (this.checkLongRange(momCorbaTypeAttribute.getRanges(), lArray[i])) continue;
                    return false;
                }
                break;
            }
            case 5: {
                int[] nArray = nameValue.getIntArrayValue();
                for (int i = 0; i < nArray.length; ++i) {
                    if (this.checkLongRange(momCorbaTypeAttribute.getRanges(), (long)nArray[i])) continue;
                    return false;
                }
                break;
            }
            case 7: {
                float[] fArray = nameValue.getFloatArrayValue();
                for (int i = 0; i < fArray.length; ++i) {
                    if (this.checkFloatRange(momCorbaTypeAttribute.getRanges(), fArray[i])) continue;
                    return false;
                }
                break;
            }
            case 1: {
                boolean[] blArray = nameValue.getBooleanArrayValue();
                for (int i = 0; i < blArray.length; ++i) {
                    if (this.checkBooleanRange(momCorbaTypeAttribute.getRanges(), blArray[i])) continue;
                    return false;
                }
                break;
            }
            default: {
                Log.trace(MomFilteredMoImpl.class, "Unsupported sequence type: " + nameValue.getType());
                return false;
            }
        }
        return true;
    }

    private boolean isValidStruct(MomStruct momStruct, Struct struct) {
        Iterator iterator = momStruct.getMembers();
        while (iterator != null && iterator.hasNext()) {
            String string;
            Object e = iterator.next();
            if (!(e instanceof MomStructMember) || this.isValidRange((MomEntity)e, struct.getMember(string = ((MomStructMember)e).getName()))) continue;
            return false;
        }
        return true;
    }

    private boolean checkLongRange(Iterator iterator, long l) {
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            bl = this.checkLongRange((MomRange)iterator.next(), l);
        }
        return bl;
    }

    private boolean checkBooleanRange(Iterator iterator, boolean bl) {
        boolean bl2 = false;
        while (iterator.hasNext() && !bl2) {
            bl2 = this.checkBooleanRange((MomRange)iterator.next(), bl);
        }
        return bl2;
    }

    boolean checkIntegerRange(Iterator iterator, Number number) {
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            bl = this.checkIntegerRange((MomRange)iterator.next(), number);
        }
        return bl;
    }

    boolean checkStringRange(Iterator iterator, String string) {
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            bl = this.checkStringRange((MomRange)iterator.next(), string);
        }
        return bl;
    }

    boolean checkFloatRange(Iterator iterator, float f) {
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            bl = this.checkFloatRange((MomRange)iterator.next(), f);
        }
        return bl;
    }

    boolean checkLongRange(MomRange momRange, long l) {
        return (double)l <= momRange.getMax().doubleValue() && (double)l >= momRange.getMin().doubleValue();
    }

    boolean checkBooleanRange(MomRange momRange, boolean bl) {
        return true;
    }

    private boolean checkIntegerRange(MomRange momRange, Number number) {
        return number.doubleValue() <= momRange.getMax().doubleValue() && number.doubleValue() >= momRange.getMin().doubleValue();
    }

    private boolean checkStringRange(MomRange momRange, String string) {
        return string.length() <= momRange.getMax().intValue() && string.length() >= momRange.getMin().intValue();
    }

    private boolean checkFloatRange(MomRange momRange, float f) {
        return (double)f <= momRange.getMax().doubleValue() && (double)f >= momRange.getMin().doubleValue();
    }

    public Mo getUnfilteredMo() {
        return this.mo;
    }
}

