/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.services;

import java.util.Timer;
import java.util.TimerTask;
import se.ericsson.cello.ncli.mao.NcliMoImpl;
import se.ericsson.cello.ncli.server.configuration.ConfigurationReader;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.services.ControllableServer;
import se.ericsson.cello.ncli.server.services.NCLIServices;
import se.ericsson.cello.ncli.server.session.SessionDataManager;
import se.ericsson.cello.ncli.server.session.SessionDataManagerFactory;
import se.ericsson.cello.ncli.server.session.SessionManager;

public class NCLIServer
implements ControllableServer,
Runnable {
    private static NCLIServer instance;
    private int myStatus = 0;
    private SessionStopper sessionStopper;
    private SessionManager mySessionManager = null;
    private Thread myNcliServerThread = null;
    private SessionDataManager mySessionDataManager;
    private static final int SESSION_DATA_POLL_INTERVAL = 60000;
    private static int DISABLED;
    private static int ENABLED;

    private NCLIServer() {
    }

    public static synchronized NCLIServer getInstance() {
        if (instance == null) {
            instance = new NCLIServer();
        }
        return instance;
    }

    public void init() {
    }

    public void start() {
        if (this.sessionStopper != null) {
            this.sessionStopper.cancelTask();
            this.sessionStopper = null;
            this.mySessionManager.allowNewSessions();
            this.myStatus = ENABLED;
            return;
        }
        if (this.myNcliServerThread == null || !this.myNcliServerThread.isAlive()) {
            this.myNcliServerThread = new Thread((Runnable)this, "NcliServer");
            this.myNcliServerThread.start();
        }
    }

    public synchronized void stop(int n) {
        if (this.myStatus == DISABLED) {
            if (n == 0 && this.sessionStopper != null) {
                this.sessionStopper.cancelTask();
                this.sessionStopper = null;
                this.stopServer();
            }
        } else {
            this.mySessionManager.denyNewSessions();
            this.myStatus = DISABLED;
            if (n > 0) {
                this.sessionStopper = new SessionStopper(n);
            } else {
                this.stopServer();
            }
        }
    }

    public void stopServer() {
        this.mySessionDataManager.clean();
        this.mySessionDataManager.stopManager();
        SessionDataManagerFactory.getSessionDataManager();
        this.mySessionManager.stopAllSessions();
        this.mySessionManager = null;
        this.myNcliServerThread = null;
        this.sessionStopper = null;
    }

    public int getStatus() {
        return this.myStatus;
    }

    public void run() {
        Log.trace(NCLIServer.class, "NCLIServer::run()");
        try {
            if (this.myNcliServerThread != null && this.myNcliServerThread.isAlive()) {
                ConfigurationReader configurationReader = NCLIServices.getConfigurationReader();
                Integer n = new Integer(configurationReader.getMaxNrOfSessions());
                this.startSessionDataManager();
                this.startSessionManager(n);
            }
        }
        catch (Exception exception) {
            Log.error(NCLIServer.class, "Unexpected error:", exception);
        }
    }

    public Thread getNcliServerThread() {
        return this.myNcliServerThread;
    }

    public static void main(String[] stringArray) {
        NCLIServer nCLIServer = new NCLIServer();
        nCLIServer.startSessionDataManager();
        nCLIServer.startSessionManager(new Integer(2));
    }

    private void startSessionDataManager() {
        this.mySessionDataManager = SessionDataManagerFactory.getSessionDataManager();
        this.mySessionDataManager.startManager(60000L);
    }

    private void startSessionManager(Integer n) {
        this.mySessionManager = new SessionManager(n);
        this.myStatus = ENABLED;
        this.mySessionManager.listen();
        this.myStatus = DISABLED;
    }

    static {
        DISABLED = 0;
        ENABLED = 1;
    }

    public class SessionStopper {
        int delay;
        Timer timer;
        boolean cancel = false;
        DelayTask task;

        public SessionStopper(int n) {
            int n2 = 1000 * n;
            this.timer = new Timer();
            this.task = new DelayTask(n2);
            this.timer.schedule((TimerTask)this.task, 0L);
        }

        public void stopSession() {
            if (!this.cancel) {
                NcliMoImpl.instance().setAdministrativeStateToLocked();
            }
            this.timer.cancel();
            this.timer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelTask() {
            this.cancel = true;
            DelayTask delayTask = this.task;
            synchronized (delayTask) {
                this.task.notify();
            }
        }

        class DelayTask
        extends TimerTask {
            int delay;
            int time = 0;

            public DelayTask(int n) {
                this.delay = n;
            }

            public synchronized void run() {
                try {
                    this.wait(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    SessionStopper.this.cancel = true;
                }
                SessionStopper.this.stopSession();
            }
        }
    }
}

