/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.session;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import se.ericsson.cello.ncli.server.command.handlers.CommandFileHandling;
import se.ericsson.cello.ncli.server.command.handlers.CommandHandlerFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.cs.NodeServicesFactory;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.session.CommandFileSession;

public class CommandFileSessionImpl
implements CommandFileSession {
    private BufferedReader stream = null;
    private NodeServices nodeServices = NodeServicesFactory.createNodeService();
    private CommandFileHandling cmdHandler = CommandHandlerFactory.createCommandFileHandler(this, this.nodeServices);
    private boolean cmdLineError = false;
    private String errorMessage = null;
    private int lineRead = 0;
    private String cmdLine = null;
    private String commandFileName = null;

    protected BufferedReader openFileStream(String string) throws NcliException, FileNotFoundException {
        this.stream = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
        return this.stream;
    }

    protected void closeFileStream() {
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            Log.info(CommandFileSessionImpl.class, "Could not close file stream");
        }
        this.stream = null;
    }

    public void sendCommandResponse(String string) {
    }

    public void sendErrorResponse(boolean bl, String string) {
        this.cmdLineError = bl;
        this.errorMessage = string;
    }

    public String getConfirmation(String string) {
        return null;
    }

    public void sendPrompt() {
    }

    public boolean checkCancellation() {
        return false;
    }

    public void closeSession() {
    }

    public void executeCommandFile(String string) throws NcliException, FileNotFoundException {
        this.executeCommandFileAsAction(string);
    }

    public void executeCommandFileAsAction(String string) throws NcliException, FileNotFoundException {
        Log.trace(CommandFileSessionImpl.class, "CommandFileSessionImpl:executeCommandFileAsAction");
        this.commandFileName = string;
        this.cmdHandler.connect(null);
        this.openFileStream(this.commandFileName);
        try {
            while ((this.cmdLine = this.stream.readLine()) != null) {
                ++this.lineRead;
                this.cmdHandler.executeCommandFromFile(this.cmdLine);
                if (!this.cmdLineError) continue;
                this.nodeServices.getHardTransactionHandler().hardRollbackTransaction();
                break;
            }
            this.cmdHandler.endOfFile(false);
        }
        catch (IOException iOException) {
            this.cmdHandler.endOfFile(true);
            this.closeFileStream();
            throw new NcliException("Could not read from command file!", iOException);
        }
        catch (Exception exception) {
            this.cmdHandler.endOfFile(true);
            String string2 = this.getErrorMessage().append("\n").append(exception.getMessage()).toString();
            this.closeFileStream();
            throw new NcliException(string2);
        }
        this.closeFileStream();
        if (this.cmdLineError) {
            String string3 = this.getErrorMessage().append("\n").append(this.errorMessage).toString();
            this.cmdLineError = false;
            throw new NcliException(string3);
        }
    }

    public void acknowledgeConnection(boolean bl, String string) {
    }

    public void sendHistoryResponse(String string) {
    }

    public void sendCancelAcknowledge(String string) {
    }

    private StringBuffer getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Errors encountered at line ").append(this.lineRead).append(" :\n");
        stringBuffer.append(this.cmdLine).append("\n");
        stringBuffer.append("in script file: ").append(this.commandFileName);
        return stringBuffer;
    }
}

