/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.session;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriber;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgr;
import se.ericsson.cello.moframework.csnotifications.CSNotificationSubscriberMgrFactory;
import se.ericsson.cello.moframework.csnotifications.OrbRestartSubscriber;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.session.CommandLineSession;
import se.ericsson.cello.ncli.server.session.SessionEventListener;
import se.ericsson.cello.ncli.server.session.SessionFactory;

public class SessionManager
implements SessionEventListener,
OrbRestartSubscriber {
    private int maxNumOfSessions;
    private ServerSocket serverSocket;
    private boolean shutDownFlag = false;
    static final int DEFAULT_PORT_NUMBER = 5050;
    private Vector sessions;
    private static final String LOCAL_HOST = "localhost";
    private boolean noNewSessions = false;
    private static final String SESSION_NAME_PREFIX = "NcliSession-";
    private static final int MAX_FAILED_CONNECTION_ATTEMPTS = 5;
    private boolean inhibitSessionRemoval = false;
    private static final String HOST_DIR = System.getProperty("sim.host.dir", "/host");
    private static final String NCLISERVER_PORT_NUMBER = HOST_DIR + "/ncliserver_port";

    public SessionManager(Integer n) {
        this.maxNumOfSessions = n;
        this.noNewSessions = false;
        this.sessions = new Vector(this.maxNumOfSessions + 1);
        CSNotificationSubscriberMgr cSNotificationSubscriberMgr = CSNotificationSubscriberMgrFactory.createCSNotificationSubscriberMgr();
        cSNotificationSubscriberMgr.register((CSNotificationSubscriber)this);
    }

    public void listen() {
        int n = 1;
        String string = null;
        int n2 = 0;
        try {
            int n3 = 5050;
            if (System.getProperty("SIM", "false").equalsIgnoreCase("true") || System.getProperty("javasim") != null) {
                ServerSocket serverSocket = new ServerSocket(0);
                n3 = serverSocket.getLocalPort();
                serverSocket.close();
                Log.info(SessionManager.class, "We are running on SimCello/JavaSim NCLI Server is running on port " + n3);
                FileWriter fileWriter = new FileWriter(NCLISERVER_PORT_NUMBER);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write("" + n3);
                bufferedWriter.close();
            }
            if (System.getProperty("REMOTE", "false").equalsIgnoreCase("true")) {
                Log.trace(SessionManager.class, "Server socket is unbinded");
                this.serverSocket = new ServerSocket(0, this.maxNumOfSessions + 1);
            } else {
                this.serverSocket = new ServerSocket(n3, this.maxNumOfSessions + 1, InetAddress.getByName(LOCAL_HOST));
                Log.trace(SessionManager.class, "Binding server socket to " + InetAddress.getByName(LOCAL_HOST));
            }
        }
        catch (IOException iOException) {
            Log.info(SessionManager.class, "Unable to create socket");
            Log.trace(SessionManager.class, iOException.getMessage());
            return;
        }
        Log.trace(SessionManager.class, "Starting Server loop!");
        while (!this.shutDownFlag) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
                Log.trace(class$se$ericsson$cello$ncli$server$session$SessionManager == null ? SessionManager.class$("se.ericsson.cello.ncli.server.session.SessionManager") : class$se$ericsson$cello$ncli$server$session$SessionManager, "Starting new CommandLineSession thread.");
                this.addSession(SessionFactory.createCommandLineSession(this, socket));
                string = SESSION_NAME_PREFIX + Integer.toString(n++);
                if (n == 100) {
                    n = 1;
                }
                new Thread((Runnable)((CommandLineSession)this.sessions.get(this.getActiveSessions() - 1)), string).start();
                Log.trace(class$se$ericsson$cello$ncli$server$session$SessionManager == null ? SessionManager.class$("se.ericsson.cello.ncli.server.session.SessionManager") : class$se$ericsson$cello$ncli$server$session$SessionManager, "Started new Ncli session thread: " + string);
            }
            catch (InterruptedIOException interruptedIOException) {
                Log.trace(class$se$ericsson$cello$ncli$server$session$SessionManager == null ? SessionManager.class$("se.ericsson.cello.ncli.server.session.SessionManager") : class$se$ericsson$cello$ncli$server$session$SessionManager, interruptedIOException.getMessage());
                socket = null;
                if (this.shutDownFlag) continue;
            }
            catch (IOException iOException) {
                if (this.shutDownFlag) {
                    Log.trace(class$se$ericsson$cello$ncli$server$session$SessionManager == null ? SessionManager.class$("se.ericsson.cello.ncli.server.session.SessionManager") : class$se$ericsson$cello$ncli$server$session$SessionManager, "ServerSocket closed due to stop request");
                    continue;
                }
                if (++n2 == 5) {
                    Log.info(class$se$ericsson$cello$ncli$server$session$SessionManager == null ? SessionManager.class$("se.ericsson.cello.ncli.server.session.SessionManager") : class$se$ericsson$cello$ncli$server$session$SessionManager, "Maximum number of failed connections attempts has been exceeded", iOException);
                    this.stopAllSessions();
                    continue;
                }
                Log.info(class$se$ericsson$cello$ncli$server$session$SessionManager == null ? SessionManager.class$("se.ericsson.cello.ncli.server.session.SessionManager") : class$se$ericsson$cello$ncli$server$session$SessionManager, "Could not accept connection. Failed attempt #" + n2);
            }
        }
    }

    public void orbRestartInitiated() {
        Log.trace(SessionManager.class, "ORB restart is initiated.");
        this.stopAllSessions("Session is closed due to restart of the ORB.");
    }

    public synchronized void stopAllSessions() {
        this.shutDownFlag = true;
        this.stopAllSessions(null);
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            Log.info(SessionManager.class, "Closing of ServerSocket failed.");
        }
    }

    private synchronized void stopAllSessions(String string) {
        this.inhibitSessionRemoval = true;
        Log.trace(SessionManager.class, "Stopping all sessions (" + this.sessions.size() + ")");
        if (this.sessions.size() > 0) {
            Iterator iterator = this.sessions.iterator();
            while (iterator.hasNext()) {
                CommandLineSession commandLineSession = (CommandLineSession)iterator.next();
                commandLineSession.stop(string);
            }
        }
        this.sessions.clear();
        this.inhibitSessionRemoval = false;
    }

    public void denyNewSessions() {
        this.noNewSessions = true;
    }

    public void allowNewSessions() {
        this.noNewSessions = false;
    }

    public void onSessionStop(CommandLineSession commandLineSession) {
        if (!this.inhibitSessionRemoval) {
            this.removeSession(commandLineSession);
        }
    }

    public boolean isServiceAvailable() {
        return !this.noNewSessions;
    }

    public boolean validateNumberOfSessions() {
        Log.trace(SessionManager.class, "Active Sessions = " + this.getActiveSessions() + ", Max Sessions = " + this.maxNumOfSessions);
        return this.getActiveSessions() <= this.maxNumOfSessions;
    }

    private synchronized int getActiveSessions() {
        return this.sessions.size();
    }

    private synchronized void addSession(CommandLineSession commandLineSession) {
        this.sessions.add(commandLineSession);
    }

    private synchronized void removeSession(CommandLineSession commandLineSession) {
        this.sessions.remove(commandLineSession);
    }
}

