/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.common;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateTimeHelper {
    public static final String DATE_FORMAT_2 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_1 = "yyyy-MM-dd";
    public static final String DATE_FORMAT_4 = "yyyy-MM-dd HH:mm";
    public static final String DATE_FORMAT_5 = "yyyyMMdd";
    public static final String DATE_FORMAT_6 = "MMM dd HH:mm";
    public static final String DATE_FORMAT_7 = "MMM dd yyyy";
    public static final String DATE_FORMAT_8 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMAT_9 = "yyyyMMdd'T'HHmmss";
    public static final String DATE_FORMAT_10 = "yyyyMMdd_HHmmss";
    public static final String DATE_FORMAT_11 = "yyMMdd_HHmmss";
    public static final String DATE_FORMAT_12 = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String DATE_FORMAT_13 = "yyMMdd'_'HHmm";
    public static final String DATE_FORMAT_14 = "EEE MMM d HH:mm:ss yyyy";
    public static final String DATE_FORMAT_15 = "yyyy-MM-dd'T'HH:mm:ss z";
    public static final String DATE_FORMAT_16 = "yyMMdd'_'HHmmss";
    public static final String DATE_FORMAT_17 = "yyyy-mm-dd HH:mm:ss zzz";
    public static final String DATE_FORMAT_18 = "yyyyMMdd'T'HHmmss'Z'";
    public static final String DATE_FORMAT_3 = "HH:mm:ss";
    public static final String DATE_FORMAT_19 = "yyyy";
    public static final String DATE_FORMAT_20 = "MMM";
    public static final String DATE_FORMAT_21 = "d";
    public static final String DATE_FORMAT_22 = "MMMM";
    public static final String DATE_FORMAT_23 = "EEEE";
    public static final String DATE_FORMAT_24 = "dd";
    public static final String DATE_FORMAT_25 = "HH";
    public static final String DATE_FORMAT_26 = "mm";
    public static final String DATE_FORMAT_27 = "z (zzzz)";
    public static final String DATE_FORMAT_28 = "MMM d yyyy";
    public static final String DATE_FORMAT_29 = "MMM d HH:mm";
    public static final String DATE_FORMAT_30 = "yyyy_MM_dd_HHmmss";
    public static final String TIME_ZONE_FORMAT_1 = "z";
    public static final String TIME_FORMAT_1 = "HH:mm:ss";
    public static final String TIME_FORMAT_2 = "HH:mm";

    public static String dateToString(long millis) {
        return DateTimeHelper.dateToString(millis, new SimpleDateFormat(DATE_FORMAT_1));
    }

    public static String dateToString(long millis, String dateFormat) {
        return DateTimeHelper.dateToString(millis, dateFormat, Locale.US);
    }

    public static String dateToString(long millis, String dateFormat, Locale locale) {
        return DateTimeHelper.dateToString(millis, new SimpleDateFormat(dateFormat, locale));
    }

    public static String dateToString(long millis, SimpleDateFormat format) {
        String result = "";
        if (millis != 0L) {
            result = format.format(new Date(millis));
        }
        return result;
    }

    public static String getDateTime() {
        return new SimpleDateFormat(DATE_FORMAT_30).format(new Date(Calendar.getInstance().getTimeInMillis()));
    }

    public static Date stringToDateTime(String dateString, String dateFormat) {
        return DateTimeHelper.stringToDateTime(dateString, dateFormat, Locale.US);
    }

    public static Date stringToDateTime(String dateString, String dateFormat, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, locale);
        simpleDateFormat.applyPattern(dateFormat);
        Date result = simpleDateFormat.parse(dateString, new ParsePosition(0));
        return result;
    }
}

