/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.common.xml;

import java.text.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import se.ericsson.crbs.omf.aue.common.xml.MomInfo;

public class ModificationXmlVersionHandler
extends DefaultHandler {
    private MomInfo fromMomInfo;
    private MomInfo toMomInfo;
    private Integer sequenceNumber;

    public void startDocument() throws SAXException {
        this.fromMomInfo = null;
        this.toMomInfo = null;
        this.sequenceNumber = null;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("ModificationFile".equals(localName)) {
            String fromVersion = attributes.getValue("fromVersion");
            String toVersion = attributes.getValue("toVersion");
            String sequenceNumberString = attributes.getValue("sequenceNumber");
            if (fromVersion == null || fromVersion.length() <= 0) {
                throw new SAXException("Missing fromVersion attributes");
            }
            if (toVersion == null || toVersion.length() <= 0) {
                throw new SAXException("Missing toVersion attributes");
            }
            if (sequenceNumberString == null || sequenceNumberString.length() <= 0) {
                throw new SAXException("Missing sequenceNumber attributes");
            }
            try {
                this.fromMomInfo = MomInfo.getMomInfo(fromVersion);
                this.toMomInfo = MomInfo.getMomInfo(toVersion);
            }
            catch (ParseException pe) {
                throw new SAXException(pe.getMessage());
            }
            try {
                this.sequenceNumber = Integer.valueOf(sequenceNumberString);
            }
            catch (NumberFormatException nfe) {
                throw new SAXException("Incorrect format of SequenceNumber in modification file.", nfe);
            }
        }
    }

    public MomInfo getFromMomInfo() {
        return this.fromMomInfo;
    }

    public MomInfo getToMomInfo() {
        return this.toMomInfo;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }
}

