/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.actions.NoSuchTableException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class RemapAttributeRangeAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$RemapAttributeRangeAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$RemapAttributeRangeAction = RemapAttributeRangeAction.class$("se.ericsson.crbs.omf.aue.step1.actions.RemapAttributeRangeAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$RemapAttributeRangeAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private static List valueList = null;
    private static final String TEXT_LOWBOUND = "lowBound";
    private static final String TEXT_HIBOUND = "hiBound";
    private static final String TEXT_SETVALUE = "setValue";
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$RemapAttributeRangeAction;

    public void convert(AueContext context) throws CrbsAueException, NoSuchTableException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String froTypeName = this.getAndCheckParamMapString("Mo", this.paramMap, "The FRO type is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String attrName = this.getAndCheckParamMapString("name", this.paramMap, "No attribute name is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String mapping = this.getAndCheckParamMapString("mapping", this.paramMap, "No mapping is specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        valueList = this.parseMappingString(mapping);
        TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
        try {
            TableData tableData = tableHandler.getTableData(froTypeName);
            if (tableData.isNotEmpty()) {
                this.modifyAttributeValue(attrName, tableData);
            }
        }
        catch (TableDataException tde) {
            String errorMsg = "Could not modify attribute, " + AueUtil.doubleQuote(attrName) + ", in, " + AueUtil.doubleQuote(froTypeName);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, tde));
            throw new CrbsAueException(errorMsg, tde);
        }
    }

    protected List parseMappingString(String mapping) throws CrbsAueException {
        String[] names = new String[]{TEXT_LOWBOUND, TEXT_HIBOUND, TEXT_SETVALUE};
        ArrayList<StructImpl> list = new ArrayList<StructImpl>();
        String strippedMapping = AueUtil.replaceInString(mapping, " ", "");
        StringTokenizer singlemapping = new StringTokenizer(strippedMapping, ",");
        while (singlemapping.hasMoreTokens()) {
            String keyvalue = singlemapping.nextToken();
            int posTo = keyvalue.toLowerCase().indexOf("to");
            int posColon = keyvalue.indexOf(58);
            try {
                Integer lowBound = null;
                Integer hiBound = null;
                Integer setValue = null;
                if (posTo > 0) {
                    lowBound = Integer.valueOf(keyvalue.substring(0, posTo));
                }
                if (posColon - (posTo + 2) > 0) {
                    hiBound = Integer.valueOf(keyvalue.substring(posTo + 2, posColon));
                }
                if (keyvalue.length() - (posColon + 1) > 0) {
                    setValue = Integer.valueOf(keyvalue.substring(posColon + 1));
                }
                Object[] values = new Integer[]{lowBound, hiBound, setValue};
                list.add(new StructImpl(names, values));
            }
            catch (NumberFormatException e) {
                throw new CrbsAueException("The parsing of " + keyvalue + " could not be done.");
            }
        }
        return list;
    }

    private void modifyAttributeValue(String attrName, TableData tableData) throws CrbsAueException, TableDataException {
        Object[] ldnColumnData = tableData.getAttributeValues("ldn");
        Object[] attrColumnData = tableData.getAttributeValues(attrName);
        Integer oldAttrValue = null;
        Integer newAttrValue = null;
        for (int moInstanceIndex = 0; moInstanceIndex < ldnColumnData.length; ++moInstanceIndex) {
            Object attrData = attrColumnData[moInstanceIndex];
            if (attrData == null) {
                throw new CrbsAueException("The attribute to modify is NULL!");
            }
            try {
                oldAttrValue = Integer.valueOf(attrData.toString());
                newAttrValue = this.evaluateInput(oldAttrValue);
            }
            catch (NumberFormatException e) {
                throw new CrbsAueException("The attribute value " + attrData.toString() + " is not a valid Long number.");
            }
            tableData.setAttributeValue(moInstanceIndex, attrName, newAttrValue);
            logger.traceGeneral(THIS_CLASS, "Attribute value modified, from " + AueUtil.doubleQuote(oldAttrValue.toString()) + " to " + AueUtil.doubleQuote(newAttrValue.toString()) + ", in attribute, " + AueUtil.doubleQuote(attrName) + ", in, " + AueUtil.doubleQuote(tableData.getTableName()));
        }
    }

    private Integer evaluateInput(Integer inData) throws CrbsAueException {
        Integer workData = inData;
        Integer lowB = null;
        Integer hiB = null;
        Integer setValue = null;
        Iterator listIter = valueList.iterator();
        while (listIter.hasNext()) {
            Struct rangedata = (Struct)listIter.next();
            try {
                lowB = (Integer)rangedata.getValue(TEXT_LOWBOUND);
                hiB = (Integer)rangedata.getValue(TEXT_HIBOUND);
                setValue = (Integer)rangedata.getValue(TEXT_SETVALUE);
            }
            catch (Exception exc) {
                throw new CrbsAueException("The mapping data do not contain values for:" + exc);
            }
            if (setValue == null) {
                throw new CrbsAueException("The value to set must be defined in the mapping.");
            }
            if (lowB == null && hiB == null) {
                workData = setValue;
                continue;
            }
            if (lowB == null && workData.compareTo(hiB) <= 0) {
                workData = setValue;
                continue;
            }
            if (hiB == null && 0 <= workData.compareTo(lowB)) {
                workData = setValue;
                continue;
            }
            if (lowB == null || hiB == null || 0 > workData.compareTo(lowB) || workData.compareTo(hiB) > 0) continue;
            workData = setValue;
        }
        return workData;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

