/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions;

import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroArray;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroMoRef;
import se.ericsson.crbs.omf.aue.step1.actions.util.FroStruct;
import se.ericsson.crbs.omf.aue.step1.actions.util.NameTypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.ParseException;
import se.ericsson.crbs.omf.aue.step1.actions.util.TypeValue;
import se.ericsson.crbs.omf.aue.step1.actions.util.XmlTag;

public class ReplaceInAllLdnsAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step1$actions$ReplaceInAllLdnsAction == null ? (class$se$ericsson$crbs$omf$aue$step1$actions$ReplaceInAllLdnsAction = ReplaceInAllLdnsAction.class$("se.ericsson.crbs.omf.aue.step1.actions.ReplaceInAllLdnsAction")) : class$se$ericsson$crbs$omf$aue$step1$actions$ReplaceInAllLdnsAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step1$actions$ReplaceInAllLdnsAction;

    public void convert(AueContext context) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        String oldMoName = this.getAndCheckParamMapString("oldMo", this.paramMap, "The old MO name is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        String newMoName = this.getAndCheckParamMapString("newMo", this.paramMap, "The new MO nmae is not specified in " + AueUtil.doubleQuote(this.getClass().getName()));
        try {
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            FroVersionsTable froVersionsTable = tableHandler.getFroVersionsTable();
            FroVersionsData[] froVersionsDatas = froVersionsTable.getDatas();
            for (int i = 0; i < froVersionsDatas.length; ++i) {
                this.checkAndUpdateMo(context, froVersionsDatas[i].froTypeName, oldMoName, newMoName);
            }
        }
        catch (Exception e) {
            String errorMsg = AueUtil.appendReason("Failed to run action " + AueUtil.doubleQuote(THIS_CLASS.getName()), e);
            logger.traceDebug(THIS_CLASS, errorMsg);
            throw new CrbsAueException(errorMsg, e);
        }
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void checkAndUpdateMo(AueContext context, String froTypeName, String oldMoName, String newMoName) throws CrbsAueException {
        boolean tableWasUpdatedFromStart = false;
        try {
            TableHandler tableHandler = (TableHandler)context.getAttribute("CURRENT_TABLE_HANDLER");
            TableData tableData = tableHandler.getTableData(froTypeName);
            tableWasUpdatedFromStart = tableData.isTableDataUpdated();
            if (tableData.isNotEmpty()) {
                boolean updateTableName = this.updateLdns(froTypeName, oldMoName, newMoName, tableData);
                if (!tableData.isTableDataUpdated()) {
                    logger.traceGeneral(THIS_CLASS, "No LDN contained, " + AueUtil.doubleQuote(oldMoName) + ", in " + AueUtil.doubleQuote(froTypeName));
                }
                if (updateTableName) {
                    tableHandler.updateDataTableName(oldMoName, newMoName, tableData);
                }
                this.updateReferencingAttributes(tableHandler, froTypeName, oldMoName, newMoName, tableData);
                tableHandler.checkAndDropIfNotUpdated(tableWasUpdatedFromStart, tableData);
            }
        }
        catch (Exception e) {
            String errorMsg = "Could not replace ," + AueUtil.doubleQuote(oldMoName) + ", in all LDNs with, " + AueUtil.doubleQuote(newMoName) + ", in, " + AueUtil.doubleQuote(froTypeName);
            logger.traceDebug(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
            throw new CrbsAueException(errorMsg, e);
        }
    }

    private boolean updateLdns(String froTypeName, String oldMoName, String newMoName, TableData tableData) throws TableDataException {
        boolean updateTableName = false;
        Object[] ldnColumnDatas = tableData.getAttributeValues("ldn");
        for (int i = 0; i < ldnColumnDatas.length; ++i) {
            String oldLdn = ldnColumnDatas[i].toString();
            if (oldLdn.indexOf(oldMoName) <= -1) continue;
            String newLdn = AueUtil.replaceInLdn(oldLdn, oldMoName, newMoName);
            tableData.setAttributeValue(i, "ldn", newLdn);
            logger.traceGeneral(THIS_CLASS, "LDN, " + AueUtil.doubleQuote(oldLdn) + ", replaced with, " + AueUtil.doubleQuote(newLdn) + ", in " + AueUtil.doubleQuote(froTypeName));
            if (updateTableName) continue;
            updateTableName = AueUtil.getLastLdnElement(newLdn).equals(newMoName);
        }
        return updateTableName;
    }

    private boolean updateReferencingAttributes(TableHandler tableHandler, String froTypeName, String oldMoName, String newMoName, TableData tableData) throws ParseException, TableDataException {
        boolean updated = false;
        String[] attributeNames = tableData.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String momType = tableData.getMomType(attributeNames[i]);
            if (momType.equalsIgnoreCase("moref")) {
                updated = this.updateMoRef(tableHandler, froTypeName, attributeNames[i], oldMoName, newMoName, tableData);
                continue;
            }
            if (momType.equalsIgnoreCase("struct")) {
                updated = this.updateStruct(tableHandler, froTypeName, attributeNames[i], oldMoName, newMoName, tableData);
                continue;
            }
            if (!momType.equalsIgnoreCase("array")) continue;
            updated = this.updateArray(tableHandler, froTypeName, attributeNames[i], oldMoName, newMoName, tableData);
        }
        if (!updated) {
            logger.traceGeneral(THIS_CLASS, "No referencing attributes (MORef, struct or array) contained the MO, " + AueUtil.doubleQuote(oldMoName) + ", in " + AueUtil.doubleQuote(froTypeName));
        }
        return updated;
    }

    private boolean updateMoRef(TableHandler tableHandler, String froTypeName, String attrName, String oldMoName, String newMoName, TableData tableData) throws ParseException, TableDataException {
        boolean updated = false;
        Object[] moRefColumnDatas = tableData.getAttributeValues(attrName);
        for (int i = 0; i < moRefColumnDatas.length; ++i) {
            String moRefXmlString = (String)moRefColumnDatas[i];
            FroMoRef froMoRef = new FroMoRef(tableHandler);
            froMoRef.parse(moRefXmlString);
            boolean thisIsUpdated = this.updateXmlTags(froMoRef.getXmlTags(), attrName, froTypeName, oldMoName, newMoName);
            if (!thisIsUpdated) continue;
            updated = true;
            tableData.setAttributeValue(i, attrName, froMoRef.toXmlString());
        }
        return updated;
    }

    private boolean updateStruct(TableHandler tableHandler, String froTypeName, String attrName, String oldMoName, String newMoName, TableData tableData) throws ParseException, TableDataException {
        boolean updated = false;
        Object[] structColumnDatas = tableData.getAttributeValues(attrName);
        for (int i = 0; i < structColumnDatas.length; ++i) {
            String structXmlString = (String)structColumnDatas[i];
            FroStruct froStruct = new FroStruct(tableHandler);
            froStruct.parse(structXmlString);
            boolean thisIsUpdated = this.updateXmlTags(froStruct.getXmlTags(), attrName, froTypeName, oldMoName, newMoName);
            if (!thisIsUpdated) continue;
            updated = true;
            tableData.setAttributeValue(i, attrName, froStruct.toXmlString());
        }
        return updated;
    }

    private boolean updateArray(TableHandler tableHandler, String froTypeName, String attrName, String oldMoName, String newMoName, TableData tableData) throws ParseException, TableDataException {
        boolean updated = false;
        Object[] arrayColumnDatas = tableData.getAttributeValues(attrName);
        for (int i = 0; i < arrayColumnDatas.length; ++i) {
            String arrayXmlString = (String)arrayColumnDatas[i];
            FroArray froArray = new FroArray(tableHandler);
            froArray.parse(arrayXmlString);
            boolean thisIsUpdated = this.updateXmlTags(froArray.getXmlTags(), attrName, froTypeName, oldMoName, newMoName);
            if (!thisIsUpdated) continue;
            updated = true;
            tableData.setAttributeValue(i, attrName, froArray.toXmlString());
        }
        return updated;
    }

    private boolean updateXmlTags(XmlTag[] xmlTags, String attributeName, String froTypeName, String oldMoName, String newMoName) {
        boolean updated = false;
        block7: for (int i = 0; i < xmlTags.length; ++i) {
            int tagType = xmlTags[i].getTagType();
            switch (tagType) {
                case 2: {
                    updated |= this.updateTypeValue(attributeName, froTypeName, oldMoName, newMoName, (TypeValue)xmlTags[i]);
                    continue block7;
                }
                case 1: {
                    updated |= this.updateNameTypeValue(attributeName, froTypeName, oldMoName, newMoName, (NameTypeValue)xmlTags[i]);
                    continue block7;
                }
                case 3: {
                    updated |= this.updateXmlTags(((FroMoRef)xmlTags[i]).getXmlTags(), attributeName, froTypeName, oldMoName, newMoName);
                    continue block7;
                }
                case 4: {
                    updated |= this.updateXmlTags(((FroStruct)xmlTags[i]).getXmlTags(), attributeName, froTypeName, oldMoName, newMoName);
                    continue block7;
                }
                case 5: {
                    updated |= this.updateXmlTags(((FroArray)xmlTags[i]).getXmlTags(), attributeName, froTypeName, oldMoName, newMoName);
                    continue block7;
                }
            }
        }
        return updated;
    }

    private boolean updateTypeValue(String attributeName, String froTypeName, String oldMoName, String newMoName, TypeValue typeValue) {
        String newValue;
        String value;
        boolean updated = false;
        String type = typeValue.getType();
        if (type.equals("STRING") && AueUtil.isLdn(value = typeValue.getValue()) && !(newValue = AueUtil.replaceInLdn(value, oldMoName, newMoName)).equals(value)) {
            typeValue.setValue(newValue);
            updated = true;
            logger.traceGeneral(THIS_CLASS, "LDN, " + AueUtil.doubleQuote(value) + ", replaced with, " + AueUtil.doubleQuote(newValue) + ", for " + AueUtil.doubleQuote(attributeName) + ", in " + AueUtil.doubleQuote(froTypeName));
        }
        return updated;
    }

    private boolean updateNameTypeValue(String attributeName, String froTypeName, String oldMoName, String newMoName, NameTypeValue nameTypeValue) {
        String newValue;
        String value;
        boolean updated = false;
        String type = nameTypeValue.getType();
        if (type.equals("STRING") && AueUtil.isLdn(value = nameTypeValue.getValue()) && !(newValue = AueUtil.replaceInLdn(value, oldMoName, newMoName)).equals(value)) {
            nameTypeValue.setValue(newValue);
            updated = true;
            logger.traceGeneral(THIS_CLASS, "LDN, " + AueUtil.doubleQuote(value) + ", replaced with, " + AueUtil.doubleQuote(newValue) + ", for " + AueUtil.doubleQuote(attributeName) + ", in " + AueUtil.doubleQuote(froTypeName));
        }
        return updated;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

