/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.data;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;

public class FroVersionsTableImpl
implements FroVersionsTable {
    private static final Class THIS_CLASS = FroVersionsTable.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final List froVersionsList;
    private final String froVersionsTableName;
    private final DbWrapper dbWrapper;

    public FroVersionsTableImpl(String froVersionsTableName, DbWrapper dbWrapper) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "FroVersionsTable(" + froVersionsTableName + ")");
        this.froVersionsTableName = froVersionsTableName;
        this.dbWrapper = dbWrapper;
        this.froVersionsList = new ArrayList();
        ResultSet resultSet = null;
        try {
            Sql.Select queryFroVersion = new Sql.Select(froVersionsTableName, new String[]{"frotype", "frotypename", "frodataTableName"});
            dbWrapper.openConnection();
            resultSet = dbWrapper.executeQuery(queryFroVersion);
            while (resultSet.next()) {
                int froType = resultSet.getInt(1);
                String froTypeName = resultSet.getString(2);
                String froDataTableName = resultSet.getString(3);
                this.froVersionsList.add(new FroVersionsData(froType, froTypeName, froDataTableName));
            }
            logger.traceDebug(THIS_CLASS, "Read " + this.froVersionsList.size() + " number of elements from: " + AueUtil.doubleQuote(froVersionsTableName));
        }
        catch (SQLException se) {
            throw new CrbsAueException("Failed to read " + AueUtil.doubleQuote(froVersionsTableName), se);
        }
        logger.traceReturn(THIS_CLASS, "FroVersionsTable(" + froVersionsTableName + ")");
    }

    public String getTableName() {
        return this.froVersionsTableName;
    }

    public FroVersionsData[] getDatas() {
        logger.traceEnter(THIS_CLASS, "getFroVersionsDatas()");
        FroVersionsData[] froVersionDatas = new FroVersionsData[this.froVersionsList.size()];
        this.froVersionsList.toArray(froVersionDatas);
        logger.traceReturn(THIS_CLASS, "getFroVersionsDatas()");
        return froVersionDatas;
    }

    public void storePersistently(String tableName) throws TableDataException {
        try {
            this.dbWrapper.openConnection();
            Sql.DropTable dropTable = new Sql.DropTable(tableName);
            try {
                this.dbWrapper.executeUpdate(dropTable);
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            Sql.CreateTable createTable = new Sql.CreateTable(tableName, new Sql.CreateTable.ColumnSpec[]{new Sql.CreateTable.ColumnSpec("frotype", Sql.MomDataType.MOM_S32, 0, null, true), new Sql.CreateTable.ColumnSpec("frotypename", Sql.MomDataType.MOM_STRING, 0, null, false), new Sql.CreateTable.ColumnSpec("frodataTableName", Sql.MomDataType.MOM_STRING, 0, null, false)});
            this.dbWrapper.executeUpdate(createTable);
            for (int i = 0; i < this.froVersionsList.size(); ++i) {
                FroVersionsData froVersionsData = (FroVersionsData)this.froVersionsList.get(i);
                Sql.InsertRow insertRow = new Sql.InsertRow(tableName, new Sql.InsertRow.ColumnValue[]{new Sql.InsertRow.ColumnValue("frotype", froVersionsData.froType), new Sql.InsertRow.ColumnValue("frotypename", froVersionsData.froTypeName), new Sql.InsertRow.ColumnValue("frodataTableName", froVersionsData.froDataTableName)});
                this.dbWrapper.executeUpdate(insertRow);
            }
        }
        catch (SQLException sqle) {
            String errorMsg = "Failed to store FRO versions to persistent table: " + AueUtil.doubleQuote(tableName);
            throw new TableDataException(AueUtil.appendReason(errorMsg, sqle), sqle);
        }
    }

    public void deleteAllData() {
        this.froVersionsList.clear();
    }

    public FroVersionsData deleteFroTypeId(int froType) throws TableDataException {
        FroVersionsData existingRecord = null;
        for (int i = 0; i < this.froVersionsList.size(); ++i) {
            FroVersionsData froVersionsData = (FroVersionsData)this.froVersionsList.get(i);
            if (froVersionsData.froType != froType) continue;
            existingRecord = froVersionsData;
            this.froVersionsList.remove(i);
            break;
        }
        if (existingRecord == null) {
            throw new TableDataException("FRO type id, \"" + froType + "\" not found in: " + AueUtil.doubleQuote(this.froVersionsTableName));
        }
        return existingRecord;
    }

    public void updateFroTypeId(int oldFroType, int newFroType) throws TableDataException {
        FroVersionsData existingRecord = this.deleteFroTypeId(oldFroType);
        FroVersionsData newFroVersionsData = new FroVersionsData(newFroType, existingRecord.froTypeName, existingRecord.froDataTableName);
        this.froVersionsList.add(newFroVersionsData);
    }

    public void updateFroTypeName(String oldFroTypeName, String newFroTypeName) throws TableDataException {
        FroVersionsData existingRecord = null;
        for (int i = 0; i < this.froVersionsList.size(); ++i) {
            FroVersionsData froVersionData = (FroVersionsData)this.froVersionsList.get(i);
            if (!froVersionData.froTypeName.equalsIgnoreCase(oldFroTypeName)) continue;
            existingRecord = froVersionData;
            this.froVersionsList.remove(i);
            break;
        }
        if (existingRecord == null) {
            throw new TableDataException("FRO type name, " + AueUtil.doubleQuote(oldFroTypeName) + " not found in " + this.froVersionsTableName);
        }
        String currentTableName = existingRecord.froDataTableName;
        String newTableName = AueUtil.replaceInString(currentTableName, oldFroTypeName, newFroTypeName);
        FroVersionsData newFroVersionsData = new FroVersionsData(existingRecord.froType, newFroTypeName, newTableName);
        this.froVersionsList.add(newFroVersionsData);
    }

    public void updateTableName(int froType, String newFroDataTableName) throws TableDataException {
        FroVersionsData existingRecord = this.deleteFroTypeId(froType);
        FroVersionsData newFroVersionsData = new FroVersionsData(existingRecord.froType, existingRecord.froTypeName, newFroDataTableName);
        this.froVersionsList.add(newFroVersionsData);
    }

    public void insertIntoTable(int froType, String froTypeName, String froDataTableName) throws TableDataException {
        for (int i = 0; i < this.froVersionsList.size(); ++i) {
            FroVersionsData froVersionData = (FroVersionsData)this.froVersionsList.get(i);
            if (froVersionData.froType != froType) continue;
            throw new TableDataException("Key \"" + froType + "\", already exists in \"fro_versions\"");
        }
        FroVersionsData newFroVersionsData = new FroVersionsData(froType, froTypeName, froDataTableName);
        this.froVersionsList.add(newFroVersionsData);
    }
}

