/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1.actions.data;

import com.polyhedra.sql.ResultSet;
import com.polyhedra.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroAttributesTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsData;
import se.ericsson.crbs.omf.aue.step1.actions.data.FroVersionsTable;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableColumnData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableColumnHeaderData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;

public class TableDataImpl
implements TableData {
    private static final Class THIS_CLASS = TableDataImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    protected static final String INCONSISTENT_DATA = "Data is inconsistent, length of data is not the same";
    protected Integer froTypeId = new Integer(-1);
    protected final SortedSet columnDataSet = new TreeSet();
    protected String froTypeName;
    private FroTableData froTableData = null;
    private boolean tableDataUpdated = false;
    private final FroAttributesTable froAttributesTable;
    private final FroVersionsTable froVersionsTable;
    private boolean tableNameChanged = false;
    static /* synthetic */ Class class$java$lang$String;

    public TableDataImpl(FroAttributesTable froAttributesTable, FroVersionsTable froVersionsTable, String froTypeName) {
        logger.traceEnter(THIS_CLASS, "TableData(" + froTypeName + ")");
        this.froTypeName = froTypeName;
        this.froAttributesTable = froAttributesTable;
        this.froVersionsTable = froVersionsTable;
        logger.traceReturn(THIS_CLASS, "TableData(" + froTypeName + ")");
    }

    public TableDataImpl(FroAttributesTable froAttributesTable, FroVersionsTable froVersionsTable, String tablePrefix, String froTypeName, Integer froTypeId) {
        logger.traceEnter(THIS_CLASS, "TableData(" + froTypeName + ")");
        this.froTypeName = froTypeName;
        this.froAttributesTable = froAttributesTable;
        this.froVersionsTable = froVersionsTable;
        this.froTypeId = froTypeId;
        String froDataTableName = tablePrefix + froTypeName + "_INITIAL";
        this.froTableData = new FroTableData(froTypeId, froDataTableName);
        logger.traceReturn(THIS_CLASS, "TableData(" + froTypeName + ")");
    }

    public FroVersionsTable getFroVersionsTable() {
        return this.froVersionsTable;
    }

    public FroAttributesTable getFroAttributesTable() {
        return this.froAttributesTable;
    }

    public void deleteMoType() throws TableDataException {
        try {
            this.froAttributesTable.deleteFromTable(this.froTypeId);
        }
        catch (TableDataException ignore) {
            logger.traceDebug(THIS_CLASS, "deleteMoType(): no entries in fro_attributes for " + this.froTypeName);
        }
        try {
            this.froVersionsTable.deleteFroTypeId(this.froTypeId);
        }
        catch (TableDataException ignore) {
            logger.traceDebug(THIS_CLASS, "deleteMoType(): no entry in fro_versions for " + this.froTypeName);
        }
        this.clearAllData();
        this.tableDataUpdated = true;
    }

    public Object getDefaultValue(String attributeName) throws TableDataException {
        return this.getColumnHeaderData(attributeName).getDefaultValue();
    }

    public void setDefaultValue(String attributeName, String defaultValue) throws TableDataException {
        this.getColumnHeaderData(attributeName).setDefaultValue(defaultValue);
        this.tableDataUpdated = true;
    }

    public String getSqlType(String attributeName) throws TableDataException {
        return this.getColumnHeaderData(attributeName).getSqlType();
    }

    public void setSqlType(String attributeName, String sqlType) throws TableDataException {
        this.getColumnHeaderData(attributeName).setSqlType(sqlType);
        this.tableDataUpdated = true;
    }

    public Class getJavaType(String attributeName) throws TableDataException {
        return this.getColumnHeaderData(attributeName).getJavaType();
    }

    public String getMomType(String attributeName) throws TableDataException {
        return this.getColumnHeaderData(attributeName).getMomType();
    }

    public void setMomType(String attributeName, String momType) throws TableDataException {
        try {
            Object[] attributeValues = this.getColumnData(attributeName).getColumnData();
            this.checkAttributeValue(attributeName, momType, attributeValues);
        }
        catch (TableDataException tde) {
            String errorMsg = AueUtil.appendReason("Can not set MOM type to, \"" + momType + "\", as the data in the attribute is not of that type", tde);
            logger.traceAbnormal(THIS_CLASS, errorMsg);
            throw new TableDataException(errorMsg);
        }
        this.getColumnHeaderData(attributeName).setMomType(momType);
        this.tableDataUpdated = true;
    }

    public String[] getPrimaryKeys() throws TableDataException {
        TableColumnHeaderData[] tableColumnHeaderDatas = this.getColumnHeaderDatas();
        ArrayList<String> primaryKeysList = new ArrayList<String>();
        for (int i = 0; i < tableColumnHeaderDatas.length; ++i) {
            if (!tableColumnHeaderDatas[i].isPrimaryKey()) continue;
            primaryKeysList.add(tableColumnHeaderDatas[i].getColumnName());
        }
        String[] primaryKeys = new String[primaryKeysList.size()];
        primaryKeysList.toArray(primaryKeys);
        return primaryKeys;
    }

    public void setPrimaryKey(String attributeName, boolean isPrimaryKey) throws TableDataException {
        this.getColumnHeaderData(attributeName).setPrimaryKey(isPrimaryKey);
        this.tableDataUpdated = true;
    }

    public void setAsTheOnlyPrimaryKey(String attributeName) throws TableDataException {
        TableColumnHeaderData[] tableColumnHeaderDatas = this.getColumnHeaderDatas();
        for (int i = 0; i < tableColumnHeaderDatas.length; ++i) {
            tableColumnHeaderDatas[i].setPrimaryKey(false);
        }
        this.getColumnHeaderData(attributeName).setPrimaryKey(true);
        this.tableDataUpdated = true;
    }

    public int getLength(String attributeName) throws TableDataException {
        return this.getColumnHeaderData(attributeName).getLength();
    }

    public void setLength(String attributeName, int length) throws TableDataException {
        this.getColumnHeaderData(attributeName).setLength(length);
        this.tableDataUpdated = true;
    }

    public String[] getReferencingAttributes() {
        ArrayList<String> referencingAttrList = new ArrayList<String>();
        TableColumnHeaderData[] tableColumnHeaderDatas = this.getColumnHeaderDatas();
        for (int i = 0; i < tableColumnHeaderDatas.length; ++i) {
            if (!tableColumnHeaderDatas[i].getMomType().equalsIgnoreCase("array") && !tableColumnHeaderDatas[i].getMomType().equalsIgnoreCase("moref") && !tableColumnHeaderDatas[i].getMomType().equalsIgnoreCase("struct")) continue;
            referencingAttrList.add(tableColumnHeaderDatas[i].getColumnName());
        }
        String[] referencingAttrArray = new String[referencingAttrList.size()];
        referencingAttrList.toArray(referencingAttrArray);
        return referencingAttrArray;
    }

    public boolean isTableDataUpdated() {
        return this.tableDataUpdated;
    }

    public void setTableDataUpdated(boolean tableDataUpdated) {
        this.tableDataUpdated = tableDataUpdated;
    }

    protected void readTableData() throws TableDataException {
        logger.traceGeneral(THIS_CLASS, "Reading table data for: " + AueUtil.doubleQuote(this.froTypeName));
        try {
            DbWrapper database = DbWrapperFactory.getInstance().getDbWrapper();
            database.openConnection();
            this.froTableData = this.getFroTableData(this.froVersionsTable, this.froTypeName);
            int froTableRows = this.getFroTableRowsNumber(database);
            if (froTableRows > 0) {
                TableColumnHeaderData[] tableColumnHeaderDatas = this.getColumnHeaderDataList(database, this.froTableData.getTableName());
                this.readTheData(database, this.froAttributesTable, this.froTableData, tableColumnHeaderDatas);
            } else if (froTableRows == 0) {
                try {
                    this.dropFroTableAndUpdateFroAttributes(database);
                }
                catch (TableDataException seemsLikeTheFroHasNoAttributes) {
                    // empty catch block
                }
            }
            this.froTypeId = this.froTableData.froTypeId;
            logger.traceGeneral(THIS_CLASS, "Read table data for: " + AueUtil.doubleQuote(this.froTypeName));
        }
        catch (Exception e) {
            String errorMsg = "Failed to read table for " + AueUtil.doubleQuote(this.froTypeName);
            logger.traceAbnormal(THIS_CLASS, AueUtil.appendReason(errorMsg, e));
            TableDataException tde = new TableDataException(errorMsg, e);
            tde.setStackTrace(e.getStackTrace());
            throw tde;
        }
        finally {
            this.tableDataUpdated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFroTableRowsNumber(DbWrapper database) {
        int rows = -1;
        ResultSet resultSet = null;
        try {
            Sql.Select.Count countRowsQuery = new Sql.Select.Count(this.froTableData.getTableName(), "froid");
            resultSet = database.executeQuery(countRowsQuery);
            if (resultSet.next()) {
                rows = resultSet.getInt(1);
            }
        }
        catch (SQLException ignore) {
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception ignore) {}
        }
        return rows;
    }

    private void dropFroTableAndUpdateFroAttributes(DbWrapper database) throws SQLException, TableDataException {
        this.froAttributesTable.deleteFromTable(this.froTableData.froTypeId);
        database.executeUpdate(new Sql.DropTable(this.froTableData.getTableName()));
    }

    public Integer getFroTypeId() {
        return this.froTypeId;
    }

    public void setFroTypeId(Integer newFroTypeId) throws TableDataException {
        Integer currentFroTypeId = this.froTypeId;
        try {
            this.froAttributesTable.updateFroTypeId(currentFroTypeId, newFroTypeId);
        }
        catch (TableDataException tde) {
            // empty catch block
        }
        try {
            this.froVersionsTable.updateFroTypeId(currentFroTypeId, newFroTypeId);
        }
        catch (TableDataException tableDataException) {
            // empty catch block
        }
        this.froTypeId = newFroTypeId;
        this.tableDataUpdated = true;
    }

    public String getFroTypeName() {
        return this.froTypeName;
    }

    public String getTableName() {
        return this.froTableData == null ? "Table data not read yet" : this.froTableData.getTableName();
    }

    public String getOriginalTableName() {
        return this.froTableData == null ? "Table data not read yet" : this.froTableData.getOriginalTableName();
    }

    public String getIdentifier() {
        return "FRO type name: " + AueUtil.doubleQuote(this.getFroTypeName()) + ", FRO type id: " + AueUtil.doubleQuote(this.getFroTypeId().toString()) + ", Table name: " + AueUtil.doubleQuote(this.getTableName());
    }

    public void changeFroTypeName(String oldFroTypeName, String newFroTypeName) throws TableDataException {
        if (this.froTableData != null) {
            this.froTypeName = newFroTypeName;
            String currentTableName = this.froTableData.getTableName();
            String newTableName = AueUtil.replaceInString(currentTableName, oldFroTypeName, newFroTypeName);
            this.froTableData.setTableName(newTableName);
            if (!this.tableNameChanged) {
                this.froTableData.setOriginalTableName(currentTableName);
                this.tableNameChanged = true;
            }
        }
        this.froVersionsTable.updateFroTypeName(oldFroTypeName, newFroTypeName);
        this.tableDataUpdated = true;
        logger.traceDebug(THIS_CLASS, "changeFroTypeName(" + oldFroTypeName + ", " + newFroTypeName + ")");
    }

    public void setNewTableName(String newFroDataTableName) throws TableDataException {
        String currentTableName = this.froTableData.getTableName();
        try {
            this.froVersionsTable.updateTableName(this.froTypeId, newFroDataTableName);
        }
        catch (TableDataException tableDataException) {
            // empty catch block
        }
        this.froTableData.setTableName(newFroDataTableName);
        if (!this.tableNameChanged) {
            this.froTableData.setOriginalTableName(currentTableName);
            this.tableNameChanged = true;
        }
        this.tableDataUpdated = true;
        logger.traceDebug(THIS_CLASS, "setNewTableName(" + newFroDataTableName + ")");
    }

    public int getNumberOfRecords() {
        int numberOfRecords = 0;
        if (this.columnDataSet.size() > 0) {
            numberOfRecords = ((TableColumnData)this.columnDataSet.first()).getSize();
        }
        return numberOfRecords;
    }

    public boolean hasColumns() {
        return this.columnDataSet.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllData() throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            if (this.columnDataSet.size() > 0) {
                Iterator iterator = this.columnDataSet.iterator();
                while (iterator.hasNext()) {
                    TableColumnData columnData = (TableColumnData)iterator.next();
                    columnData.clearColumnData();
                }
                this.tableDataUpdated = true;
                logger.traceDebug(THIS_CLASS, "deleteTableData()");
            }
        }
    }

    public boolean isNotEmpty() {
        return this.getNumberOfRecords() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(String attributeName, String momType, String defaultValueStr) throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            int localFroTypeid;
            if (this.doesAttributeExist(attributeName)) {
                String errorMsg = "Attribute, " + AueUtil.doubleQuote(attributeName) + ", for ," + AueUtil.doubleQuote(this.froTypeName) + ", already exists";
                logger.traceError(THIS_CLASS, errorMsg);
                throw new TableDataException(errorMsg);
            }
            TableColumnHeaderData tableColumnHeaderData = new TableColumnHeaderData(attributeName);
            tableColumnHeaderData.setMomType(momType);
            tableColumnHeaderData.setDefaultValue(defaultValueStr);
            TableColumnData tableColumnData = new TableColumnData(tableColumnHeaderData);
            int currentDataLength = this.getNumberOfRecords();
            for (int i = 0; i < currentDataLength; ++i) {
                if (momType.equalsIgnoreCase("S32") || momType.equalsIgnoreCase("U32")) {
                    tableColumnData.addColumnData(Integer.valueOf(defaultValueStr));
                    continue;
                }
                tableColumnData.addColumnData(defaultValueStr);
            }
            this.columnDataSet.add(tableColumnData);
            if (!("froid".equalsIgnoreCase(attributeName) || "ldn".equalsIgnoreCase(attributeName) || this.froAttributesTable.isCombinationPresent(localFroTypeid = this.froTypeId.intValue(), attributeName))) {
                String convertedMomType = this.convertMomType(momType);
                this.froAttributesTable.insertIntoTable(localFroTypeid, attributeName, convertedMomType);
            }
            this.tableDataUpdated = true;
            logger.traceDebug(THIS_CLASS, "Added: " + AueUtil.doubleQuote(attributeName) + ", " + AueUtil.doubleQuote(momType) + " and " + AueUtil.doubleQuote(defaultValueStr) + " to " + AueUtil.doubleQuote(this.getFroTypeName()));
        }
    }

    private String convertMomType(String momType) throws TableDataException {
        String result;
        if (momType.equalsIgnoreCase("U32")) {
            result = "U32";
        } else if (momType.equalsIgnoreCase("S32")) {
            result = "S32";
        } else if (momType.equalsIgnoreCase("S64")) {
            result = "S64";
        } else if (momType.equalsIgnoreCase("STRING")) {
            result = "STRING";
        } else if (momType.equalsIgnoreCase("array")) {
            result = "array";
        } else if (momType.equalsIgnoreCase("struct")) {
            result = "struct";
        } else if (momType.equalsIgnoreCase("moref")) {
            result = "moref";
        } else {
            throw new TableDataException("Incorrect MOM-type provided: " + momType);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String attributeToBeRemoved) throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            boolean found = false;
            Iterator iterator = this.columnDataSet.iterator();
            while (iterator.hasNext()) {
                TableColumnData columnData = (TableColumnData)iterator.next();
                if (!columnData.getTableColumnHeaderData().getColumnName().equalsIgnoreCase(attributeToBeRemoved)) continue;
                this.columnDataSet.remove(columnData);
                logger.traceDebug(THIS_CLASS, "removeColumn(" + attributeToBeRemoved + ")");
                found = true;
                break;
            }
            if (!found) {
                String errorMsg = "The attribute name, " + AueUtil.doubleQuote(attributeToBeRemoved) + ", is not present in the table: " + AueUtil.doubleQuote(this.getTableName());
                logger.traceAbnormal(THIS_CLASS, errorMsg);
                throw new TableDataException(errorMsg);
            }
            this.froAttributesTable.deleteFromTable(this.froTypeId, attributeToBeRemoved);
            this.tableDataUpdated = true;
        }
    }

    public void addAttributeValues(String[] attributeNames, Object[] attributeValues) throws TableDataException {
        String[] currentAttributeNames = this.getAttributeNames();
        this.checkAttributeLength(attributeNames, attributeValues, currentAttributeNames);
        this.checkAttributeNames(attributeNames, attributeValues, currentAttributeNames);
        this.checkAttributeValues(attributeNames, attributeValues);
        TableColumnData[] tableColumnDatas = this.getColumnDatas();
        block0: for (int i = 0; i < currentAttributeNames.length; ++i) {
            for (int j = 0; j < tableColumnDatas.length; ++j) {
                if (!attributeNames[i].equalsIgnoreCase(tableColumnDatas[j].getTableColumnHeaderData().getColumnName())) continue;
                tableColumnDatas[j].addColumnData(attributeValues[i]);
                this.tableDataUpdated = true;
                continue block0;
            }
        }
    }

    public void storeTableData() throws TableDataException {
        String originalTableName = this.getOriginalTableName();
        String currentTableName = this.getTableName();
        logger.traceEnter(THIS_CLASS, "storeTableData(current:" + currentTableName + ", original:" + originalTableName + ")");
        DbWrapper database = null;
        logger.traceGeneral(THIS_CLASS, "Storing table data to data base table: " + AueUtil.doubleQuote(currentTableName));
        try {
            database = DbWrapperFactory.getInstance().getDbWrapper();
            database.openConnection();
            if (database.doTableExist(currentTableName)) {
                this.dropTable(currentTableName, database);
            }
            this.createTable(currentTableName, database);
            this.insertIntoTable(currentTableName, database);
        }
        catch (Exception e) {
            String errorMsg = AueUtil.appendReason("Failed to store data for, \"" + this.froTypeName + "\", to data base table, " + AueUtil.doubleQuote(currentTableName), e);
            logger.info(THIS_CLASS, errorMsg);
            TableDataException tde = new TableDataException(errorMsg, e);
            tde.setStackTrace(e.getStackTrace());
            throw tde;
        }
        logger.traceReturn(THIS_CLASS, "storeTableData(" + currentTableName + ")");
    }

    private void dropTable(String currentTableName, DbWrapper database) throws SQLException {
        block2: {
            try {
                Sql.DropTable dropTable = new Sql.DropTable(currentTableName);
                database.executeUpdate(dropTable);
            }
            catch (SQLException sqle) {
                if (sqle.getErrorCode() == 1) break block2;
                throw sqle;
            }
        }
    }

    private void createTable(String currentTableName, DbWrapper database) throws TableDataException, SQLException {
        TableColumnHeaderData[] tableColumnHeaderDatas = this.getColumnHeaderDatas();
        Sql.CreateTable createTable = new Sql.CreateTable(currentTableName);
        for (int a = 0; a < tableColumnHeaderDatas.length; ++a) {
            Sql.SqlDataType sqlDatatType = Sql.SqlDataType.toSqlDataType(tableColumnHeaderDatas[a].getSqlType());
            createTable.addColumn(new Sql.CreateTable.ColumnSpec(tableColumnHeaderDatas[a].getColumnName(), sqlDatatType, tableColumnHeaderDatas[a].getLength(), null, tableColumnHeaderDatas[a].isPrimaryKey()));
        }
        database.executeUpdate(createTable);
    }

    private void insertIntoTable(String currentTableName, DbWrapper database) throws TableDataException, SQLException {
        String[] attributeNames = this.getAttributeNames();
        int numberOfRecords = this.getNumberOfRecords();
        for (int r = 0; r < numberOfRecords; ++r) {
            Sql.InsertRow insertInto = new Sql.InsertRow(currentTableName);
            Object[] recordDatas = this.getRecord(r);
            for (int rd = 0; rd < recordDatas.length; ++rd) {
                int intValue;
                if (recordDatas[rd] == null) {
                    throw new TableDataException("Corrupt attribute value in table. Attribute name = '" + attributeNames[rd] + "', value is null on row " + r + ".");
                }
                Class javaType = this.getJavaType(attributeNames[rd]);
                if (javaType == (class$java$lang$String == null ? TableDataImpl.class$("java.lang.String") : class$java$lang$String)) {
                    insertInto.addColumnValue(new Sql.InsertRow.ColumnValue(attributeNames[rd], recordDatas[rd]));
                    continue;
                }
                if (recordDatas[rd] instanceof Integer) {
                    intValue = (Integer)recordDatas[rd];
                    insertInto.addColumnValue(new Sql.InsertRow.ColumnValue(attributeNames[rd], intValue));
                    continue;
                }
                if (recordDatas[rd] instanceof Long) {
                    intValue = (int)((Long)recordDatas[rd]).longValue();
                    insertInto.addColumnValue(new Sql.InsertRow.ColumnValue(attributeNames[rd], intValue));
                    continue;
                }
                if (recordDatas[rd] instanceof String) {
                    String stringValue = (String)recordDatas[rd];
                    try {
                        int intValue2 = Integer.parseInt(stringValue);
                        insertInto.addColumnValue(new Sql.InsertRow.ColumnValue(attributeNames[rd], intValue2));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new TableDataException("Failed to convert \"" + stringValue + "\" into an int value for table " + currentTableName + " column " + attributeNames[rd], nfe);
                    }
                }
                throw new TableDataException("Failed to convert " + recordDatas[rd] + " into an int value for table " + currentTableName + " column " + attributeNames[rd]);
            }
            String insertIntoStr = this.ensureSafeInsertQuerryLenght(insertInto);
            database.executeUpdate(insertIntoStr);
        }
    }

    private String ensureSafeInsertQuerryLenght(Sql.InsertRow insertInto) {
        int DEVIL_QUERRY_LENGTH = 9980;
        String insertIntoStr = insertInto.toString();
        if (insertIntoStr.length() == 9980) {
            insertIntoStr = insertIntoStr + " ";
            logger.traceDebug(THIS_CLASS, "HS82265: added single space to avoid 9980 length Polyhedra issue");
        }
        return insertIntoStr;
    }

    private void checkAttributeLength(String[] attributeNames, Object[] attributeValues, String[] availableAttributeNames) throws TableDataException {
        if (attributeNames.length != attributeValues.length) {
            throw new TableDataException("Specified attribute names (" + attributeNames.length + ") and values (" + attributeValues.length + ") are not of the same size.");
        }
        if (attributeNames.length < availableAttributeNames.length) {
            throw new TableDataException("Specified attribute names (" + attributeNames.length + ") and values (" + attributeValues.length + ") are less in size than available attribute names in data table (" + availableAttributeNames.length + ")");
        }
        if (attributeNames.length > availableAttributeNames.length) {
            throw new TableDataException("Specified attribute names (" + attributeNames.length + ") and values (" + attributeValues.length + ") are greater in size than available attribute names in data table (" + availableAttributeNames.length + ")");
        }
    }

    private void checkAttributeNames(String[] attributeNames, Object[] attributeValues, String[] availableAttributeNames) throws TableDataException {
        for (int i = 0; i < availableAttributeNames.length; ++i) {
            boolean attributeNameFound = false;
            for (int j = 0; j < attributeValues.length; ++j) {
                if (!availableAttributeNames[i].equalsIgnoreCase(attributeNames[j])) continue;
                attributeNameFound = true;
                break;
            }
            if (attributeNameFound) continue;
            ArrayList<String> availableAttributesList = new ArrayList<String>();
            availableAttributesList.addAll(Arrays.asList(availableAttributeNames));
            ArrayList<String> specifiedAttributesList = new ArrayList<String>();
            specifiedAttributesList.addAll(Arrays.asList(attributeNames));
            throw new TableDataException("One or more attributes not found. Available attributes: \"" + availableAttributesList + "\", Specified attributes: \"" + specifiedAttributesList + "\"");
        }
    }

    private void checkAttributeValues(String[] attributeNames, Object[] attributeValues) throws TableDataException {
        for (int i = 0; i < attributeNames.length; ++i) {
            String momType = this.getMomType(attributeNames[i]);
            this.checkAttributeValue(attributeNames[i], momType, new Object[]{attributeValues[i]});
        }
    }

    private void checkAttributeValue(String attributeName, String momType, Object[] attributeValues) throws TableDataException {
        for (int i = 0; i < attributeValues.length; ++i) {
            if (momType.equalsIgnoreCase("S32") && !(attributeValues[i] instanceof Integer)) {
                throw new TableDataException("Specified attribute, \"" + attributeName + "\", must be an integer but is: " + attributeValues[i].getClass().getName());
            }
            if (momType.equalsIgnoreCase("U32") && !(attributeValues[i] instanceof Integer)) {
                throw new TableDataException("Specified attribute, \"" + attributeName + "\", must be an integer but is: " + attributeValues[i].getClass().getName());
            }
            if (momType.equalsIgnoreCase("U32") && attributeValues[i] instanceof Integer) {
                Integer attrValue = (Integer)attributeValues[i];
                if (attrValue >= 0) continue;
                throw new TableDataException("Specified attribute value must be greater than zero for an U32. Values is: " + attrValue);
            }
            if (momType.equalsIgnoreCase("S64") && !(attributeValues[i] instanceof String)) {
                throw new TableDataException("Specified attribute, \"" + attributeName + "\", must be a string but is: " + attributeValues[i].getClass().getName());
            }
            if (!momType.equalsIgnoreCase("STRING") && !momType.equalsIgnoreCase("array") && !momType.equalsIgnoreCase("struct") && !momType.equalsIgnoreCase("moref") || attributeValues[i] instanceof String) continue;
            throw new TableDataException("Specified attribute, \"" + attributeName + "\", must be a string but is: " + attributeValues[i].getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAttributeData(TableColumnHeaderData tableColumnHeaderData, Object data) throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            TableColumnData columnData = new TableColumnData(tableColumnHeaderData);
            if (this.columnDataSet.contains(columnData)) {
                Iterator iterator = this.columnDataSet.iterator();
                while (iterator.hasNext()) {
                    TableColumnData existingColumnData = (TableColumnData)iterator.next();
                    if (!existingColumnData.equals(columnData)) continue;
                    columnData = existingColumnData;
                    break;
                }
            } else {
                this.columnDataSet.add(columnData);
            }
            columnData.addColumnData(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableColumnHeaderData[] getColumnHeaderDatas() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            ArrayList<TableColumnHeaderData> columnHeaderDataList = new ArrayList<TableColumnHeaderData>();
            Iterator iterator = this.columnDataSet.iterator();
            while (iterator.hasNext()) {
                TableColumnData columnData = (TableColumnData)iterator.next();
                columnHeaderDataList.add(columnData.getTableColumnHeaderData());
            }
            TableColumnHeaderData[] columnHeaderDatas = new TableColumnHeaderData[columnHeaderDataList.size()];
            columnHeaderDataList.toArray(columnHeaderDatas);
            return columnHeaderDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableColumnHeaderData getColumnHeaderData(String attributeName) throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            Iterator iterator = this.columnDataSet.iterator();
            TableColumnHeaderData columnHeaderData = null;
            while (iterator.hasNext()) {
                TableColumnData columnData = (TableColumnData)iterator.next();
                TableColumnHeaderData tmpTableColumnHeaderData = columnData.getTableColumnHeaderData();
                if (!tmpTableColumnHeaderData.getColumnName().equalsIgnoreCase(attributeName)) continue;
                columnHeaderData = tmpTableColumnHeaderData;
                break;
            }
            if (columnHeaderData == null) {
                String errorMsg = "The attribute name, " + AueUtil.doubleQuote(attributeName) + ", is not present in the table: " + AueUtil.doubleQuote(this.getTableName());
                logger.traceAbnormal(THIS_CLASS, errorMsg);
                throw new TableDataException(errorMsg);
            }
            return columnHeaderData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableColumnData[] getColumnDatas() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            TableColumnData[] tableColumnDatas = new TableColumnData[this.columnDataSet.size()];
            this.columnDataSet.toArray(tableColumnDatas);
            return tableColumnDatas;
        }
    }

    public void setAttributeName(String currentAttributeName, String newAttributeName) throws TableDataException {
        TableColumnHeaderData[] tableColumnHeaderDatas = this.getColumnHeaderDatas();
        for (int i = 0; i < tableColumnHeaderDatas.length; ++i) {
            if (!tableColumnHeaderDatas[i].getColumnName().equalsIgnoreCase(currentAttributeName)) continue;
            tableColumnHeaderDatas[i].setColumnName(newAttributeName);
            break;
        }
        this.froAttributesTable.updateTable(this.froTypeId, currentAttributeName, newAttributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableColumnData getColumnData(String attributeName) throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            TableColumnData result = null;
            TableColumnData[] tableColumnDatas = new TableColumnData[this.columnDataSet.size()];
            this.columnDataSet.toArray(tableColumnDatas);
            for (int i = 0; i < tableColumnDatas.length; ++i) {
                if (!tableColumnDatas[i].getTableColumnHeaderData().getColumnName().equalsIgnoreCase(attributeName)) continue;
                result = tableColumnDatas[i];
                break;
            }
            if (result == null) {
                throw new TableDataException("The attribute name, " + AueUtil.doubleQuote(attributeName) + ", is not present in the table: " + AueUtil.doubleQuote(this.getTableName()));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexAndCheckAttributeExistence(String errorMsg, String attrToLookFor) throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            Iterator iterator = this.columnDataSet.iterator();
            int index = 0;
            int attributeIndex = -1;
            while (iterator.hasNext()) {
                TableColumnData columnData = (TableColumnData)iterator.next();
                TableColumnHeaderData tmpTableColumnHeaderData = columnData.getTableColumnHeaderData();
                if (tmpTableColumnHeaderData.getColumnName().equalsIgnoreCase(attrToLookFor)) {
                    attributeIndex = index;
                    break;
                }
                ++index;
            }
            if (attributeIndex == -1) {
                throw new TableDataException(errorMsg);
            }
            return attributeIndex;
        }
    }

    public void setAttributeValue(int index, String attributeName, Object attributeValue) throws TableDataException {
        if (index < 0) {
            throw new TableDataException("Specified index, \"" + index + "\", less than zero");
        }
        int columnIndex = this.getIndexAndCheckAttributeExistence("Specified attribute, " + AueUtil.doubleQuote(attributeName) + ", not found", attributeName);
        TableColumnData[] tableColumnDatas = this.getColumnDatas();
        TableColumnData currentTableColumn = tableColumnDatas[columnIndex];
        Object[] columnDatas = currentTableColumn.getColumnData();
        if (index >= columnDatas.length) {
            throw new TableDataException("Specified index, \"" + index + "\" is too high - max should be: " + (columnDatas.length - 1));
        }
        currentTableColumn.setRowData(index, attributeValue);
        this.tableDataUpdated = true;
    }

    public Object[] getRecord(int index) {
        TableColumnData[] tableColumnDatas = this.getColumnDatas();
        Object[] record = new Object[tableColumnDatas.length];
        for (int i = 0; i < record.length; ++i) {
            record[i] = tableColumnDatas[i].getColumnData()[index];
        }
        return record;
    }

    public Map getRecordMap(int index) throws TableDataException {
        if (index < 0) {
            throw new TableDataException("Specified index, " + index + ", less than zero");
        }
        TableColumnHeaderData[] tableColumnHeaderDatas = this.getColumnHeaderDatas();
        TableColumnData[] tableColumnDatas = this.getColumnDatas();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < tableColumnDatas.length; ++i) {
            String attributeName = tableColumnHeaderDatas[i].getColumnName();
            Object[] columnDatas = tableColumnDatas[i].getColumnData();
            if (index >= columnDatas.length) {
                throw new TableDataException("Specified index, " + index + " is too high - max should be: " + (columnDatas.length - 1));
            }
            Object attributeValue = columnDatas[index];
            map.put(attributeName, attributeValue);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getAttributeValues() throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            TableColumnData[] tableColumnDatas = this.getColumnDatas();
            Object[][] allAttributeValues = new Object[tableColumnDatas.length][];
            for (int i = 0; i < tableColumnDatas.length; ++i) {
                Object[] columnData = tableColumnDatas[i].getColumnData();
                allAttributeValues[i] = new Object[columnData.length];
                System.arraycopy(columnData, 0, allAttributeValues[i], 0, columnData.length);
            }
            return allAttributeValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAttributeValues(String attributeName) throws TableDataException {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            TableColumnData tableColumnData = this.getColumnData(attributeName);
            return tableColumnData.getColumnData();
        }
    }

    public boolean doesAttributeExist(String attributeName) {
        boolean attributeExists = false;
        String[] existingAttributeNames = this.getAttributeNames();
        for (int i = 0; i < existingAttributeNames.length; ++i) {
            if (!existingAttributeNames[i].equalsIgnoreCase(attributeName)) continue;
            attributeExists = true;
            break;
        }
        return attributeExists;
    }

    public String[] getAttributeNames() {
        TableColumnHeaderData[] tableColumnHeaderDatas = this.getColumnHeaderDatas();
        String[] attributeNames = new String[tableColumnHeaderDatas.length];
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNames[i] = tableColumnHeaderDatas[i].getColumnName();
        }
        return attributeNames;
    }

    public void deleteRowData(int row) {
        if (this.columnDataSet.size() > 0 && row >= 0) {
            Iterator iterator = this.columnDataSet.iterator();
            while (iterator.hasNext()) {
                TableColumnData columnData = (TableColumnData)iterator.next();
                if (row >= columnData.getSize()) continue;
                columnData.deleteRow(row);
            }
            this.tableDataUpdated = true;
        }
    }

    public int hashCode() {
        return this.froTypeName.hashCode();
    }

    public boolean equals(Object otherTableDataObject) {
        boolean result = false;
        if (otherTableDataObject instanceof TableData) {
            TableData otherTableData = (TableData)otherTableDataObject;
            result = this.froTypeName.equalsIgnoreCase(otherTableData.getFroTypeName());
        } else {
            result = false;
        }
        return result;
    }

    private FroTableData getFroTableData(FroVersionsTable inputFroVersionsTable, String inputFroTypeName) {
        FroVersionsData[] froVersionsDatas = inputFroVersionsTable.getDatas();
        int localFroTypeId = -1;
        String frodataTableName = "";
        for (int i = 0; i < froVersionsDatas.length; ++i) {
            if (!froVersionsDatas[i].froTypeName.equalsIgnoreCase(inputFroTypeName)) continue;
            localFroTypeId = froVersionsDatas[i].froType;
            frodataTableName = froVersionsDatas[i].froDataTableName;
            break;
        }
        return new FroTableData(new Integer(localFroTypeId), frodataTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableColumnHeaderData[] getColumnHeaderDataList(DbWrapper database, String tableName) throws SQLException {
        ResultSet resultSet = null;
        ArrayList<TableColumnHeaderData> columnHeaderDataList = new ArrayList<TableColumnHeaderData>();
        try {
            if (!"".equals(tableName)) {
                Sql.Select selectAttributes = new Sql.Select("attributes", new String[]{"name", "type", "length", "isprimary"}, new Sql.Select.ColumnValue("table_name", tableName.toLowerCase(Locale.getDefault())));
                resultSet = database.executeQuery(selectAttributes);
                while (resultSet.next()) {
                    String name = resultSet.getString(1);
                    TableColumnHeaderData columnHeaderData = new TableColumnHeaderData(name);
                    String type = resultSet.getString(2);
                    columnHeaderData.setSqlType(type);
                    int length = resultSet.getInt(3);
                    columnHeaderData.setLength(length);
                    boolean isPrimaryKey = resultSet.getBoolean(4);
                    columnHeaderData.setPrimaryKey(isPrimaryKey);
                    logger.traceGeneral(THIS_CLASS, "getColumnHeaderDataList adding column: " + AueUtil.doubleQuote(columnHeaderData.getColumnName()));
                    columnHeaderDataList.add(columnHeaderData);
                }
            }
            TableColumnHeaderData[] tableColumnHeaderDatas = new TableColumnHeaderData[columnHeaderDataList.size()];
            columnHeaderDataList.toArray(tableColumnHeaderDatas);
            TableColumnHeaderData[] tableColumnHeaderDataArray = tableColumnHeaderDatas;
            return tableColumnHeaderDataArray;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception ignore) {}
        }
    }

    private void readFroAttrData(Integer inputFroTypeId, FroAttributesTable inputFroAttributesTable, TableColumnHeaderData[] tableColumnHeaderDatas) {
        FroAttributesData[] froAttributesDatas = inputFroAttributesTable.getDatas();
        for (int i = 0; i < froAttributesDatas.length; ++i) {
            if (froAttributesDatas[i].froType != inputFroTypeId) continue;
            String froAttrName = froAttributesDatas[i].attrName;
            String froAttrType = froAttributesDatas[i].attrType;
            logger.traceGeneral(THIS_CLASS, "readFroAttrData: name=" + froAttrName + ", type=" + this.froTypeId);
            for (int j = 0; j < tableColumnHeaderDatas.length; ++j) {
                if (!tableColumnHeaderDatas[j].getColumnName().equalsIgnoreCase(froAttrName)) continue;
                logger.traceGeneral(THIS_CLASS, "readFroAttrData: momType[" + j + "]=" + froAttrType);
                tableColumnHeaderDatas[j].setMomType(froAttrType);
                tableColumnHeaderDatas[j].setColumnName(froAttrName);
            }
        }
    }

    private Sql.Select getFroDataSqlQuery(String tableName, TableColumnHeaderData[] tableColumnHeaderDatas) throws SQLException {
        Sql.Select sqlQuery = new Sql.Select(tableName);
        for (int i = 0; i < tableColumnHeaderDatas.length; ++i) {
            sqlQuery.addColumn(tableColumnHeaderDatas[i].getColumnName());
        }
        return sqlQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTheData(DbWrapper database, FroAttributesTable localFroAttributesTable, FroTableData localFroTableData, TableColumnHeaderData[] tableColumnHeaderDatas) throws SQLException, TableDataException {
        if (localFroTableData.isInitialized()) {
            this.froTypeId = localFroTableData.getFroTypeId();
            this.readFroAttrData(this.froTypeId, localFroAttributesTable, tableColumnHeaderDatas);
            if (tableColumnHeaderDatas.length > 0) {
                Sql.Select dataSqlQuery = this.getFroDataSqlQuery(localFroTableData.getTableName(), tableColumnHeaderDatas);
                ResultSet resultSet = database.executeQuery(dataSqlQuery);
                try {
                    while (resultSet.next()) {
                        for (int i = 0; i < tableColumnHeaderDatas.length; ++i) {
                            Object tmpData = "";
                            if (tableColumnHeaderDatas[i].getSqlType().equalsIgnoreCase("integer")) {
                                tmpData = new Integer(resultSet.getInt(i + 1));
                            } else if (tableColumnHeaderDatas[i].getSqlType().equalsIgnoreCase("varchar")) {
                                tmpData = resultSet.getString(i + 1);
                            }
                            this.addAttributeData(tableColumnHeaderDatas[i], tmpData);
                        }
                    }
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        }
    }

    public String toString() {
        return "TableData - Fro type name: " + AueUtil.doubleQuote(this.froTypeName) + ", Table name: " + AueUtil.doubleQuote(this.getTableName());
    }

    protected static class FroTableData {
        private final Integer froTypeId;
        private String froDataTableName = "";
        private String orgFroDataTableName;

        protected FroTableData(Integer froTypeId, String frodataTableName) {
            this.froTypeId = froTypeId;
            this.froDataTableName = frodataTableName;
            this.orgFroDataTableName = frodataTableName;
        }

        public Integer getFroTypeId() {
            return this.froTypeId;
        }

        public String getTableName() {
            return this.froDataTableName;
        }

        public String getOriginalTableName() {
            return this.orgFroDataTableName;
        }

        public void setTableName(String frodataTableName) {
            this.froDataTableName = frodataTableName;
            logger.traceDebug(THIS_CLASS, "setTableName(" + AueUtil.doubleQuote(frodataTableName) + ")");
        }

        public void setOriginalTableName(String frodataTableName) {
            this.orgFroDataTableName = frodataTableName;
        }

        public boolean isInitialized() {
            return this.froTypeId != -1 && !this.froDataTableName.equals("");
        }
    }
}

