/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.J9JSSESSLContext;
import com.ibm.j9.jsse.J9JSSESessionContext;
import com.ibm.j9.jsse.SSLServerSocketFactory;
import com.ibm.j9.jsse.SSLSocketFactory;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.j9.ssl.J9SSLContext;
import com.ibm.j9.ssl.J9SSLSessionContext;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class J9JSSEContextSSLV3
extends SSLContextSpi {
    private boolean initialised = false;
    private J9SSLContext sslContext;
    private J9SSLSessionContext sessionContextImpl = new J9SSLSessionContext();
    private J9JSSESessionContext serverSessionContext;
    private J9JSSESessionContext sessionContext = new J9JSSESessionContext(this.sessionContextImpl);

    protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        X509KeyManager km = null;
        km = keyManagers == null ? J9JSSEContextSSLV3.getDefaultKeyManager() : J9JSSEContextSSLV3.findValidKeyManager(keyManagers);
        X509TrustManager tm = null;
        tm = trustManagers == null ? J9JSSEContextSSLV3.getDefaultTrustManager() : J9JSSEContextSSLV3.findValidTrustManager(trustManagers);
        SecureRandom randomSource = null;
        randomSource = secureRandom == null ? new SecureRandom() : secureRandom;
        this.sslContext = new J9JSSESSLContext(km, tm, randomSource, this.sessionContextImpl);
        this.initialised = true;
    }

    protected javax.net.ssl.SSLSocketFactory engineGetSocketFactory() {
        if (!this.initialised) {
            throw new IllegalStateException();
        }
        return new SSLSocketFactory(this.sslContext);
    }

    protected javax.net.ssl.SSLServerSocketFactory engineGetServerSocketFactory() {
        if (!this.initialised) {
            throw new IllegalStateException();
        }
        return new SSLServerSocketFactory(this.sslContext);
    }

    protected SSLSessionContext engineGetServerSessionContext() {
        if (!this.initialised) {
            return null;
        }
        return this.serverSessionContext;
    }

    protected SSLSessionContext engineGetClientSessionContext() {
        if (!this.initialised) {
            return null;
        }
        return this.sessionContext;
    }

    private static X509TrustManager getDefaultTrustManager() throws KeyManagementException {
        X509TrustManager tm = null;
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("IBMJ9X509");
            tmf.init((KeyStore)null);
            TrustManager[] candidates = tmf.getTrustManagers();
            tm = (X509TrustManager)candidates[0];
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagementException(Msg.getString("K03a6"));
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyManagementException(Msg.getString("K03a7"));
        }
        return tm;
    }

    private static X509KeyManager getDefaultKeyManager() throws KeyManagementException {
        X509KeyManager km = null;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(null, null);
            KeyManager[] candidates = kmf.getKeyManagers();
            km = (X509KeyManager)candidates[0];
        }
        catch (KeyStoreException keyStoreException) {
            throw new KeyManagementException(Msg.getString("K03a7"));
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new KeyManagementException(Msg.getString("K03a7"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyManagementException(Msg.getString("K03a8"));
        }
        return km;
    }

    private static X509TrustManager findValidTrustManager(TrustManager[] trustManagers) throws KeyManagementException {
        int i = 0;
        while (i < trustManagers.length) {
            if (trustManagers[i] instanceof X509TrustManager) {
                return (X509TrustManager)trustManagers[i];
            }
            ++i;
        }
        throw new KeyManagementException(Msg.getString("K03a9"));
    }

    private static X509KeyManager findValidKeyManager(KeyManager[] keyManagers) throws KeyManagementException {
        int i = 0;
        while (i < keyManagers.length) {
            if (keyManagers[i] instanceof X509KeyManager) {
                return (X509KeyManager)keyManagers[i];
            }
            ++i;
        }
        throw new KeyManagementException(Msg.getString("K03aa"));
    }
}

