/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.J9X509TrustManager;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.oti.util.PriviAction;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class X509TrustManagerFactory
extends TrustManagerFactorySpi {
    private KeyStore keyStore;
    private boolean initialized = false;

    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        this.keyStore = keyStore == null ? X509TrustManagerFactory.openSystemKeyStore() : keyStore;
        this.initialized = true;
    }

    protected void engineInit(ManagerFactoryParameters params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(Msg.getString("K03be"));
    }

    protected TrustManager[] engineGetTrustManagers() {
        if (!this.initialized) {
            throw new IllegalStateException(Msg.getString("K03c1"));
        }
        TrustManager[] result = new TrustManager[]{new J9X509TrustManager(this.keyStore)};
        return result;
    }

    private static KeyStore openSystemKeyStore() throws KeyStoreException {
        KeyStore result = null;
        String keyStoreType = null;
        keyStoreType = X509TrustManagerFactory.getPrivilegedSystemProperty("javax.net.ssl.trustStoreType");
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        String keyStorePassword = null;
        keyStorePassword = X509TrustManagerFactory.getPrivilegedSystemProperty("javax.net.ssl.trustStorePassword");
        String keyStorePath = null;
        File keyStoreFile = null;
        keyStorePath = X509TrustManagerFactory.getPrivilegedSystemProperty("javax.net.ssl.trustStore");
        if (keyStorePath != null && X509TrustManagerFactory.fileExists(keyStoreFile = new File(keyStorePath))) {
            return X509TrustManagerFactory.openKeyStore(keyStoreFile, keyStoreType, keyStorePassword);
        }
        keyStorePath = String.valueOf(X509TrustManagerFactory.getSecurityPath()) + "jssecacerts";
        keyStoreFile = new File(keyStorePath);
        if (X509TrustManagerFactory.fileExists(keyStoreFile)) {
            return X509TrustManagerFactory.openKeyStore(keyStoreFile, keyStoreType, keyStorePassword);
        }
        keyStorePath = String.valueOf(X509TrustManagerFactory.getSecurityPath()) + "cacerts";
        keyStoreFile = new File(keyStorePath);
        if (X509TrustManagerFactory.fileExists(keyStoreFile)) {
            return X509TrustManagerFactory.openKeyStore(keyStoreFile, keyStoreType, keyStorePassword);
        }
        return result;
    }

    private static String getPrivilegedSystemProperty(String key) {
        return (String)AccessController.doPrivileged(new PriviAction(key));
    }

    private static final boolean fileExists(final File aFile) {
        Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(aFile.exists());
            }
        });
        return result;
    }

    private static final KeyStore openKeyStore(final File keyStoreFile, String keyStoreType, String keyStorePassword) throws KeyStoreException {
        InputStream is;
        KeyStore result = KeyStore.getInstance(keyStoreType);
        try {
            is = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new BufferedInputStream(new FileInputStream(keyStoreFile));
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new KeyStoreException(e.getException().getMessage());
        }
        char[] keyStorePasswordChars = null;
        if (keyStorePassword != null) {
            keyStorePasswordChars = keyStorePassword.toCharArray();
        }
        try {
            try {
                result.load(is, keyStorePasswordChars);
            }
            catch (Exception e) {
                String fileName = keyStoreFile == null ? Msg.getString("K006c") : keyStoreFile.getPath();
                throw new KeyStoreException(Msg.getString("K03c0", fileName, e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private static final String getSecurityPath() {
        String separator = (String)AccessController.doPrivileged(new PriviAction("file.separator"));
        String javaHomePath = (String)AccessController.doPrivileged(new PriviAction("java.home"));
        return String.valueOf(javaHomePath) + separator + "lib" + separator + "security" + separator;
    }
}

