/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.ibm.j9.jsse.support.Msg;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;

public abstract class HttpsURLConnection
extends HttpURLConnection {
    private static HostnameVerifier defaultHostnameVerifier = new HostnameVerifier(){

        public boolean verify(String hostName, SSLSession sslSession) {
            return false;
        }
    };
    private static SSLSocketFactory defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    protected HostnameVerifier hostnameVerifier = defaultHostnameVerifier;
    private SSLSocketFactory factory = defaultSSLSocketFactory;

    protected HttpsURLConnection(URL httpsURL) throws IOException {
        super(httpsURL);
    }

    public abstract String getCipherSuite();

    public abstract Certificate[] getLocalCertificates();

    public abstract Certificate[] getServerCertificates() throws SSLPeerUnverifiedException;

    public static synchronized void setDefaultHostnameVerifier(HostnameVerifier verifier) {
        if (verifier == null) {
            throw new IllegalArgumentException(Msg.getString("K03b2"));
        }
        defaultHostnameVerifier = verifier;
    }

    public static synchronized HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public synchronized void setHostnameVerifier(HostnameVerifier verifier) {
        if (verifier == null) {
            throw new IllegalArgumentException(Msg.getString("K03b2"));
        }
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new SSLPermission("setHostnameVerifier"));
        }
        this.hostnameVerifier = verifier;
    }

    public synchronized HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public static synchronized void setDefaultSSLSocketFactory(SSLSocketFactory aFactory) {
        if (aFactory == null) {
            throw new IllegalArgumentException(Msg.getString("K03b3"));
        }
        defaultSSLSocketFactory = aFactory;
    }

    public static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSSLSocketFactory;
    }

    public synchronized void setSSLSocketFactory(SSLSocketFactory aFactory) {
        if (aFactory == null) {
            throw new IllegalArgumentException(Msg.getString("K03b3"));
        }
        this.factory = aFactory;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        return this.factory;
    }
}

