/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import se.ericsson.cello.commandlog.logcontentcontrol.InspectorRepository;
import se.ericsson.cello.commandlog.logcontentcontrol.LogContentInspector;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipsec.IkePeerMo;
import se.ericsson.cello.ipsec.IpSecMo;
import se.ericsson.cello.ipsec.StructHelper;
import se.ericsson.cello.ipsec.StructHelperInterface;
import se.ericsson.cello.ipsec.mom.EnumAuthentificationMethodCheck;
import se.ericsson.cello.ipsec.mom.EnumDiffieHellmanGroupCheck;
import se.ericsson.cello.ipsec.mom.EnumIdTypeCheck;
import se.ericsson.cello.ipsec.mom.EnumIkeEncryptionAlgorithmCheck;
import se.ericsson.cello.ipsec.mom.EnumIkeIntegrityAlgorithmCheck;
import se.ericsson.cello.ipsec.mom.EnumIkeVersionCheck;
import se.ericsson.cello.ipsec.mom.EnumOwnIdType;
import se.ericsson.cello.ipsec.mom.EnumPreSharedKeyEncodingCheck;
import se.ericsson.cello.ipsec.mom.EnumPseudoRandomFunctionCheck;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.DomainNameFormatException;
import se.ericsson.cello.mao.DomainNameValidation;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.Ipv4AddressValidation;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumStateValsCheck;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class IkePeerMoImpl
extends CelloMao
implements IkePeerMo,
Reservable,
LogContentInspector {
    private MoData data;
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    private static boolean isDomainName = false;
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;
    private static final String INSTALL_PRE_SHARED_KEY = "installPreSharedKey";
    public static final StructHelperImpl myStructHelper = new StructHelperImpl();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        StructParameter structParameter;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IkePeer", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSec");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IkePeer", (int)128, (int)0);
        Struct[] structArray = MoAttributeValidator.checkAndGetArrayOfStructs((String)"allowedTransforms", (AttrList)attrList, (boolean)true, (int)1, (int)5, (String)"IkePeer");
        int n = MoAttributeValidator.checkAndGetEnumAttribute((String)"authenticationMethod", (AttrList)attrList, (boolean)false, (int)1, (int[])EnumAuthentificationMethodCheck.VALUES_ARRAY, (String)"IkePeer");
        Struct struct = MoAttributeValidator.checkAndGetStructAttribute((String)"childSaLifeTime", (AttrList)attrList, (boolean)false, (String)"IkePeer");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"deadPeerDetectionInterval", (AttrList)attrList, (boolean)false, (int)60, (int)30, (int)1800, (String)"IkePeer");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"ikeSaLifeTime", (AttrList)attrList, (boolean)false, (int)1440, (int)60, (int)5000, (String)"IkePeer");
        int n4 = MoAttributeValidator.checkAndGetEnumAttribute((String)"logging", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumStateValsCheck.VALUES_ARRAY, (String)"IkePeer");
        String string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"peerIpAddress", (AttrList)attrList, (boolean)true, (String)"", (String)"IkePeer");
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"dscp", (AttrList)attrList, (boolean)false, (int)48, (int)0, (int)63, (String)"IkePeer");
        IkePeerMoImpl.checkPeerIpAddress(string3);
        int n6 = ((IpSecMo)managedObject).getFroId(coordinator);
        Struct struct2 = MoAttributeValidator.checkAndGetStructAttribute((String)"peerIdentity", (AttrList)attrList, (boolean)false, (String)"IkePeer");
        Struct struct3 = null;
        if (struct2 != null) {
            struct3 = IkePeerMoImpl.checkPeerIdentity(struct2, string3);
        }
        Struct struct4 = MoAttributeValidator.checkAndGetStructAttribute((String)"ownIdentity", (AttrList)attrList, (boolean)false, (String)"IkePeer");
        Struct struct5 = null;
        if (struct4 != null) {
            struct5 = IkePeerMoImpl.checkOwnIdentity(struct4, string3);
        }
        int n7 = MoAttributeValidator.checkAndGetEnumAttribute((String)"ikeVersion", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumIkeVersionCheck.VALUES_ARRAY, (String)"IkePeer");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IkePeer");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StructHelper.packStructArrayIntoFroParameters(structArray, arrayList, "allowedTransforms", "allowedTransformsEntry", IkePeerMo.ALLOWED_TRANSFORMS_ELEMENT_NAMES, myStructHelper);
        arrayList.add(new SignedIntParameter("authenticationMethod", n));
        if (struct != null) {
            structParameter = StructHelper.convertStructIntoStructParameter(struct, CHILD_SA_LIFETIME_ELEMENT_NAMES, "childSaLifeTime", "childSaLifeTime", myStructHelper);
            arrayList.add(structParameter);
        } else {
            structParameter = new StructParameter[]{new Integer(50000), new Integer(1440)};
            StructParameter structParameter2 = StructHelper.convertStructIntoStructParameter((Struct)new StructImpl(CHILD_SA_LIFETIME_ELEMENT_NAMES, (Object[])structParameter), CHILD_SA_LIFETIME_ELEMENT_NAMES, "childSaLifeTime", "childSaLifeTime", myStructHelper);
            arrayList.add(structParameter2);
        }
        arrayList.add(new SignedIntParameter("deadPeerDetectionInterval", n2));
        arrayList.add(new SignedIntParameter("ikeSaLifeTime", n3));
        arrayList.add(new SignedIntParameter("logging", n4));
        arrayList.add(new StringParameter("peerIpAddress", string3));
        arrayList.add(new SignedIntParameter("dscp", n5));
        arrayList.add(new SignedIntParameter("ipsecFroId", n6));
        arrayList.add(new StringParameter("ikePeerMoId", managedObject.getFullDistinguishedName() + "," + "IkePeer" + "=" + string));
        if (struct3 != null) {
            structParameter = new StructParameter("peerIdentity");
            structParameter.add((Parameter)new StringParameter("peerIdentity.idFqdn", struct3.getValue("idFqdn").toString()));
            structParameter.add((Parameter)new SignedIntParameter("peerIdentity.idType", ((Integer)struct3.getValue("idType")).intValue()));
            structParameter.add((Parameter)new StringParameter("peerIdentity.ipv4Address", struct3.getValue("ipv4Address").toString()));
            arrayList.add(structParameter);
        } else {
            structParameter = new StructParameter("peerIdentity");
            structParameter.add((Parameter)new StringParameter("peerIdentity.idFqdn", ""));
            structParameter.add((Parameter)new SignedIntParameter("peerIdentity.idType", 3));
            structParameter.add((Parameter)new StringParameter("peerIdentity.ipv4Address", ""));
            arrayList.add(structParameter);
        }
        if (struct5 != null) {
            structParameter = new StructParameter("ownIdentity");
            structParameter.add((Parameter)new StringParameter("ownIdentity.idFqdn", struct5.getValue("idFqdn").toString()));
            structParameter.add((Parameter)new SignedIntParameter("ownIdentity.ownIdType", ((Integer)struct5.getValue("ownIdType")).intValue()));
            structParameter.add((Parameter)new StringParameter("ownIdentity.ipv4Address", struct5.getValue("ipv4Address").toString()));
            arrayList.add(structParameter);
        } else {
            structParameter = new StructParameter("ownIdentity");
            structParameter.add((Parameter)new StringParameter("ownIdentity.idFqdn", ""));
            structParameter.add((Parameter)new SignedIntParameter("ownIdentity.ownIdType", 0));
            structParameter.add((Parameter)new StringParameter("ownIdentity.ipv4Address", ""));
            arrayList.add(structParameter);
        }
        arrayList.add(new SignedIntParameter("ikeVersion", n7));
        return new IkePeerMoImpl(managedObject, string, string2, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    private static Struct checkPeerIdentity(Struct struct, String string) throws MoAccessException {
        String string2;
        String string3;
        int n;
        if (struct.size() != 3) {
            throw new ValueOutOfRangeException("peerIdentity has wrong number of elements.", "IkePeer");
        }
        try {
            n = (Integer)struct.getValue("idType");
            string3 = (String)struct.getValue("ipv4Address");
            string2 = (String)struct.getValue("idFqdn");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ValueOutOfRangeException("PeerIdentity is inconsistent, attribute is missing " + noSuchFieldException.toString(), "IkePeer");
        }
        catch (MoAccessException moAccessException) {
            throw moAccessException;
        }
        if (n > 3) {
            throw new ValueOutOfRangeException("idType is set to " + n + " , value is not OK", "IkePeer");
        }
        if ((n == 2 || n == 0) && string2.length() == 0) {
            throw new ValueOutOfRangeException("idType is set to FQDN or ANY, but idFqdn is empty", "IkePeer");
        }
        if (n == 3 && (string2.length() != 0 || string3.length() != 0)) {
            throw new ValueOutOfRangeException("IdType is set to AUTOMATIC, but Fqdn and/or IpAdd is not empty", "IkePeer");
        }
        if (string2.length() != 0) {
            char c = '.';
            char c2 = '-';
            char c3 = string2.charAt(0);
            char c4 = string2.charAt(string2.length() - 1);
            if (Character.isLetter(c3) && Character.isLetterOrDigit(c4)) {
                for (int i = 1; i < string2.length() - 1; ++i) {
                    if (Character.isLetterOrDigit(string2.charAt(i)) || string2.charAt(i) == c || string2.charAt(i) == c2) continue;
                    throw new ValueOutOfRangeException("FQDN is not a qualified domain name", "IkePeer");
                }
            } else {
                throw new ValueOutOfRangeException("FQDN is not a qualified domain name", "IkePeer");
            }
        }
        if (string3.length() != 0) {
            new IpAddress(string3);
        }
        if (n == 1 && string3.length() == 0 && isDomainName) {
            throw new IllegalAttributeValueException("If idType specifies an IPv4 address and the value of peerIpAddress is a domain name, field IpAddress must not be empty.", "IkePeer");
        }
        if ((n == 1 || n == 0) && string3.length() == 0) {
            String[] stringArray = new String[]{"idFqdn", "idType", "ipv4Address"};
            Object[] objectArray = new Object[]{struct.getValue("idFqdn"), struct.getValue("idType"), string};
            StructImpl structImpl = new StructImpl(stringArray, objectArray);
            return structImpl;
        }
        return struct;
    }

    private static Struct checkOwnIdentity(Struct struct, String string) throws MoAccessException {
        String string2;
        String string3;
        int n;
        if (struct.size() != 3) {
            throw new ValueOutOfRangeException("ownIdType has wrong number of elements.", "IkePeer");
        }
        try {
            n = (Integer)struct.getValue("ownIdType");
            string3 = (String)struct.getValue("ipv4Address");
            string2 = (String)struct.getValue("idFqdn");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ValueOutOfRangeException("OwnIdentity is inconsistent, attribute is missing " + noSuchFieldException.toString(), "IkePeer");
        }
        catch (MoAccessException moAccessException) {
            throw moAccessException;
        }
        int n2 = EnumOwnIdType.VALUES_ARRAY.length - 1;
        if (n > n2) {
            throw new ValueOutOfRangeException("ownIdType is set to " + n + " , value is not OK", "IkePeer");
        }
        if (n == 0 || n == 3) {
            if (string3.length() > 0) {
                throw new ValueOutOfRangeException("ownIdType is set to AUTOMATIC/AUTOMATIC_DN, but ownIpAdd is not empty", "IkePeer");
            }
            if (string2.length() > 0) {
                throw new ValueOutOfRangeException("ownIdType is set to AUTOMATIC/AUTOMATIC_DN, but idFqdn is not empty", "IkePeer");
            }
        }
        if (string2.length() != 0) {
            char c = '.';
            for (int i = 0; i < string2.length(); ++i) {
                if (Character.isLetterOrDigit(string2.charAt(i)) || string2.charAt(i) == c) continue;
                throw new ValueOutOfRangeException("FQDN is not a qualified domain name", "IkePeer");
            }
        }
        if (string3.length() != 0) {
            new IpAddress(string3);
        }
        return struct;
    }

    private static void checkPeerIpAddress(String string) throws MoAccessException {
        isDomainName = false;
        if (!Ipv4AddressValidation.isValidIpv4Address((String)string)) {
            try {
                DomainNameValidation.validateForFQDN((String)string);
            }
            catch (DomainNameFormatException domainNameFormatException) {
                throw new ValueOutOfRangeException(string, "IkePeer", "Invalid format of Ipv4Address and domain name");
            }
            isDomainName = true;
        }
    }

    private IkePeerMoImpl(ManagedObject managedObject, String string, String string2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "IkePeer", string, coordinator);
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "IkePeer");
        this.data.setRevision(8000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IkePeerMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
        ((InspectorRepository)this.getMaoContext().getServiceRepository().getService(InspectorRepository.class)).register((LogContentInspector)this, "IkePeer");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = null;
        map = this.getFroParameters(map, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                arrayList.add(((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                arrayList.add(ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("allowedTransforms")) {
                if (map.get("allowedTransforms") != null) {
                    arrayList.add(StructHelper.ikeSaTransformArray2StructArray((ArrayParameter)map.get("allowedTransforms")));
                    continue;
                }
                arrayList.add(new Struct[0]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("securityAssociations")) {
                if (map.get("securityAssociations") != null) {
                    arrayList.add(StructHelper.converIkeSaArray2Struct((ArrayParameter)map.get("securityAssociations")));
                    continue;
                }
                arrayList.add(new Struct[0]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("childSaLifeTime")) {
                if (map.get("childSaLifeTime") != null) {
                    arrayList.add(StructHelper.convertChildSaLifeTime2Struct((StructParameter)map.get("childSaLifeTime")));
                    continue;
                }
                signedIntParameter = new SignedIntParameter[]{"", ""};
                arrayList.add(new StructImpl(CHILD_SA_LIFETIME_ELEMENT_NAMES, (Object[])signedIntParameter));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("peerCertificate")) {
                if (map.get("peerCertificate") != null) {
                    arrayList.add(StructHelper.convertCertInfo2Struct((StructParameter)map.get("peerCertificate")));
                    continue;
                }
                signedIntParameter = new Object[CERT_INFO_ELEMENT_NAMES.length];
                for (int j = 0; j < ((SignedIntParameter)signedIntParameter).length; ++j) {
                    signedIntParameter[j] = "";
                }
                arrayList.add(new StructImpl(CERT_INFO_ELEMENT_NAMES, (Object[])signedIntParameter));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("authenticationMethod")) {
                signedIntParameter = (SignedIntParameter)map.get("authenticationMethod");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("deadPeerDetectionInterval")) {
                signedIntParameter = (SignedIntParameter)map.get("deadPeerDetectionInterval");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ikeSaLifeTime")) {
                signedIntParameter = (SignedIntParameter)map.get("ikeSaLifeTime");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logging")) {
                if (map.get("logging") != null) {
                    signedIntParameter = (SignedIntParameter)map.get("logging");
                    arrayList.add(new Integer(signedIntParameter.getValue()));
                    continue;
                }
                arrayList.add(new Integer(99));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("peerIdentity")) {
                if (map.get("peerIdentity") == null) continue;
                arrayList.add(StructHelper.convertPeerIdentity2Struct((StructParameter)map.get("peerIdentity")));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ownIdentity")) {
                if (map.get("ownIdentity") == null) continue;
                arrayList.add(StructHelper.convertOwnIdentity2Struct((StructParameter)map.get("ownIdentity")));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("peerIpAddress")) {
                signedIntParameter = (StringParameter)map.get("peerIpAddress");
                arrayList.add(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dscp")) {
                signedIntParameter = (SignedIntParameter)map.get("dscp");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("IkePeerId")) {
                arrayList.add(super.getNamingAttributeValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ikeVersion")) {
                if (map.get("ikeVersion") != null) {
                    signedIntParameter = (SignedIntParameter)map.get("ikeVersion");
                    arrayList.add(new Integer(signedIntParameter.getValue()));
                    continue;
                }
                arrayList.add(new Integer(99));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInAuthReq")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInAuthReq", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInAuthRsp")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInAuthRsp", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInCrChildReq")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInCrChildReq", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInCrChildRsp")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInCrChildRsp", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInInfoReq")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInInfoReq", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInInfoRsp")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInInfoRsp", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInInitReq")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInInitReq", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInInitRsp")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInInitRsp", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInInvalid")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInInvalid", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInInvalidSpi")) {
                arrayList.add(new Integer(super.getPmAttribute("pmInInvalidSpi", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutAuthReq")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutAuthReq", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutAuthRsp")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutAuthRsp", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutCrChildReq")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutCrChildReq", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutCrChildRsp")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutCrChildRsp", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutInfoReq")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutInfoReq", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutInfoRsp")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutInfoRsp", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutInitReq")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutInitReq", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutInitRsp")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutInitRsp", coordinator)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmChildSaRekey")) {
                arrayList.add(new Integer(super.getPmAttribute("pmChildSaRekey", coordinator)));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IkePeer");
        }
        return arrayList.toArray();
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.setAttributes(new String[]{string}, new Object[]{object}, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        Object var6_6 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            StructParameter structParameter;
            Struct struct;
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IkePeerMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IkePeer");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IkePeer", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("allowedTransforms")) {
                object = new AttrListImpl();
                object.addElement("allowedTransforms", objectArray[i]);
                struct = MoAttributeValidator.checkAndGetArrayOfStructs((String)"allowedTransforms", (AttrList)object, (boolean)true, (int)1, (int)5, (String)"IkePeer");
                StructHelper.packStructArrayIntoFroParameters((Struct[])struct, arrayList, "allowedTransforms", "allowedTransformsEntry", IkePeerMo.ALLOWED_TRANSFORMS_ELEMENT_NAMES, myStructHelper);
                this.sendNotification("allowedTransforms", struct, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("childSaLifeTime")) {
                if (!(objectArray[i] instanceof Struct)) {
                    throw new WrongAttributeTypeException("childSaLifeTime", "IkePeer");
                }
                object = StructHelper.convertStructIntoStructParameter((Struct)objectArray[i], CHILD_SA_LIFETIME_ELEMENT_NAMES, "childSaLifeTime", "childSaLifeTime", myStructHelper);
                arrayList.add(object);
                this.sendNotification("childSaLifeTime", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("authenticationMethod")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IkePeerMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("authenticationMethod", "IkePeer");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkEnumAttribute((String)"authenticationMethod", (int)n, (int[])EnumAuthentificationMethodCheck.VALUES_ARRAY, (String)"IkePeer");
                arrayList.add(new SignedIntParameter("authenticationMethod", n));
                this.sendNotification("authenticationMethod", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("deadPeerDetectionInterval")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IkePeerMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("deadPeerDetectionInterval", "IkePeer");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"deadPeerDetectionInterval", (int)n, (int)30, (int)1800, (String)"IkePeer");
                arrayList.add(new SignedIntParameter("deadPeerDetectionInterval", n));
                this.sendNotification("deadPeerDetectionInterval", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logging")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IkePeerMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("logging", "IkePeer");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkEnumAttribute((String)"logging", (int)n, (int[])EnumStateValsCheck.VALUES_ARRAY, (String)"IkePeer");
                arrayList.add(new SignedIntParameter("logging", n));
                this.sendNotification("logging", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("peerIdentity")) {
                if (!(objectArray[i] instanceof Struct)) {
                    throw new WrongAttributeTypeException("peerIdentity", "IkePeer");
                }
                object = this.getPeerIpAddress(coordinator);
                struct = IkePeerMoImpl.checkPeerIdentity((Struct)objectArray[i], (String)object);
                structParameter = new StructParameter("peerIdentity");
                structParameter.add((Parameter)new StringParameter("peerIdentity.idFqdn", struct.getValue("idFqdn").toString()));
                structParameter.add((Parameter)new SignedIntParameter("peerIdentity.idType", ((Integer)struct.getValue("idType")).intValue()));
                structParameter.add((Parameter)new StringParameter("peerIdentity.ipv4Address", struct.getValue("ipv4Address").toString()));
                arrayList.add(structParameter);
                this.sendNotification("peerIdentity", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ownIdentity")) {
                if (!(objectArray[i] instanceof Struct)) {
                    throw new WrongAttributeTypeException("ownIdentity", "IkePeer");
                }
                object = this.getPeerIpAddress(coordinator);
                struct = IkePeerMoImpl.checkOwnIdentity((Struct)objectArray[i], (String)object);
                structParameter = new StructParameter("ownIdentity");
                structParameter.add((Parameter)new StringParameter("ownIdentity.idFqdn", struct.getValue("idFqdn").toString()));
                structParameter.add((Parameter)new SignedIntParameter("ownIdentity.ownIdType", ((Integer)struct.getValue("ownIdType")).intValue()));
                structParameter.add((Parameter)new StringParameter("ownIdentity.ipv4Address", struct.getValue("ipv4Address").toString()));
                arrayList.add(structParameter);
                this.sendNotification("ownIdentity", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ikeSaLifeTime")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IkePeerMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ikeSaLifeTime", "IkePeer");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"ikeSaLifeTime", (int)n, (int)60, (int)5000, (String)"IkePeer");
                arrayList.add(new SignedIntParameter("ikeSaLifeTime", n));
                this.sendNotification("ikeSaLifeTime", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dscp")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IkePeerMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("dscp", "IkePeer");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"dscp", (int)n, (int)0, (int)63, (String)"IkePeer");
                arrayList.add(new SignedIntParameter("dscp", n));
                this.sendNotification("dscp", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ikeVersion")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IkePeerMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ikeVersion", "IkePeer");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkEnumAttribute((String)"ikeVersion", (int)n, (int[])EnumIkeVersionCheck.VALUES_ARRAY, (String)"IkePeer");
                arrayList.add(new SignedIntParameter("ikeVersion", n));
                this.sendNotification("ikeVersion", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IkePeer");
        }
        if (!arrayList.isEmpty()) {
            this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public int getPmOutInfoRsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutInfoReq", coordinator);
    }

    public int getLogging(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("logging", coordinator);
    }

    public Struct getPeerIdentity(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("peerIdentity", coordinator);
    }

    public void setPeerIdentity(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("peerIdentity", struct, coordinator);
    }

    public Struct getOwnIdentity(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("ownIdentity", coordinator);
    }

    public void setOwnIdentity(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ownIdentity", struct, coordinator);
    }

    public void setLogging(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("logging", new Integer(n), coordinator);
    }

    public int getIkeVersion(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ikeVersion", coordinator);
    }

    public void setIkeVersion(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ikeVersion", new Integer(n), coordinator);
    }

    public int getPmInInvalidSpi(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInInvalidSpi", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public Struct[] getAllowedTransforms(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("allowedTransforms", coordinator);
    }

    public void setAllowedTransforms(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("allowedTransforms", structArray, coordinator);
    }

    public Struct[] getSecurityAssociations(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("securityAssociations", coordinator);
    }

    public int getPmChildSaRekey(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmChildSaRekey", coordinator);
    }

    public int getPmInInfoReq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInInfoReq", coordinator);
    }

    public int getPmOutInfoReq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutInfoReq", coordinator);
    }

    public int getPmInInfoRsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInInfoRsp", coordinator);
    }

    public int getPmInInvalid(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInInvalid", coordinator);
    }

    public int getPmOutAuthReq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutAuthReq", coordinator);
    }

    public int getPmOutCrChildRsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutCrChildRsp", coordinator);
    }

    public int getPmInCrChildRsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInCrChildRsp", coordinator);
    }

    public int getPmOutCrChildReq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutCrChildReq", coordinator);
    }

    public int getPmInCrChildReq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInCrChildReq", coordinator);
    }

    public int getPmOutInitRsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutInitRsp", coordinator);
    }

    public int getPmInInitRsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInInitRsp", coordinator);
    }

    public int getPmOutInitReq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutInitReq", coordinator);
    }

    public int getPmInInitReq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInInitReq", coordinator);
    }

    public int getPmOutAuthRsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutAuthRsp", coordinator);
    }

    public int getPmInAuthRsp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInAuthRsp", coordinator);
    }

    public int getPmInAuthReq(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInAuthReq", coordinator);
    }

    public String getPeerIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("peerIpAddress", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAuthenticationMethod(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("authenticationMethod", coordinator);
    }

    public void setAuthenticationMethod(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("authenticationMethod", new Integer(n), coordinator);
    }

    public Struct getPeerCertificate(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("peerCertificate", coordinator);
    }

    public int getIkeSaLifeTime(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ikeSaLifeTime", coordinator);
    }

    public void setIkeSaLifeTime(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ikeSaLifeTime", new Integer(n), coordinator);
    }

    public Struct getChildSaLifeTime(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("childSaLifeTime", coordinator);
    }

    public void setChildSaLifeTime(Struct struct, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("childSaLifeTime", struct, coordinator);
    }

    public int getDeadPeerDetectionInterval(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("deadPeerDetectionInterval", coordinator);
    }

    public void setDeadPeerDetectionInterval(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("deadPeerDetectionInterval", new Integer(n), coordinator);
    }

    public int getDscp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("dscp", coordinator);
    }

    public void setDscp(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("dscp", new Integer(n), coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    public void actionInstallPreSharedKey(Struct struct, Coordinator coordinator) throws MoAccessException {
        StructParameter structParameter = StructHelper.convertStructIntoStructParameter(struct, IkePeerMo.INSTALL_PRE_SHARED_KEY_ELEMENT_NAMES, "actionInstallPreSharedKey", "preSharedKeyData", myStructHelper);
        ArrayList<StructParameter> arrayList = new ArrayList<StructParameter>();
        arrayList.add(structParameter);
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 101, arrayList);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    private Map getFroParameters(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    public Object[] hideHazardousAttributeValues(AttrList attrList) {
        return null;
    }

    public Object[] hideHazardousActionParameters(String string, Object[] objectArray) {
        try {
            if (string.equalsIgnoreCase(INSTALL_PRE_SHARED_KEY)) {
                return this.blankPreSharedKeyValue(objectArray);
            }
            return null;
        }
        catch (RuntimeException runtimeException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + runtimeException));
            return null;
        }
    }

    private Object[] blankPreSharedKeyValue(Object[] objectArray) {
        try {
            Struct struct = (Struct)objectArray[0];
            String[] stringArray = new String[]{"encoding", "preSharedKey"};
            Object[] objectArray2 = new Object[]{struct.getValue("encoding"), "*****"};
            StructImpl structImpl = new StructImpl(stringArray, objectArray2);
            objectArray[0] = structImpl;
            return objectArray;
        }
        catch (MoAccessException moAccessException) {
            MessageLog.info(this.getClass(), (String)("In hideHazardousActionParameters, not able to hide hazardous parameters" + (Object)((Object)moAccessException)));
            return null;
        }
    }

    public static class StructHelperImpl
    implements StructHelperInterface {
        public Parameter convertStructValueIntoParameter(String string, Object object, String string2) throws IllegalParameterValueException, NoSuchAttributeException, MoAccessException {
            int n = -1;
            if (string.equals("diffieHellmanGroup")) {
                n = (Integer)object;
                MoAttributeValidator.checkEnumAttribute((String)"diffieHellmanGroup", (int)n, (int[])EnumDiffieHellmanGroupCheck.VALUES_ARRAY, (String)"IkePeer");
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("encryptionAlgorithm")) {
                n = (Integer)object;
                MoAttributeValidator.checkEnumAttribute((String)"encryptionAlgorithm", (int)n, (int[])EnumIkeEncryptionAlgorithmCheck.VALUES_ARRAY, (String)"IkePeer");
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("integrityAlgorithm")) {
                n = (Integer)object;
                MoAttributeValidator.checkEnumAttribute((String)"integrityAlgorithm", (int)n, (int[])EnumIkeIntegrityAlgorithmCheck.VALUES_ARRAY, (String)"IkePeer");
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("pseudoRandomFunction")) {
                n = (Integer)object;
                MoAttributeValidator.checkEnumAttribute((String)"pseudoRandomFunction", (int)n, (int[])EnumPseudoRandomFunctionCheck.VALUES_ARRAY, (String)"IkePeer");
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("dataLimit")) {
                n = (Integer)object;
                if (n < 100 || n > 500000) {
                    throw new ValueOutOfRangeException(string, string2);
                }
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("time")) {
                n = (Integer)object;
                if (n < 60 || n > 5000) {
                    throw new ValueOutOfRangeException(string, string2);
                }
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("encoding")) {
                n = (Integer)object;
                MoAttributeValidator.checkEnumAttribute((String)"encoding", (int)n, (int[])EnumPreSharedKeyEncodingCheck.VALUES_ARRAY, (String)"IkePeer");
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("preSharedKey")) {
                String string3 = (String)object;
                MoAttributeValidator.checkStringWithLength((String)string3, (String)"preSharedKey", (String)"IkePeer", (int)80, (int)1);
                return new StringParameter(string, (String)object);
            }
            if (string.equals("idFqdn")) {
                return new StringParameter(string, (String)object);
            }
            if (string.equals("idType")) {
                n = (Integer)object;
                MoAttributeValidator.checkEnumAttribute((String)"idType", (int)n, (int[])EnumIdTypeCheck.VALUES_ARRAY, (String)"IkePeer");
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("ipv4Address")) {
                return new StringParameter(string, (String)object);
            }
            if (string.equals("idFqdn")) {
                return new StringParameter(string, (String)object);
            }
            if (string.equals("ownIdType")) {
                n = (Integer)object;
                MoAttributeValidator.checkEnumAttribute((String)"ownIdType", (int)n, (int[])EnumIdTypeCheck.VALUES_ARRAY, (String)"IkePeer");
                return new SignedIntParameter(string, (Integer)object);
            }
            if (string.equals("ipv4Address")) {
                return new StringParameter(string, (String)object);
            }
            throw new NoSuchAttributeException(string2 + "." + string, "IkePeer");
        }
    }
}

