/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.StringTokenizer;
import se.ericsson.cello.ipsec.mom.EnumSubjectAltNameType;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.security.mom.EnumCertEnrollMode;
import se.ericsson.cello.security.mom.EnumKeyLength;

public class IpSecEnrollmentData {
    private String enrollmentServerURL = null;
    private String caFingerPrint = null;
    private String distinguishedName = null;
    private String challengePassword = null;
    private String subjectAltName = null;
    private int subjectAltNameType = 0;
    private int keyLength = 0;
    private int enrollmentMode = 0;
    private String certificateAuthorityDn = "";
    private static final String HTTP = "http";

    public IpSecEnrollmentData() throws MoAccessException {
    }

    public IpSecEnrollmentData(Struct struct) throws MoAccessException {
        Object object;
        String[] stringArray = struct.getNames();
        if (stringArray.length < 7 || stringArray.length > 9) {
            throw new ValueOutOfRangeException("Missing member in ipSecEnrollmentData", "IpSec");
        }
        if (!(struct.getValue("caFingerPrint") instanceof String)) {
            throw new WrongAttributeTypeException("caFingerPrint", "IpSec");
        }
        this.caFingerPrint = (String)struct.getValue("caFingerPrint");
        if (!(struct.getValue("challengePassword") instanceof String)) {
            throw new WrongAttributeTypeException("challengePassword", "IpSec");
        }
        this.challengePassword = (String)struct.getValue("challengePassword");
        if (!(struct.getValue("distinguishedName") instanceof String)) {
            throw new WrongAttributeTypeException("distinguishedName", "IpSec");
        }
        this.distinguishedName = (String)struct.getValue("distinguishedName");
        if (!(struct.getValue("enrollmentServerURL") instanceof String)) {
            throw new WrongAttributeTypeException("enrollmentServerURL", "IpSec");
        }
        this.enrollmentServerURL = (String)struct.getValue("enrollmentServerURL");
        if (!(struct.getValue("keyLength") instanceof Integer)) {
            throw new WrongAttributeTypeException("keyLength", "IpSec");
        }
        this.keyLength = (Integer)struct.getValue("keyLength");
        if (!(struct.getValue("subjectAltName") instanceof String)) {
            throw new WrongAttributeTypeException("subjectAltName", "IpSec");
        }
        this.subjectAltName = (String)struct.getValue("subjectAltName");
        if (!(struct.getValue("subjectAltNameType") instanceof Integer)) {
            throw new WrongAttributeTypeException("subjectAltNameType", "IpSec");
        }
        this.subjectAltNameType = (Integer)struct.getValue("subjectAltNameType");
        try {
            object = struct.getValue("enrollmentMode");
            if (!(object instanceof Integer)) {
                throw new WrongAttributeTypeException("enrollmentMode", "IpSec");
            }
            this.enrollmentMode = (Integer)object;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.enrollmentMode = 0;
        }
        try {
            object = struct.getValue("certificateAuthorityDn");
            if (!(object instanceof String)) {
                throw new WrongAttributeTypeException("certificateAuthorityDn", "IpSec");
            }
            this.certificateAuthorityDn = (String)object;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.certificateAuthorityDn = "";
        }
        this.check();
    }

    protected String getEnrollmentServerURL() {
        return this.enrollmentServerURL;
    }

    protected String getCaFingerPrint() {
        return this.caFingerPrint;
    }

    protected String getDistinguishedName() {
        return this.distinguishedName;
    }

    protected String getChallengePassword() {
        return this.challengePassword;
    }

    protected String getSubjectAltName() {
        return this.subjectAltName;
    }

    protected int getSubjectAltNameType() {
        return this.subjectAltNameType;
    }

    protected int getKeyLength() {
        return this.keyLength;
    }

    public int getEnrollmentMode() {
        return this.enrollmentMode;
    }

    protected String getCertificateAuthorityDn() {
        return this.certificateAuthorityDn;
    }

    private void check() throws MoAccessException {
        if (this.enrollmentServerURL == null || this.enrollmentServerURL.length() > 255) {
            throw new ValueOutOfRangeException("enrollmentServerURL String too long", "IpSec");
        }
        if (!this.enrollmentServerURL.equals("")) {
            this.checkEnrollmentServerURL(this.enrollmentServerURL);
        }
        if (this.distinguishedName == null || this.distinguishedName.length() > 128 || this.distinguishedName.length() < 1) {
            throw new ValueOutOfRangeException("distinguishedName String too long/empty. ", "IpSec");
        }
        if (this.caFingerPrint == null || this.caFingerPrint.length() > 127) {
            throw new ValueOutOfRangeException("caFingerPrint String format invalid/null", "IpSec");
        }
        if (this.challengePassword == null || this.challengePassword.length() > 21) {
            throw new ValueOutOfRangeException("challengePassword String format invalid/null", "IpSec");
        }
        if (!this.checkFingerprint(this.caFingerPrint)) {
            throw new IllegalAttributeValueException("Invalid format.", "caFingerPrint", "IpSec");
        }
        if (!MoAttributeValidator.isWithinEnum((int)this.subjectAltNameType, (int[])EnumSubjectAltNameType.VALUES_ARRAY)) {
            throw new ValueOutOfRangeException("subjectAltNameTypeInvalid value.", "IpSec");
        }
        this.checkSubjectAltName(this.subjectAltNameType, this.subjectAltName);
        if (!MoAttributeValidator.isWithinEnum((int)this.keyLength, (int[])EnumKeyLength.VALUES_ARRAY)) {
            throw new ValueOutOfRangeException("keyLengthInvalid value.", "IpSec");
        }
        if (!MoAttributeValidator.isWithinEnum((int)this.enrollmentMode, (int[])EnumCertEnrollMode.VALUES_ARRAY)) {
            throw new ValueOutOfRangeException("enrollmentModeInvalid value.", "IpSec");
        }
        if (!this.certificateAuthorityDn.equals("") && this.certificateAuthorityDn.length() > 511) {
            throw new ValueOutOfRangeException("certificateAuthorityDnInvalid value.", "IpSec");
        }
    }

    private void checkSubjectAltName(int n, String string) throws IpFormatException {
        if (n == 1) {
            new IpAddress(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkEnrollmentServerURL(String string) throws MoAccessException {
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.startsWith(HTTP)) throw new IllegalAttributeValueException(" Has to start with http", "enrollmentServerURL", "IpSec");
        String string2 = string.substring(7);
        if (string2.length() == 0) throw new IllegalAttributeValueException(" shall have a valid IP address after http", "enrollmentServerURL", "IpSec");
        if (string2.startsWith("[")) {
            stringBuffer.append(string2.substring(string2.indexOf("[") + 1, string2.indexOf("]")));
            string2 = string2.substring(string2.indexOf("]") + 1);
        } else {
            int n;
            for (int i = 0; i < 3; ++i) {
                n = string2.indexOf(".");
                stringBuffer.append(string2.substring(0, n + 1));
                string2 = string2.substring(n + 1);
            }
            n = string2.indexOf(":");
            int n2 = string2.indexOf("/");
            if (n > 0 && n < 4) {
                stringBuffer.append(string2.substring(0, n));
            } else {
                if (n2 <= 0 || n2 >= 4) throw new IllegalAttributeValueException(" Invalid format ", "enrollmentServerURL", "IpSec");
                stringBuffer.append(string2.substring(0, n2));
            }
        }
        Ipv6Address.validate((String)stringBuffer.toString());
    }

    private boolean checkFingerprint(String string) {
        if (string.equals("")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() == 2) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("MD5") == 0) {
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ":");
                return stringTokenizer2.countTokens() == 16;
            }
            if (string2.indexOf("SHA-1") == 0 || string2.indexOf("SHA1") == 0) {
                String string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string4, ":");
                return stringTokenizer3.countTokens() == 20;
            }
            if (string2.indexOf("SHA256") == 0) {
                String string5 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer4 = new StringTokenizer(string5, ":");
                return stringTokenizer4.countTokens() == 32;
            }
            return false;
        }
        return false;
    }
}

