/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipsec.IpSecTunnelMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.ipsec.VpnInterfaceMoImpl;
import se.ericsson.cello.ipsec.mom.EnumChildSaEncryptionAlgorithm;
import se.ericsson.cello.ipsec.mom.EnumChildSaIntegrityAlgorithm;
import se.ericsson.cello.ipsec.mom.IkePeer;
import se.ericsson.cello.ipsec.mom.VpnInterface;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumProtocolType;
import se.ericsson.cello.transaction.Coordinator;

public class IpSecTunnelMoImpl
extends CelloMao
implements IpSecTunnelMo {
    private MoData data;
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    static final String[] ALLOWED_TRANSFORMATIONS_ELEMENT_NAMES = new String[]{"encryptionAlgorithm", "integrityAlgorithm"};
    static final String[] TS_IP_ADDRESS_RANGES_ELEMENT_NAMES = new String[]{"ipAddress", "mask"};
    static final String[] SECURITY_ASSOCIATIONS_ELEMENT_NAMES = new String[]{"direction", "encryptionAlgorithm", "integrityAlgorithm", "localTrafficSelectors", "remoteTrafficSelectors", "spiValue"};
    static final String[] TRAFFIC_SELECTOR_ELEMENT_NAMES = new String[]{"maxIpAddress", "minIpAddress", "maxPortNumber", "minPortNumber", "protocol"};
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$se$ericsson$cello$ipsec$IpSecTunnelMoImpl;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSec");
        MoAttributeValidator.checkIdentity((String)"IpSecTunnel", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpSecTunnel", (int)128, (int)0);
        Struct[] structArray = MoAttributeValidator.checkAndGetArrayOfStructs((String)"allowedTransforms", (AttrList)attrList, (boolean)true, (int)0, (int)10, (String)"IpSecTunnel");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ikePeerRef", (AttrList)attrList, (boolean)true, (Class[])new Class[]{IkePeer.class}, (String)"IpSecTunnel");
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"priority", (AttrList)attrList, (boolean)true, (int)0, (int)1, (int)200, (String)"IpSecTunnel");
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"antiReplayProtection", (AttrList)attrList, (boolean)false, (boolean)true, (String)"IpSecTunnel");
        Struct[] structArray2 = MoAttributeValidator.checkAndGetArrayOfStructs((String)"tsLocalIpAddressRanges", (AttrList)attrList, (boolean)true, (int)1, (int)2, (String)"IpSecTunnel");
        int[] nArray = MoAttributeValidator.checkAndGetArrayOfPrimitiveIntegers((String)"tsProtocols", (AttrList)attrList, (boolean)true, (int)1, (int)1, (int[])EnumProtocolType.VALUES_ARRAY, (String)"IpSecTunnel");
        Struct[] structArray3 = MoAttributeValidator.checkAndGetArrayOfStructs((String)"tsRemoteIpAddressRanges", (AttrList)attrList, (boolean)true, (int)1, (int)25, (String)"IpSecTunnel");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"vpnInterfaceRef", (AttrList)attrList, (boolean)true, (Class[])new Class[]{VpnInterface.class}, (String)"IpSecTunnel");
        IpSecTunnelMoImpl.validateTsRanges(managedObject4, structArray3, structArray2, coordinator);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpSecTunnel");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IpSecTunnelMoImpl.packStructArrayIntoFroParameters(structArray, arrayList, "allowedTransforms", "allowedTransformsEntry", ALLOWED_TRANSFORMATIONS_ELEMENT_NAMES);
        IpSecTunnelMoImpl.packFroIdForGivenMoRef(arrayList, "ikePeerRef", managedObject3, coordinator);
        arrayList.add(new SignedIntParameter("priority", new Integer(n)));
        arrayList.add(new SignedIntParameter("antiReplayProtection", new Integer(bl ? 1 : 0)));
        IpSecTunnelMoImpl.packStructArrayIntoFroParameters(structArray2, arrayList, "tsLocalIpAddressRanges", "tsIpAddressRangesEntry", TS_IP_ADDRESS_RANGES_ELEMENT_NAMES);
        ArrayParameter arrayParameter = new ArrayParameter("tsProtocols");
        for (int i = 0; i < nArray.length; ++i) {
            arrayParameter.add((Parameter)new SignedIntParameter("protocol", new Integer(nArray[i])));
        }
        arrayList.add(arrayParameter);
        IpSecTunnelMoImpl.packStructArrayIntoFroParameters(structArray3, arrayList, "tsRemoteIpAddressRanges", "tsIpAddressRangesEntry", TS_IP_ADDRESS_RANGES_ELEMENT_NAMES);
        IpAccessHostEtMo ipAccessHostEtMo = (IpAccessHostEtMo)((VpnInterface)managedObject4).getIpAccessHostEtRef(coordinator);
        ManagedObject managedObject5 = ipAccessHostEtMo.getIpInterfaceMoRef(coordinator);
        if (!(managedObject5 instanceof IpInterfaceMo)) {
            throw new MoCanNotBeCreatedException("IpSecTunnel");
        }
        ManagedObject managedObject6 = managedObject5.getParent().getParent().getParent();
        arrayList.add(new SignedIntParameter("piuRef", new Integer(((PlugInUnitMo)managedObject6).getResourceId(coordinator))));
        arrayList.add(new SignedIntParameter("ipInterfaceRef", new Integer(((IpInterfaceMo)managedObject5).getFroId(coordinator))));
        arrayList.add(new SignedIntParameter("outerHostRef", new Integer(ipAccessHostEtMo.getFroId(coordinator))));
        IpSecTunnelMoImpl.packFroIdForGivenMoRef(arrayList, "ipSecRef", managedObject, coordinator);
        IpSecTunnelMoImpl.packFroIdForGivenMoRef(arrayList, "vpnInterfaceRef", managedObject4, coordinator);
        arrayList.add(new StringParameter("IpSecTunnelId", managedObject.getFullDistinguishedName() + "," + "IpSecTunnel" + "=" + string));
        int n2 = ((VpnInterfaceMoImpl)managedObject4).getConfigurationMode(coordinator);
        arrayList.add(new SignedIntParameter("configurationMethod", new Integer(n2)));
        int n3 = ((VpnInterfaceMo)managedObject4).getIpVersion(coordinator);
        arrayList.add(new SignedIntParameter("ipVersion", new Integer(n3)));
        int n4 = ((VpnInterfaceMo)managedObject4).getAutoDetectIpVersion(coordinator);
        arrayList.add(new SignedIntParameter("autoDetectIpVersion", new Integer(n4)));
        return new IpSecTunnelMoImpl(managedObject, string, string2, managedObject3, managedObject4, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    private static void validateTsRanges(ManagedObject managedObject, Struct[] structArray, Struct[] structArray2, Coordinator coordinator) throws MoAccessException {
        int n = ((VpnInterfaceMo)managedObject).getAutoDetectIpVersion(coordinator);
        if (n == 0) {
            int n2 = ((VpnInterfaceMo)managedObject).getIpVersion(coordinator);
            IpSecTunnelMoImpl.validateIpVersionForTsRanges(structArray, n2);
            IpSecTunnelMoImpl.validateIpVersionForTsRanges(structArray2, n2);
        } else {
            IpSecTunnelMoImpl.validateIpAddressesForTsRanges(structArray);
            IpSecTunnelMoImpl.validateIpAddressesForTsRanges(structArray2);
        }
    }

    private static void validateIpAddressesForTsRanges(Struct[] structArray) throws MoAccessException {
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            String string = (String)struct.getValue("ipAddress");
            if (string.equals("")) continue;
            Ipv6Address.validate((String)string);
        }
    }

    private static void validateIpVersionForTsRanges(Struct[] structArray, int n) throws MoAccessException {
        boolean bl = false;
        for (int i = 0; i < structArray.length; ++i) {
            Struct struct = structArray[i];
            String string = (String)struct.getValue("ipAddress");
            if (string.equals("")) continue;
            if (n == 1) {
                if (!Ipv6Address.isValidIpv6Addres((String)string)) {
                    bl = true;
                }
            } else if (!Ipv6Address.isValidIpv4Address((String)string)) {
                bl = true;
            }
            if (!bl) continue;
            throw new IllegalAttributeValueException("The ipVersion of VpnInterface must match the ip version (ipv4/ipv6) for remote/local tsIpAddressRange and be a valid ip address", "IpSecTunnel");
        }
    }

    private static void packFroIdForGivenMoRef(ArrayList arrayList, String string, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = MoAttributeValidator.checkAndGetFroIdFromMoRefAttribute((String)string, (Object)managedObject, (String)"IpSecTunnel", (Coordinator)coordinator);
        arrayList.add(new SignedIntParameter(string, new Integer(n)));
    }

    private static void packStructArrayIntoFroParameters(Struct[] structArray, ArrayList arrayList, String string, String string2, String[] stringArray) throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter(string);
        for (int i = 0; i < structArray.length; ++i) {
            StructParameter structParameter = IpSecTunnelMoImpl.convertStructIntoStructParameter(structArray[i], stringArray, string, string2);
            arrayParameter.add((Parameter)structParameter);
        }
        arrayList.add(arrayParameter);
    }

    private static StructParameter convertStructIntoStructParameter(Struct struct, String[] stringArray, String string, String string2) throws IllegalParameterValueException, NoSuchAttributeException, NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, AttrMissingAtCreateException, MoAccessException {
        StructParameter structParameter = new StructParameter(string2);
        String[] stringArray2 = struct.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!string3.equals(stringArray2[j])) continue;
                structParameter.add(IpSecTunnelMoImpl.convertStructValueIntoParameter(stringArray2[j], struct.getValue(stringArray2[j]), string));
                bl = true;
                break;
            }
            if (bl) continue;
            throw new AttrMissingAtCreateException("" + string3, string);
        }
        return structParameter;
    }

    private static Parameter convertStructValueIntoParameter(String string, Object object, String string2) throws IllegalParameterValueException, NoSuchAttributeException, MoAccessException {
        int n = -1;
        if (string.equals("encryptionAlgorithm")) {
            n = (Integer)object;
            MoAttributeValidator.checkEnumAttribute((String)"encryptionAlgorithm", (int)n, (int[])EnumChildSaEncryptionAlgorithm.VALUES_ARRAY, (String)"IpSecTunnel");
            return new SignedIntParameter(string, (Integer)object);
        }
        if (string.equals("integrityAlgorithm")) {
            n = (Integer)object;
            MoAttributeValidator.checkEnumAttribute((String)"integrityAlgorithm", (int)n, (int[])EnumChildSaIntegrityAlgorithm.VALUES_ARRAY, (String)"IpSecTunnel");
            return new SignedIntParameter(string, (Integer)object);
        }
        if (string.equals("ipAddress")) {
            try {
                Ipv6Address.validate((String)((String)object));
            }
            catch (IpFormatException ipFormatException) {
                IpSecTunnelMoImpl.throwMeIllegalValueException(string, object);
            }
            return new StringParameter(string, (String)object, 39);
        }
        if (string.equals("mask")) {
            n = (Integer)object;
            return new SignedIntParameter(string, (Integer)object);
        }
        throw new NoSuchAttributeException(string2 + "." + string, "IpSecTunnel");
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            Attribute attribute;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("IpSecTunnelId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ikePeerRef")) {
                attribute = this.data.getAttribute("ikePeerRef");
                if (null != attribute) {
                    objectArray[i] = ((ReferenceAttribute)attribute).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vpnInterfaceRef")) {
                attribute = this.data.getAttribute("vpnInterfaceRef");
                if (null != attribute) {
                    objectArray[i] = ((ReferenceAttribute)attribute).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("allowedTransforms")) {
                map = this.getFroParameters(map, coordinator);
                objectArray[i] = this.extractStructsFromFroArrayParameters(map.get("allowedTransforms"), "allowedTransforms", ALLOWED_TRANSFORMATIONS_ELEMENT_NAMES);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("securityAssociations")) {
                map = this.getFroParameters(map, coordinator);
                objectArray[i] = this.extractStructsFromFroArrayParameters(map.get("securityAssociations"), "securityAssociations", SECURITY_ASSOCIATIONS_ELEMENT_NAMES);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("tsLocalIpAddressRanges")) {
                map = this.getFroParameters(map, coordinator);
                objectArray[i] = this.extractStructsFromFroArrayParameters(map.get("tsLocalIpAddressRanges"), "tsLocalIpAddressRanges", TS_IP_ADDRESS_RANGES_ELEMENT_NAMES);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("tsProtocols")) {
                map = this.getFroParameters(map, coordinator);
                objectArray[i] = this.extractArrayOfIntsFromFroArrayParameter(map.get("tsProtocols"), "tsProtocols", "protocol");
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("tsRemoteIpAddressRanges")) {
                map = this.getFroParameters(map, coordinator);
                objectArray[i] = this.extractStructsFromFroArrayParameters(map.get("tsRemoteIpAddressRanges"), "tsRemoteIpAddressRanges", TS_IP_ADDRESS_RANGES_ELEMENT_NAMES);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("priority")) {
                map = this.getFroParameters(map, coordinator);
                objectArray[i] = new Integer(((SignedIntParameter)map.get("priority")).getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("antiReplayProtection")) {
                map = this.getFroParameters(map, coordinator);
                objectArray[i] = this.getConvertAntiReplayProtection(((SignedIntParameter)map.get("antiReplayProtection")).getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDiscAReFail")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmInDiscAReFail", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDiscDec")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmInDiscDec", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDiscIntCh")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmInDiscIntCh", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDiscNoSa")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmInDiscNoSa", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInEspData")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmInEspData", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInPkt")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmInPkt", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutDiscNoSa")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmOutDiscNoSa", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutDiscSeqOw")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmOutDiscSeqOw", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutEspData")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmOutEspData", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutPkt")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmOutPkt", coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpSecTunnel");
        }
        return objectArray;
    }

    private Boolean getConvertAntiReplayProtection(int n) {
        if (n == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.setAttributes(new String[]{string}, new Object[]{object}, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            AttrListImpl attrListImpl;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpSecTunnelMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpSecTunnel");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpSecTunnel", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("allowedTransforms")) {
                attrListImpl = new AttrListImpl();
                attrListImpl.addElement("allowedTransforms", objectArray[i]);
                Struct[] structArray = MoAttributeValidator.checkAndGetArrayOfStructs((String)"allowedTransforms", (AttrList)attrListImpl, (boolean)true, (int)0, (int)10, (String)"IpSecTunnel");
                IpSecTunnelMoImpl.packStructArrayIntoFroParameters(structArray, arrayList, "allowedTransforms", "allowedTransformsEntry", ALLOWED_TRANSFORMATIONS_ELEMENT_NAMES);
                this.sendNotification("allowedTransforms", structArray, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("tsProtocols")) {
                attrListImpl = new AttrListImpl();
                attrListImpl.addElement("tsProtocols", objectArray[i]);
                int[] nArray = MoAttributeValidator.checkAndGetArrayOfPrimitiveIntegers((String)"tsProtocols", (AttrList)attrListImpl, (boolean)true, (int)1, (int)1, (int[])EnumProtocolType.VALUES_ARRAY, (String)"IpSecTunnel");
                ArrayParameter arrayParameter = new ArrayParameter("tsProtocols");
                for (int j = 0; j < nArray.length; ++j) {
                    arrayParameter.add((Parameter)new SignedIntParameter("protocol", new Integer(nArray[j])));
                }
                arrayList.add(arrayParameter);
                this.sendNotification("tsProtocols", nArray, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("tsLocalIpAddressRanges")) {
                attrListImpl = new AttrListImpl();
                attrListImpl.addElement("tsLocalIpAddressRanges", objectArray[i]);
                Struct[] structArray = MoAttributeValidator.checkAndGetArrayOfStructs((String)"tsLocalIpAddressRanges", (AttrList)attrListImpl, (boolean)true, (int)1, (int)2, (String)"IpSecTunnel");
                this.validateTsIpAddressRanges(structArray, coordinator);
                IpSecTunnelMoImpl.packStructArrayIntoFroParameters(structArray, arrayList, "tsLocalIpAddressRanges", "tsIpAddressRangesEntry", TS_IP_ADDRESS_RANGES_ELEMENT_NAMES);
                this.sendNotification("tsLocalIpAddressRanges", structArray, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("tsRemoteIpAddressRanges")) {
                attrListImpl = new AttrListImpl();
                attrListImpl.addElement("tsRemoteIpAddressRanges", objectArray[i]);
                Struct[] structArray = MoAttributeValidator.checkAndGetArrayOfStructs((String)"tsRemoteIpAddressRanges", (AttrList)attrListImpl, (boolean)true, (int)1, (int)25, (String)"IpSecTunnel");
                this.validateTsIpAddressRanges(structArray, coordinator);
                IpSecTunnelMoImpl.packStructArrayIntoFroParameters(structArray, arrayList, "tsRemoteIpAddressRanges", "tsIpAddressRangesEntry", TS_IP_ADDRESS_RANGES_ELEMENT_NAMES);
                this.sendNotification("tsRemoteIpAddressRanges", structArray, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("antiReplayProtection")) {
                attrListImpl = new AttrListImpl();
                attrListImpl.addElement("antiReplayProtection", objectArray[i]);
                boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"antiReplayProtection", (AttrList)attrListImpl, (boolean)false, (boolean)true, (String)"IpSecTunnel");
                arrayList.add(new SignedIntParameter("antiReplayProtection", bl ? 1 : 0));
                this.sendNotification("antiReplayProtection", new Boolean(bl), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpSecTunnel");
        }
        if (!arrayList.isEmpty()) {
            this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private void validateTsIpAddressRanges(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        int n = ((VpnInterfaceMo)this.getVpnInterfaceRef(coordinator)).getIpVersion(coordinator);
        IpSecTunnelMoImpl.validateIpVersionForTsRanges(structArray, n);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    private static void throwMeIllegalValueException(String string, Object object) throws IllegalParameterValueException {
        throw new IllegalParameterValueException("parameter " + string + " has illegal value=" + object);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public IpSecTunnelMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("ikePeerRef");
        moDataRecoveryHelper.assertAttribute("vpnInterfaceRef");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        this.releaseReference(coordinator, "ikePeerRef");
        this.releaseReference(coordinator, "vpnInterfaceRef");
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private int[] extractArrayOfIntsFromFroArrayParameter(Object object, String string, String string2) throws MoAccessException {
        int[] nArray = null;
        ArrayParameter arrayParameter = null;
        if (object instanceof ArrayParameter) {
            arrayParameter = (ArrayParameter)object;
            nArray = new int[arrayParameter.size()];
            for (int i = 0; i < arrayParameter.size(); ++i) {
                Parameter parameter = arrayParameter.get(i);
                if (!(parameter instanceof SignedIntParameter)) {
                    throw new FroRequestFailedException("arrayParameter contains wrong element type, expected SignedIntParameter but was " + parameter.getClass().getName(), "", "", -1);
                }
                SignedIntParameter signedIntParameter = (SignedIntParameter)parameter;
                if (!signedIntParameter.getName().equals(string2)) {
                    throw new FroRequestFailedException("arrayParameter contains wrong element name, expected " + string2 + " but was " + signedIntParameter.getName(), "", "", -1);
                }
                nArray[i] = signedIntParameter.getValue();
            }
        }
        return nArray;
    }

    private void releaseReference(Coordinator coordinator, String string) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        ManagedObject managedObject = (ManagedObject)objectArray[0];
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
    }

    private Struct[] extractStructsFromFroArrayParameters(Object object, String string, String[] stringArray) throws MoAccessException {
        ArrayParameter arrayParameter = null;
        if (!(object instanceof ArrayParameter)) {
            System.out.println("Value is missing for array parameter " + string);
            return null;
        }
        arrayParameter = (ArrayParameter)object;
        Struct[] structArray = new Struct[arrayParameter.size()];
        for (int i = 0; i < arrayParameter.size(); ++i) {
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            structArray[i] = this.extractStructFromFroStructParameter(structParameter, stringArray);
        }
        return structArray;
    }

    private Struct extractStructFromFroStructParameter(Object object, String[] stringArray) throws MoAccessException {
        StructParameter structParameter = null;
        if (!(object instanceof StructParameter)) {
            throw new FroRequestFailedException("Fro responded with wrong type for structEntry parameter", "", "", -1);
        }
        structParameter = (StructParameter)object;
        StructImpl structImpl = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            Struct[] structArray;
            Parameter parameter = structParameter.get(stringArray[i]);
            if (parameter == null) {
                // empty if block
            }
            if (parameter instanceof SignedIntParameter) {
                hashMap.put(stringArray[i], new Integer(((SignedIntParameter)parameter).getValue()));
                continue;
            }
            if (parameter instanceof StringParameter) {
                if (stringArray[i].equals("ipAddress") || stringArray[i].equals("maxIpAddress") || stringArray[i].equals("minIpAddress")) {
                    structArray = ((StringParameter)parameter).getValue().trim();
                    hashMap.put(stringArray[i], structArray);
                    continue;
                }
                hashMap.put(stringArray[i], ((StringParameter)parameter).getValue());
                continue;
            }
            if (!(parameter instanceof ArrayParameter)) continue;
            if (stringArray[i].equals("localTrafficSelectors") || stringArray[i].equals("remoteTrafficSelectors")) {
                structArray = this.extractStructsFromFroArrayParameters(parameter, stringArray[i], TRAFFIC_SELECTOR_ELEMENT_NAMES);
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < structArray.length; ++j) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append("Ip Address Range = ");
                    stringBuffer2.append(((StructImpl)structArray[j]).getValue("minIpAddress") + " - ");
                    stringBuffer2.append(((StructImpl)structArray[j]).getValue("maxIpAddress") + ", Protocol = ");
                    stringBuffer2.append(((StructImpl)structArray[j]).getValue("protocol") + ", Port Range = ");
                    stringBuffer2.append(((StructImpl)structArray[j]).getValue("minPortNumber") + " - ");
                    stringBuffer2.append(((StructImpl)structArray[j]).getValue("maxPortNumber") + "\n");
                    stringBuffer.append(stringBuffer2);
                }
                hashMap.put(stringArray[i], stringBuffer.toString());
                continue;
            }
            hashMap.put(stringArray[i], parameter.getValueAsString());
            UpgradeTrace.info((Class)(class$se$ericsson$cello$ipsec$IpSecTunnelMoImpl == null ? IpSecTunnelMoImpl.class$("se.ericsson.cello.ipsec.IpSecTunnelMoImpl") : class$se$ericsson$cello$ipsec$IpSecTunnelMoImpl), (String)"extractStructFromFroStructParameter: something is wrong", (String)("unrecognized array parameter " + stringArray[i]));
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = hashMap.get(stringArray[i]);
        }
        structImpl = new StructImpl(stringArray, objectArray);
        return structImpl;
    }

    private IpSecTunnelMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ManagedObject managedObject3, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "IpSecTunnel", string, coordinator);
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ikePeerRef", true, managedObject2));
        if (null != managedObject2) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("vpnInterfaceRef", true, managedObject3));
        if (null != managedObject3) {
            ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
        }
        ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute("reservedBy", coordinator);
        ManagedObject managedObject4 = null;
        ManagedObject managedObject5 = null;
        ManagedObject managedObject6 = null;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            managedObject6 = (ManagedObject)managedObjectArray[i].getAttribute("vpnInterfaceRef", coordinator);
            if (i == 0) {
                managedObject4 = (ManagedObject)managedObject6.getAttribute("ipAccessHostEtRef", coordinator);
                continue;
            }
            managedObject5 = (ManagedObject)managedObject6.getAttribute("ipAccessHostEtRef", coordinator);
            if (managedObject4.equals(managedObject5)) continue;
            throw new IllegalAttributeValueException("All IpSecTunnel MOs referring to the same IkePeer MO must refer to VpnInterface MOs that refer to the same IpAccessHostEt MO", "IpSecTunnel");
        }
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.setRevision(8000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private Map getFroParameters(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    public Struct[] getAllowedTransforms(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("allowedTransforms", coordinator);
    }

    public ManagedObject getIkePeerRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ikePeerRef", coordinator);
    }

    public Struct[] getSecurityAssociations(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("securityAssociations", coordinator);
    }

    public Struct[] getTsLocalIpAddressRanges(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("tsLocalIpAddressRanges", coordinator);
    }

    public int[] getTsProtocols(Coordinator coordinator) throws MoAccessException {
        return (int[])this.getAttribute("tsProtocols", coordinator);
    }

    public Struct[] getTsRemoteIpAddressRanges(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("tsRemoteIpAddressRanges", coordinator);
    }

    public ManagedObject getVpnInterfaceRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("vpnInterfaceRef", coordinator);
    }

    public int getPriority(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("priority", coordinator);
    }

    public void setAllowedTransforms(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("allowedTransforms", structArray, coordinator);
    }

    public void setTsLocalIpAddressRanges(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("tsLocalIpAddressRanges", structArray, coordinator);
    }

    public void setTsProtocols(int[] nArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("tsProtocols", nArray, coordinator);
    }

    public void setTsRemoteIpAddressRanges(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("tsRemoteIpAddressRanges", structArray, coordinator);
    }

    public int getPmInDiscAReFail(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInDiscAReFail", coordinator);
    }

    public int getPmInDiscDec(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInDiscDec", coordinator);
    }

    public int getPmInDiscIntCh(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInDiscIntCh", coordinator);
    }

    public int getPmInDiscNoSa(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInDiscNoSa", coordinator);
    }

    public int getPmInEspData(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInEspData", coordinator);
    }

    public int getPmInPkt(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInPkt", coordinator);
    }

    public int getPmOutEspData(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutEspData", coordinator);
    }

    public int getPmOutDiscNoSa(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutDiscNoSa", coordinator);
    }

    public int getPmOutPkt(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutPkt", coordinator);
    }

    public int getPmOutDiscSeqOw(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutDiscSeqOw", coordinator);
    }

    public boolean getAntiReplayProtection(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("antiReplayProtection", coordinator);
    }

    public void setAntiReplayProtection(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("antiReplayProtection", new Boolean(bl), coordinator);
    }
}

