/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ipsec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.IpHostLinkIpInterfaceBuildIF;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.ipsec.IpSecTunnelMo;
import se.ericsson.cello.ipsec.VpnInterfaceMo;
import se.ericsson.cello.ipsec.mom.EnumConfMode;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.NetworkAddress;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrNotSettableException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumIpVersion;
import se.ericsson.cello.transaction.Coordinator;

public class VpnInterfaceMoImpl
extends CelloMao
implements VpnInterfaceMo,
VpnInterfaceBuildIF,
Reservable,
IpHostLinkIpInterfaceBuildIF {
    private MoData data;
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    private static final int MAX_NUMBER_VPNINTERFACE = 2;
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"VpnInterface", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkCardinality((String)"VpnInterface", (int)2);
        Class[] classArray = new Class[]{IpAccessHostEtMo.class};
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipAccessHostEtRef", (AttrList)attrList, (boolean)true, (Class[])classArray, (String)"VpnInterface");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"VpnInterface", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"networkPrefixLength", (AttrList)attrList, (boolean)false, (int)32, (int)1, (int)32, (String)"VpnInterface");
        String string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"subnet", (AttrList)attrList, (boolean)false, (String)"", (String)"VpnInterface");
        if (!string3.equals("")) {
            new IpAddress(string3);
        }
        int n2 = MoAttributeValidator.checkAndGetEnumAttribute((String)"configurationMode", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumConfMode.VALUES_ARRAY, (String)"VpnInterface");
        int n3 = MoAttributeValidator.checkAndGetEnumAttribute((String)"ipVersion", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumIpVersion.VALUES_ARRAY, (String)"VpnInterface");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"VpnInterface");
        int n4 = ((IpAccessHostEtMo)managedObject3).getFroId(coordinator);
        ManagedObject managedObject4 = ((IpAccessHostEtMo)managedObject3).getIpInterfaceMoRef(coordinator);
        ManagedObject managedObject5 = null;
        if (!(managedObject4 instanceof IpInterfaceMo)) {
            throw new InvalidReferenceException("VpnInterface", (Object)"The referenced instance of IpAccessHostEt MO must refer to IpInterface MO");
        }
        managedObject5 = managedObject4;
        int n5 = ((IpInterfaceMo)managedObject4).getFroId(coordinator);
        int n6 = 0;
        n6 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject5);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new StringParameter("subnet", string3));
        arrayList.add(new SignedIntParameter("networkPrefixLength", n));
        arrayList.add(new SignedIntParameter("configurationMode", n2));
        arrayList.add(new SignedIntParameter("ipVersion", n3));
        arrayList.add(new SignedIntParameter("autoDetectIpVersion", 0));
        arrayList.add(new UnsignedIntParameter("ipAccessHostEtRef", (long)n4));
        arrayList.add(new UnsignedIntParameter("ipInterfaceFroId", (long)n5));
        arrayList.add(new UnsignedIntParameter("piuFroId", (long)n6));
        return new VpnInterfaceMoImpl(managedObject, string, string2, managedObject3, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    private VpnInterfaceMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "VpnInterface", string, coordinator);
        arrayList.add(new StringParameter("vpnInterfaceMoRdn", this.getRelativeDistinguishedName()));
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ipAccessHostEtRef", false, managedObject2));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.setRevision(8000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public VpnInterfaceMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("ipAccessHostEtRef");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        String[] stringArray = new String[]{"ipAccessHostEtRef"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        ManagedObject managedObject = (ManagedObject)objectArray[0];
        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = null;
        map = this.getFroParameters(map, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef")) {
                signedIntParameter = this.data.getAttribute("ipAccessHostEtRef");
                arrayList.add(((ReferenceAttribute)signedIntParameter).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("networkPrefixLength")) {
                signedIntParameter = (SignedIntParameter)map.get("networkPrefixLength");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("subnet")) {
                signedIntParameter = (StringParameter)map.get("subnet");
                arrayList.add(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                arrayList.add(((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("VpnInterfaceId")) {
                arrayList.add(super.getNamingAttributeValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                arrayList.add(ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("configurationMode")) {
                signedIntParameter = (SignedIntParameter)map.get("configurationMode");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipVersion")) {
                signedIntParameter = (SignedIntParameter)map.get("ipVersion");
                arrayList.add(new Integer(signedIntParameter.getValue()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmOutDroppedPacketsPolicyControl")) {
                arrayList.add(new Integer(super.getPmAttribute("pmOutDroppedPacketsPolicyControl", coordinator)));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "VpnInterface");
        }
        return arrayList.toArray();
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.setAttributes(new String[]{string}, new Object[]{object}, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        ArrayList arrayList = new ArrayList();
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? VpnInterfaceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "VpnInterface");
                }
            } else {
                if (stringArray[i].equalsIgnoreCase("subnet")) {
                    throw new AttrNotSettableException("VpnInterface", "subnet attribute is deprecated and has no functional behavior");
                }
                if (stringArray[i].equalsIgnoreCase("networkPrefixLength")) {
                    throw new AttrNotSettableException("VpnInterface", "networkPrefixLength attribute is deprecated and has no functional behavior");
                }
                throw new NoSuchAttributeException(stringArray[i], "VpnInterface");
            }
            MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"VpnInterface", (int)128, (int)0);
            ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
        }
        if (!arrayList.isEmpty()) {
            this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private int validateAutoDetectIpVersion(int n) throws WrongAttributeTypeException, MoAccessException {
        MoAttributeValidator.checkEnumAttribute((String)"autoDetectIpVersion", (int)n, (int[])AUTO_DETECT_IP_VERSION_VALUES, (String)"VpnInterface");
        return n;
    }

    public void helpAssignVpnAddress(int n, IpAddress ipAddress, Coordinator coordinator) throws MoAccessException {
        if (n < 1 || n > 32) {
            throw new ValueOutOfRangeException("networkPrefixLength", "VpnInterface");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("networkPrefixLength", new SignedIntParameter("networkPrefixLength", n));
        hashMap.put("subnet", new StringParameter("subnet", ipAddress.getSubnetAddress(n).toString()));
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashMap.values());
        this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getSubnet(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("subnet", coordinator);
    }

    public int getNetworkPrefixLength(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("networkPrefixLength", coordinator);
    }

    public int getPmOutDroppedPacketsPolicyControl(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmOutDroppedPacketsPolicyControl", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    public ManagedObject getIpAccessHostEtRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessHostEtRef", coordinator);
    }

    public int getConfigurationMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("configurationMode", coordinator);
    }

    public int getIpVersion(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ipVersion", coordinator);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        ManagedObject[] managedObjectArray;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("VpnInterface", (Object)"Cannot be reserved by 'null' reference");
        }
        if (this.getConfigurationMode(coordinator) == 1) {
            int n2;
            managedObjectArray = this.getReservedBy(coordinator);
            n = managedObjectArray.length;
            if (managedObject.getType().equalsIgnoreCase("IpAccessHostEt")) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (!managedObjectArray[n2].getType().equalsIgnoreCase("IpHostLink")) continue;
                    throw new MoNotPossibleToReserveException("This MO already reserved by IpHostLink MO.", "VpnInterface");
                }
            } else if (managedObject.getType().equalsIgnoreCase("IpHostLink")) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (managedObjectArray[n2].getType().equalsIgnoreCase("IpAccessHostEt")) {
                        throw new MoNotPossibleToReserveException("This MO already reserved by IpAccessHostEt MO.", "VpnInterface");
                    }
                    if (!managedObjectArray[n2].getType().equalsIgnoreCase("IpHostLink")) continue;
                    throw new MoNotPossibleToReserveException("This MO already reserved by another IpHostLink MO.", "VpnInterface");
                }
            }
        }
        managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
        for (n = 0; n < managedObjectArray.length; ++n) {
            if (managedObject instanceof IpHostLinkMo && managedObjectArray[n] instanceof IpHostLinkMo) {
                throw new MoNotPossibleToReserveException("Only one IpHostLink instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
            }
            if (managedObject instanceof IpAccessHostEtMo && managedObjectArray[n] instanceof IpAccessHostEtMo) {
                throw new MoNotPossibleToReserveException("Only one IpAccessHostEt instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
            }
            if (this.getConfigurationMode(coordinator) != 1 || !(managedObject instanceof IpSecTunnelMo) || !(managedObjectArray[n] instanceof IpSecTunnelMo)) continue;
            throw new MoNotPossibleToReserveException("Only one IpSecTunnelMo instance is allowed to reserve VpnInterface, Already reserved by: " + managedObjectArray[n], "VpnInterface");
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    private Map getFroParameters(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    public NetworkAddress getNetworkAddress(Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{"subnet", "networkPrefixLength"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return new NetworkAddress((String)objectArray[0], ((Integer)objectArray[1]).intValue());
    }

    public void checkIfIpAddressInSubnet(IpAddress ipAddress, Coordinator coordinator) throws MoAccessException {
        NetworkAddress networkAddress = this.getNetworkAddress(coordinator);
        ipAddress.validateIpAddrWithinSubnet(networkAddress.getNetworkPrefix(), new IpAddress(networkAddress.getSubnet()), "VpnInterface");
    }

    public int getConnectedPiuFroId(Coordinator coordinator) throws MoAccessException {
        return PiuUtils.findPiuParentFroId((ManagedObject)((IpAccessHostEtMo)this.getIpAccessHostEtRef(coordinator)).getIpInterfaceMoRef(coordinator));
    }

    public int getFroType(Coordinator coordinator) throws MoAccessException {
        return Integer.parseInt("A0B", 16);
    }

    public void setNetworkPrefixLength(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("networkPrefixLength", new Integer(n), coordinator);
    }

    public void setSubnet(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("subnet", string, coordinator);
    }

    public int getAutoDetectIpVersion(Coordinator coordinator) throws MoAccessException {
        SignedIntParameter signedIntParameter = (SignedIntParameter)this.genericProxyInstance.getAttribute(coordinator, this.getFroId(coordinator), "autoDetectIpVersion");
        return signedIntParameter.getValue();
    }

    public void setAutoDetectIpVersion(int n, Coordinator coordinator) throws MoAccessException {
        int n2 = this.validateAutoDetectIpVersion(n);
        SignedIntParameter signedIntParameter = new SignedIntParameter("autoDetectIpVersion", n2);
        this.genericProxyInstance.setAttribute(coordinator, this.getFroId(coordinator), (Parameter)signedIntParameter);
    }
}

