/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.AccessControlListMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedByOtherUserException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.IllegalParameterValueException;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class AccessControlListMoImpl
extends CelloMao
implements AccessControlListMo,
Reservable {
    private MoData data;
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    static final String[] _ELEMENT_NAMES = new String[]{"aclAction", "icmpType", "localIpAddress", "localIpAddressMask", "localPort", "localPortFiltering", "protocol", "remoteIpAddress", "remoteIpAddressMask", "remotePort", "remotePortFiltering"};
    private static final int MO_DATA_REVISION_8 = 8000;
    private static final int MO_DATA_REVISION_LATEST = 8000;
    private static final int IPV4_ADDRESS_MASK_RANGE = 32;
    private static final int IPV6_ADDRESS_MASK_RANGE = 128;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"AccessControlList", (String)string);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"bypassNdpAndMld", (AttrList)attrList, (boolean)false, (boolean)true, (String)"AccessControlList");
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"AccessControlList", (int)128, (int)0);
        Struct[] structArray = MoAttributeValidator.checkAndGetArrayOfStructs((String)"aclEntries", (AttrList)attrList, (boolean)false, (int)0, (int)20, (String)"AccessControlList");
        AccessControlListMoImpl.validateAclEntries(structArray);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"AccessControlList");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        AccessControlListMoImpl.packAclStructArrayIntoFroParameters(structArray, arrayList);
        arrayList.add(new SignedIntParameter("bypassNdpAndMld", bl));
        return new AccessControlListMoImpl(managedObject, string, string2, arrayList, coordinator, froProxy, maoFroIndicationHandler, initialMaoContext);
    }

    private static void validateAclEntries(Struct[] structArray) throws MoAccessException {
        for (int i = 0; i < structArray.length; ++i) {
            int n = (Integer)structArray[i].getValue("localIpAddressMask");
            int n2 = (Integer)structArray[i].getValue("remoteIpAddressMask");
            if (Ipv6Address.isIpv4((String)((String)structArray[i].getValue("localIpAddress"))) && Ipv6Address.isIpv4((String)((String)structArray[i].getValue("remoteIpAddress")))) {
                AccessControlListMoImpl.checkIpv4MaskRange(n, n2);
                if (i <= 0 || !Ipv6Address.isIpv6((String)((String)structArray[i - 1].getValue("localIpAddress"))) && !Ipv6Address.isIpv6((String)((String)structArray[i - 1].getValue("remoteIpAddress")))) continue;
                throw new IllegalAttributeValueException("IpVersion of the addresses in AclEntries should be same", "AccessControlList");
            }
            if (Ipv6Address.isIpv6((String)((String)structArray[i].getValue("localIpAddress"))) && Ipv6Address.isIpv6((String)((String)structArray[i].getValue("remoteIpAddress")))) {
                AccessControlListMoImpl.checkIpv6MaskRange(n, n2);
                if (i <= 0 || !Ipv6Address.isIpv4((String)((String)structArray[i - 1].getValue("localIpAddress"))) && !Ipv6Address.isIpv4((String)((String)structArray[i - 1].getValue("remoteIpAddress")))) continue;
                throw new IllegalAttributeValueException("IpVersion of the addresses in AclEntries should be same", "AccessControlList");
            }
            throw new IllegalAttributeValueException("IpVersion of the addresses in AclEntries should be same", "AccessControlList");
        }
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map map = null;
        map = this.getFroParameters(map, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("aclEntries")) {
                arrayList.add(this.extractStructsFromFroArrayParameters(map.get("aclEntries")));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("bypassNdpAndMld")) {
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("bypassNdpAndMld");
                if (signedIntParameter == null) {
                    throw new FroRequestFailedException("AccessControlList", "Missing parameter from FRO: ByPassNDPandMLD", "getAttributes", -1);
                }
                arrayList.add(new Boolean(signedIntParameter.getBoolean()));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                arrayList.add(((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("AccessControlListId")) {
                arrayList.add(super.getNamingAttributeValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                arrayList.add(ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "AccessControlList");
        }
        return arrayList.toArray();
    }

    private Struct[] extractStructsFromFroArrayParameters(Object object) throws MoAccessException {
        ArrayParameter arrayParameter = null;
        if (!(object instanceof ArrayParameter)) {
            throw new FroRequestFailedException("Fro responded with wrong type for aclEntry parameter", "", "", -1);
        }
        arrayParameter = (ArrayParameter)object;
        Struct[] structArray = new Struct[arrayParameter.size()];
        for (int i = 0; i < arrayParameter.size(); ++i) {
            Parameter parameter;
            StructParameter structParameter = (StructParameter)arrayParameter.get(i);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int j = 0; j < _ELEMENT_NAMES.length; ++j) {
                parameter = structParameter.get(_ELEMENT_NAMES[j]);
                if (parameter == null) {
                    // empty if block
                }
                if (parameter instanceof SignedIntParameter) {
                    if (_ELEMENT_NAMES[j].equals("localPortFiltering") || _ELEMENT_NAMES[j].equals("remotePortFiltering")) {
                        int n = ((SignedIntParameter)parameter).getValue();
                        if (n == 0) {
                            hashMap.put(_ELEMENT_NAMES[j], Boolean.FALSE);
                            continue;
                        }
                        hashMap.put(_ELEMENT_NAMES[j], Boolean.TRUE);
                        continue;
                    }
                    hashMap.put(_ELEMENT_NAMES[j], new Integer(((SignedIntParameter)parameter).getValue()));
                    continue;
                }
                if (!(parameter instanceof StringParameter)) continue;
                if (_ELEMENT_NAMES[j].equals("localIpAddress") || _ELEMENT_NAMES[j].equals("remoteIpAddress")) {
                    String string = ((StringParameter)parameter).getValue().trim();
                    hashMap.put(_ELEMENT_NAMES[j], string);
                    continue;
                }
                hashMap.put(_ELEMENT_NAMES[j], ((StringParameter)parameter).getValue());
            }
            Object[] objectArray = new Object[_ELEMENT_NAMES.length];
            for (int j = 0; j < _ELEMENT_NAMES.length; ++j) {
                objectArray[j] = hashMap.get(_ELEMENT_NAMES[j]);
            }
            parameter = new StructImpl(_ELEMENT_NAMES, objectArray);
            structArray[i] = parameter;
        }
        return structArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.setAttributes(new String[]{string}, new Object[]{object}, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? AccessControlListMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "AccessControlList");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"AccessControlList", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("bypassNdpAndMld")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Boolean == null ? AccessControlListMoImpl.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    throw new WrongAttributeTypeException("bypassNdpAndMld", "AccessControlList");
                }
                boolean bl = (Boolean)objectArray[i];
                arrayList.add(new SignedIntParameter("bypassNdpAndMld", bl));
                this.sendNotification("bypassNdpAndMld", new Boolean(bl), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aclEntries")) {
                AttrListImpl attrListImpl = new AttrListImpl();
                Struct[] structArray = this.getAclEntries(coordinator);
                attrListImpl.addElement("aclEntries", objectArray[i]);
                Struct[] structArray2 = MoAttributeValidator.checkAndGetArrayOfStructs((String)"aclEntries", (AttrList)attrListImpl, (boolean)true, (int)0, (int)20, (String)"AccessControlList");
                if (structArray2.length != 0) {
                    int n;
                    if (structArray.length > 0) {
                        n = Ipv6Address.isIpv4((String)((String)structArray[0].getValue("localIpAddress")));
                        boolean bl = Ipv6Address.isIpv4((String)((String)structArray2[0].getValue("localIpAddress")));
                        if (!(n != 0 && bl || n == 0 && !bl)) {
                            throw new IllegalAttributeValueException("Ip version must be compatible with the previous acl entries", this.getType());
                        }
                    }
                    AccessControlListMoImpl.validateAclEntries(structArray2);
                    for (n = 0; n < structArray2.length; ++n) {
                        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
                        if (managedObjectArray.length == 0) continue;
                        String string = (String)structArray2[n].getValue("localIpAddress");
                        if (managedObjectArray[0] instanceof IpInterfaceMo && !Ipv6Address.isIpv4((String)string)) {
                            throw new IllegalAttributeValueException("Ip version must be compatible with the referencing MO ", this.getType());
                        }
                        if (!(managedObjectArray[0] instanceof Ipv6InterfaceMo) || Ipv6Address.isIpv6((String)string)) continue;
                        throw new IllegalAttributeValueException("Ip version must be compatible with the referencing MO ", this.getType());
                    }
                }
                AccessControlListMoImpl.packAclStructArrayIntoFroParameters(structArray2, arrayList);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "AccessControlList");
        }
        if (!arrayList.isEmpty()) {
            this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private static void packAclStructArrayIntoFroParameters(Struct[] structArray, ArrayList arrayList) throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter("aclEntries");
        for (int i = 0; i < structArray.length; ++i) {
            StructParameter structParameter = AccessControlListMoImpl.convertStructIntoStructParameter(structArray[i], _ELEMENT_NAMES);
            arrayParameter.add((Parameter)structParameter);
        }
        arrayList.add(arrayParameter);
    }

    private static StructParameter convertStructIntoStructParameter(Struct struct, String[] stringArray) throws IllegalParameterValueException, NoSuchAttributeException, NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, AttrMissingAtCreateException {
        StructParameter structParameter = new StructParameter("aclEntry");
        String[] stringArray2 = struct.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!string.equals(stringArray2[j])) continue;
                structParameter.add(AccessControlListMoImpl.convertAclEntryStructValueIntoParameter(stringArray2[j], struct.getValue(stringArray2[j])));
                bl = true;
                break;
            }
            if (bl) continue;
            throw new AttrMissingAtCreateException("" + string, "aclEntries");
        }
        return structParameter;
    }

    public static String padMyIpAddressUpTo39CharLengthPlusTermination(String string) {
        int n;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        n2 = string.length();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(string.charAt(n));
        }
        for (n = n2; n < 39; ++n) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    private static Parameter convertAclEntryStructValueIntoParameter(String string, Object object) throws IllegalParameterValueException, NoSuchAttributeException {
        int n = -1;
        if (string.equals("aclAction")) {
            n = (Integer)object;
            if (n != 0 && n != 1) {
                AccessControlListMoImpl.throwMeIllegalValueException(string, object);
            }
            return new SignedIntParameter(string, (Integer)object);
        }
        if (string.equals("localIpAddress")) {
            try {
                Ipv6Address.validate((String)((String)object));
            }
            catch (IpFormatException ipFormatException) {
                AccessControlListMoImpl.throwMeIllegalValueException(string, object);
            }
            return new StringParameter(string, AccessControlListMoImpl.padMyIpAddressUpTo39CharLengthPlusTermination((String)object));
        }
        if (string.equals("localIpAddressMask")) {
            n = (Integer)object;
            return new SignedIntParameter(string, (Integer)object);
        }
        if (string.equals("localPort")) {
            n = (Integer)object;
            if (n < 0 || n > 65535) {
                AccessControlListMoImpl.throwMeIllegalValueException(string, object);
            }
            return new SignedIntParameter(string, (Integer)object);
        }
        if (string.equals("localPortFiltering")) {
            if (((Boolean)object).booleanValue()) {
                return new SignedIntParameter(string, new Integer(1));
            }
            return new SignedIntParameter(string, new Integer(0));
        }
        if (string.equals("protocol")) {
            n = (Integer)object;
            if (n != 0 && n != 1 && n != 6 && n != 17 && n != 132 && n != 255) {
                AccessControlListMoImpl.throwMeIllegalValueException(string, object);
            }
            return new SignedIntParameter(string, (Integer)object);
        }
        if (string.equals("remoteIpAddress")) {
            try {
                Ipv6Address.validate((String)((String)object));
            }
            catch (IpFormatException ipFormatException) {
                AccessControlListMoImpl.throwMeIllegalValueException(string, object);
            }
            return new StringParameter(string, AccessControlListMoImpl.padMyIpAddressUpTo39CharLengthPlusTermination((String)object));
        }
        if (string.equals("remoteIpAddressMask")) {
            n = (Integer)object;
            return new SignedIntParameter(string, (Integer)object);
        }
        if (string.equals("remotePort")) {
            n = (Integer)object;
            if (n < 0 || n > 65535) {
                AccessControlListMoImpl.throwMeIllegalValueException(string, object);
            }
            return new SignedIntParameter(string, (Integer)object);
        }
        if (string.equals("remotePortFiltering")) {
            if (((Boolean)object).booleanValue()) {
                return new SignedIntParameter(string, new Integer(1));
            }
            return new SignedIntParameter(string, new Integer(0));
        }
        if (string.equals("icmpType")) {
            n = (Integer)object;
            if (n < 0 || n > 256) {
                AccessControlListMoImpl.throwMeIllegalValueException(string, object);
            }
            return new SignedIntParameter(string, (Integer)object);
        }
        throw new NoSuchAttributeException("aclEntry." + string, "AccessControlList");
    }

    private static void throwMeIllegalValueException(String string, Object object) throws IllegalParameterValueException {
        throw new IllegalParameterValueException("parameter " + string + " has illegal value=" + object);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public void actionRemoveEntry(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"aclIndex", (int)n, (int)0, (int)19, (String)"AccessControlList");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("aclIndex", n));
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 102, arrayList);
    }

    private static void checkIpv4MaskRange(int n, int n2) throws MoAccessException {
        if (n > 32 || n < 0) {
            throw new ValueOutOfRangeException("localIpAddressMask", "AccessControlList", "The range is 0 through 32 for IPv4 addresses");
        }
        if (n2 > 32 || n2 < 0) {
            throw new ValueOutOfRangeException("remoteIpAddressMask", "AccessControlList", "The range is 0 through 32 for IPv4 addresses");
        }
    }

    private static void checkIpv6MaskRange(int n, int n2) throws MoAccessException {
        if (n > 128 || n < 0) {
            throw new ValueOutOfRangeException("localIpAddressMask", "AccessControlList", "The range is 0 through 128 for IPv6 addresses");
        }
        if (n2 > 128 || n2 < 0) {
            throw new ValueOutOfRangeException("remoteIpAddressMask", "AccessControlList", "The range is 0 through 128 for IPv6 addresses");
        }
    }

    public void actionAddEntry(Struct struct, int n, Coordinator coordinator) throws MoAccessException {
        Object object;
        ManagedObject[] managedObjectArray;
        MoAttributeValidator.checkIntegerAttribute((String)"aclIndex", (int)n, (int)0, (int)19, (String)"AccessControlList");
        String string = (String)struct.getValue("localIpAddress");
        String string2 = (String)struct.getValue("remoteIpAddress");
        int n2 = (Integer)struct.getValue("localIpAddressMask");
        int n3 = (Integer)struct.getValue("remoteIpAddressMask");
        if (Ipv6Address.isIpv4((String)string) && Ipv6Address.isIpv4((String)string2)) {
            AccessControlListMoImpl.checkIpv4MaskRange(n2, n3);
        } else if (Ipv6Address.isIpv6((String)string) && Ipv6Address.isIpv6((String)string2)) {
            AccessControlListMoImpl.checkIpv6MaskRange(n2, n3);
        } else {
            throw new IllegalAttributeValueException("localIpAddress and remoteIpAddress should be of same Ip version ", this.getType());
        }
        Struct[] structArray = this.getAclEntries(coordinator);
        if (structArray.length == 0) {
            managedObjectArray = this.getReservedBy(coordinator);
            if (managedObjectArray.length != 0 && (managedObjectArray[0] instanceof IpInterfaceMo ? !Ipv6Address.isIpv4((String)string) : managedObjectArray[0] instanceof Ipv6InterfaceMo && !Ipv6Address.isIpv6((String)string))) {
                throw new IllegalAttributeValueException("Ip version must be compatible with the referencing MO ", this.getType());
            }
        } else {
            managedObjectArray = (String)structArray[0].getValue("localIpAddress");
            object = (String)structArray[0].getValue("remoteIpAddress");
            if (Ipv6Address.isIpv4((String)string) && Ipv6Address.isIpv4((String)managedObjectArray) && Ipv6Address.isIpv4((String)string2) && Ipv6Address.isIpv4((String)object)) {
                AccessControlListMoImpl.checkIpv4MaskRange(n2, n3);
            } else if (Ipv6Address.isIpv6((String)string) && Ipv6Address.isIpv6((String)managedObjectArray) && Ipv6Address.isIpv6((String)string2) && Ipv6Address.isIpv6((String)object)) {
                AccessControlListMoImpl.checkIpv6MaskRange(n2, n3);
            } else {
                throw new IllegalAttributeValueException("In ACL entry , the address must be of the same IP version as the existing ACL entries ", this.getType());
            }
        }
        managedObjectArray = AccessControlListMoImpl.convertStructIntoStructParameter(struct, _ELEMENT_NAMES);
        object = new ArrayList();
        ((ArrayList)object).add(managedObjectArray);
        ((ArrayList)object).add(new SignedIntParameter("aclIndex", n));
        this.genericProxyInstance.actionWithCfm(coordinator, this.getFroId(coordinator), 101, (Collection)object);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        if (managedObject instanceof IpInterfaceMo) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!(managedObjectArray[i] instanceof Ipv6InterfaceMo)) continue;
                throw new MoReservedByOtherUserException("Ipv6Interface", "AccessControlList", "IpInterface");
            }
        } else if (managedObject instanceof Ipv6InterfaceMo) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!(managedObjectArray[i] instanceof IpInterfaceMo)) continue;
                throw new MoReservedByOtherUserException("IpInterface", "AccessControlList", "Ipv6Interface");
            }
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public Struct[] getAclEntries(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("aclEntries", coordinator);
    }

    public void setAclEntries(Struct[] structArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aclEntries", structArray, coordinator);
    }

    public boolean getBypassNdpAndMld(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("bypassNdpAndMld", coordinator);
    }

    public void setBypassNdpAndMld(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("bypassNdpAndMld", new Boolean(bl), coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public AccessControlListMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(8000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private AccessControlListMoImpl(ManagedObject managedObject, String string, String string2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, "AccessControlList", string, coordinator, initialMaoContext);
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.setRevision(8000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private Map getFroParameters(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }
}

