/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.TreeSet;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.DefaultRouterMo;
import se.ericsson.cello.iptransport.DefaultRouterMoGen;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.PathSupervisionMo;
import se.ericsson.cello.iptransport.mom.Ipv6Interface;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;

public class DefaultRouterMoImpl
extends DefaultRouterMoGen {
    public DefaultRouterMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public DefaultRouterMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        Coordinator coordinator = setRequestContext.getCoordinator();
        int n = 0;
        int n2 = 0;
        if (this.getParent() instanceof IpInterfaceMo) {
            n = ((IpInterfaceMo)this.getParent()).getFroId(coordinator);
            n2 = PiuUtils.findPiuParentFroId((ManagedObject)this.getParent());
        } else {
            n = ((Ipv6InterfaceMo)this.getParent()).getFroId(coordinator);
            n2 = PiuUtils.findPiuParentFroId((ManagedObject)((Ipv6InterfaceMo)this.getParent()).getEthernetRef(coordinator));
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("ipIfFroId", n));
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuId", n2));
    }

    protected void validatePriority(int n, SetRequestContext setRequestContext) throws MoAccessException {
        super.validatePriority(n, setRequestContext);
        this.validateIsUniqueInSiblings(new Integer(n), "priority", setRequestContext);
    }

    private void validateIsUniqueInSiblings(Object object, String string, SetRequestContext setRequestContext) throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedObject = this.getParent();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        if (object instanceof String) {
            object = ((String)object).toUpperCase();
        }
        treeSet.add(object);
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (managedObject2.equals(this) || !(managedObject2 instanceof DefaultRouterMo)) continue;
                Object object2 = managedObject2.getAttribute(string, setRequestContext.getCoordinator());
                if (object2 instanceof String) {
                    object2 = ((String)object2).toUpperCase();
                }
                if (treeSet.contains(object2)) {
                    throw new AttrValueNotUniqueException("Two DefaultRouter MOs tied to the same Ipv6Interface MO must not have the same " + string, "DefaultRouter");
                }
                treeSet.add(object2);
            }
        }
    }

    protected void validateNextHopIpAddr(String string, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateNextHopIpAddr(string, setRequestContext);
        this.validateIpv6Format(string);
        this.validateIsUniqueInSiblings(string, "nextHopIpAddr", setRequestContext);
        boolean bl = this.validateIpv6Type(string);
        this.validateAllDRsAddresType(setRequestContext, bl);
        this.validateNetPrefix(string, setRequestContext, bl);
    }

    private void validateNetPrefix(String string, SetRequestContext setRequestContext, boolean bl) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        if (!this.validateAgainstPathSupervision(string, setRequestContext, bl)) {
            this.validateAgainstIpAccessHostEt(string, setRequestContext, bl);
        }
    }

    private void validateAgainstIpAccessHostEt(String string, SetRequestContext setRequestContext, boolean bl) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        ManagedObject managedObject = this.getParent();
        ManagedObject managedObject2 = null;
        if (bl && managedObject instanceof Ipv6InterfaceMo) {
            ManagedObject[] managedObjectArray = ((Ipv6Interface)managedObject).getReservedBy(setRequestContext.getCoordinator());
            for (int i = 0; i < managedObjectArray.length; ++i) {
                managedObject2 = managedObjectArray[i];
                if (!managedObjectArray[i].getType().equals("IpAccessHostEt")) continue;
                String string2 = (String)managedObject2.getAttribute("ipAddress", setRequestContext.getCoordinator());
                int n = (Integer)managedObject2.getAttribute("networkPrefixLength", setRequestContext.getCoordinator());
                this.validateIsUnique(string, string2);
                if (Ipv6Address.compareNetPrefix((String)string2, (String)string, (int)n)) continue;
                throw new IllegalAttributeValueException("The network prefix of IpAccessHostEt MO ipaddress and nextHopIpAddr for the same Ipv6Interface MO must be the same ", "DefaultRouter");
            }
        }
    }

    private boolean validateAgainstPathSupervision(String string, SetRequestContext setRequestContext, boolean bl) throws MoAccessException, NoSuchAttributeException, IllegalAttributeValueException, IpFormatException {
        ManagedObject managedObject;
        MoIterator moIterator;
        ManagedObject managedObject2 = this.getParent();
        boolean bl2 = false;
        if (managedObject2 instanceof Ipv6InterfaceMo && (moIterator = managedObject2.getChildren()).hasMoreElements() && (managedObject = moIterator.nextMo()) instanceof PathSupervisionMo) {
            bl2 = true;
            String string2 = (String)managedObject.getAttribute("ownIpAddress", setRequestContext.getCoordinator());
            this.validateIsUnique(string, string2);
            if (string2.equals("::")) {
                if (bl) {
                    throw new IllegalAttributeValueException("nextHopIpAddr should be local when PathSupervision MO ownipaddress is unspecified ", "DefaultRouter");
                }
            } else if (bl) {
                int n = (Integer)managedObject.getAttribute("networkPrefixLength", setRequestContext.getCoordinator());
                if (!Ipv6Address.compareNetPrefix((String)string2, (String)string, (int)n)) {
                    throw new IllegalAttributeValueException("The network prefix of PathSupervision MO and DefaultRouter nextHopIpAddr for the same Ipv6Interface MO must be the same ", "DefaultRouter");
                }
            } else {
                throw new IllegalAttributeValueException("nextHopIpAddr should be global when PathSupervision MO ownipaddress is specified ", "DefaultRouter");
            }
        }
        return bl2;
    }

    private void validateAllDRsAddresType(SetRequestContext setRequestContext, boolean bl) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        ManagedObject managedObject = this.getParent();
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                String string;
                ManagedObject managedObject2 = moIterator.nextMo();
                if (managedObject2.equals(this) || !(managedObject2 instanceof DefaultRouterMo) || bl == Ipv6Address.isGlobalUnicastIpv6((String)(string = (String)managedObject2.getAttribute("nextHopIpAddr", setRequestContext.getCoordinator())))) continue;
                throw new IllegalAttributeValueException("The address type for nextHopIpAddr must be the same for all DefaultRouter MOs for the same Ipv6Interface MO ", "DefaultRouter");
            }
        }
    }

    private boolean validateIpv6Type(String string) throws IpFormatException, IllegalAttributeValueException {
        boolean bl = Ipv6Address.isGlobalUnicastIpv6((String)string);
        if (!Ipv6Address.isLinkLocalIpv6((String)string) && !bl) {
            throw new IllegalAttributeValueException("The addres type must be global unicast or link local unicast for nextHopIpAddr", "DefaultRouter");
        }
        return bl;
    }

    private void validateIpv6Format(String string) throws IllegalAttributeValueException {
        if (!Ipv6Address.isValidIpv6Addres((String)string)) {
            throw new IllegalAttributeValueException("Only Ipv6 address format is supported for nextHopIpAddr", "DefaultRouter");
        }
    }

    private void validateIsUnique(String string, String string2) throws IpFormatException, AttrValueNotUniqueException {
        if (Ipv6Address.getIpv6Addres((String)string).equals(Ipv6Address.getIpv6Addres((String)string2))) {
            throw new AttrValueNotUniqueException("nextHopIpAddrmust be unique", "DefaultRouter");
        }
    }
}

