/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.iptransport.DscpGroupMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListMoGenImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntArrayParameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public abstract class DscpGroupMoGen
extends CelloMao
implements DscpGroupMo {
    private static String[] ATTRIBUTE_NAMES = new String[]{"samplingInterval", "dscpValues", "userLabel"};
    private static boolean[] MANDATORY = new boolean[]{false, true, false};
    protected FroProxy froProxy = null;
    protected MoData data;
    protected static final String FROID = "froId";
    protected static final int MO_DATA_REVISION_LATEST = 9000;

    protected DscpGroupMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, AttrList attrList) throws MoAccessException {
        super(managedObject, "DscpGroup", string, coordinator);
        this.froProxy = froProxy;
        MoGenUtil.checkAttributesDuringCreate((String[])ATTRIBUTE_NAMES, (boolean[])MANDATORY, (AttrList)attrList, (String)"DscpGroup");
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"samplingInterval", (AttrList)attrList, (Class)Integer.class, (String)"DscpGroup");
        int n2 = 300;
        if (n != null) {
            n2 = n;
        }
        this.validateSamplingInterval(attrList, n2, coordinator);
        int[] nArray = (int[])MoGenUtil.checkAndGetAttributeType((String)"dscpValues", (AttrList)attrList, (Class)[I.class, (String)"DscpGroup");
        this.validateDscpValues(attrList, nArray, coordinator);
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"DscpGroup");
        if (string2 == null) {
            string2 = "";
        }
        this.validateUserLabel(attrList, string2, coordinator);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter("samplingInterval", n2));
        arrayList.add(new SignedIntArrayParameter("dscpValues", nArray));
        arrayList.add(new SignedIntParameter("IpIfFroId", this.getIpIfFroId(coordinator)));
        arrayList.add(new SignedIntParameter("piuId", this.getPiuId(coordinator)));
        arrayList.add(new SignedIntParameter("lengthOfDscpList", this.getLengthOfDscpList(coordinator)));
        FroData froData = this.froProxy.create(coordinator, arrayList);
        int n3 = froData.getFroId();
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n3));
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    protected abstract int getIpIfFroId(Coordinator var1) throws MoAccessException;

    protected abstract int getPiuId(Coordinator var1) throws MoAccessException;

    protected abstract int getLengthOfDscpList(Coordinator var1) throws MoAccessException;

    public DscpGroupMoGen(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void setSamplingInterval(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("samplingInterval", new Integer(n), coordinator);
    }

    public int getSamplingInterval(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("samplingInterval", coordinator);
    }

    public int[] getDscpValues(Coordinator coordinator) throws MoAccessException {
        return (int[])this.getAttribute("dscpValues", coordinator);
    }

    public String getDscpGroupId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("DscpGroupId", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", new String(string), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public long[] getPmIfStatsDscpInOctets(Coordinator coordinator) throws MoAccessException {
        return (long[])this.getAttribute("pmIfStatsDscpInOctets", coordinator);
    }

    public long[] getPmIfStatsDscpInPkts(Coordinator coordinator) throws MoAccessException {
        return (long[])this.getAttribute("pmIfStatsDscpInPkts", coordinator);
    }

    public long[] getPmIfStatsDscpOutOctets(Coordinator coordinator) throws MoAccessException {
        return (long[])this.getAttribute("pmIfStatsDscpOutOctets", coordinator);
    }

    public long[] getPmIfStatsDscpOutPkts(Coordinator coordinator) throws MoAccessException {
        return (long[])this.getAttribute("pmIfStatsDscpOutPkts", coordinator);
    }

    public String getType() {
        return "DscpGroup";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("samplingInterval")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("samplingInterval");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dscpValues")) {
                map = this.getFroAttributes(map, coordinator);
                signedIntParameter = (SignedIntArrayParameter)map.get("dscpValues");
                objectArray[i] = MoGenUtil.getIntegerArrayFromIntArray((int[])signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsDscpInOctets")) {
                objectArray[i] = MoGenUtil.getLongArrayFromPrimLongArray((long[])super.getPmLongArrayAttribute("pmIfStatsDscpInOctets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsDscpInPkts")) {
                objectArray[i] = MoGenUtil.getLongArrayFromPrimLongArray((long[])super.getPmLongArrayAttribute("pmIfStatsDscpInPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsDscpOutOctets")) {
                objectArray[i] = MoGenUtil.getLongArrayFromPrimLongArray((long[])super.getPmLongArrayAttribute("pmIfStatsDscpOutOctets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsDscpOutPkts")) {
                objectArray[i] = MoGenUtil.getLongArrayFromPrimLongArray((long[])super.getPmLongArrayAttribute("pmIfStatsDscpOutPkts", coordinator));
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "DscpGroup");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        AttrListMoGenImpl attrListMoGenImpl = new AttrListMoGenImpl(stringArray, objectArray);
        MoGenUtil.checkAttributesDuringSet((String[])ATTRIBUTE_NAMES, (AttrList)attrListMoGenImpl, (String)"DscpGroup");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("samplingInterval")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("samplingInterval", "DscpGroup");
                }
                int n = (Integer)objectArray[i];
                n = this.validateSamplingInterval((AttrList)attrListMoGenImpl, n, coordinator);
                arrayList.add(new SignedIntParameter("samplingInterval", n));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "DscpGroup");
                }
                String string = (String)objectArray[i];
                string = this.validateUserLabel((AttrList)attrListMoGenImpl, string, coordinator);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "DscpGroup");
        }
        if (arrayList.size() > 0) {
            this.froProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private Map getFroAttributes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.froProxy.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    protected int validateSamplingInterval(AttrList attrList, int n, Coordinator coordinator) throws MoAccessException {
        int[] nArray = new int[]{10, 30, 60, 300};
        int[] nArray2 = new int[]{10, 30, 60, 300};
        MoGenUtil.checkIntegerAttribute((String)"samplingInterval", (int)n, (int[])nArray, (int[])nArray2, (String)"DscpGroup");
        return n;
    }

    protected int[] validateDscpValues(AttrList attrList, int[] nArray, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkIntegerArrayAttribute((String)"dscpValues", (int[])nArray, (int)0, (int)63, (int)1, (int)64, (String)"DscpGroup");
        return nArray;
    }

    protected String validateUserLabel(AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"DscpGroup");
        return string;
    }
}

