/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.iptransport.EthernetOamLocalMepMo;
import se.ericsson.cello.iptransport.EthernetOamLocalMepMoGen;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class EthernetOamLocalMepMoImpl
extends EthernetOamLocalMepMoGen {
    public static final int MAINTENANCE_ASSOCIATION_NAME_MIN_LENGTH = 1;
    public static final int MAINTENANCE_ASSOCIATION_NAME_MAX_LENGTH = 45;
    public static final int MAINTENANCE_DOMAIN_NAME_MIN_LENGTH = 1;
    public static final int MAINTENANCE_DOMAIN_NAME_MAX_LENGTH = 43;

    public EthernetOamLocalMepMoImpl(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(coordinator, managedObject, string, froProxy, initialMaoContext, attrList, maoFroIndicationHandler);
    }

    public EthernetOamLocalMepMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    public ManagedObject fetchEthernetRef(SignedIntParameter signedIntParameter, Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.froId2MaoInstance((String)"GigaBitEthernet", (int)signedIntParameter.getValue(), (Coordinator)coordinator);
    }

    protected void validateEthernetRef(ManagedObject managedObject, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateEthernetRef(managedObject, setRequestContext);
        if (!(managedObject instanceof GigaBitEthernetMo)) {
            throw new IllegalParentException("EthernetOamLocalMep");
        }
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        int n2 = 0;
        Coordinator coordinator = setRequestContext.getCoordinator();
        ManagedObject managedObject = (ManagedObject)setRequestContext.getAttributeFromRequest("ethernetRef");
        ManagedObject managedObject2 = managedObject.getParent();
        if (managedObject2.getParent().getType().equals("PlugInUnit")) {
            n2 = ((PlugInUnitMo)managedObject2.getParent()).getFroId(coordinator);
        }
        if (managedObject2.getParent().getType().equals("PiuDevice")) {
            n2 = ((PlugInUnitMo)managedObject2.getParent().getParent()).getFroId(coordinator);
        }
        setRequestContext.addParameter(this.froProxy, (Parameter)new SignedIntParameter("piuId", n2));
        if (setRequestContext.isIncludedInRequest("maintenanceDomainLevel")) {
            boolean bl = true;
            n = 1;
            int n3 = (Integer)setRequestContext.getAttributeFromRequest("maintenanceDomainLevel");
            if (setRequestContext.isIncludedInRequest("vLan")) {
                bl = (Boolean)setRequestContext.getAttributeFromRequest("vLan");
            }
            if (setRequestContext.isIncludedInRequest("vid")) {
                n = (Integer)setRequestContext.getAttributeFromRequest("vid");
            }
            this.checkForUniquness(n3, bl, n, coordinator);
        }
        if (setRequestContext.isIncludedInRequest("maintenanceDomainName")) {
            String string = (String)setRequestContext.getAttributeFromRequest("maintenanceDomainName");
            n = 0;
            if (setRequestContext.isIncludedInRequest("maintenanceDomainType")) {
                n = (Integer)setRequestContext.getAttributeFromRequest("maintenanceDomainType");
            }
            if (n != 0) {
                MoGenUtil.checkStringWithLength((String)string, (String)"maintenanceDomainName", (int)43, (int)1, (String)"EthernetOamLocalMep");
            } else {
                MoGenUtil.checkStringWithLength((String)string, (String)"maintenanceDomainName", (int)43, (int)0, (String)"EthernetOamLocalMep");
            }
        }
        if (setRequestContext.isIncludedInRequest("maintenanceAssociationName")) {
            String string = (String)setRequestContext.getAttributeFromRequest("maintenanceAssociationName");
            n = 0;
            if (setRequestContext.isIncludedInRequest("maintenanceAssociationType")) {
                n = (Integer)setRequestContext.getAttributeFromRequest("maintenanceAssociationType");
            }
            if (n != 0) {
                MoGenUtil.checkStringWithLength((String)string, (String)"maintenanceAssociationName", (int)45, (int)1, (String)"EthernetOamLocalMep");
            } else {
                MoGenUtil.checkStringWithLength((String)string, (String)"maintenanceAssociationName", (int)45, (int)0, (String)"EthernetOamLocalMep");
            }
        }
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
        int n;
        String string;
        Coordinator coordinator = setRequestContext.getCoordinator();
        boolean bl = true;
        int n2 = 1;
        int n3 = 0;
        n3 = setRequestContext.isIncludedInRequest("maintenanceDomainLevel") ? ((Integer)setRequestContext.getAttributeFromRequest("maintenanceDomainLevel")).intValue() : this.getMaintenanceDomainLevel(coordinator);
        bl = setRequestContext.isIncludedInRequest("vLan") ? ((Boolean)setRequestContext.getAttributeFromRequest("vLan")).booleanValue() : this.getVLan(coordinator);
        n2 = setRequestContext.isIncludedInRequest("vid") ? ((Integer)setRequestContext.getAttributeFromRequest("vid")).intValue() : this.getVid(coordinator);
        this.checkForUniquness(n3, bl, n2, coordinator);
        int n4 = 1;
        if (setRequestContext.isIncludedInRequest("mepIdentifier")) {
            n4 = (Integer)setRequestContext.getAttributeFromRequest("mepIdentifier");
            this.checkMepIdentifierUnique(n4, coordinator);
        }
        if (setRequestContext.isIncludedInRequest("maintenanceDomainName")) {
            string = (String)setRequestContext.getAttributeFromRequest("maintenanceDomainName");
            n = 0;
            n = setRequestContext.isIncludedInRequest("maintenanceDomainType") ? ((Integer)setRequestContext.getAttributeFromRequest("maintenanceDomainType")).intValue() : this.getMaintenanceDomainType(coordinator);
            if (n != 0) {
                MoGenUtil.checkStringWithLength((String)string, (String)"maintenanceDomainName", (int)43, (int)1, (String)"EthernetOamLocalMep");
            } else {
                MoGenUtil.checkStringWithLength((String)string, (String)"maintenanceDomainName", (int)43, (int)0, (String)"EthernetOamLocalMep");
            }
        }
        if (setRequestContext.isIncludedInRequest("maintenanceAssociationName")) {
            string = (String)setRequestContext.getAttributeFromRequest("maintenanceAssociationName");
            n = 0;
            n = setRequestContext.isIncludedInRequest("maintenanceAssociationType") ? ((Integer)setRequestContext.getAttributeFromRequest("maintenanceAssociationType")).intValue() : this.getMaintenanceAssociationType(coordinator);
            if (n != 0) {
                MoGenUtil.checkStringWithLength((String)string, (String)"maintenanceAssociationName", (int)45, (int)1, (String)"EthernetOamLocalMep");
            } else {
                MoGenUtil.checkStringWithLength((String)string, (String)"maintenanceAssociationName", (int)45, (int)0, (String)"EthernetOamLocalMep");
            }
        }
    }

    private void checkForUniquness(int n, boolean bl, int n2, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = MoRepository.instance().lookupType("EthernetOamLocalMep");
        if (moIterator == null) {
            return;
        }
        ManagedObject managedObject = null;
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (managedObject == this) continue;
            int n3 = ((EthernetOamLocalMepMo)managedObject).getMaintenanceDomainLevel(coordinator);
            int n4 = ((EthernetOamLocalMepMo)managedObject).getVid(coordinator);
            boolean bl2 = ((EthernetOamLocalMepMo)managedObject).getVLan(coordinator);
            if (!(bl && bl2 && n2 == n4 ? n3 == n : !bl && !bl2 && n3 == n)) continue;
            throw new AttrValueNotUniqueException("For each value of maintenanceDomainLevel, only one EthernetOamLocalMep MO can be configured for each VLAN", "maintenanceDomainLevel");
        }
    }

    protected void validateVLan(boolean bl, SetRequestContext setRequestContext) throws MoAccessException {
        super.validateVLan(bl, setRequestContext);
        int n = 2;
        if (setRequestContext.isIncludedInRequest("maintenanceAssociationType") && (n = ((Integer)setRequestContext.getAttributeFromRequest("maintenanceAssociationType")).intValue()) == 0 && !bl) {
            throw new IllegalAttributeValueException("If the attribute maintenanceAssociationType is set to PRIMARY_VID, the attribute vLan must be set to true", "vLan", "EthernetOamLocalMep");
        }
    }

    private void checkMepIdentifierUnique(int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        if (this.getChildren() != null) {
            MoIterator moIterator = this.getChildren();
            while (moIterator != null && moIterator.hasMoreElements()) {
                managedObject = moIterator.nextMo();
                int n2 = (Integer)managedObject.getAttribute("mepIdentifier", coordinator);
                if (n != n2) continue;
                throw new WrongAttributeTypeException("mepIdentifier", "EthernetOamLocalMep");
            }
        }
    }
}

