/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.equipment.PlugInUnitMoInternal;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.IpHostLinkMo;
import se.ericsson.cello.iptransport.DnsResolverMo;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpInterfaceGroupMo;
import se.ericsson.cello.iptransport.IpInterfaceGroupMoImpl;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.IpInterfaceMoImpl;
import se.ericsson.cello.iptransport.IpMuxMo;
import se.ericsson.cello.iptransport.IpValidator;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMoImpl;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.iptransport.ipadm_ethostmi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.GenPmMaoHandler;
import se.ericsson.cello.mao.HostIpAddress;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.IpAddress;
import se.ericsson.cello.mao.IpException;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MaoPmStrategyForReqContext;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class IpAccessHostEtMoImpl
extends CelloMao
implements IpAccessHostEtMo,
Reservable,
FroInfo {
    private MoData data;
    private FroProxy genIpacHostEtProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    TagNameDictionary DICTIONARY = TagNameDictionaries.create((ResourceBundle)ResourceBundle.getBundle(ipadm_ethostmi.class.getName()));
    private static final String ET_FRO_ID = "ipacHostEtFroId";
    private static final String PING = "ping";
    private static final String DEFAULT_IPv4_ADDRESS = "0.0.0.0";
    public static final int NTP_SERVER_MODE_NOT_APPLICABLE = 0;
    public static final int NTP_SERVER_MODE_SERVER = 1;
    private static final int MAX_NUMBER_ET_HOSTS = 2500;
    private static final int MAX_NUMBER_OF_VPN_RESERVED = 2;
    private static final int NTP_DSCP_MIN = 0;
    private static final int NTP_DSCP_MAX = 63;
    private static final int NTP_DSCP_DEFAULT = 46;
    public static final String PIU_FRO_ID = "plugInUnitMoRef";
    private int thePiuFroId = 0;
    static final String CONF_MODE = "confMode";
    static final int CONF_MODE_MANUAL = 0;
    static final int CONF_MODE_IKE = 1;
    private Map myPmProxyFroIdMap = new HashMap(3);
    private static final int MO_DATA_REVISION_5100 = 5100;
    private static final int MO_DATA_REVISION_6100 = 6100;
    private static final int MO_DATA_REVISION_LATEST = 6100;
    private static final int IP_INTERFACE_REF_TYPE = 1;
    private static final int IP_INTERFACE_GROUP_REF_TYPE = 2;
    private static final int IPv6_INTERFACE_REF_TYPE = 10;
    private static final int VPN_INTERFACE_REF_TYPE = 11;
    private static final int MIN_INTERFACE_REF_THAT_ALLOW_IPV6 = 10;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoAccessException {
        int n;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpAccessHostEt", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoIterator moIterator = initialMaoContext.getMoAccessor().lookupType("IpAccessHostEt");
        if (moIterator != null && moIterator.size() >= 2500) {
            throw new MaxNumberExceededException("Can not exceed 2500 instances", "IpAccessHostEt");
        }
        IpValidator.checkCombinedHostCardinality(managedObject, "IpAccessHostEt");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpAccessHostEt", (int)128, (int)0);
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"IpAccessHostEt");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"ipDefaultTtl", (AttrList)attrList, (boolean)false, (int)64, (int)1, (int)255, (String)"IpAccessHostEt");
        Class[] classArray = new Class[]{IpInterfaceMo.class, Ipv6InterfaceMo.class, VpnInterfaceBuildIF.class, IpInterfaceGroupMo.class};
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipInterfaceMoRef", (AttrList)attrList, (boolean)true, (Class[])classArray, (String)"IpAccessHostEt");
        String string3 = "";
        int n4 = IpAccessHostEtMoImpl.getConfModeFromIpInterfaceMoRef(managedObject3, coordinator);
        if (n4 == 0) {
            string3 = MoAttributeValidator.checkAndGetStringAttribute((String)"ipAddress", (AttrList)attrList, (boolean)true, (String)"", (String)"IpAccessHostEt");
        } else if (n4 == 1) {
            string3 = "";
            if (attrList.indexOf("ipAddress") != -1) {
                throw new IllegalAttributeValueException("For DHCP/IKE configurations, ipAddress should not be supplied in create request. ", "IpAccessHostEt");
            }
        }
        boolean bl = Ipv6Address.isProperIPv6Address((String)string3);
        int n5 = 64;
        if (bl) {
            Ipv6Address.validate((String)string3);
            n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"networkPrefixLength", (AttrList)attrList, (boolean)false, (int)64, (int)1, (int)128, (String)"IpAccessHostEt");
        } else {
            n = attrList.indexOf("networkPrefixLength");
            if (n != -1) {
                attrList.removeElementAt(n);
            }
        }
        IpAccessHostEtMoImpl.validateIpAddress(coordinator, string3, managedObject3, n5);
        IpAccessHostEtMoImpl.checkIFRelationships(bl, managedObject3, coordinator);
        n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"ntpDscp", (AttrList)attrList, (boolean)false, (int)46, (int)0, (int)63, (String)"IpAccessHostEt");
        int n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"ntpServerMode", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"IpAccessHostEt");
        IpAccessHostEtMoImpl.validateNtpServerMode(coordinator, string3, managedObject3, n6);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpAccessHostEt");
        return new IpAccessHostEtMoImpl(managedObject, string, string2, n2, managedObject3, string3, n3, n6, n, n5, coordinator, froProxy, maoFroIndicationHandler, initialMaoContext);
    }

    private static int getConfModeFromIpInterfaceMoRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject.getType().equalsIgnoreCase("IpInterface")) {
            return ((IpInterfaceMoImpl)managedObject).getConfigurationMode(coordinator);
        }
        if (managedObject.getType().equalsIgnoreCase("VpnInterface")) {
            return ((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator);
        }
        return 0;
    }

    private static void validateNtpServerMode(Coordinator coordinator, String string, ManagedObject managedObject, int n) throws IllegalAttributeValueException, MoAccessException {
        MoIterator moIterator;
        if (!(n != 1 || (moIterator = MoRepository.instance().lookupType("IpSyncRef")) == null && Ipv6Address.isIpv4((String)string))) {
            throw new IllegalAttributeValueException("ntpServerMode cannot be set to ENABLED, if there are any IpSyncRef MOs in the node or IpAddress is not Ipv4", "IpAccessHostEt");
        }
        if (n == 1) {
            IpAccessHostEtMoImpl.checkNtpServerMode(managedObject, coordinator);
        }
    }

    private static void checkIFRelationships(boolean bl, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n = IpAccessHostEtMoImpl.getInterfaceType(managedObject);
        ManagedObject[] managedObjectArray = null;
        switch (n) {
            case 11: {
                IpAccessHostEtMoImpl.validateVpnIpVersion(managedObject, bl, coordinator);
                managedObjectArray = ((VpnInterfaceBuildIF)managedObject).getReservedBy(coordinator);
                break;
            }
            case 2: {
                managedObjectArray = ((IpInterfaceGroupMo)managedObject).getReservedBy(coordinator);
                break;
            }
            case 10: {
                managedObjectArray = ((Ipv6InterfaceMo)managedObject).getReservedBy(coordinator);
            }
        }
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].getType().equals("IpAccessHostEt")) continue;
                throw new MaxNumberExceededException("Only one instance of IpAccessHostEt MO can refer to a VpnInterface MO, an IpInterfaceGroup MO or an Ipv6Interface MO", "IpAccessHostEt");
            }
        }
    }

    private static void validateIpVersionAndInterfaceType(boolean bl, ManagedObject managedObject) throws MoAccessException {
        int n = IpAccessHostEtMoImpl.getInterfaceType(managedObject);
        if (n > -1) {
            if (n < 10 && bl) {
                throw new IllegalAttributeValueException("ipInterfaceMoRef must refer to Ipv6Interface or VpnInterface for ipv6 addresses", "IpAccessHostEt");
            }
            if (n == 10 && !bl) {
                throw new IllegalAttributeValueException("ipInterfaceMoRef can not refer to Ipv6Interface for ipv4 addresses", "IpAccessHostEt");
            }
        }
    }

    private static void validateVpnIpVersion(ManagedObject managedObject, boolean bl, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        int n2 = 0;
        n = ((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator);
        n2 = ((VpnInterfaceBuildIF)managedObject).getIpVersion(coordinator);
        if (n == 0 && (bl && n2 == 0 || !bl && n2 == 1)) {
            throw new IllegalAttributeValueException("Ip addresses must match the referenced VpnInterface ipVersion (ipv4/ipv6) when VpnInterface configurationMode is MANUAL ", "IpAccessHostEt");
        }
    }

    private static int getInterfaceType(ManagedObject managedObject) {
        int n = -1;
        if (managedObject.getType().equals("IpInterface")) {
            n = 1;
        }
        if (managedObject.getType().equals("IpInterfaceGroup")) {
            n = 2;
        }
        if (managedObject.getType().equals("Ipv6Interface")) {
            n = 10;
        }
        if (managedObject.getType().equals("VpnInterface")) {
            n = 11;
        }
        return n;
    }

    private static void validateIpv6Address(String string, int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        IpAccessHostEtMoImpl.validateIpv6Format(string);
        IpAccessHostEtMoImpl.validateIpv6Type(string);
        IpAccessHostEtMoImpl.validateNetPrefix(string, n, managedObject, coordinator);
    }

    private static void validateNetPrefix(String string, int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        boolean bl = false;
        bl = IpAccessHostEtMoImpl.validateAgainstPathSupervision(string, n, managedObject, coordinator);
        if (!bl) {
            IpAccessHostEtMoImpl.validateAgainstDefaultRouter(string, n, managedObject, coordinator);
        }
    }

    private static void validateAgainstDefaultRouter(String string, int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                if (!managedObject2.getType().equals("DefaultRouter")) continue;
                String string2 = (String)managedObject2.getAttribute("nextHopIpAddr", coordinator);
                IpAccessHostEtMoImpl.validateIsUnique(string, string2);
                if (!Ipv6Address.isGlobalUnicastIpv6((String)string2) || Ipv6Address.compareNetPrefix((String)string, (String)string2, (int)n)) continue;
                throw new IllegalAttributeValueException("The network prefix of ipAddress and DefaultRouter MO(s)nextHopIpAddr for the same Ipv6Interface MO must be the same ", "IpAccessHostEt");
            }
        }
    }

    private static boolean validateAgainstPathSupervision(String string, int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException, IpFormatException, IllegalAttributeValueException {
        boolean bl = false;
        if (managedObject instanceof Ipv6InterfaceMo) {
            MoIterator moIterator = managedObject.getChildren();
            while (moIterator.hasMoreElements()) {
                String string2;
                String string3;
                ManagedObject managedObject2 = moIterator.nextMo();
                if (!managedObject2.getType().equals("PathSupervision")) continue;
                bl = true;
                String string4 = (String)managedObject2.getAttribute("ownIpAddress", coordinator);
                if (Ipv6Address.isUnspecifiedIpv6((String)string4)) continue;
                int n2 = (Integer)managedObject2.getAttribute("networkPrefixLength", coordinator);
                int n3 = (Integer)managedObject2.getAttribute("linkSide", coordinator);
                String string5 = Ipv6Address.getNetworkPrefix((String)string, (int)n);
                String string6 = Ipv6Address.getNetworkPrefix((String)string4, (int)n2);
                if (n != n2 || !string5.equalsIgnoreCase(string6)) {
                    throw new IllegalAttributeValueException("The network prefix of IpAccessHostEt MO ipaddress and PathSupervison MO ownIpAddress for the same Ipv6Interface MO must be the same ", "IpAccessHostEt");
                }
                if (n3 != 1 || !(string3 = Ipv6Address.getIpv6Addres((String)string).getHostAddress()).equalsIgnoreCase(string2 = Ipv6Address.getIpv6Addres((String)string4).getHostAddress())) continue;
                throw new IllegalAttributeValueException("ipAddress can only be shared with PathSupervision MO ownIpAddress for the active link, PathSupervision MO linkSide=ACTIVE ", "IpAccessHostEt");
            }
        }
        return bl;
    }

    private static void validateIsUnique(String string, String string2) throws IpFormatException, AttrValueNotUniqueException {
        if (Ipv6Address.getIpv6Addres((String)string).equals(Ipv6Address.getIpv6Addres((String)string2))) {
            throw new AttrValueNotUniqueException("ipAddress must be unique", "IpAccessHostEt");
        }
    }

    private static void validateIpv6Format(String string) throws IpFormatException {
        if (!Ipv6Address.isValidIpv6Addres((String)string)) {
            throw new IpFormatException("Wrong Ipv6 address format for ipAddress");
        }
    }

    private static void validateIpv6Type(String string) throws IpFormatException, IllegalAttributeValueException {
        boolean bl = Ipv6Address.isGlobalUnicastIpv6((String)string);
        if (!Ipv6Address.isLinkLocalIpv6((String)string) && !bl) {
            throw new IllegalAttributeValueException("The addres type must be global unicast for ipAddress", "IpAccessHostEt");
        }
    }

    private static boolean isVpnInterface(ManagedObject managedObject) {
        return managedObject instanceof VpnInterfaceBuildIF;
    }

    private static boolean isIpInterfaceGroup(ManagedObject managedObject) {
        return managedObject instanceof IpInterfaceGroupMo;
    }

    private IpAccessHostEtMoImpl(ManagedObject managedObject, String string, String string2, int n, ManagedObject managedObject2, String string3, int n2, int n3, int n4, int n5, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, "IpAccessHostEt", string, coordinator, initialMaoContext);
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.genIpacHostEtProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        ManagedObject managedObject3 = null;
        ManagedObject managedObject4 = null;
        if (IpAccessHostEtMoImpl.isVpnInterface(managedObject2)) {
            IpAccessHostEtMo ipAccessHostEtMo = (IpAccessHostEtMo)((VpnInterfaceBuildIF)managedObject2).getIpAccessHostEtRef(coordinator);
            managedObject3 = ipAccessHostEtMo.getIpInterfaceMoRef(coordinator);
        } else if (IpAccessHostEtMoImpl.isIpInterfaceGroup(managedObject2)) {
            managedObject3 = ((IpInterfaceGroupMo)managedObject2).getPrimaryIpInterfaceRef(coordinator);
            managedObject4 = ((IpInterfaceGroupMo)managedObject2).getSecondaryIpInterfaceRef(coordinator);
        } else if (managedObject2 instanceof IpInterfaceMo) {
            managedObject3 = managedObject2;
        } else if (managedObject2 instanceof Ipv6InterfaceMo) {
            managedObject3 = ((Ipv6InterfaceMo)managedObject2).getEthernetRef(coordinator);
        } else {
            throw new InvalidReferenceException(this.getType(), (Object)managedObject2);
        }
        int n6 = this.thePiuFroId = PiuUtils.findPiuParentFroId((ManagedObject)managedObject3);
        if (managedObject4 != null) {
            n6 = PiuUtils.findPiuParentFroId((ManagedObject)managedObject4);
        }
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        int n7 = this.createEtFro(coordinator, this.thePiuFroId, n, managedObject2, string3, n2, n3, n4, n5, n6);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(ET_FRO_ID, false, n7));
        this.data.setRevision(6100);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n7);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpAccessHostEtMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        super.setPmHandler((GenPmMaoHandler)new MaoPmStrategyForReqContext((ManagedObject)this, this.myPmAppPortal));
        this.data = moData;
        this.genIpacHostEtProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(ET_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute(ET_FRO_ID)).getValue(null));
    }

    private int createEtFro(Coordinator coordinator, int n, int n2, ManagedObject managedObject, String string, int n3, int n4, int n5, int n6, int n7) throws MoAccessException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter(PIU_FRO_ID, n));
        arrayList.add(new SignedIntParameter("secondaryLocation", n7));
        arrayList.add(new SignedIntParameter("administrativeState", n2));
        if (IpAccessHostEtMoImpl.isVpnInterface(managedObject)) {
            arrayList.add(new SignedIntParameter("ipInterfaceMoRef", ((VpnInterfaceBuildIF)managedObject).getFroId(coordinator)));
        } else if (IpAccessHostEtMoImpl.isIpInterfaceGroup(managedObject)) {
            arrayList.add(new SignedIntParameter("ipInterfaceMoRef", ((IpInterfaceGroupMoImpl)managedObject).getFroId(coordinator)));
        } else if (managedObject instanceof Ipv6InterfaceMo) {
            arrayList.add(new SignedIntParameter("ipInterfaceMoRef", ((Ipv6InterfaceMoImpl)managedObject).getFroId(coordinator)));
        } else if (managedObject instanceof IpInterfaceMo) {
            arrayList.add(new SignedIntParameter("ipInterfaceMoRef", ((IpInterfaceMoImpl)managedObject).getFroId(coordinator)));
        }
        arrayList.add(new StringParameter("ipAddress", string, 47));
        arrayList.add(new SignedIntParameter("ipDefaultTtl", n3));
        arrayList.add(new SignedIntParameter("ntpServerMode", n4));
        arrayList.add(new SignedIntParameter("ntpDscp", n5));
        arrayList.add(new SignedIntParameter("networkPrefixLength", n6));
        int n8 = IpAccessHostEtMoImpl.getConfModeFromIpInterfaceMoRef(managedObject, coordinator);
        arrayList.add(new SignedIntParameter(CONF_MODE, n8));
        int n9 = this.getIpVersionFromIpInterfaceMoRef(managedObject, coordinator);
        arrayList.add(new SignedIntParameter("ipVersion", n9));
        FroData froData = this.genIpacHostEtProxy.create(coordinator, arrayList);
        return froData.getFroId();
    }

    private int getIpVersionFromIpInterfaceMoRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject.getType().equalsIgnoreCase("IpInterface")) {
            return 0;
        }
        if (managedObject.getType().equalsIgnoreCase("Ipv6Interface")) {
            return 1;
        }
        if (managedObject.getType().equalsIgnoreCase("VpnInterface")) {
            return ((VpnInterfaceBuildIF)managedObject).getIpVersion(coordinator);
        }
        return 0;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        String[] stringArray = new String[]{"administrativeState", "ipInterfaceMoRef"};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        int n = (Integer)objectArray[0];
        if (n != 0) {
            throw new FroNotLockedException(this.getType(), "The MO can not be deleted when unlocked");
        }
        ManagedObject managedObject = (ManagedObject)objectArray[1];
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        this.genIpacHostEtProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        return this.getHostFroId(coordinator);
    }

    public int getHostFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(ET_FRO_ID)).getValue(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject == null) {
            throw new InvalidReferenceException("IpAccessHostEt", (Object)"null");
        }
        ManagedObject[] managedObjectArray = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
        int n = 1;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (IpAccessHostEtMoImpl.isVpnInterface(managedObjectArray[i])) {
                ++n;
            }
            if (managedObject instanceof IpMuxMo && managedObjectArray[i] instanceof IpMuxMo) {
                throw new MoNotPossibleToReserveException("Only one IpMux instance is allowed to reserve IpAccessHostEt, Already reserved by: " + managedObjectArray[i], "IpAccessHostEt");
            }
            if (n > 2 && managedObject instanceof VpnInterfaceBuildIF) {
                throw new MoNotPossibleToReserveException("Only two VpnInterface instances are allowed to reserve IpAccessHostEt, Already reserved by: " + managedObjectArray[0] + " and " + managedObjectArray[1], "IpAccessHostEt");
            }
            if (!(managedObject instanceof DnsResolverMo) || !(managedObjectArray[i] instanceof DnsResolverMo)) continue;
            throw new MoNotPossibleToReserveException("Only one DnsResolver instance is allowed to reserve IpAccessHostEt, Already reserved by: " + managedObjectArray[i], "IpAccessHostEt");
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getType() {
        return "IpAccessHostEt";
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("administrativeState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (StringParameter)map.get("ipAddress");
                objectArray[i] = signedIntParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipDefaultTtl")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("ipDefaultTtl");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipInterfaceMoRef")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("ipInterfaceMoRef");
                objectArray[i] = IpInterfaceMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                int n = signedIntParameter.getValue();
                if (objectArray[i] == null) {
                    objectArray[i] = this.findVpnInterface(n, coordinator);
                }
                if (objectArray[i] == null) {
                    objectArray[i] = Ipv6InterfaceMoImpl.lookupInstance(n, coordinator);
                }
                if (objectArray[i] == null) {
                    objectArray[i] = this.findIpInterfaceGroup(n, coordinator);
                }
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch reference ", "IpAccessHostEt", "ipInterfaceMoRef");
            }
            if (stringArray[i].equalsIgnoreCase("ntpServerMode")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("ntpServerMode");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ntpDscp")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("ntpDscp");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("networkPrefixLength")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("networkPrefixLength");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInDestUnreachs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInDestUnreachs", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInEchoReps")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInEchoReps", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInEchos")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInEchos", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInErrors", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInMsgs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInMsgs", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInParamProbs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInParamProbs", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInRedirects")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInRedirects", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInSrcQuenchs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInSrcQuenchs", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpInTimeExcds")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpInTimeExcds", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutDestUnreachs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutDestUnreachs", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutEchoReps")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutEchoReps", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutEchos")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutEchos", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutErrors", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutMsgs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutMsgs", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIcmpOutParamProbs")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIcmpOutParamProbs", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInAddrErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInAddrErrors", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInDelivers")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInDelivers", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInDiscards", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInHdrErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInHdrErrors", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInReceives")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInReceives", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpInUnknownProtos")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpInUnknownProtos", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpOutDiscards")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpOutDiscards", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpOutRequests")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpOutRequests", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmMeanAtmConnSetupIntensity")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmMeanAtmConnSetupIntensity", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmPeakAtmConnSetupIntensity")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmPeakAtmConnSetupIntensity", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmStdDevAtmSetupIntensity")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmStdDevAtmSetupIntensity", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpInDatagrams")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUdpInDatagrams", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpInErrors")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUdpInErrors", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpNoPorts")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUdpNoPorts", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpOutDatagrams")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmUdpOutDatagrams", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmReqds")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpReasmReqds", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmOks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpReasmOks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpReasmFails")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpReasmFails", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragOks")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpFragOks", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragFails")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpFragFails", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpFragCreates")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpFragCreates", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpPortUnreachable")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmIpPortUnreachable", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInAppLayerError")) {
                objectArray[i] = pmRequestContextImpl.getPmAttribute("pmInAppLayerError", INTEGER_PM_TYPE);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = pmRequestContextImpl.getCurrentPmRegister();
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessHostEt");
        }
        return objectArray;
    }

    private VpnInterfaceBuildIF findVpnInterface(int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("VpnInterface");
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (n != ((VpnInterfaceBuildIF)managedObject).getFroId(coordinator)) continue;
            return (VpnInterfaceBuildIF)managedObject;
        }
        return null;
    }

    private IpInterfaceGroupMo findIpInterfaceGroup(int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("IpInterfaceGroup");
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (n != ((IpInterfaceGroupMoImpl)managedObject).getFroId(coordinator)) continue;
            return (IpInterfaceGroupMo)managedObject;
        }
        return null;
    }

    private static void checkNtpServerMode(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (IpAccessHostEtMoImpl.isVpnInterface(managedObject)) {
            return;
        }
        if (IpAccessHostEtMoImpl.isIpInterfaceGroup(managedObject)) {
            MoIterator moIterator = MoRepository.instance().lookupType("IpAccessHostEt");
            IpInterfaceMo ipInterfaceMo = null;
            ipInterfaceMo = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator);
            ManagedObject managedObject2 = ipInterfaceMo.getParent().getParent();
            IpAccessHostEtMoImpl.performNtpServerModeCheck(moIterator, managedObject2, coordinator);
            ipInterfaceMo = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getSecondaryIpInterfaceRef(coordinator);
            ManagedObject managedObject3 = ipInterfaceMo.getParent().getParent();
            IpAccessHostEtMoImpl.performNtpServerModeCheck(moIterator, managedObject3, coordinator);
        } else {
            MoIterator moIterator = MoRepository.instance().lookupType("IpAccessHostEt");
            ManagedObject managedObject4 = managedObject.getParent().getParent();
            IpAccessHostEtMoImpl.performNtpServerModeCheck(moIterator, managedObject4, coordinator);
        }
    }

    private static void performNtpServerModeCheck(MoIterator moIterator, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject2 = null;
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject2 = moIterator.nextMo();
            if (((IpAccessHostEtMo)managedObject2).getNtpServerMode(coordinator) != 1 || !((IpAccessHostEtMo)managedObject2).getIpInterfaceMoRef(coordinator).getParent().getParent().getLocalDistinguishedName().equals(managedObject.getLocalDistinguishedName())) continue;
            throw new IllegalAttributeValueException("Of all instancies of IpAccessHostEt that are connected to a EtMfg, only one can have the ntpServerMode set to ENABLE", "IpAccessHostEt");
        }
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private ManagedObject piuFroId2MaoInstance(Coordinator coordinator, int n) throws MoAccessException {
        ManagedObject managedObject = null;
        ManagedObject managedObject2 = null;
        MoIterator moIterator = MoRepository.instance().lookupType("PlugInUnit");
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (n != ((PlugInUnitMoInternal)managedObject).getResourceId(coordinator)) continue;
            managedObject2 = managedObject;
        }
        if (managedObject2 == null) {
            throw new ConfigurationMismatchException("Failed to fetch reference plugInUnitMoRef", "IpAccessHostEt");
        }
        return managedObject2;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        String string = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessHostEtMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpAccessHostEt");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpAccessHostEt", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostEtMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "IpAccessHostEt");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"administrativeState", (int)n, (int)0, (int)2, (String)"IpAccessHostEt");
                arrayList.add(new SignedIntParameter("administrativeState", n));
                this.sendNotification("administrativeState", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipDefaultTtl")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostEtMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ipDefaultTtl", "IpAccessHostEt");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"ipDefaultTtl", (int)n, (int)1, (int)255, (String)"IpAccessHostEt");
                arrayList.add(new SignedIntParameter("ipDefaultTtl", n));
                this.sendNotification("ipDefaultTtl", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ntpServerMode")) {
                MoIterator moIterator;
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostEtMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ntpServerMode", "IpAccessHostEt");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"ntpServerMode", (int)n, (int)0, (int)1, (String)"IpAccessHostEt");
                if (!(n != 1 || (moIterator = MoRepository.instance().lookupType("IpSyncRef")) == null && Ipv6Address.isIpv4((String)this.getIpAddress(coordinator)))) {
                    throw new IllegalAttributeValueException("ntpServerMode cannot be set to ENABLED, if there are any IpSyncRef MOs in the node or IP Address is not Ipv4", "IpAccessHostEt");
                }
                if (n == 1) {
                    IpAccessHostEtMoImpl.checkNtpServerMode(this.getIpInterfaceMoRef(coordinator), coordinator);
                }
                arrayList.add(new SignedIntParameter("ntpServerMode", n));
                this.sendNotification("ntpServerMode", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ntpDscp")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? IpAccessHostEtMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("ntpDscp", "IpAccessHostEt");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"ntpDscp", (int)n, (int)0, (int)63, (String)"IpAccessHostEt");
                arrayList.add(new SignedIntParameter("ntpDscp", n));
                this.sendNotification("ntpDscp", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAddress")) {
                if (this.getAdministrativeState(coordinator) != 0) {
                    throw new FroNotLockedException("IpAccessHostEt", "AdministrativeState need to be locked when setting ip address");
                }
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessHostEtMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("ipAddress", "IpAccessHostEt");
                }
                int n2 = IpAccessHostEtMoImpl.getConfModeFromIpInterfaceMoRef(this.getIpInterfaceMoRef(coordinator), coordinator);
                if (n2 == 1) {
                    throw new OperationNotAllowedException("Set ipAddress when configurationMode is DHCP/IKE is not allowed.", "IpAccessHostEt");
                }
                string = (String)objectArray[i];
                IpAccessHostEtMoImpl.validateIpAddress(coordinator, string, this.getIpInterfaceMoRef(coordinator), this.getNetworkPrefixLength(coordinator));
                arrayList.add(new StringParameter("ipAddress", string, 47));
                this.sendNotification("ipAddress", string, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessHostEt");
        }
        if (arrayList.size() > 0) {
            this.genIpacHostEtProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private static void validateIpAddress(Coordinator coordinator, String string, ManagedObject managedObject, int n) throws IpFormatException, MoAccessException, IpException, NoSuchAttributeException, OperationNotAllowedException, IllegalAttributeValueException {
        if (!string.equals("")) {
            Ipv6Address.validate((String)string);
        }
        boolean bl = Ipv6Address.isIpv6((String)string);
        if (IpAccessHostEtMoImpl.isAttachedToVpnIf(managedObject)) {
            if (IpAccessHostEtMoImpl.isConfModeIKE(((VpnInterfaceBuildIF)managedObject).getConfigurationMode(coordinator))) {
                if (!string.equals("")) {
                    throw new OperationNotAllowedException("Setting an  ipAddress is only allowed when IpAccessHostEt refers to a VpnInterface with configurationMode MANUAL", "IpAccessHostEt");
                }
                return;
            }
            if (IpAccessHostEtMoImpl.getInterfaceType(managedObject) == 11) {
                IpAccessHostEtMoImpl.validateVpnIpVersion(managedObject, bl, coordinator);
            }
        }
        IpAccessHostEtMoImpl.validateIpVersionAndInterfaceType(bl, managedObject);
        int n2 = IpAccessHostEtMoImpl.getConfModeFromIpInterfaceMoRef(managedObject, coordinator);
        if (bl) {
            IpAccessHostEtMoImpl.validateIpv6Address(string, n, managedObject, coordinator);
            IpAccessHostEtMoImpl.checkIpAddressWithIpHostLink(string, bl, coordinator);
        } else if (n2 == 0) {
            IpAccessHostEtMoImpl.ipv4Validations(coordinator, string, managedObject);
            IpAccessHostEtMoImpl.checkIpAddressWithIpHostLink(string, bl, coordinator);
        }
    }

    private static void ipv4Validations(Coordinator coordinator, String string, ManagedObject managedObject) throws MoAccessException, IpFormatException, IpException, OperationNotAllowedException {
        int n = 0;
        if (managedObject instanceof IpInterfaceMo) {
            n = ((IpInterfaceMo)managedObject).getNetworkPrefixLength(coordinator);
            new HostIpAddress(string, n);
        } else if (managedObject instanceof VpnInterfaceBuildIF) {
            n = ((VpnInterfaceBuildIF)managedObject).getNetworkPrefixLength(coordinator);
            new IpAddress(string);
        } else if (managedObject instanceof IpInterfaceGroupMo) {
            n = ((IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator)).getNetworkPrefixLength(coordinator);
            new HostIpAddress(string, n);
        }
        IpAccessHostEtMoImpl.ipv4subnetValidations(coordinator, string, managedObject);
    }

    private static void ipv4subnetValidations(Coordinator coordinator, String string, ManagedObject managedObject) throws MoAccessException, OperationNotAllowedException {
        if (managedObject instanceof IpInterfaceGroupMo) {
            IpInterfaceMo ipInterfaceMo = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator);
            IpValidator.validateAddressTowardsInterface(string, ipInterfaceMo, "IpAccessHostEt", coordinator);
            IpInterfaceMo ipInterfaceMo2 = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getSecondaryIpInterfaceRef(coordinator);
            String string2 = ipInterfaceMo.getOwnIpAddressActive(coordinator);
            String string3 = ipInterfaceMo.getOwnIpAddressPassive(coordinator);
            String string4 = ipInterfaceMo2.getOwnIpAddressActive(coordinator);
            String string5 = ipInterfaceMo2.getOwnIpAddressPassive(coordinator);
            if (!string2.equals(DEFAULT_IPv4_ADDRESS) && string.equals(string2) || !string3.equals(DEFAULT_IPv4_ADDRESS) && string.equals(string3) || !string4.equals(DEFAULT_IPv4_ADDRESS) && string.equals(string4) || !string5.equals(DEFAULT_IPv4_ADDRESS) && string.equals(string5)) {
                throw new OperationNotAllowedException("The ipAddress can not be the same as ownIpAddressActive/Passive of the primary/secondary IpInterface in the IpInterfaceGroup. ", "IpAccessHostEt");
            }
        } else if (!managedObject.getType().equals("Ipv6Interface")) {
            IpValidator.validateAddressTowardsInterface(string, managedObject, "IpAccessHostEt", coordinator);
        }
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genIpacHostEtProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public ManagedObject getIpInterfaceMoRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipInterfaceMoRef", coordinator);
    }

    public void setIpAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAddress", string, coordinator);
    }

    public String getIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("ipAddress", coordinator);
    }

    public int getIpDefaultTtl(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ipDefaultTtl", coordinator);
    }

    public void setIpDefaultTtl(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipDefaultTtl", new Integer(n), coordinator);
    }

    public int getNtpServerMode(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ntpServerMode", coordinator);
    }

    public void setNtpServerMode(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ntpServerMode", new Integer(n), coordinator);
    }

    public int getNtpDscp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("ntpDscp", coordinator);
    }

    public void setNtpDscp(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ntpDscp", new Integer(n), coordinator);
    }

    public String getIpAccessHostEtId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public int getNetworkPrefixLength(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("networkPrefixLength", coordinator);
    }

    public int getPmIcmpInDestUnreachs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInDestUnreachs", coordinator);
    }

    public int getPmIcmpInEchoReps(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInEchoReps", coordinator);
    }

    public int getPmIcmpInEchos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInEchos", coordinator);
    }

    public int getPmIcmpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInErrors", coordinator);
    }

    public int getPmIcmpInMsgs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInMsgs", coordinator);
    }

    public int getPmIcmpInParamProbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInParamProbs", coordinator);
    }

    public int getPmIcmpInRedirects(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInRedirects", coordinator);
    }

    public int getPmIcmpInSrcQuenchs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInSrcQuenchs", coordinator);
    }

    public int getPmIcmpInTimeExcds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpInTimeExcds", coordinator);
    }

    public int getPmIcmpOutDestUnreachs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutDestUnreachs", coordinator);
    }

    public int getPmIcmpOutEchoReps(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutEchoReps", coordinator);
    }

    public int getPmIcmpOutEchos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutEchos", coordinator);
    }

    public int getPmIcmpOutErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutErrors", coordinator);
    }

    public int getPmIcmpOutMsgs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutMsgs", coordinator);
    }

    public int getPmIcmpOutParamProbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIcmpOutParamProbs", coordinator);
    }

    public int getPmIpInAddrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInAddrErrors", coordinator);
    }

    public int getPmIpInDelivers(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInDelivers", coordinator);
    }

    public int getPmIpInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInDiscards", coordinator);
    }

    public int getPmIpInHdrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInHdrErrors", coordinator);
    }

    public int getPmIpInReceives(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInReceives", coordinator);
    }

    public int getPmIpInUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpInUnknownProtos", coordinator);
    }

    public int getPmIpOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpOutDiscards", coordinator);
    }

    public int getPmIpOutRequests(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpOutRequests", coordinator);
    }

    public int getPmMeanAtmConnSetupIntensity(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmMeanAtmConnSetupIntensity", coordinator);
    }

    public int getPmPeakAtmConnSetupIntensity(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmPeakAtmConnSetupIntensity", coordinator);
    }

    public int getPmStdDevAtmSetupIntensity(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmStdDevAtmSetupIntensity", coordinator);
    }

    public int getPmUdpInDatagrams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpInDatagrams", coordinator);
    }

    public int getPmUdpInErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpInErrors", coordinator);
    }

    public int getPmUdpNoPorts(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpNoPorts", coordinator);
    }

    public int getPmIpPortUnreachable(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpPortUnreachable", coordinator);
    }

    public int getPmUdpOutDatagrams(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpOutDatagrams", coordinator);
    }

    public int getPmIpReasmReqds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmReqds", coordinator);
    }

    public int getPmIpReasmOKs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmOks", coordinator);
    }

    public int getPmIpReasmOks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmOks", coordinator);
    }

    public int getPmIpReasmFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpReasmFails", coordinator);
    }

    public int getPmIpFragOks(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragOks", coordinator);
    }

    public int getPmIpFragOKs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragOks", coordinator);
    }

    public int getPmIpFragFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragFails", coordinator);
    }

    public int getPmIpFragCreates(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpFragCreates", coordinator);
    }

    public int getPmInAppLayerError(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmInAppLayerError", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl();
        try {
            Map map = maoFroGenericParameterChdInd.getParameters(this.DICTIONARY);
            Iterator iterator = map.keySet().iterator();
            String string = null;
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (string.equals("administrativeState")) {
                    setRequestContextImpl.addAvcNotification("administrativeState", (Object)new Integer(((SignedIntParameter)map.get("administrativeState")).getValue()));
                    continue;
                }
                if (string.equals("ipAddress")) {
                    setRequestContextImpl.addAvcNotification("ipAddress", (Object)((StringParameter)map.get("ipAddress")).getValue());
                    continue;
                }
                MessageLog.traceError(this.getClass(), (String)("Unknown attribute in parameterChanged(): " + string));
            }
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Attribute tag not in property file");
        }
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    public String actionPing(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        boolean bl = Ipv6Address.isProperIPv6Address((String)string);
        if (!bl) {
            new IpAddress(string);
        } else {
            Ipv6Address.validate((String)string);
        }
        int n = this.getIpVersionFromIpInterfaceMoRef(this.getIpInterfaceMoRef(coordinator), coordinator);
        if (n == 0) {
            if (Ipv6Address.isIpv6((String)string)) {
                throw new IllegalAttributeValueException("Called host must have the same IP version as this MO.", "IpAccessHostEt");
            }
        } else if (Ipv6Address.isIpv4((String)string)) {
            throw new IllegalAttributeValueException("Called host must have the same IP version as this MO. ", "IpAccessHostEt");
        }
        ArrayList<StringParameter> arrayList = new ArrayList<StringParameter>();
        StringParameter stringParameter = new StringParameter("ipAddress", string, 47);
        arrayList.add(stringParameter);
        Map map = this.genIpacHostEtProxy.actionWithCfm(null, this.getFroId(coordinator), 2001, arrayList);
        StringParameter stringParameter2 = (StringParameter)map.get("pingReply");
        String string2 = "";
        if (stringParameter2 != null) {
            string2 = stringParameter2.getValue();
        }
        return string2;
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    private static void checkIpAddressWithIpHostLink(String string, boolean bl, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = MoRepository.instance().lookupType("IpHostLink");
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            String string2 = "";
            if (bl) {
                Struct[] structArray = ((IpHostLinkMo)managedObject).getIpv6Addresses(coordinator);
                if (structArray != null && structArray.length > 0) {
                    string2 = (String)structArray[0].getValue("ipAddress");
                }
            } else {
                string2 = ((IpHostLinkMo)managedObject).getIpAddress(coordinator);
            }
            if (!Ipv6Address.getIpAddress((String)string).equals(Ipv6Address.getIpAddress((String)string2))) continue;
            throw new IllegalAttributeValueException("The IpAddress " + string + " is already using by IpHostLink MO,choose other value for IpAddress", "IpAccessHostEt");
        }
    }

    public int getPlugInUnitHostId(Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getIpInterfaceMoRef(coordinator);
        IpAccessHostEtMo ipAccessHostEtMo = null;
        ipAccessHostEtMo = managedObject instanceof VpnInterfaceBuildIF ? (IpAccessHostEtMo)((VpnInterfaceBuildIF)managedObject).getIpAccessHostEtRef(coordinator) : this;
        int n = PiuUtils.findPiuParentFroId((ManagedObject)ipAccessHostEtMo.getIpInterfaceMoRef(coordinator));
        return n;
    }

    private static boolean isAttachedToVpnIf(ManagedObject managedObject) throws MoAccessException {
        return managedObject instanceof VpnInterfaceBuildIF;
    }

    private static boolean isConfModeIKE(int n) throws MoAccessException {
        return n == 1;
    }

    public int getPiuFroid(Coordinator coordinator) throws MoAccessException {
        return this.thePiuFroId;
    }
}

