/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.IpAccessHostEtMo;
import se.ericsson.cello.iptransport.IpAccessSctpMo;
import se.ericsson.cello.iptransport.IpInterfaceGroupMo;
import se.ericsson.cello.iptransport.SctpBuildIF;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class IpAccessSctpMoImpl
extends CelloMao
implements IpAccessSctpMo,
Reservable,
FroInfo {
    private MoData data;
    private static final int MO_DATA_REVISION_7 = 7000;
    private static final int MO_DATA_REVISION_8 = 7100;
    private static final int MO_DATA_REVISION_LATEST = 7100;
    boolean swapped = false;
    private FroProxy ipAccessSctpProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"IpAccessSctp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"IpAccessSctp", (int)128, (int)0);
        ManagedObject managedObject2 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipAccessHostEtRef1", (AttrList)attrList, (boolean)true, (String)"IpAccessSctp");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ipAccessHostEtRef2", (AttrList)attrList, (boolean)false, (String)"IpAccessSctp");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"IpAccessSctp");
        if (managedObject2 != null && managedObject3 != null) {
            if (managedObject2 == managedObject3) {
                throw new ValueOutOfRangeException("ipAccessHostEtRef2", "IpAccessSctp");
            }
            if (!managedObject2.getType().equals(managedObject3.getType())) {
                throw new OperationNotAllowedException("the IpAccessSctp shouldn't have  References of different types.", "IpAccessSctp");
            }
        }
        return new IpAccessSctpMoImpl(managedObject, string, string2, managedObject2, managedObject3, coordinator, froProxy, maoFroIndicationHandler, initialMaoContext);
    }

    private IpAccessSctpMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ManagedObject managedObject3, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, InitialMaoContext initialMaoContext) throws MoAccessException {
        super(managedObject, "IpAccessSctp", string, coordinator, initialMaoContext);
        this.ipAccessSctpProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        int n = ((FroInfo)managedObject2).getFroId(coordinator);
        SignedIntParameter signedIntParameter = new SignedIntParameter("ipAccessHostEtRef1", n);
        arrayList.add(signedIntParameter);
        if (managedObject2 instanceof IpAccessHostEtMo) {
            arrayList.add(new SignedIntParameter("ipAccessHostRef_type", 1));
        } else {
            arrayList.add(new SignedIntParameter("ipAccessHostRef_type", 2));
        }
        if (managedObject3 != null) {
            int n2 = ((FroInfo)managedObject3).getFroId(coordinator);
            SignedIntParameter signedIntParameter2 = new SignedIntParameter("ipAccessHostEtRef2", n2);
            arrayList.add(signedIntParameter2);
            if (managedObject3 instanceof IpAccessHostEtMo) {
                arrayList.add(new SignedIntParameter("ipAccessHostRef_type", 1));
            } else {
                arrayList.add(new SignedIntParameter("ipAccessHostRef_type", 2));
            }
        }
        FroData froData = this.ipAccessSctpProxy.create(coordinator, arrayList);
        int n3 = froData.getFroId();
        ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        if (managedObject3 != null) {
            ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
        }
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n3));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ipAccessHostEtRef1", true));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ipAccessHostEtRef2", true));
        ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef1")).setValue(managedObject2);
        ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef2")).setValue(managedObject3);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n3);
        this.data.setRevision(7100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public IpAccessSctpMoImpl(MoData moData, FroProxy froProxy, InitialMaoContext initialMaoContext, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.ipAccessSctpProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(7100);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("ipAccessHostEtRef1");
        moDataRecoveryHelper.assertAttribute("ipAccessHostEtRef2");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (((ManagedObject[])this.getAttribute("reservedBy", coordinator)).length != 0) {
            throw new MoReservedNotDeletableException("IpAccessSctp");
        }
        ManagedObject managedObject = this.getIpAccessHostEtRef1(coordinator);
        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        ManagedObject managedObject2 = this.getIpAccessHostEtRef2(coordinator);
        if (managedObject2 != null) {
            ((Reservable)managedObject2).release((ManagedObject)this, coordinator);
        }
        this.ipAccessSctpProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getIpAccessSctpId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public ManagedObject getIpAccessHostEtRef1(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessHostEtRef1", coordinator);
    }

    public void setIpAccessHostEtRef1(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAccessHostEtRef1", managedObject, coordinator);
    }

    public ManagedObject getIpAccessHostEtRef2(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ipAccessHostEtRef2", coordinator);
    }

    public void setIpAccessHostEtRef2(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("ipAccessHostEtRef2", managedObject, coordinator);
    }

    public boolean getPortDistribution(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("portDistribution", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("reservedBy", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getType() {
        return "IpAccessSctp";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrsFromFro(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrsFromFro(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef1")) {
                map = this.getAttrsFromFro(map, coordinator);
                signedIntParameter = ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef1")).getValue(coordinator);
                objectArray[i] = signedIntParameter;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef2")) {
                map = this.getAttrsFromFro(map, coordinator);
                signedIntParameter = ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef2")).getValue(coordinator);
                objectArray[i] = signedIntParameter;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("portDistribution")) {
                map = this.getAttrsFromFro(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("portDistribution");
                objectArray[i] = new Boolean(signedIntParameter.getBoolean());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessSctp");
        }
        return objectArray;
    }

    private Map getAttrsFromFro(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            map = this.ipAccessSctpProxy.getAttributes(coordinator, this.getFroId(coordinator));
        }
        return map;
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObject instanceof SctpBuildIF) {
            ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!(managedObjectArray[i] instanceof SctpBuildIF)) continue;
                throw new OperationNotAllowedException("Reserve request failed. This SwAllocation is already reserved by an Sctp MO.", "IpAccessSctp");
            }
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        ManagedObject managedObject = null;
        ManagedObject managedObject2 = null;
        this.ValidateIpAccessRef(stringArray, objectArray, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? IpAccessSctpMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "IpAccessSctp");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"IpAccessSctp", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef1")) {
                if (objectArray[i] instanceof ManagedObject) {
                    managedObject = (ManagedObject)objectArray[i];
                    if (managedObject == null) {
                        throw new OperationNotAllowedException("IpAccessHostEtRef1 is mandatory so can *NOT* be set NULL.", "IpAccessSctp");
                    }
                    this.replaceRef(this.getIpAccessHostEtRef1(coordinator), managedObject, "ipAccessHostEtRef1", arrayList, coordinator);
                    ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef1")).setValue(managedObject);
                    this.sendNotification("ipAccessHostEtRef1", objectArray[i], coordinator);
                    continue;
                }
                throw new WrongAttributeTypeException("ipAccessHostEtRef1", "IpAccessSctp");
            }
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef2")) {
                if (objectArray[i] == null || objectArray[i] instanceof ManagedObject) {
                    managedObject2 = (ManagedObject)objectArray[i];
                    this.replaceRef(this.getIpAccessHostEtRef2(coordinator), managedObject2, "ipAccessHostEtRef2", arrayList, coordinator);
                    ((ReferenceAttribute)this.data.getAttribute("ipAccessHostEtRef2")).setValue(managedObject2);
                    this.sendNotification("ipAccessHostEtRef2", objectArray[i], coordinator);
                    continue;
                }
                throw new WrongAttributeTypeException("ipAccessHostEtRef2", "IpAccessSctp");
            }
            throw new NoSuchAttributeException(stringArray[i], "IpAccessSctp");
        }
        if (arrayList.size() > 0) {
            this.ipAccessSctpProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private void replaceRef(ManagedObject managedObject, ManagedObject managedObject2, String string, ArrayList arrayList, Coordinator coordinator) throws MoAccessException {
        int n = 0;
        if (!this.swapped && !this.getIpAccessHostEtRef1(coordinator).equals(this.getIpAccessHostEtRef2(coordinator)) && managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
        if (managedObject2 != null) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
            n = ((FroInfo)managedObject2).getFroId(coordinator);
        }
        arrayList.add(new SignedIntParameter(string, n));
        if (managedObject2 == null || managedObject2 instanceof ManagedObject) {
            if (managedObject2 instanceof IpAccessHostEtMo) {
                arrayList.add(new SignedIntParameter("ipAccessHostRef_type", 1));
            } else {
                arrayList.add(new SignedIntParameter("ipAccessHostRef_type", 2));
            }
        } else {
            throw new WrongAttributeTypeException("ipAccessHostEtRef2", "IpAccessSctp");
        }
    }

    private static void containsIpInterfaceGroup(Object object, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject;
        if (object == null) {
            return;
        }
        if (((IpAccessHostEtMo)object).getIpInterfaceMoRef(coordinator) instanceof IpInterfaceGroupMo) {
            throw new OperationNotAllowedException("It is not possible for an IpAccessSctp Mo to refer to an IpAccessHostEt connected directly to an IpInterfaceGroup.", "IpAccessSctp");
        }
        if (((IpAccessHostEtMo)object).getIpInterfaceMoRef(coordinator) instanceof VpnInterfaceBuildIF && ((IpAccessHostEtMo)(managedObject = ((VpnInterfaceBuildIF)((IpAccessHostEtMo)object).getIpInterfaceMoRef(coordinator)).getIpAccessHostEtRef(coordinator))).getIpInterfaceMoRef(coordinator) instanceof IpInterfaceGroupMo) {
            throw new OperationNotAllowedException("Cannot create IpSyncRef Mo when parent IpAccessHostEt Mo is connected indirectly to an  IpInterfaceGroup. ", "IpAccessSctp");
        }
    }

    private void ValidateIpAccessRef(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = this.getIpAccessHostEtRef1(coordinator);
        ManagedObject managedObject2 = this.getIpAccessHostEtRef2(coordinator);
        this.swapped = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("ipAccessHostEtRef1")) {
                if (objectArray[i] instanceof ManagedObject) {
                    managedObject = (ManagedObject)objectArray[i];
                } else {
                    throw new WrongAttributeTypeException("ipAccessHostEtRef1", "IpAccessSctp");
                }
            }
            if (!stringArray[i].equalsIgnoreCase("ipAccessHostEtRef2")) continue;
            if (objectArray[i] == null || objectArray[i] instanceof ManagedObject) {
                managedObject2 = (ManagedObject)objectArray[i];
                continue;
            }
            throw new WrongAttributeTypeException("ipAccessHostEtRef2", "IpAccessSctp");
        }
        if (this.getIpAccessHostEtRef2(coordinator) != null && this.getIpAccessHostEtRef1(coordinator).equals(managedObject2) && this.getIpAccessHostEtRef2(coordinator).equals(managedObject)) {
            this.swapped = true;
        }
        if (managedObject.equals(managedObject2)) {
            throw new OperationNotAllowedException("IpAccessHostEtRef1 and IpAccessHostEtRef2 must NOT be the same", "IpAccessSctp");
        }
        if (managedObject2 != null && !managedObject.getType().equals(managedObject2.getType())) {
            throw new OperationNotAllowedException("the IpAccessSctp shouldn't have diferent Reference type.", "IpAccessSctp");
        }
    }
}

