/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.HashMap;
import java.util.Map;
import se.ericsson.cello.iptransport.IpFlowMonitorMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.GetRequestContext;
import se.ericsson.cello.mao.GetRequestContextImpl;
import se.ericsson.cello.mao.MoGenUtil;
import se.ericsson.cello.mao.ParameterNames;
import se.ericsson.cello.mao.PmRequestContextImpl;
import se.ericsson.cello.mao.SetRequestContext;
import se.ericsson.cello.mao.SetRequestContextImpl;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.SignedIntArrayParameter;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public abstract class IpFlowMonitorMoGen
extends CelloMao
implements IpFlowMonitorMo {
    private static String[] ATTRIBUTES_TO_REQUEST_FROM_FRO = new String[]{"dscpValue", "remoteIpAddress", "samplingInterval", "lengthOfDscpList", "IpIfFroId", "piuId"};
    private static String[] NON_READONLY_MOM_ATTRIBUTES = new String[]{"IpFlowMonitorId", "userLabel", "dscpValue", "remoteIpAddress", "samplingInterval"};
    protected FroProxy froProxy = null;
    protected MoData data;
    Map myPmProxyFroIdMap = new HashMap(3);
    protected static final String FROID = "froId";
    protected static final int MO_DATA_REVISION_LATEST = 14300;

    private void checkMandatoryAttrs(AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        this.checkMandatoryAttribute("dscpValue", attrList);
    }

    private void checkMandatoryAttribute(String string, AttrList attrList) throws AttrMissingAtCreateException, MoNotFoundException, NotHandledAttributeTypeException {
        int n = attrList.indexOf(string);
        if (n < 0 || attrList.getValue(n) == null) {
            throw new AttrMissingAtCreateException(string, "IpFlowMonitor");
        }
    }

    protected IpFlowMonitorMoGen(Coordinator coordinator, ManagedObject managedObject, String string, FroProxy froProxy, InitialMaoContext initialMaoContext, AttrList attrList) throws MoAccessException {
        super(managedObject, "IpFlowMonitor", string, coordinator, initialMaoContext);
        this.froProxy = froProxy;
        this.checkMandatoryAttrs(attrList);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(attrList, coordinator);
        setRequestContextImpl.assertNoDuplicateAttributes("IpFlowMonitor");
        setRequestContextImpl.assertAllowedAttributes(NON_READONLY_MOM_ATTRIBUTES, "IpFlowMonitor");
        this.data = initialMaoContext.createMoData(this.getLocalDistinguishedName(), "IpFlowMonitor", true, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true));
        this.data.setRevision(14300);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String string2 = (String)MoGenUtil.checkAndGetAttributeType((String)"userLabel", (AttrList)attrList, (Class)String.class, (String)"IpFlowMonitor");
        if (string2 == null) {
            string2 = "";
        }
        this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
        int[] nArray = (int[])MoGenUtil.checkAndGetAttributeType((String)"dscpValue", (AttrList)attrList, (Class)[I.class, (String)"IpFlowMonitor");
        this.validateDscpValue(nArray, (SetRequestContext)setRequestContextImpl);
        SignedIntArrayParameter signedIntArrayParameter = null;
        if (nArray != null) {
            signedIntArrayParameter = new SignedIntArrayParameter("dscpValue", nArray);
        }
        setRequestContextImpl.addParameter(this.froProxy, signedIntArrayParameter);
        String string3 = (String)MoGenUtil.checkAndGetAttributeType((String)"remoteIpAddress", (AttrList)attrList, (Class)String.class, (String)"IpFlowMonitor");
        if (string3 == null) {
            string3 = "";
        }
        this.validateRemoteIpAddress(string3, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("remoteIpAddress", string3));
        Integer n = (Integer)MoGenUtil.checkAndGetAttributeType((String)"samplingInterval", (AttrList)attrList, (Class)Integer.class, (String)"IpFlowMonitor");
        int n2 = 300;
        if (n != null) {
            n2 = n;
        }
        this.validateSamplingInterval(n2, (SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("samplingInterval", n2));
        this.onCreate((SetRequestContext)setRequestContextImpl);
        FroData froData = setRequestContextImpl.sendCreateRequest(this.froProxy);
        int n3 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(FROID, false, n3));
    }

    public IpFlowMonitorMoGen(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.froProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(14300);
        moDataRecoveryHelper.assertAttribute(FROID);
        moDataRecoveryHelper.assertAttribute("userLabel");
    }

    protected void onCreate(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onSetAttributes(SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void onGetAttributes(GetRequestContext getRequestContext) throws MoAccessException {
    }

    protected void onDelete(Coordinator coordinator) throws MoAccessException {
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.onDelete(coordinator);
        this.froProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public int[] getDscpValue(Coordinator coordinator) throws MoAccessException {
        return (int[])this.getAttribute("dscpValue", coordinator);
    }

    public void setRemoteIpAddress(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("remoteIpAddress", string, coordinator);
    }

    public String getRemoteIpAddress(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("remoteIpAddress", coordinator);
    }

    public void setSamplingInterval(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("samplingInterval", new Integer(n), coordinator);
    }

    public int getSamplingInterval(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("samplingInterval", coordinator);
    }

    public long[] getPmIpFlowInOctets(Coordinator coordinator) throws MoAccessException {
        return MoGenUtil.getPrimLongArrayFromLongArray((Long[])((Long[])this.getAttribute("pmIpFlowInOctets", coordinator)));
    }

    public long[] getPmIpFlowInPkts(Coordinator coordinator) throws MoAccessException {
        return MoGenUtil.getPrimLongArrayFromLongArray((Long[])((Long[])this.getAttribute("pmIpFlowInPkts", coordinator)));
    }

    public long[] getPmIpFlowOutOctets(Coordinator coordinator) throws MoAccessException {
        return MoGenUtil.getPrimLongArrayFromLongArray((Long[])((Long[])this.getAttribute("pmIpFlowOutOctets", coordinator)));
    }

    public long[] getPmIpFlowOutPkts(Coordinator coordinator) throws MoAccessException {
        return MoGenUtil.getPrimLongArrayFromLongArray((Long[])((Long[])this.getAttribute("pmIpFlowOutPkts", coordinator)));
    }

    public long getPmIpFlowMaxInBitrate(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmIpFlowMaxInBitrate", coordinator);
    }

    public long getPmIpFlowMinInBitrate(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmIpFlowMinInBitrate", coordinator);
    }

    public long getPmIpFlowMaxOutBitrate(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmIpFlowMaxOutBitrate", coordinator);
    }

    public long getPmIpFlowMinOutBitrate(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmIpFlowMinOutBitrate", coordinator);
    }

    public String getType() {
        return "IpFlowMonitor";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(FROID)).getValue(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        GetRequestContextImpl getRequestContextImpl = new GetRequestContextImpl(stringArray, coordinator);
        this.addParameterNames(getRequestContextImpl.getParameterNames());
        getRequestContextImpl.readAttributesFromProxy(this.froProxy, this.getFroId(coordinator), ATTRIBUTES_TO_REQUEST_FROM_FRO);
        Object[] objectArray = new Object[stringArray.length];
        PmRequestContextImpl pmRequestContextImpl = new PmRequestContextImpl((ManagedObject)this, this.myPmProxyFroIdMap, coordinator);
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntArrayParameter signedIntArrayParameter;
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dscpValue")) {
                Integer[] integerArray;
                signedIntArrayParameter = (SignedIntArrayParameter)getRequestContextImpl.getParameter("dscpValue");
                if (signedIntArrayParameter == null) {
                    throw new FroRequestFailedException("IpFlowMonitor", "Missing parameter from FRO: dscpValue", "getAttributes", -1);
                }
                objectArray[i] = integerArray = (Integer[])signedIntArrayParameter.getArrayValueAsObjects();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("remoteIpAddress")) {
                signedIntArrayParameter = (StringParameter)getRequestContextImpl.getParameter("remoteIpAddress");
                if (signedIntArrayParameter == null) {
                    throw new FroRequestFailedException("IpFlowMonitor", "Missing parameter from FRO: remoteIpAddress", "getAttributes", -1);
                }
                objectArray[i] = signedIntArrayParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("samplingInterval")) {
                signedIntArrayParameter = (SignedIntParameter)getRequestContextImpl.getParameter("samplingInterval");
                if (signedIntArrayParameter == null) {
                    throw new FroRequestFailedException("IpFlowMonitor", "Missing parameter from FRO: samplingInterval", "getAttributes", -1);
                }
                objectArray[i] = new Integer(signedIntArrayParameter.getValue());
                continue;
            }
            objectArray[i] = stringArray[i].equalsIgnoreCase("pmIpFlowInOctets") ? pmRequestContextImpl.getPmAttribute("pmIpFlowInOctets", LONG_ARRAY_PM_TYPE) : (stringArray[i].equalsIgnoreCase("pmIpFlowInPkts") ? pmRequestContextImpl.getPmAttribute("pmIpFlowInPkts", LONG_ARRAY_PM_TYPE) : (stringArray[i].equalsIgnoreCase("pmIpFlowOutOctets") ? pmRequestContextImpl.getPmAttribute("pmIpFlowOutOctets", LONG_ARRAY_PM_TYPE) : (stringArray[i].equalsIgnoreCase("pmIpFlowOutPkts") ? pmRequestContextImpl.getPmAttribute("pmIpFlowOutPkts", LONG_ARRAY_PM_TYPE) : (stringArray[i].equalsIgnoreCase("pmIpFlowMaxInBitrate") ? pmRequestContextImpl.getPmAttribute("pmIpFlowMaxInBitrate", LONG_PM_TYPE) : (stringArray[i].equalsIgnoreCase("pmIpFlowMinInBitrate") ? pmRequestContextImpl.getPmAttribute("pmIpFlowMinInBitrate", LONG_PM_TYPE) : (stringArray[i].equalsIgnoreCase("pmIpFlowMaxOutBitrate") ? pmRequestContextImpl.getPmAttribute("pmIpFlowMaxOutBitrate", LONG_PM_TYPE) : (stringArray[i].equalsIgnoreCase("pmIpFlowMinOutBitrate") ? pmRequestContextImpl.getPmAttribute("pmIpFlowMinOutBitrate", LONG_PM_TYPE) : super.getAttribute(stringArray[i], coordinator))))))));
        }
        this.onGetAttributes((GetRequestContext)getRequestContextImpl);
        return objectArray;
    }

    public void addParameterNames(ParameterNames parameterNames) {
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        SetRequestContextImpl setRequestContextImpl = new SetRequestContextImpl(stringArray, objectArray, coordinator);
        String string = null;
        Object object = null;
        setRequestContextImpl.assertNoDuplicateAttributes("IpFlowMonitor");
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            object = objectArray[i];
            if (string.equalsIgnoreCase("userLabel")) {
                if (object instanceof String) {
                    String string2 = (String)object;
                    this.validateUserLabel(string2, (SetRequestContext)setRequestContextImpl);
                    ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string2);
                    continue;
                }
                throw new WrongAttributeTypeException("userLabel", "IpFlowMonitor");
            }
            if (string.equalsIgnoreCase("remoteIpAddress")) {
                if (object instanceof String) {
                    String string3 = (String)object;
                    this.validateRemoteIpAddress(string3, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new StringParameter("remoteIpAddress", string3));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("remoteIpAddress", "IpFlowMonitor");
            }
            if (string.equalsIgnoreCase("samplingInterval")) {
                if (object instanceof Integer) {
                    int n = (Integer)object;
                    this.validateSamplingInterval(n, (SetRequestContext)setRequestContextImpl);
                    setRequestContextImpl.addParameter(this.froProxy, (Parameter)new SignedIntParameter("samplingInterval", n));
                    setRequestContextImpl.addAvcNotification(string, object);
                    continue;
                }
                throw new WrongAttributeTypeException("samplingInterval", "IpFlowMonitor");
            }
            throw new NoSuchAttributeException(string, "IpFlowMonitor");
        }
        this.onSetAttributes((SetRequestContext)setRequestContextImpl);
        setRequestContextImpl.sendSetRequest(this.froProxy, this.getFroId(coordinator));
        setRequestContextImpl.sendAvcNotifications((ManagedObject)this);
    }

    protected void validateUserLabel(String string, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkStringWithLength((String)string, (String)"userLabel", (int)128, (int)0, (String)"IpFlowMonitor");
    }

    protected void validateDscpValue(int[] nArray, SetRequestContext setRequestContext) throws MoAccessException {
        MoGenUtil.checkIntegerArrayAttribute((String)"dscpValue", (int[])nArray, (int)0, (int)63, (int)1, (int)64, (String)"IpFlowMonitor");
        MoGenUtil.checkUniquenessOfArray((String)"dscpValue", (Object)nArray, (String)"IpFlowMonitor");
    }

    protected void validateRemoteIpAddress(String string, SetRequestContext setRequestContext) throws MoAccessException {
    }

    protected void validateSamplingInterval(int n, SetRequestContext setRequestContext) throws MoAccessException {
        int[] nArray = new int[]{1, 10, 30, 60, 300};
        int[] nArray2 = new int[]{1, 10, 30, 60, 300};
        MoGenUtil.checkIntegerAttribute((String)"samplingInterval", (int)n, (int[])nArray, (int[])nArray2, (String)"IpFlowMonitor");
    }
}

