/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.HashSet;
import java.util.StringTokenizer;
import se.ericsson.cello.iptransport.IpAccessHostGpbMo;
import se.ericsson.cello.iptransport.IpAccessHostSpbMo;
import se.ericsson.cello.iptransport.IpInterface;
import se.ericsson.cello.iptransport.IpInterfaceGroupMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.VpnInterfaceBuildIF;
import se.ericsson.cello.mao.IpFormatException;
import se.ericsson.cello.mao.IpValidatorCommon;
import se.ericsson.cello.mao.NetworkAddress;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCardinalityViolationException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class IpValidator {
    public static void validateAddressTowardsInterface(String string, ManagedObject managedObject, String string2, Coordinator coordinator) throws MoAccessException {
        NetworkAddress networkAddress = null;
        if (managedObject instanceof IpInterface) {
            networkAddress = ((IpInterface)managedObject).getNetworkAddress(coordinator);
            String string3 = networkAddress.getSubnet();
            int n = networkAddress.getNetworkPrefix();
            IpValidatorCommon.validateIpAddrWithinSubnet((int)n, (String)string3, (String)string, (String)string2);
        } else if (!(managedObject instanceof VpnInterfaceBuildIF)) {
            throw new WrongAttributeTypeException("validateAddressTowardsInterface failed, MAO instance of wrong type", string2);
        }
    }

    public static void checkCombinedHostCardinality(ManagedObject managedObject, String string) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        int n = 0;
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!(managedObject2 instanceof IpAccessHostSpbMo) && !(managedObject2 instanceof IpAccessHostGpbMo)) continue;
            ++n;
        }
        if (n >= 128) {
            throw new MoCardinalityViolationException(string);
        }
    }

    public static void checkIpaddressFormat(String string) throws IpFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n3;
        }
        if (n3 != 3) {
            throw new IpFormatException("Not a valid IP address");
        }
        while (stringTokenizer.hasMoreTokens()) {
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IpFormatException("Not a valid IP address");
            }
            if (n < 0 || n > 255) {
                throw new IpFormatException("Not a valid IP address");
            }
            ++n2;
        }
        if (n2 != 4) {
            throw new IpFormatException("Not a valid IP address");
        }
    }

    public static void checkInterfacesNotSameInstance(ManagedObject managedObject, ManagedObject managedObject2) throws MoAccessException {
        if (managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
            throw new ValueOutOfRangeException("Attributes interface1 and interface2 must not be the same MO instance", "IpAccessHostSpb");
        }
        if (managedObject.getType().equals("IpInterface") && managedObject2.getType().equals("IpInterface") && managedObject.getParent().getParent().getLocalDistinguishedName().equals(managedObject2.getParent().getParent().getLocalDistinguishedName())) {
            throw new ValueOutOfRangeException("Attributes interface1 and interface2 must not be on same ET-IP boards", "IpAccessHostGpb");
        }
    }

    public static void checkInterfacesNotSameInstance(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        if (managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
            throw new ValueOutOfRangeException("Attributes interface1 and interface2 must not be the same MO instance", "IpAccessHostSpb");
        }
        if (managedObject instanceof IpInterfaceMo) {
            if (managedObject.getParent().getParent().getLocalDistinguishedName().equals(managedObject2.getParent().getParent().getLocalDistinguishedName())) {
                throw new ValueOutOfRangeException("Attributes interface1 and interface2 must not be on same ET boards", "IpAccessHostGpb");
            }
        } else if (managedObject instanceof IpInterfaceGroupMo) {
            HashSet hashSet = new HashSet();
            IpValidator.validateGroupInterfaces(managedObject, hashSet, coordinator);
            IpValidator.validateGroupInterfaces(managedObject2, hashSet, coordinator);
        }
    }

    public static void validateGroupInterfaces(ManagedObject managedObject, HashSet hashSet, Coordinator coordinator) throws MoAccessException {
        IpInterfaceMo ipInterfaceMo = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getPrimaryIpInterfaceRef(coordinator);
        IpInterfaceMo ipInterfaceMo2 = (IpInterfaceMo)((IpInterfaceGroupMo)managedObject).getSecondaryIpInterfaceRef(coordinator);
        if (!hashSet.add(ipInterfaceMo.getParent().getParent().getLocalDistinguishedName()) || !hashSet.add(ipInterfaceMo2.getParent().getParent().getLocalDistinguishedName())) {
            throw new ValueOutOfRangeException("Configured IpInterfaces must not be on the same ET board", "IpAccessHostGpb");
        }
    }

    public static void checkForZeroIpAddress(String string) throws MoAccessException {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreElements()) {
            n = Integer.parseInt(stringTokenizer.nextToken());
            if (n != 0) continue;
            ++n2;
        }
        if (n2 == 4) {
            throw new OperationNotAllowedException("ntpServerIpAddress must be a valid IP address. 0.0.0.0 is not allowed", "IpSyncRef");
        }
    }
}

