/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.equipment.PiuUtils;
import se.ericsson.cello.equipment.PlugInUnitMaoi;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.ipoam.IpHostLinkIpInterfaceBuildIF;
import se.ericsson.cello.iptransport.AccessControlListMo;
import se.ericsson.cello.iptransport.AccessControlListMoImpl;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.TrafficSchedulerMo;
import se.ericsson.cello.iptransport.TrafficSchedulerMoImpl;
import se.ericsson.cello.iptransport.VlanInfo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.Ipv6Address;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StringParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumStateValsCheck;
import se.ericsson.cello.transaction.Coordinator;

public class Ipv6InterfaceMoImpl
extends CelloMao
implements Ipv6InterfaceMo,
Reservable,
IpHostLinkIpInterfaceBuildIF {
    private boolean mtuCheck = true;
    private static TransactionalFroIdMap froIds = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private MoData data;
    protected static final int MTU_IEEE_802_3_LLC_SNAP_MAX = 1492;
    protected static final int MTU_FOR_NON_BACLPLANE_PORTS_MAX = 1500;
    private static final int MAX_NO_OF_IPHOSTLINK_RESERVERS = 1;
    private static final String IPHOSTLINK_CLASSNAME = "se.ericsson.cello.ipoam.IpHostLinkMoImpl";
    private static final int VID_MIN = 0;
    private static final int VID_MAX = 4094;
    private static final int VID_DEFAULT = 1;
    private static final boolean V_LAN_DEFAULT = false;
    public static final String PIU_FRO_ID = "piuFroId";
    private int thePiuFroId = 0;
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MO_DATA_REVISION_9_1 = 9100;
    private static final int MO_DATA_REVISION_9_2 = 9200;
    private static final int MO_DATA_REVISION_LATEST = 9200;
    private FroProxy ipv6InterfaceProxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    public static final String CURRENT_PM_REGISTER = "currentPmRegister";
    private static Class[] trafficSchedulerClass = new Class[]{TrafficSchedulerMo.class};
    private static Class[] accessControlListClass = new Class[]{AccessControlListMo.class};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Ipv6Interface", (String)string);
        String[] stringArray = new String[]{"IpSystem"};
        MoAttributeValidator.checkParents((ManagedObject)managedObject, (String[])stringArray);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Ipv6Interface", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"mtu", (AttrList)attrList, (boolean)false, (int)1500, (int)1280, (int)2018, (String)"Ipv6Interface");
        int n2 = MoAttributeValidator.checkAndGetEnumAttribute((String)"logging", (AttrList)attrList, (boolean)false, (int)0, (int[])EnumStateValsCheck.VALUES_ARRAY, (String)"Ipv6Interface");
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"ethernetRef", (AttrList)attrList, (boolean)true, (Class)GigaBitEthernetMo.class, (String)"Ipv6Interface");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"trafficSchedulerRef", (AttrList)attrList, (boolean)false, (Class[])trafficSchedulerClass, (String)"Ipv6Interface");
        ManagedObject managedObject5 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"accessControlListRef", (AttrList)attrList, (boolean)false, (Class[])accessControlListClass, (String)"Ipv6Interface");
        VlanInfo vlanInfo = Ipv6InterfaceMoImpl.analyzeVlanInfo(managedObject3, attrList, managedObject, coordinator);
        Ipv6InterfaceMoImpl.checkMtu(n, managedObject3, coordinator);
        int n3 = 0;
        if (managedObject4 != null) {
            n3 = ((TrafficSchedulerMoImpl)managedObject4).getFroId(coordinator);
        }
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Ipv6Interface");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter("mtu", n));
        arrayList.add(new SignedIntParameter("logging", n2));
        arrayList.add(new StringParameter("Ipv6InterfaceId", "Ipv6Interface=" + string));
        int n4 = ((FroInfo)managedObject3).getFroId(coordinator);
        arrayList.add(new SignedIntParameter("ethernetRef", n4));
        arrayList.add(new UnsignedIntParameter("trafficSchedulerRef", (long)n3));
        int n5 = 0;
        if (managedObject5 != null) {
            Ipv6InterfaceMoImpl.checkAccessControlListConfiguration(managedObject5, coordinator);
            n5 = ((AccessControlListMoImpl)managedObject5).getFroId(coordinator);
        }
        arrayList.add(new UnsignedIntParameter("accessControlListRef", (long)n5));
        ManagedObject managedObject6 = vlanInfo.getVlanRef();
        arrayList.addAll(vlanInfo.packVlanInfo(coordinator).values());
        return new Ipv6InterfaceMoImpl(managedObject, string, string2, managedObject3, managedObject4, managedObject5, managedObject6, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    private static void checkAccessControlListConfiguration(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        Struct struct;
        String string;
        Struct[] structArray = ((AccessControlListMo)managedObject).getAclEntries(coordinator);
        if (structArray != null && structArray.length != 0 && !Ipv6Address.isIpv6((String)(string = (String)(struct = structArray[0]).getValue("localIpAddress")))) {
            throw new IllegalAttributeValueException("Ipv6InterfaceMO can refer to AccessControlListMO which contains Ipv6 addresses only", "Ipv6Interface");
        }
    }

    private Ipv6InterfaceMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ManagedObject managedObject3, ManagedObject managedObject4, ManagedObject managedObject5, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "Ipv6Interface", string, coordinator);
        this.ipv6InterfaceProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.thePiuFroId = ((PlugInUnitMaoi)managedObject2.getParent().getParent()).getResourceId(coordinator);
        SignedIntParameter signedIntParameter = new SignedIntParameter(PIU_FRO_ID, this.thePiuFroId);
        arrayList.add(signedIntParameter);
        FroData froData = this.ipv6InterfaceProxy.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("ethernetRef", true, managedObject2));
        if (null != managedObject2) {
            ((Reservable)managedObject2).reserve((ManagedObject)this, coordinator);
        }
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("trafficSchedulerRef", true, managedObject3));
        if (managedObject3 != null) {
            ((Reservable)managedObject3).reserve((ManagedObject)this, coordinator);
        }
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("vlanRef", true, managedObject5));
        if (managedObject4 != null) {
            ((Reservable)managedObject4).reserve((ManagedObject)this, coordinator);
        }
        if (null != managedObject5) {
            ((Reservable)managedObject5).reserve((ManagedObject)this, coordinator);
        }
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        froIds.put(n, (ManagedObject)this, coordinator);
        this.data.setRevision(9200);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Ipv6InterfaceMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.ipv6InterfaceProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9200);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("ethernetRef");
        moDataRecoveryHelper.assertAttribute("trafficSchedulerRef");
        moDataRecoveryHelper.assertAttribute("vlanRef");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
        froIds.put(((IntegerAttribute)this.data.getAttribute("froId")).getValue(null), (ManagedObject)this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.releaseReference(coordinator, "ethernetRef");
        this.releaseReference(coordinator, "trafficSchedulerRef");
        this.releaseReference(coordinator, "vlanRef");
        this.releaseReference(coordinator, "accessControlListRef");
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException("Ipv6Interface");
        }
        this.ipv6InterfaceProxy.delete(coordinator, this.getFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        froIds.remove(this.getFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void releaseReference(Coordinator coordinator, String string) throws MoAccessException {
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        ManagedObject managedObject = (ManagedObject)objectArray[0];
        if (managedObject != null) {
            ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        }
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getVid(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("vid", coordinator);
    }

    public void setVid(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vid", new Integer(n), coordinator);
    }

    public boolean getVLan(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("vLan", coordinator);
    }

    public void setVLan(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vLan", new Boolean(bl), coordinator);
    }

    public int getMtu(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("mtu", coordinator);
    }

    public void setMtu(int n, Coordinator coordinator) throws MoAccessException {
        this.mtuCheckOn();
        this.setAttribute("mtu", new Integer(n), coordinator);
    }

    public ManagedObject getEthernetRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ethernetRef", coordinator);
    }

    public String getInterfaceName(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("interfaceName", coordinator);
    }

    public void setTrafficSchedulerRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("trafficSchedulerRef", managedObject, coordinator);
    }

    public ManagedObject getTrafficSchedulerRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("trafficSchedulerRef", coordinator);
    }

    public ManagedObject getAccessControlListRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("accessControlListRef", coordinator);
    }

    public void setAccessControlListRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("accessControlListRef", managedObject, coordinator);
    }

    public int getLogging(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("logging", coordinator);
    }

    public void setLogging(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("logging", new Integer(n), coordinator);
    }

    public ManagedObject getVlanRef(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("vlanRef", coordinator);
    }

    public void setVlanRef(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vlanRef", managedObject, coordinator);
    }

    public long getPmIfStatsHCIpInMcastOctets(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmIfStatsHCIpInMcastOctets", coordinator);
    }

    public long getPmIfStatsHCIpInMcastPkts(Coordinator coordinator) throws MoAccessException {
        return ((Integer)this.getAttribute("pmIfStatsHCIpInMcastPkts", coordinator)).longValue();
    }

    public long getPmIfStatsHCIpOutMcastOctets(Coordinator coordinator) throws MoAccessException {
        return ((Integer)this.getAttribute("pmIfStatsHCIpOutMcastOctets", coordinator)).longValue();
    }

    public long getPmIfStatsHCIpOutMcastPkts(Coordinator coordinator) throws MoAccessException {
        return ((Integer)this.getAttribute("pmIfStatsHCIpOutMcastPkts", coordinator)).longValue();
    }

    public int getPmIpIfStatsOutDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsOutDiscards", coordinator);
    }

    public long getPmIpIfStatsHCInReceives(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIpIfStatsHCInReceives", coordinator)).intValue();
    }

    public long getPmIpIfStatsHCInOctets(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIpIfStatsHCInOctets", coordinator)).intValue();
    }

    public long getPmIpIfStatsHCOutOctets(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIpIfStatsHCOutOctets", coordinator)).intValue();
    }

    public long getPmIpIfStatsHCOutTransmits(Coordinator coordinator) throws MoAccessException {
        return ((Long)this.getAttribute("pmIpIfStatsHCOutTransmits", coordinator)).intValue();
    }

    public int getPmIpIfStatsInHdrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInHdrErrors", coordinator);
    }

    public int getPmIpIfStatsInAddrErrors(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInAddrErrors", coordinator);
    }

    public int getPmIpIfStatsInUnknownProtos(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInUnknownProtos", coordinator);
    }

    public int getPmIpIfStatsReasmReqds(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsReasmReqds", coordinator);
    }

    public int getPmIpIfStatsReasmFails(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsReasmFails", coordinator);
    }

    public int getPmIpIfStatsInDiscards(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsInDiscards", coordinator);
    }

    public int getPmIpIfStatsOutFragCreates(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmIpIfStatsOutFragCreates", coordinator);
    }

    public int getPmUdpIfStatsInError(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUdpIfStatsInError", coordinator);
    }

    public long getPmInDiscPolicy(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmInDiscPolicy", coordinator);
    }

    public long getPmInPassedPolicy(Coordinator coordinator) throws MoAccessException {
        return (Long)this.getAttribute("pmInPassedPolicy", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute(CURRENT_PM_REGISTER, coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("Ipv6InterfaceId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vid")) {
                map = this.getAttrFromRes(map, coordinator);
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("vid");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vLan")) {
                map = this.getAttrFromRes(map, coordinator);
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("vLan");
                objectArray[i] = new Boolean(signedIntParameter.getBoolean());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ethernetRef")) {
                Attribute attribute = this.data.getAttribute("ethernetRef");
                if (null != attribute) {
                    objectArray[i] = ((ReferenceAttribute)attribute).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vlanRef")) {
                Attribute attribute = this.data.getAttribute("vlanRef");
                if (null != attribute) {
                    objectArray[i] = ((ReferenceAttribute)attribute).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mtu")) {
                map = this.getAttrFromRes(map, coordinator);
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("mtu");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("interfaceName")) {
                map = this.getAttrFromRes(map, coordinator);
                StringParameter stringParameter = (StringParameter)map.get("interfaceName");
                objectArray[i] = stringParameter.getValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trafficSchedulerRef")) {
                Attribute attribute = this.data.getAttribute("trafficSchedulerRef");
                if (null != attribute) {
                    objectArray[i] = ((ReferenceAttribute)attribute).getValue(coordinator);
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("accessControlListRef")) {
                int n = (int)((UnsignedIntParameter)(map = this.getAttrFromRes(map, coordinator)).get("accessControlListRef")).getValue();
                ManagedObject managedObject = MaoFroTypeConverter.froId2MaoInstance((String)"AccessControlList", (int)n, (Coordinator)coordinator);
                if (null != managedObject) {
                    objectArray[i] = managedObject;
                    continue;
                }
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logging")) {
                map = this.getAttrFromRes(map, coordinator);
                SignedIntParameter signedIntParameter = (SignedIntParameter)map.get("logging");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsOutDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsOutDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsHCInReceives")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmIpIfStatsHCInReceives", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsHCInOctets")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmIpIfStatsHCInOctets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsHCOutOctets")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmIpIfStatsHCOutOctets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsHCOutTransmits")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmIpIfStatsHCOutTransmits", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInHdrErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInHdrErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInAddrErrors")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInAddrErrors", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInUnknownProtos")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInUnknownProtos", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsReasmReqds")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsReasmReqds", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsReasmFails")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsReasmFails", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsInDiscards")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsInDiscards", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIpIfStatsOutFragCreates")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmIpIfStatsOutFragCreates", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUdpIfStatsInError")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmUdpIfStatsInError", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsHCIpInMcastOctets")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmIfStatsHCIpInMcastOctets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsHCIpInMcastPkts")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmIfStatsHCIpInMcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsHCIpOutMcastOctets")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmIfStatsHCIpOutMcastOctets", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmIfStatsHCIpOutMcastPkts")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmIfStatsHCIpOutMcastPkts", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInPassedPolicy")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmInPassedPolicy", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmInDiscPolicy")) {
                objectArray[i] = new Long(super.getPmLongAttribute("pmInDiscPolicy", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(CURRENT_PM_REGISTER)) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Ipv6Interface");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.ipv6InterfaceProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    private void mtuCheckOn() {
        this.mtuCheck = true;
    }

    private void mtuCheckOff() {
        this.mtuCheck = false;
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        Map map;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map2 = this.prepareSetFroAttr(coordinator);
        HashMap hashMap = (HashMap)((HashMap)map2).clone();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? Ipv6InterfaceMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Ipv6Interface");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Ipv6Interface", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vlanRef")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vid")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vLan")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("mtu")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Ipv6InterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("mtu", "Ipv6Interface");
                }
                int n2 = (Integer)objectArray[i];
                if (this.mtuCheck) {
                    MoAttributeValidator.checkIntegerAttribute((String)"mtu", (int)n2, (int)1280, (int)2018, (String)"Ipv6Interface");
                    Ipv6InterfaceMoImpl.checkMtu(n2, this.getEthernetRef(coordinator), coordinator);
                }
                map2.put("mtu", new SignedIntParameter("mtu", n2));
                this.sendNotification("mtu", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("logging")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Ipv6InterfaceMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("logging", "Ipv6Interface");
                }
                int n3 = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"logging", (int)n3, (int)0, (int)1, (String)"Ipv6Interface");
                map2.put("logging", new SignedIntParameter("logging", n3));
                this.sendNotification("logging", new Integer(n3), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("accessControlListRef")) {
                int n4;
                ManagedObject managedObject = (ManagedObject)this.getAttribute("accessControlListRef", coordinator);
                n = 0;
                if (objectArray[i] == null) {
                    if (managedObject != null) {
                        n4 = 0;
                        map2.put("accessControlListRef", new UnsignedIntParameter("accessControlListRef", (long)n4));
                        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                        n = 1;
                    }
                } else {
                    if (!(objectArray[i] instanceof AccessControlListMo)) {
                        throw new WrongAttributeTypeException("accessControlListRef", "Ipv6Interface");
                    }
                    Ipv6InterfaceMoImpl.checkAccessControlListConfiguration((ManagedObject)objectArray[i], coordinator);
                    if (managedObject == null) {
                        n4 = ((AccessControlListMoImpl)objectArray[i]).getFroId(coordinator);
                        map2.put("accessControlListRef", new UnsignedIntParameter("accessControlListRef", (long)n4));
                        ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                        n = 1;
                    } else if (!((AccessControlListMoImpl)objectArray[i]).equals(managedObject)) {
                        n4 = ((AccessControlListMoImpl)objectArray[i]).getFroId(coordinator);
                        map2.put("accessControlListRef", new UnsignedIntParameter("accessControlListRef", (long)n4));
                        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                        ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                        n = 1;
                    }
                }
                if (n != true) continue;
                this.sendNotification("accessControlListRef", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("trafficSchedulerRef")) {
                ManagedObject managedObject = (ManagedObject)this.getAttribute("trafficSchedulerRef", coordinator);
                if (objectArray[i] == null) {
                    if (managedObject == null) continue;
                    n = 0;
                    map2.put("trafficSchedulerRef", new UnsignedIntParameter("trafficSchedulerRef", (long)n));
                    ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                    ((ReferenceAttribute)this.data.getAttribute("trafficSchedulerRef")).setValue((ManagedObject)objectArray[i]);
                    continue;
                }
                if (!(objectArray[i] instanceof TrafficSchedulerMo)) {
                    throw new WrongAttributeTypeException("trafficSchedulerRef", "Ipv6Interface");
                }
                if (managedObject == null) {
                    n = ((TrafficSchedulerMoImpl)objectArray[i]).getFroId(coordinator);
                    map2.put("trafficSchedulerRef", new UnsignedIntParameter("trafficSchedulerRef", (long)n));
                    ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                    ((ReferenceAttribute)this.data.getAttribute("trafficSchedulerRef")).setValue((ManagedObject)objectArray[i]);
                    continue;
                }
                if (((TrafficSchedulerMoImpl)objectArray[i]).equals(managedObject)) continue;
                n = ((TrafficSchedulerMoImpl)objectArray[i]).getFroId(coordinator);
                map2.put("trafficSchedulerRef", new UnsignedIntParameter("trafficSchedulerRef", (long)n));
                ((Reservable)managedObject).release((ManagedObject)this, coordinator);
                ((Reservable)objectArray[i]).reserve((ManagedObject)this, coordinator);
                ((ReferenceAttribute)this.data.getAttribute("trafficSchedulerRef")).setValue((ManagedObject)objectArray[i]);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Ipv6Interface");
        }
        if (bl && null != (map = this.setVlanAttributes(this.getEthernetRef(coordinator), stringArray, objectArray, coordinator))) {
            map2.putAll(map);
        }
        if (this.doesFroParametersDiffer(hashMap, (HashMap)map2)) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(map2.values());
            this.ipv6InterfaceProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    private boolean doesFroParametersDiffer(HashMap hashMap, HashMap hashMap2) {
        if (hashMap.size() != hashMap2.size()) {
            return true;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (hashMap2.containsKey(string)) {
                Object v = hashMap.get(string);
                Object v2 = hashMap2.get(string);
                if (v.toString().equals(v2.toString())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private Map prepareSetFroAttr(Coordinator coordinator) throws MoAccessException {
        Map map = this.ipv6InterfaceProxy.getAttributes(coordinator, this.getFroId(coordinator), null);
        return map;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    private int getNoOfReservers(String string, Coordinator coordinator) throws MoAccessException {
        return ReservableImpl.noOfReservers((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (String)string, (Coordinator)coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n = 0;
        if (managedObject.getType().equals("IpHostLink")) {
            n = this.getNoOfReservers(IPHOSTLINK_CLASSNAME, coordinator);
        }
        if (n >= 1) {
            throw new MaxNumberExceededException("Max number of " + managedObject.getType() + " reservers is exceeded", "Ipv6Interface");
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    private static void checkMtu(int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n2;
        if (n > 1492 && (n2 = ((Integer)managedObject.getAttribute("frameFormat", coordinator)).intValue()) == 1) {
            throw new ValueOutOfRangeException("frameFormat in GigaBitEthernet is set to " + n2 + ". The value on " + "mtu" + " can not exceed " + 1492, "Ipv6Interface");
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private static VlanInfo analyzeVlanInfo(ManagedObject managedObject, AttrList attrList, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException, OperationNotAllowedException {
        VlanInfo vlanInfo = new VlanInfo(attrList, managedObject2, null);
        vlanInfo.creationCheck(managedObject, attrList, coordinator);
        Ipv6InterfaceMoImpl.removeAttr("vid", attrList);
        Ipv6InterfaceMoImpl.removeAttr("vLan", attrList);
        return vlanInfo;
    }

    private Map setVlanAttributes(ManagedObject managedObject, String[] stringArray, Object[] objectArray, Coordinator coordinator) throws WrongAttributeTypeException, MoAccessException, OperationNotAllowedException {
        VlanInfo vlanInfo = new VlanInfo(stringArray, objectArray, (ManagedObject)this);
        vlanInfo.setAttrCheck(managedObject, coordinator);
        vlanInfo.sendAVC(coordinator);
        vlanInfo.storeIntoMoData(this.data, coordinator);
        return vlanInfo.packVlanInfo(coordinator);
    }

    public int getConnectedPiuFroId(Coordinator coordinator) throws MoAccessException {
        return PiuUtils.findPiuParentFroId((ManagedObject)this.getEthernetRef(coordinator));
    }

    public int getFroType(Coordinator coordinator) throws MoAccessException {
        return Integer.parseInt("E09", 16);
    }

    public static Ipv6InterfaceMoImpl lookupInstance(int n, Coordinator coordinator) throws TransactionRequiredException {
        return (Ipv6InterfaceMoImpl)froIds.get(n, coordinator);
    }

    private static void removeAttr(String string, AttrList attrList) {
        int n = attrList.indexOf(string);
        if (-1 == n) {
            return;
        }
        attrList.removeElementAt(n);
    }
}

