/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.IcmpMoFactory;
import se.ericsson.cello.iptransport.IcmpMoImpl;
import se.ericsson.cello.iptransport.Ipv6Mo;
import se.ericsson.cello.iptransport.ipv6_mi;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.proxy.MaoFroGenericParameterChdInd;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.mom.commondefinitions.EnumActivationValsCheck;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class Ipv6MoImpl
extends CelloMao
implements Ipv6Mo,
FroInfo {
    private MoData data;
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private FroProxy ipv6Proxy = null;
    private MaoFroIndicationHandler indicationHandler = null;
    private static TagNameDictionary tnd = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(ipv6_mi.class.getName()));
    public static int MAX_NUMBER_IPV6 = 1;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, IcmpMoFactory icmpMoFactory) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"Ipv6", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"IpSystem");
        MoAttributeValidator.checkCardinality((String)"Ipv6", (int)MAX_NUMBER_IPV6);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Ipv6", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"featureState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"Ipv6");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Ipv6");
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        SignedIntParameter signedIntParameter = new SignedIntParameter("featureState", n);
        arrayList.add(signedIntParameter);
        return new Ipv6MoImpl(managedObject, string, string2, arrayList, coordinator, froProxy, maoFroIndicationHandler, icmpMoFactory);
    }

    private Ipv6MoImpl(ManagedObject managedObject, String string, String string2, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler, IcmpMoFactory icmpMoFactory) throws MoAccessException {
        super(managedObject, "Ipv6", string, coordinator);
        this.ipv6Proxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.ipv6Proxy.create(coordinator, (Collection)arrayList);
        int n = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n);
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        icmpMoFactory.autoCreateMo(managedObject, "1", coordinator);
    }

    public Ipv6MoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.ipv6Proxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.ipv6Proxy.delete(coordinator, this.getFroId(coordinator), null);
        MoIterator moIterator = MoRepository.instance().lookupType("Icmp");
        while (moIterator.hasMoreElements()) {
            IcmpMoImpl icmpMoImpl = (IcmpMoImpl)moIterator.nextMo();
            icmpMoImpl.deleteMo(coordinator);
        }
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getType() {
        return "Ipv6";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public int getFeatureState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("featureState", coordinator);
    }

    public int getLicenseState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("licenseState", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setFeatureState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("featureState", new Integer(n), coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.ipv6Proxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("Ipv6Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("featureState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("featureState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("licenseState")) {
                map = this.getAttrFromRes(map, coordinator);
                signedIntParameter = (SignedIntParameter)map.get("licenseState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Ipv6");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        if (coordinator == null) {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
        }
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? Ipv6MoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Ipv6");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Ipv6", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("featureState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? Ipv6MoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("featureState", "Ipv6");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkEnumAttribute((String)"featureState", (int)n, (int[])EnumActivationValsCheck.VALUES_ARRAY, (String)"Ipv6");
                arrayList.add(new SignedIntParameter("featureState", n));
                this.sendNotification("featureState", new Integer(n), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Ipv6");
        }
        if (arrayList.size() > 0) {
            this.ipv6Proxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public void parameterChanged(MaoFroGenericParameterChdInd maoFroGenericParameterChdInd) {
        String[] stringArray;
        SignedIntParameter signedIntParameter = null;
        try {
            stringArray = maoFroGenericParameterChdInd.getParameters(tnd);
            signedIntParameter = (SignedIntParameter)stringArray.get("licenseState");
        }
        catch (MoAccessException moAccessException) {
            MessageLog.traceError(this.getClass(), (String)"Unable to translate parameters in indication signal", (Throwable)moAccessException);
        }
        if (signedIntParameter != null) {
            stringArray = new String[]{new String("licenseState")};
            Object[] objectArray = new Object[1];
            Integer n = new Integer(signedIntParameter.getValue());
            objectArray[0] = n;
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        } else {
            MessageLog.traceError(this.getClass(), (String)"Unknown attribute in parameterChanged()");
        }
    }
}

