/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.iptransport.DscpQueueMap;
import se.ericsson.cello.iptransport.GigaBitEthernetMo;
import se.ericsson.cello.iptransport.IpInterfaceMo;
import se.ericsson.cello.iptransport.Ipv6InterfaceMo;
import se.ericsson.cello.iptransport.TmQueueMo;
import se.ericsson.cello.iptransport.TmQueueMoImpl;
import se.ericsson.cello.iptransport.TrafficSchedulerMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrListImpl;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class TrafficSchedulerMoImpl
extends CelloMao
implements TrafficSchedulerMo,
Reservable {
    private MoData data;
    private FroProxy genericProxyInstance;
    private MaoFroIndicationHandler indicationHandler;
    private static final int MO_DATA_REVISION_9 = 9000;
    private static final int MAX_NO_OF_SIBLINGS = 1;
    private static final int QUEUE_WEIGHT_MAX = 100;
    private static final int MO_DATA_REVISION_LATEST = 9000;
    private StringAttribute userLabel;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        int n;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"TrafficScheduler", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TrafficManagement");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"TrafficScheduler", (int)128, (int)0);
        DscpQueueMap dscpQueueMap = TrafficSchedulerMoImpl.checkAndGetDscpQueueMap(attrList);
        int n2 = TrafficSchedulerMoImpl.checkAndGetIntegerAttribute("egressCbs", attrList, false, 0, "TrafficScheduler");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"egressCir", (AttrList)attrList, (boolean)false, (int)0, (int[])new int[]{0, 2}, (int[])new int[]{0, 1000}, (String)"TrafficScheduler");
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"egressCirLow", (AttrList)attrList, (boolean)false, (int)0, (int[])new int[]{0, 1}, (int[])new int[]{0, 100}, (String)"TrafficScheduler");
        if (n4 != 0) {
            MoIterator moIterator = managedObject.getChildren();
            n = 0;
            while (moIterator != null && moIterator.hasMoreElements()) {
                if (!moIterator.nextMo().getType().equals("TrafficScheduler") || ++n < 1) continue;
                throw new MaxNumberExceededException("TrafficScheduler", "Since there exists atleast one child under TrafficManagement MO, this MO cant be created with egressCirLow set to a non-zero value.");
            }
            if (n3 != 0) {
                throw new MoCanNotBeCreatedException("TrafficScheduler");
            }
        }
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"wpStartQueue", (AttrList)attrList, (boolean)false, (int)1000, (int[])new int[]{1, 1000}, (int[])new int[]{8, 1000}, (String)"TrafficScheduler");
        n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"wpEndQueue", (AttrList)attrList, (boolean)false, (int)1000, (int[])new int[]{2, 1000}, (int[])new int[]{8, 1000}, (String)"TrafficScheduler");
        TrafficSchedulerMoImpl.wpQueuesRangeCheck(n5, n);
        ArrayParameter arrayParameter = dscpQueueMap.toParameter();
        int n6 = dscpQueueMap.numberOfQueues();
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"TrafficScheduler");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new SignedIntParameter("egressCir", n3));
        arrayList.add(new SignedIntParameter("egressCirLow", n4));
        arrayList.add(new SignedIntParameter("egressCbs", n2));
        arrayList.add(new SignedIntParameter("wpStartQueue", n5));
        arrayList.add(new SignedIntParameter("wpEndQueue", n));
        arrayList.add(new SignedIntParameter("numberOfQueues", n6));
        arrayList.add(arrayParameter);
        return new TrafficSchedulerMoImpl(managedObject, string, string2, n6, arrayList, coordinator, froProxy, maoFroIndicationHandler);
    }

    public TrafficSchedulerMoImpl(MoData moData, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(9000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    private TrafficSchedulerMoImpl(ManagedObject managedObject, String string, String string2, int n, ArrayList arrayList, Coordinator coordinator, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "TrafficScheduler", string, coordinator);
        this.genericProxyInstance = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        FroData froData = this.genericProxyInstance.create(coordinator, (Collection)arrayList);
        int n2 = froData.getFroId();
        this.createQueues(n2, n, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n2));
        this.data.registerPersistentAttr((Attribute)new SequenceAttribute("reservedBy", false));
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n2);
        this.data.setRevision(9000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private void createQueues(int n, int n2, Coordinator coordinator) throws MoAccessException {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            String string = new String("" + (i + 1));
            String string2 = new String("");
            AttrListImpl attrListImpl = new AttrListImpl(3);
            attrListImpl.addElement("userLabel", (Object)string2);
            attrListImpl.addElement("tsFroId", (Object)new Integer(n));
            attrListImpl.addElement("queueNumber", (Object)new Integer(i + 1));
            ManagedObject managedObject = TmQueueMoImpl.create(this, (AttrList)attrListImpl, string, coordinator);
            nArray[i] = ((TmQueueMoImpl)managedObject).getFroId(coordinator);
        }
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedBy(coordinator).length != 0) {
            throw new MoReservedNotDeletableException((ManagedObject)this);
        }
        this.genericProxyInstance.delete(coordinator, this.getFroId(coordinator), null);
        MoIterator moIterator = this.getChildren();
        for (int i = 0; i < moIterator.size(); ++i) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof TmQueueMoImpl)) continue;
            ((TmQueueMoImpl)managedObject).deleteMo(coordinator);
        }
        this.indicationHandler.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        return this.getAttributes(new String[]{string}, coordinator)[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            DscpQueueMap dscpQueueMap;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("TrafficSchedulerId")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("dscpMap")) {
                map = this.getAttrFromRes(map, coordinator);
                dscpQueueMap = new DscpQueueMap((ArrayParameter)map.get("dscpMapArray"));
                objectArray[i] = dscpQueueMap.toStructs();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("egressCir")) {
                map = this.getAttrFromRes(map, coordinator);
                dscpQueueMap = (SignedIntParameter)map.get("egressCir");
                objectArray[i] = new Integer(dscpQueueMap.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("egressCirLow")) {
                map = this.getAttrFromRes(map, coordinator);
                dscpQueueMap = (SignedIntParameter)map.get("egressCirLow");
                objectArray[i] = new Integer(dscpQueueMap.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("egressCbs")) {
                map = this.getAttrFromRes(map, coordinator);
                dscpQueueMap = (SignedIntParameter)map.get("egressCbs");
                objectArray[i] = new Integer(dscpQueueMap.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("wpStartQueue")) {
                map = this.getAttrFromRes(map, coordinator);
                dscpQueueMap = (SignedIntParameter)map.get("wpStartQueue");
                objectArray[i] = new Integer(dscpQueueMap.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("wpEndQueue")) {
                map = this.getAttrFromRes(map, coordinator);
                dscpQueueMap = (SignedIntParameter)map.get("wpEndQueue");
                objectArray[i] = new Integer(dscpQueueMap.getValue());
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "TrafficScheduler");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Map map = this.prepareSetFroAttr(coordinator);
        int n = this.getEgressCirLow(coordinator);
        int n2 = this.getWpStartQueue(coordinator);
        int n3 = this.getWpEndQueue(coordinator);
        int n4 = Arrays.asList(stringArray).indexOf("egressCirLow");
        int n5 = Arrays.asList(stringArray).indexOf("wpStartQueue");
        int n6 = Arrays.asList(stringArray).indexOf("wpEndQueue");
        if (n4 != -1) {
            if (!objectArray[n4].getClass().equals(Integer.class)) {
                throw new WrongAttributeTypeException("egressCirLow", "TrafficScheduler");
            }
            n = (Integer)objectArray[n4];
        }
        if (n5 != -1) {
            if (!objectArray[n5].getClass().equals(Integer.class)) {
                throw new WrongAttributeTypeException("wpStartQueue", "TrafficScheduler");
            }
            n2 = (Integer)objectArray[n5];
            MoAttributeValidator.checkIntegerAttribute((String)"wpStartQueue", (int)n2, (int[])new int[]{1, 1000}, (int[])new int[]{8, 1000}, (String)"TrafficScheduler");
        }
        if (n6 != -1) {
            if (!objectArray[n6].getClass().equals(Integer.class)) {
                throw new WrongAttributeTypeException("wpEndQueue", "TrafficScheduler");
            }
            n3 = (Integer)objectArray[n6];
            MoAttributeValidator.checkIntegerAttribute((String)"wpEndQueue", (int)n3, (int[])new int[]{2, 1000}, (int[])new int[]{8, 1000}, (String)"TrafficScheduler");
        }
        TrafficSchedulerMoImpl.wpQueuesRangeCheck(n2, n3);
        if (this.getQueueWeights(n2, n3, coordinator) > 100) {
            throw new ValueOutOfRangeException("The sum of queueWeight for all queues belonging to the Weighted Priority Scheduling group can not exceed 100 ", "TrafficScheduler");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? TrafficSchedulerMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "TrafficScheduler");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"TrafficScheduler", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("egressCbs")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? TrafficSchedulerMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("egressCbs", "TrafficScheduler");
                }
                int n7 = (Integer)objectArray[i];
                if (n7 < 0) {
                    throw new ValueOutOfRangeException("egressCbs", "TrafficScheduler");
                }
                map.put("egressCbs", new SignedIntParameter("egressCbs", n7));
                this.sendNotification("egressCbs", new Integer(n7), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("egressCir")) {
                if (n == 0) {
                    if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? TrafficSchedulerMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                        throw new WrongAttributeTypeException("egressCir", "TrafficScheduler");
                    }
                    int n8 = (Integer)objectArray[i];
                    MoAttributeValidator.checkIntegerAttribute((String)"egressCir", (int)n8, (int[])new int[]{0, 2}, (int[])new int[]{0, 1000}, (String)"TrafficScheduler");
                    map.put("egressCir", new SignedIntParameter("egressCir", n8));
                    this.sendNotification("egressCir", new Integer(n8), coordinator);
                    continue;
                }
                throw new OperationNotAllowedException("egressCir cannot be set since egressCirLow is not zero", "TrafficScheduler");
            }
            if (stringArray[i].equalsIgnoreCase("egressCirLow")) {
                MoIterator moIterator = this.getParent().getChildren();
                int n9 = 0;
                while (moIterator != null && moIterator.hasMoreElements()) {
                    if (!moIterator.nextMo().getType().equals("TrafficScheduler") || ++n9 <= 1) continue;
                    throw new OperationNotAllowedException("Setting of egressCirLow not possible", "TrafficScheduler");
                }
                MoAttributeValidator.checkIntegerAttribute((String)"egressCirLow", (int)n, (int[])new int[]{0, 1}, (int[])new int[]{0, 100}, (String)"TrafficScheduler");
                map.put("egressCirLow", new SignedIntParameter("egressCirLow", n));
                this.sendNotification("egressCirLow", new Integer(n), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("wpStartQueue")) {
                map.put("wpStartQueue", new SignedIntParameter("wpStartQueue", n2));
                this.sendNotification("wpStartQueue", new Integer(n2), coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("wpEndQueue")) {
                map.put("wpEndQueue", new SignedIntParameter("wpEndQueue", n3));
                this.sendNotification("wpEndQueue", new Integer(n3), coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "TrafficScheduler");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(map.values());
        this.genericProxyInstance.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private Map prepareSetFroAttr(Coordinator coordinator) throws MoAccessException {
        Map map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator), null);
        return map;
    }

    private static DscpQueueMap checkAndGetDscpQueueMap(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("dscpMap");
        if (n == -1) {
            return new DscpQueueMap();
        }
        if (!(attrList.getValue(n) instanceof Struct[])) {
            throw new WrongAttributeTypeException("dscpMap", "TrafficScheduler");
        }
        DscpQueueMap dscpQueueMap = new DscpQueueMap((Struct[])attrList.getValue(n));
        attrList.removeElementAt(n);
        return dscpQueueMap;
    }

    private static int checkAndGetIntegerAttribute(String string, AttrList attrList, boolean bl, int n, String string2) throws MoAccessException {
        int n2 = attrList.indexOf(string);
        if (bl && n2 == -1) {
            throw new AttrMissingAtCreateException(string, string2);
        }
        if (!bl && n2 == -1) {
            return n;
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException(string, string2);
        }
        int n3 = (Integer)attrList.getValue(n2);
        if (n3 < 0) {
            throw new ValueOutOfRangeException(string, string2);
        }
        attrList.removeElementAt(n2);
        return n3;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getFroAttributes(coordinator);
        }
        return map;
    }

    private Map getFroAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genericProxyInstance.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public Struct[] getDscpMap(Coordinator coordinator) throws MoAccessException {
        return (Struct[])this.getAttribute("dscpMap", coordinator);
    }

    public void setEgressCbs(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("egressCbs", new Integer(n), coordinator);
    }

    public int getEgressCbs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("egressCbs", coordinator);
    }

    public void setEgressCir(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("egressCir", new Integer(n), coordinator);
    }

    public int getEgressCir(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("egressCir", coordinator);
    }

    public void setEgressCirLow(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("egressCirLow", new Integer(n), coordinator);
    }

    public int getEgressCirLow(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("egressCirLow", coordinator);
    }

    public void setWpStartQueue(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("wpStartQueue", new Integer(n), coordinator);
    }

    public int getWpStartQueue(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("wpStartQueue", coordinator);
    }

    public void setWpEndQueue(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("wpEndQueue", new Integer(n), coordinator);
    }

    public int getWpEndQueue(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("wpEndQueue", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"TrafficScheduler", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ReservableImpl.retrieveRefArrayFromSequence((SequenceAttribute)((SequenceAttribute)this.data.getAttribute("reservedBy")), (Coordinator)coordinator);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if ((managedObject instanceof IpInterfaceMo || managedObject instanceof Ipv6InterfaceMo) && !this.isTrafficSchedulerConsistent(managedObject, coordinator)) {
            throw new ConfigurationMismatchException("New " + managedObject.getType() + " reference to this MO must use the same GigabitEthernet MO as the other present in the list are using", "TrafficScheduler");
        }
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    private boolean isTrafficSchedulerConsistent(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ManagedObject[] managedObjectArray = this.getReservedBy(coordinator);
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>(Arrays.asList(managedObjectArray));
        arrayList.add(managedObject);
        HashSet<GigaBitEthernetMo> hashSet = new HashSet<GigaBitEthernetMo>();
        for (int i = 0; i < arrayList.size(); ++i) {
            MessageLog.info(this.getClass(), (String)"start FOR loop");
            if (arrayList.get(i) instanceof IpInterfaceMo) {
                MessageLog.info(this.getClass(), (String)"instanceof IpInterfaceMo");
                if (((IpInterfaceMo)arrayList.get(i)).getParent() instanceof GigaBitEthernetMo) {
                    MessageLog.info(this.getClass(), (String)"instanceof IpInterfaceMo/gigabitMo parent");
                    if (!hashSet.add((GigaBitEthernetMo)((IpInterfaceMo)arrayList.get(i)).getParent()) || hashSet.size() <= 1) continue;
                    return false;
                }
                MessageLog.info(this.getClass(), (String)"instanceof IpInterfaceMo/NOT gigabitMo parent");
                return false;
            }
            if (!(arrayList.get(i) instanceof Ipv6InterfaceMo)) continue;
            MessageLog.info(this.getClass(), (String)"instanceof Ipv6InterfaceMo");
            if (!hashSet.add((GigaBitEthernetMo)((Ipv6InterfaceMo)arrayList.get(i)).getEthernetRef(coordinator)) || hashSet.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private static void wpQueuesRangeCheck(int n, int n2) throws MoAccessException {
        if ((n != 1000 || n2 != 1000) && n >= n2) {
            throw new IllegalAttributeValueException("wpEndQueue should be greater than wpStartQueue. ", "TrafficScheduler");
        }
    }

    public int getQueueWeights(int n, int n2, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        int n3 = 0;
        String string = "";
        if (n == 1000) {
            return n3;
        }
        MoIterator moIterator = this.getChildren();
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            string = ((TmQueueMoImpl)managedObject).getQueueId(coordinator);
            if (!managedObject.getType().equals("TrafficManagementQueue") || Integer.parseInt(string) < n || Integer.parseInt(string) > n2) continue;
            n3 += ((TmQueueMo)managedObject).getQueueWeight(coordinator);
        }
        return n3;
    }

    public String getType() {
        return "TrafficScheduler";
    }

    public String getTrafficSchedulerId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("TrafficSchedulerId", coordinator);
    }
}

