/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.iptransport.fropxy;

import enea.ose.system.AttachSignal;
import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import java.util.ResourceBundle;
import se.ericsson.cello.common.fropxy.FroProxy;
import se.ericsson.cello.common.fropxy.FroReqU32U32;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiCreateCfm;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiCreateReq;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiDeleteCfm;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiGetAttrCfm;
import se.ericsson.cello.iptransport.fropxy.IpacAcMiNetworkAddress;
import se.ericsson.cello.maofro.proxy.TagNameDictionaries;
import se.ericsson.cello.maofro.proxy.TagNameDictionary;
import se.ericsson.cello.maofro.proxy.TagNameDictionaryException;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.session.PVSession;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.sigutil.SignalHelper;

public class IpacAcMiProxy
extends FroProxy {
    public static final int IPAC_ACMI_NONE = 0;
    public static final int IPAC_ACMI_OK = 1;
    public static final int IPAC_ACMI_INVALID_TRANSACTION_ID = 2;
    public static final int IPAC_ACMI_INVALID_ACFRO_ID = 3;
    public static final int IPAC_ACMI_IPADDR_STILL_USED = 4;
    public static final int IPAC_ACMI_INVALID_ACFRO_STATE = 5;
    public static final int IPAC_ACMI_REGISTER_ERROR = 6;
    public static final int IPAC_ACMI_EXCEEDS_NUM_OF_FRO = 7;
    public static final int IPAC_ACMI_BUSY_IN_TRANSACTION = 8;
    public static final int IPAC_ACMI_IPADDRESS_FORMAT_ERROR = 9;
    public static final int IPAC_ACMI_ACFRO_IN_USE = 10;
    public static final int IPAC_ACMI_IPADDR_OUTSIDE_SUBNET = 11;
    public static final int IPAC_ACMI_INTERNAL_ERROR = 20;
    private static IpacAcMiProxy instance = null;
    private PVSession session = null;
    private int froType = 0;
    private String serviceName = null;
    private String pvFirstWanted = null;
    private String pvSecondWanted = null;
    private String pvThirdWanted = null;
    private String moType = null;
    private static final Class THIS_CLASS = IpacAcMiProxy.class;

    public IpacAcMiCreateCfm sendIpacAcMiCreateReq(int n, IpacAcMiNetworkAddress ipacAcMiNetworkAddress) throws MoAccessException {
        IpacAcMiCreateReq ipacAcMiCreateReq = new IpacAcMiCreateReq(n, ipacAcMiNetworkAddress);
        IpacAcMiCreateCfm ipacAcMiCreateCfm = null;
        ipacAcMiCreateCfm = (IpacAcMiCreateCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)ipacAcMiCreateReq, (Class)IpacAcMiCreateCfm.class);
        if (ipacAcMiCreateCfm == null) {
            return null;
        }
        return ipacAcMiCreateCfm;
    }

    public IpacAcMiDeleteCfm sendIpacAcMiDeleteReq(int n, int n2) throws MoAccessException {
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(0x110112, n, n2);
        IpacAcMiDeleteCfm ipacAcMiDeleteCfm = null;
        ipacAcMiDeleteCfm = (IpacAcMiDeleteCfm)SignalHelper.sendAndReceive((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froReqU32U32, (Class)IpacAcMiDeleteCfm.class);
        if (ipacAcMiDeleteCfm == null) {
            return null;
        }
        return ipacAcMiDeleteCfm;
    }

    public IpacAcMiGetAttrCfm sendIpacAcMiGetAttrReq(int n, int n2) throws MoAccessException {
        FroReqU32U32 froReqU32U32 = new FroReqU32U32(0x110114, n, n2);
        Signal signal = SignalHelper.sendAndReceiveAttachedClean((OseProcess)this.session.obtainSession().getFroProcess(), (Signal)froReqU32U32, (Class)IpacAcMiGetAttrCfm.class, (int)SignalHelper.getTimeOut());
        if (signal == null || signal instanceof AttachSignal) {
            return null;
        }
        return (IpacAcMiGetAttrCfm)signal;
    }

    public void signalReceived(InSignal inSignal) {
    }

    public static synchronized IpacAcMiProxy instance(Class clazz, String string) {
        if (instance == null) {
            try {
                TagNameDictionary tagNameDictionary = TagNameDictionaries.get((ResourceBundle)ResourceBundle.getBundle(clazz.getName()));
                instance = new IpacAcMiProxy(tagNameDictionary.lookupValue("serviceName"), tagNameDictionary.lookupValue("pvFirstWanted"), tagNameDictionary.lookupValue("pvSecondWanted"), tagNameDictionary.lookupValue("pvThirdWanted"), Integer.parseInt(tagNameDictionary.lookupValue("froType"), 16), string);
            }
            catch (TagNameDictionaryException tagNameDictionaryException) {
                MessageLog.traceError((Class)THIS_CLASS, (String)("Create proxy instance for " + clazz.getName() + " failed"), (Throwable)tagNameDictionaryException);
            }
        }
        return instance;
    }

    public void serviceAdded(String string) {
    }

    public void sessionRemoved(String string) {
        super.serviceRemoved(string);
    }

    private IpacAcMiProxy(String string, String string2, String string3, String string4, int n, String string5) {
        this.froType = n;
        this.serviceName = string;
        this.pvFirstWanted = string2;
        this.pvSecondWanted = string3;
        this.pvThirdWanted = string4;
        this.moType = string5;
    }

    public void subscribeService() {
        this.session = new PVSession(this.serviceName, this.pvFirstWanted, this.pvSecondWanted, this.pvThirdWanted, this.moType, this.froType);
    }

    public String getResultMsg(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "IPAC_ACMI_NONE";
                break;
            }
            case 1: {
                string = "IPAC_ACMI_OK";
                break;
            }
            case 2: {
                string = "IPAC_ACMI_INVALID_TRANSACTION_ID";
                break;
            }
            case 3: {
                string = "IPAC_ACMI_INVALID_ACFRO_ID";
                break;
            }
            case 4: {
                string = "IPAC_ACMI_IPADDR_STILL_USED";
                break;
            }
            case 5: {
                string = "IPAC_ACMI_INVALID_ACFRO_STATE";
                break;
            }
            case 6: {
                string = "IPAC_ACMI_REGISTER_ERROR";
                break;
            }
            case 7: {
                string = "IPAC_ACMI_EXCEEDS_NUM_OF_FRO";
                break;
            }
            case 8: {
                string = "IPAC_ACMI_BUSY_IN_TRANSACTION";
                break;
            }
            case 9: {
                string = "IPAC_ACMI_IPADDRESS_FORMAT_ERROR";
                break;
            }
            case 10: {
                string = "IPAC_ACMI_ACFRO_IN_USE";
                break;
            }
            case 11: {
                string = "IPAC_ACMI_IPADDR_OUTSIDE_SUBNET";
                break;
            }
            case 20: {
                string = "IPAC_ACMI_INTERNAL_ERROR";
                break;
            }
            default: {
                string = "UNKNOWN RESULT CODE: " + n;
            }
        }
        return string;
    }
}

