/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class CreateMOEnergyMeterAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = CreateMOEnergyMeterAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String CREATE_MO_ENERGYMETER_STEP2_ACTION = "energymetersToCreate";
    protected static final String HWUNIT = "HwUnit";
    private static final String UNITTYPE = "unitType";
    private static final String LDN = "ldn";
    protected static final String ENERGYMETER = "EnergyMeter";
    private static final String ENERGYMETER_FRO_TYPE = Integer.toString(117702669);

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        TableData tableData = this.getTableData(this.tableHandler, HWUNIT);
        List list = this.generateEnergyMeterLDNs(tableData);
        this.createEnergyMeters(list, aueContext);
        this.informStep2(list);
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void informStep2(List list) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = "";
        String string3 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = LdnUtil.getParentLdn((String)string);
            string3 = LdnUtil.getRdnValue((String)string2);
            stringBuffer.append((stringBuffer.length() > 0 ? " " : "") + string3);
        }
        try {
            logger.info(THIS_CLASS, "informStep2, storeing in Auepersistency: " + stringBuffer.toString());
            this.tableHandler.storeInAuePersistency("", CREATE_MO_ENERGYMETER_STEP2_ACTION, stringBuffer.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
    }

    private void createEnergyMeters(List list, AueContext aueContext) throws CrbsAueException {
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        Map map = this.createCreateOneInstanceActionArgsMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            map.put("parentldn", LdnUtil.getParentLdn((String)string));
            map.put("rdnValue", LdnUtil.getRdnValue((String)string));
            createOneInstanceAction.setMoActionArgs(map);
            createOneInstanceAction.convert(aueContext);
        }
    }

    private List generateEnergyMeterLDNs(TableData tableData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "generateEnergyMeterLDNs()");
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = this.getExistEnergyMeterLDNs();
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            Map map;
            try {
                map = tableData.getRecordMap(i);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            String string = (String)map.get(UNITTYPE);
            if (!"PSU".equals(string) && !"EMU".equals(string)) continue;
            String string2 = (String)map.get(LDN) + ",EnergyMeter=1";
            boolean bl = false;
            for (int j = 0; j < objectArray.length; ++j) {
                String string3 = objectArray[j].toString();
                if (!string2.equalsIgnoreCase(string3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(string2);
        }
        logger.traceReturn(THIS_CLASS, "generateEnergyMeterLDNs()");
        return arrayList;
    }

    private Object[] getExistEnergyMeterLDNs() throws CrbsAueException {
        TableData tableData = this.getTableData(this.tableHandler, ENERGYMETER);
        Object[] objectArray = new Object[]{};
        try {
            if (tableData.isNotEmpty()) {
                objectArray = tableData.getAttributeValues(LDN);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        return objectArray;
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        TableData tableData;
        try {
            tableData = tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("It is not possible to get the table data: " + string, (Throwable)tableDataException);
        }
        return tableData;
    }

    private Map createCreateOneInstanceActionArgsMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("name", ENERGYMETER);
        hashMap.put("frotype", ENERGYMETER_FRO_TYPE);
        hashMap.put("parentRefExists", Boolean.FALSE.toString());
        return hashMap;
    }
}

