/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;
import se.ericsson.crbs.supsys.omf.aue.step1.util.CabinetParametersHelper;

public class HandleFroCascadedAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = HandleFroCascadedAction.class;
    private static TableHandler tableHandler;
    private static final AbstractLogger logger;
    private static final String CABINET_ATT_CLIMATE_CONTROL_MODE = "climateControlMode";
    private static final String CABINET_ATT_CLIMATE_SYSTEM = "climateSystem";
    private static final String CABINET_ATT_PRODUCT_DATA = "productData";
    private static final String CABINET_ATT_SHARED_CABINET_IDENTIFIER = "sharedCabinetIdentifier";
    private static final String CABINET_ATT_SMOKE_DETECTOR = "smokeDetector";
    private static final String CABINET_ATT_CABINET_PARAMETERS = "cabinetParameters";
    private static final String CABINET_ATT_CABPARAM_EXTENDED = "cabinetParametersProfileExtended";
    private static final String CABINET_ATT_CABPARAM_STANDARD = "cabinetParametersProfileStandard";
    private static final String CLIMATE_SYSTEM_STANDARD = "0";
    private static final String CLIMATE_SYSTEM_EXTENDED = "1";
    private static final int ECBUS_FRO_TYPE_ID = 117702672;
    private static final String EQUIP_LDN = "ManagedElement=1,Equipment=1";
    private static final String HW_UNIT = "HwUnit";
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final int CABINET_FRO_TYPE_ID = 0x7040000;
    private static final int DEFAULT_CABINET_FRO_ID = 0;
    private static final int SECOND_CABINET_FRO_ID = 1;
    private static final String DUALBOX_CABINET_RDN = "2";
    private static final String DEFAULT_CABINET_LDN = "ManagedElement=1,Equipment=1,Cabinet=1";
    private static final String SECOND_CABINET_LDN = "ManagedElement=1,Equipment=1,Cabinet=2";
    private static final String FANGROUP_MO_TYPE = "FanGroup";
    private static final int FANGROUP_FRO_ID = 1;
    private static final int FANGROUP_FRO_TYPE_ID = 117702657;
    private static final String FANGROUP_RDN = "1";
    private static final String IS_CASCADED = "isCascaded";
    private static final String CABINET_IS_CREATED = "cabinetIsCreated";
    private static final String FANGROUP_IS_CREATED = "fangroupIsCreated";
    private static final String FANGROUP_IS_DELETED = "fangroupIsDeleted";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String HWUNIT_ATT_HWUTYPE = "unitType";
    private static final String HWUNIT_ATT_POSREF = "positionRef";
    private static final String EMPTY_LDN = "emptyLdn";
    private static final String ECPORT_MO_TYPE = "EcPort";

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        boolean bl = this.isCascaded(aueContext, tableHandler);
        logger.traceGeneral(THIS_CLASS, "createInstance(): isDual box is assign to: " + Boolean.toString(bl));
        String string = "";
        string = FALSE;
        if (bl) {
            logger.traceGeneral(THIS_CLASS, "createInstance(): createDualBoxCabinet");
            this.createCabinet(aueContext);
            this.setPosRefOnSUPs(tableHandler);
            string = TRUE;
        }
        try {
            tableHandler.storeInAuePersistency("", IS_CASCADED, string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private boolean isCascaded(AueContext aueContext, TableHandler tableHandler) throws CrbsAueException {
        block24: {
            String string;
            String string2;
            int n;
            Object object;
            TableData tableData;
            block23: {
                block22: {
                    logger.traceEnter(THIS_CLASS, "isDualBox");
                    String string3 = this.getProductNameFromManagedElementMO(aueContext);
                    logger.traceGeneral(THIS_CLASS, "isCascaded(): Check if Product Name supports DualBox");
                    if (!string3.startsWith("RBS6601")) {
                        logger.traceReturn(THIS_CLASS, "isCascaded - false");
                        return false;
                    }
                    logger.traceGeneral(THIS_CLASS, "isCascaded(): Check if Configuration includes 2 SUPS");
                    try {
                        tableData = tableHandler.getTableData(HW_UNIT);
                        if (tableData != null && tableData.getNumberOfRecords() != 0) {
                            object = this.findSUPs(tableData);
                            if (object.size() != 2) {
                                logger.traceReturn(THIS_CLASS, "isCascaded - false");
                                return false;
                            }
                            break block22;
                        }
                        logger.traceReturn(THIS_CLASS, "isCascaded - false");
                        return false;
                    }
                    catch (TableDataException tableDataException) {
                        throw new CrbsAueException("Unable to get table data for HwUnit", (Throwable)tableDataException);
                    }
                }
                try {
                    tableData = tableHandler.getTableData(ECPORT_MO_TYPE);
                    if (tableData != null && tableData.getNumberOfRecords() != 0) {
                        logger.traceGeneral(THIS_CLASS, "isCascaded(): EcPort TableData exist");
                        object = tableData.getAttributeValues("hubPosition");
                        Object[] objectArray = tableData.getAttributeValues("cascadingOrder");
                        int n2 = 0;
                        for (n = 0; n < ((Object[])object).length; ++n) {
                            string2 = object[n].toString();
                            string = objectArray[n].toString();
                            if (!"NA".equals(string2) || CLIMATE_SYSTEM_STANDARD.equals(string)) continue;
                            ++n2;
                        }
                        if (n2 != 2) {
                            logger.traceReturn(THIS_CLASS, "isCascaded - false");
                            return false;
                        }
                        break block23;
                    }
                    logger.traceReturn(THIS_CLASS, "isCascaded - false");
                    return false;
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException("Unable to get table data for HwUnit", (Throwable)tableDataException);
                }
            }
            logger.traceGeneral(THIS_CLASS, "isCascaded(): Check if check if MO Cabinet attribute, climateSystem, is set to extended");
            try {
                int n3;
                tableData = tableHandler.getTableData(CABINET_MO_TYPE);
                if (tableData != null && tableData.getNumberOfRecords() == 1) {
                    logger.traceGeneral(THIS_CLASS, "isDualBox(): Cabinet TableData exist");
                    object = tableData.getAttributeValues(CABINET_ATT_CLIMATE_SYSTEM);
                    for (n3 = 0; n3 < ((Object[])object).length; ++n3) {
                        logger.traceGeneral(THIS_CLASS, "isDualBox(): Looping over attribute Climate System");
                        String string4 = object[n3].toString();
                        if (string4.equals("1")) continue;
                        logger.traceReturn(THIS_CLASS, "isDualBox - false");
                        return false;
                    }
                } else {
                    logger.traceReturn(THIS_CLASS, "isCascaded - false");
                    return false;
                }
                logger.traceGeneral(THIS_CLASS, "isCascaded(): Check if SUP-2 EcPort has HubPosition Aux NA");
                try {
                    n3 = 0;
                    TableData tableData2 = tableHandler.getTableData(FANGROUP_MO_TYPE);
                    if (tableData2 != null && tableData2.getNumberOfRecords() == 2) {
                        logger.traceGeneral(THIS_CLASS, "isCascaded(): FanGroupTableData is ok");
                        logger.traceGeneral(THIS_CLASS, "isCascaded(): Looping over " + Integer.toString(tableData2.getNumberOfRecords()) + " fangroups");
                        for (n = 0; n < tableData2.getNumberOfRecords(); ++n) {
                            try {
                                logger.traceGeneral(THIS_CLASS, "isCascaded(): Extract data from Fangroup");
                                object = tableData2.getRecordMap(n);
                            }
                            catch (TableDataException tableDataException) {
                                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
                            }
                            string2 = (String)object.get("ldn");
                            string = string2.substring(0, string2.indexOf(FANGROUP_MO_TYPE) - 1);
                            logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Add to list of FanGroup devided on parent cabinet");
                            if (!string.equals(DEFAULT_CABINET_LDN)) continue;
                            ++n3;
                        }
                        if (n3 == 2) {
                            logger.traceGeneral(THIS_CLASS, "isCascaded(): FanGroups under Cabinet=1 equals 2, is cascaded configuration ");
                            return true;
                        }
                        break block24;
                    }
                    logger.traceError(THIS_CLASS, "fanGroupTableData is null");
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException("Unable to get table data for EcPort", (Throwable)tableDataException);
                }
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Unable to get table data for HwUnit or EcPort", (Throwable)tableDataException);
            }
        }
        logger.traceReturn(THIS_CLASS, "isDualBox - false");
        return false;
    }

    private List findSUPs(TableData tableData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findSUPs()");
        logger.traceGeneral(THIS_CLASS, "findSUPs(): Collect all hwUnits");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            Map map;
            try {
                map = tableData.getRecordMap(i);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            logger.traceGeneral(THIS_CLASS, "findSUPs(): Find all hwUnits of type SUP and SCU");
            String string = (String)map.get(HWUNIT_ATT_HWUTYPE);
            if (!"SUP".equals(string) && !"SCU".equals(string)) continue;
            logger.traceGeneral(THIS_CLASS, "findSUPs(): Add SUP/SCU to supList");
            String string2 = (String)map.get("ldn");
            arrayList.add(string2);
        }
        logger.traceReturn(THIS_CLASS, "findSUPs()");
        return arrayList;
    }

    private String getPid() throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getPid()");
        logger.traceReturn(THIS_CLASS, "getPid()");
        return "<struct name=\"productData\"><attr name=\"productionDate\" type=\"STRING\" value=\"\"/><attr name=\"productName\" type=\"STRING\" value=\"\"/><attr name=\"productNumber\" type=\"STRING\" value=\"\"/><attr name=\"productRevision\" type=\"STRING\" value=\"\"/><attr name=\"serialNumber\" type=\"STRING\" value=\"\"/></struct>";
    }

    private String getProductNameFromManagedElementMO(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getProductNameFromManagedElementMO");
        try {
            logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): get ManageElement Mo");
            MoAccessor moAccessor = ((CollectorContext)aueContext).getMoAccessor();
            ManagedElementMo managedElementMo = (ManagedElementMo)moAccessor.lookup("ManagedElement=1");
            if (null == managedElementMo) {
                throw new CrbsAueException("Can't find ManagedElement=1");
            }
            logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): get Product Name");
            String string = managedElementMo.getProductName(null);
            logger.traceReturn(THIS_CLASS, "getProductNameFromManagedElementMO - productName: " + string);
            return string;
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Failed to find read productName from ManagedElement.", (Throwable)moAccessException);
        }
    }

    private void setPosRefOnSUPs(TableHandler tableHandler) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setPosRefOnSUPs()");
        try {
            TableData tableData = tableHandler.getTableData(HW_UNIT);
            Object[] objectArray = tableData.getAttributeValues(HWUNIT_ATT_HWUTYPE);
            Object[] objectArray2 = tableData.getAttributeValues("ldn");
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString();
                if ("SUP".equals(string) || "SCU".equals(string)) {
                    String string2;
                    String string3;
                    logger.traceGeneral(THIS_CLASS, "setPosRefOnSUPs(): hwUnitType is equal SUP or SCu ");
                    if (objectArray2[i].toString().equals("ManagedElement=1,Equipment=1,HwUnit=SUP-1")) {
                        string3 = this.getMoRef(HWUNIT_ATT_POSREF, DEFAULT_CABINET_LDN, Integer.toString(0x7040000), Integer.toString(0));
                        string2 = TableDataUtil.getLdnFromMoRef((String)string3);
                        tableHandler.storeInAuePersistency(objectArray2[i].toString(), HWUNIT_ATT_POSREF, string2);
                        tableData.setAttributeValue(i, HWUNIT_ATT_POSREF, (Object)string3);
                        continue;
                    }
                    if (objectArray2[i].toString().equals("ManagedElement=1,Equipment=1,HwUnit=SUP-2")) {
                        string3 = this.getMoRef(HWUNIT_ATT_POSREF, SECOND_CABINET_LDN, Integer.toString(0x7040000), Integer.toString(1));
                        string2 = TableDataUtil.getLdnFromMoRef((String)string3);
                        tableHandler.storeInAuePersistency(objectArray2[i].toString(), HWUNIT_ATT_POSREF, string2);
                        tableData.setAttributeValue(i, HWUNIT_ATT_POSREF, (Object)string3);
                        continue;
                    }
                    tableHandler.storeInAuePersistency(objectArray2[i].toString(), HWUNIT_ATT_POSREF, EMPTY_LDN);
                    continue;
                }
                tableHandler.storeInAuePersistency(objectArray2[i].toString(), HWUNIT_ATT_POSREF, EMPTY_LDN);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "setPosRefOnSUPs()");
    }

    private void addMoTypeSpecificAttributes(Map map, FroAttributes[] froAttributesArray) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
        StringBuffer stringBuffer = new StringBuffer("<attributes>");
        for (int i = 0; i < froAttributesArray.length; ++i) {
            String string = froAttributesArray[i].attrName;
            stringBuffer.append("<attr name=\"" + string + "\" type=\"" + froAttributesArray[i].attrType + "\" value=\"" + map.get(string) + "\" />");
        }
        stringBuffer.append("</attributes>");
        map.put("childAttributes", stringBuffer.toString());
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
    }

    private void createCabinet(AueContext aueContext) throws CrbsAueException {
        String string;
        String string2;
        Object object;
        TableData tableData;
        Object object2;
        logger.traceEnter(THIS_CLASS, "createDualBoxCabinet()");
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string3 = FALSE;
        string4 = FALSE;
        string5 = FALSE;
        try {
            object2 = tableHandler.getTableData(CABINET_MO_TYPE);
            if (object2.getNumberOfRecords() < 2) {
                object2.setAttributeValue(0, CABINET_ATT_CLIMATE_SYSTEM, (Object)CLIMATE_SYSTEM_STANDARD);
                string3 = TRUE;
                tableData = new HashMap();
                FroAttributes[] froAttributesArray = this.getCabinetFroAttributes();
                logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): Set parameters for Cabinet");
                tableData.put("name", CABINET_MO_TYPE);
                tableData.put("frotype", Integer.toString(0x7040000));
                tableData.put("rdnValue", DUALBOX_CABINET_RDN);
                tableData.put("parentldn", EQUIP_LDN);
                tableData.put("froid", Integer.toString(1));
                tableData.put("parentRefExists", Boolean.FALSE.toString());
                logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): get Specific Mo Attributes ");
                this.getAttributeValuesFromCabinetOne((Map)tableData);
                logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): Add Specific Mo Attributes ");
                this.addMoTypeSpecificAttributes((Map)tableData, froAttributesArray);
                logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): Create Cabinet in FRO layer ");
                object = new CreateOneInstanceAction();
                object.setMoActionArgs((Map)tableData);
                object.convert(aueContext);
                logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): Store cabinetParameters in AUE persistency to be set in MAO (step2) ");
                CabinetParametersHelper cabinetParametersHelper = new CabinetParametersHelper();
                string2 = cabinetParametersHelper.getStandardParameters(aueContext);
                string = cabinetParametersHelper.getExtendedParameters(aueContext);
                if (string2 != null) {
                    tableHandler.storeInAuePersistency(SECOND_CABINET_LDN, CABINET_ATT_CABPARAM_STANDARD, string2);
                }
                if (string != null) {
                    tableHandler.storeInAuePersistency(SECOND_CABINET_LDN, CABINET_ATT_CABPARAM_EXTENDED, string);
                }
            }
            tableHandler.storeInAuePersistency("", CABINET_IS_CREATED, string3);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read Cabinet tabledata.", (Throwable)tableDataException);
        }
        try {
            object2 = tableHandler.getTableData(CABINET_MO_TYPE);
            tableData = object2.getAttributeValues(CABINET_ATT_CLIMATE_SYSTEM);
            for (int i = 0; i < ((Object[])tableData).length; ++i) {
                object = tableData[i].toString();
                if (!((String)object).equals("1")) continue;
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): set value:climateSystem to: 0");
                object2.setAttributeValue(i, CABINET_ATT_CLIMATE_SYSTEM, (Object)CLIMATE_SYSTEM_STANDARD);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read Cabinet tabledata when trying to change climateSystem.", (Throwable)tableDataException);
        }
        try {
            tableData = tableHandler.getTableData(FANGROUP_MO_TYPE);
            if (tableData != null && tableData.isNotEmpty()) {
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): FanGroupTableData is ok");
                ArrayList<String> arrayList = new ArrayList<String>();
                object = new ArrayList();
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Looping over " + Integer.toString(tableData.getNumberOfRecords()) + " fangroups");
                for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                    try {
                        logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Extract data from Fangroup");
                        object2 = tableData.getRecordMap(i);
                    }
                    catch (TableDataException tableDataException) {
                        throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
                    }
                    string2 = (String)object2.get("ldn");
                    string = string2.substring(0, string2.indexOf(FANGROUP_MO_TYPE) - 1);
                    logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Add to list of FanGroup devided on parent cabinet");
                    if (string.equals(DEFAULT_CABINET_LDN)) {
                        arrayList.add(string2);
                        continue;
                    }
                    if (!string2.equals(SECOND_CABINET_LDN)) continue;
                    ((ArrayList)object).add(string2);
                }
                if (arrayList.size() == 2) {
                    logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): FanGroups under Cabinet=1 equals 2, delete Fangroup with RDN = 2 ");
                    string5 = TRUE;
                    tableData.deleteRowData(1);
                }
                if (((ArrayList)object).isEmpty()) {
                    logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): FanGroups under Cabinet=2 equals 0, Create Fangroup with RDN = 1 ");
                    string4 = TRUE;
                    this.createFanGroupAction(aueContext);
                }
            } else {
                logger.traceError(THIS_CLASS, "fanGroupTableData is null");
            }
            tableHandler.storeInAuePersistency("", FANGROUP_IS_CREATED, string4);
            tableHandler.storeInAuePersistency("", FANGROUP_IS_DELETED, string5);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read FanGroup tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createDualBoxCabinet()");
    }

    private void getAttributeValuesFromCabinetOne(Map map) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getAttributeValuesFromCabinetOne()");
        try {
            logger.traceGeneral(THIS_CLASS, "getAttributeValuesFromCabinetOne(): Get Cabinet table Data ");
            TableData tableData = tableHandler.getTableData(CABINET_MO_TYPE);
            if (tableData != null && tableData.isNotEmpty()) {
                logger.traceGeneral(THIS_CLASS, "getAttributeValuesFromCabinetOne(): set parameterMap with values from Cabinet=1 ");
                Map map2 = tableData.getRecordMap(0);
                map.put(CABINET_ATT_CABINET_PARAMETERS, map2.get(CABINET_ATT_CABINET_PARAMETERS).toString());
                map.put(CABINET_ATT_CLIMATE_CONTROL_MODE, map2.get(CABINET_ATT_CLIMATE_CONTROL_MODE).toString());
                map.put(CABINET_ATT_CLIMATE_SYSTEM, CLIMATE_SYSTEM_STANDARD);
                map.put(CABINET_ATT_PRODUCT_DATA, this.getPid());
                map.put(CABINET_ATT_SHARED_CABINET_IDENTIFIER, "");
                map.put(CABINET_ATT_SMOKE_DETECTOR, map2.get(CABINET_ATT_SMOKE_DETECTOR).toString());
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "getAttributeValuesFromCabinetOne()");
    }

    private String getMoRef(String string, String string2, String string3, String string4) {
        logger.traceEnter(THIS_CLASS, "getMoRef()");
        String string5 = "<moref name=\"" + string + "\">" + "<attr name=\"ldn\" type=\"STRING\" value=\"" + string2 + "\"/>" + "<attr name=\"froType\" type=\"S32\" value=\"" + string3 + "\"/>" + "<attr name=\"froId\" type=\"S32\" value=\"" + string4 + "\"/>" + "</moref>";
        logger.traceReturn(THIS_CLASS, "getMoRef()");
        return string5;
    }

    public void createFanGroupAction(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createFanGroupAction()");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        logger.traceGeneral(THIS_CLASS, "createFanGroupAction(): Set parameters for FanGroup ");
        hashMap.put("name", FANGROUP_MO_TYPE);
        hashMap.put("frotype", Integer.toString(117702657));
        hashMap.put("rdnValue", "1");
        hashMap.put("parentldn", SECOND_CABINET_LDN);
        hashMap.put("froid", Integer.toString(1));
        hashMap.put("parentRefExists", Boolean.FALSE.toString());
        logger.traceGeneral(THIS_CLASS, "createFanGroupAction(): Create FanGroup Mo ");
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(hashMap);
        createOneInstanceAction.convert(aueContext);
        logger.traceReturn(THIS_CLASS, "createFanGroupAction()");
    }

    private FroAttributes[] getCabinetFroAttributes() {
        logger.traceEnter(THIS_CLASS, "getFroAttributes() invoked");
        ArrayList<FroAttributes> arrayList = new ArrayList<FroAttributes>();
        arrayList.add(new FroAttributes(117702672, CABINET_ATT_CLIMATE_CONTROL_MODE, new String("S32")));
        arrayList.add(new FroAttributes(117702672, CABINET_ATT_CLIMATE_SYSTEM, new String("S32")));
        arrayList.add(new FroAttributes(117702672, CABINET_ATT_PRODUCT_DATA, new String("struct")));
        arrayList.add(new FroAttributes(117702672, CABINET_ATT_SHARED_CABINET_IDENTIFIER, new String("string")));
        arrayList.add(new FroAttributes(117702672, CABINET_ATT_SMOKE_DETECTOR, new String("S32")));
        arrayList.add(new FroAttributes(117702672, CABINET_ATT_CABINET_PARAMETERS, new String("string")));
        FroAttributes[] froAttributesArray = arrayList.toArray(new FroAttributes[arrayList.size()]);
        logger.traceReturn(THIS_CLASS, "ecBusFroAttributes() executed");
        return froAttributesArray;
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    }

    private class FroAttributes {
        private final int froTypeId;
        private final String attrName;
        private final String attrType;

        FroAttributes(int n, String string, String string2) {
            this.froTypeId = n;
            this.attrName = string;
            this.attrType = string2;
        }
    }
}

