/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.MoAccessor;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.cello.managedelement.ManagedElementMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step1.MoRepositoryWrapper;
import se.ericsson.crbs.omf.aue.step1.MoRepositoryWrapperFactory;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractCreateInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.CreateOneInstanceAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;
import se.ericsson.crbs.omf.aue.step1.actions.util.TableDataUtil;
import se.ericsson.crbs.supsys.omf.aue.step1.util.CabinetParametersHelper;

public class HandleFroDualBoxAction
extends AbstractCreateInstanceAction {
    private static final Class THIS_CLASS = HandleFroDualBoxAction.class;
    private static TableHandler tableHandler;
    private static final AbstractLogger logger;
    private static final String ECBUS_ATT_CONNECTION_TYPE = "connectionType";
    private static final String ECBUS_ATT_CONNECTOR_REF = "ecBusConnectorRef";
    private static final String CABINET_ATT_CLIMATE_CONTROL_MODE = "climateControlMode";
    private static final String CABINET_ATT_CLIMATE_SYSTEM = "climateSystem";
    private static final String CABINET_ATT_PRODUCT_DATA = "productData";
    private static final String CABINET_ATT_SHARED_CABINET_IDENTIFIER = "sharedCabinetIdentifier";
    private static final String CABINET_ATT_SMOKE_DETECTOR = "smokeDetector";
    private static final String CABINET_ATT_CABINET_PARAMETERS = "cabinetParameters";
    private static final String CABINET_ATT_CABPARAM_EXTENDED = "cabinetParametersProfileExtended";
    private static final String CABINET_ATT_CABPARAM_STANDARD = "cabinetParametersProfileStandard";
    private static final String CLIMATE_SYSTEM_STANDARD = "0";
    private static final String CLIMATE_SYSTEM_EXTENDED = "1";
    private static final String ECBUS_MO_TYPE = "EcBus";
    private static final int ECBUS_FRO_TYPE_ID = 117702672;
    private static final String DUALBOX_ECBUS_LDN = "ManagedElement=1,Equipment=1,EcBus=2";
    private static final String DUALBOX_ECBUS_RDN = "2";
    private static final int DUALBOX_ECBUS_FRO_ID = 2;
    private static final String CONNECTION_TYPE_VALUE_AUX = "AUX";
    private static final String EQUIP_LDN = "ManagedElement=1,Equipment=1";
    private static final String CABINET_MO_TYPE = "Cabinet";
    private static final int CABINET_FRO_TYPE_ID = 0x7040000;
    private static final int DEFAULT_CABINET_FRO_ID = 0;
    private static final int DUALBOX_CABINET_FRO_ID = 1;
    private static final String DUALBOX_CABINET_RDN = "2";
    private static final String DEFAULT_CABINET_LDN = "ManagedElement=1,Equipment=1,Cabinet=1";
    private static final String DUALBOX_CABINET_LDN = "ManagedElement=1,Equipment=1,Cabinet=2";
    private static final String FANGROUP_MO_TYPE = "FanGroup";
    private static final int FANGROUP_FRO_ID = 1;
    private static final int FANGROUP_FRO_TYPE_ID = 117702657;
    private static final String FANGROUP_RDN = "1";
    private static final String PLUG_IN_UNIT_FRO_TYPE;
    private static final String PLUG_IN_UNIT_MO_TYPE = "PlugInUnit";
    private static final String PLUG_IN_UNIT_FRO_ID_ATTR_NAME = "resourceId";
    private static final String MASTER_PLUG_IN_UNIT_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1";
    private static final String ECPORT_MO_TYPE = "EcPort";
    private static final String ECPORT_ATT_ECBUS_REF = "ecBusRef";
    private static final String ECPORT_ATT_HUBPOSITION = "hubPosition";
    private static final String IS_DUALBOX = "isDualBox";
    private static final String CABINET_IS_CREATED = "cabinetIsCreated";
    private static final String FANGROUP_IS_CREATED = "fangroupIsCreated";
    private static final String FANGROUP_IS_DELETED = "fangroupIsDeleted";
    private static final String HW_UNIT = "HwUnit";
    private static final String HWUNIT_ATT_HWUTYPE = "unitType";
    private static final String HWUNIT_ATT_POSREF = "positionRef";
    private static final String AUX_SUP_LDN = "auxSupLdn";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String EMPTY_LDN = "emptyLdn";

    public void createInstance(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createInstance()");
        tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        boolean bl = this.isDualBox(aueContext, tableHandler);
        logger.traceGeneral(THIS_CLASS, "createInstance(): isDual box is assign to: " + Boolean.toString(bl));
        String string = "";
        string = FALSE;
        if (bl) {
            logger.traceGeneral(THIS_CLASS, "createInstance(): createDualBoxEcBus");
            this.createDualBoxEcBus(aueContext);
            logger.traceGeneral(THIS_CLASS, "createInstance(): Update EcPorts");
            this.updateEcPorts(tableHandler);
            logger.traceGeneral(THIS_CLASS, "createInstance(): createDualBoxCabinet");
            this.createDualBoxCabinet(aueContext);
            this.setPosRefOnSUPs(tableHandler);
            string = TRUE;
        }
        try {
            tableHandler.storeInAuePersistency("", IS_DUALBOX, string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createInstance()");
    }

    private boolean isDualBox(AueContext aueContext, TableHandler tableHandler) throws CrbsAueException {
        block15: {
            TableData tableData;
            TableData tableData2;
            block14: {
                logger.traceEnter(THIS_CLASS, IS_DUALBOX);
                String string = this.getProductNameFromManagedElementMO(aueContext);
                logger.traceGeneral(THIS_CLASS, "isDualBox(): Check if Product Name supports DualBox");
                if (!string.startsWith("RBS6601") && !string.startsWith("RBS6302")) {
                    logger.traceReturn(THIS_CLASS, "isDualBox - false");
                    return false;
                }
                logger.traceGeneral(THIS_CLASS, "isDualBox(): Check if Configuration includes 2 SUPS");
                try {
                    tableData2 = tableHandler.getTableData(HW_UNIT);
                    if (tableData2 != null && tableData2.getNumberOfRecords() != 0) {
                        tableData = this.findSUPs(tableData2);
                        if (tableData.size() != 2) {
                            logger.traceReturn(THIS_CLASS, "isDualBox - false");
                            return false;
                        }
                        break block14;
                    }
                    logger.traceReturn(THIS_CLASS, "isDualBox - false");
                    return false;
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException("Unable to get table data for HwUnit", (Throwable)tableDataException);
                }
            }
            logger.traceGeneral(THIS_CLASS, "isDualBox(): Check if check if MO Cabinet attribute, climateSystem, is set to extended");
            try {
                tableData2 = tableHandler.getTableData(CABINET_MO_TYPE);
                if (tableData2 != null && tableData2.getNumberOfRecords() == 1) {
                    logger.traceGeneral(THIS_CLASS, "isDualBox(): Cabinet TableData exist");
                    tableData = tableData2.getAttributeValues(CABINET_ATT_CLIMATE_SYSTEM);
                    for (int i = 0; i < ((Object[])tableData).length; ++i) {
                        logger.traceGeneral(THIS_CLASS, "isDualBox(): Looping over attribute Climate System");
                        String string = tableData[i].toString();
                        if (string.equals("1")) continue;
                        logger.traceReturn(THIS_CLASS, "isDualBox - false");
                        return false;
                    }
                } else {
                    logger.traceReturn(THIS_CLASS, "isDualBox - false");
                    return false;
                }
                logger.traceGeneral(THIS_CLASS, "isDualBox(): Check if SUP-2 EcPort has HubPosition Aux NA");
                try {
                    tableData = tableHandler.getTableData(ECPORT_MO_TYPE);
                    if (tableData != null && tableData.getNumberOfRecords() != 0) {
                        logger.traceGeneral(THIS_CLASS, "isDualBox(): EcPort TableData exist");
                        Object[] objectArray = tableData.getAttributeValues(ECPORT_ATT_HUBPOSITION);
                        for (int i = 0; i < objectArray.length; ++i) {
                            String string = objectArray[i].toString();
                            if (!"AUX NA".equals(string)) continue;
                            logger.traceReturn(THIS_CLASS, "isDualBox - true");
                            return true;
                        }
                        break block15;
                    }
                    logger.traceReturn(THIS_CLASS, "isDualBox - false");
                    return false;
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException("Unable to get table data for EcPort", (Throwable)tableDataException);
                }
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException("Unable to get table data for HwUnit or EcPort", (Throwable)tableDataException);
            }
        }
        logger.traceReturn(THIS_CLASS, "isDualBox - false");
        return false;
    }

    private String getPid() throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getPid()");
        logger.traceReturn(THIS_CLASS, "getPid()");
        return "<struct name=\"productData\"><attr name=\"productionDate\" type=\"STRING\" value=\"\"/><attr name=\"productName\" type=\"STRING\" value=\"\"/><attr name=\"productNumber\" type=\"STRING\" value=\"\"/><attr name=\"productRevision\" type=\"STRING\" value=\"\"/><attr name=\"serialNumber\" type=\"STRING\" value=\"\"/></struct>";
    }

    private List findSUPs(TableData tableData) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findSUPs()");
        logger.traceGeneral(THIS_CLASS, "findSUPs(): Collect all hwUnits");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            Map map;
            try {
                map = tableData.getRecordMap(i);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            logger.traceGeneral(THIS_CLASS, "findSUPs(): Find all hwUnits of type SUP and SCU");
            String string = (String)map.get(HWUNIT_ATT_HWUTYPE);
            if (!"SUP".equals(string) && !"SCU".equals(string)) continue;
            logger.traceGeneral(THIS_CLASS, "findSUPs(): Add SUP/SCU to supList");
            String string2 = (String)map.get("ldn");
            arrayList.add(string2);
        }
        logger.traceReturn(THIS_CLASS, "findSUPs()");
        return arrayList;
    }

    private String getProductNameFromManagedElementMO(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getProductNameFromManagedElementMO");
        try {
            logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): get ManageElement Mo");
            MoAccessor moAccessor = ((CollectorContext)aueContext).getMoAccessor();
            ManagedElementMo managedElementMo = (ManagedElementMo)moAccessor.lookup("ManagedElement=1");
            if (null == managedElementMo) {
                throw new CrbsAueException("Can't find ManagedElement=1");
            }
            logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): get Product Name");
            String string = managedElementMo.getProductName(null);
            logger.traceReturn(THIS_CLASS, "getProductNameFromManagedElementMO - productName: " + string);
            return string;
        }
        catch (MoAccessException moAccessException) {
            throw new CrbsAueException("Failed to find read productName from ManagedElement.", (Throwable)moAccessException);
        }
    }

    private void createDualBoxEcBus(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createDefaultEcBus()");
        logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): Store EcBus FroId in apcAuePersistency for step2");
        try {
            tableHandler.storeInAuePersistency(DUALBOX_ECBUS_LDN, "froid", Integer.toString(2));
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): Find reference to Master Du");
        String string = this.getPiuFroId(MASTER_PLUG_IN_UNIT_LDN);
        String string2 = this.getMoRef(ECBUS_ATT_CONNECTOR_REF, MASTER_PLUG_IN_UNIT_LDN, PLUG_IN_UNIT_FRO_TYPE, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        FroAttributes[] froAttributesArray = this.getEcBusFroAttributes();
        logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): Set parameters for EcBus");
        hashMap.put("name", ECBUS_MO_TYPE);
        hashMap.put("frotype", Integer.toString(117702672));
        hashMap.put("rdnValue", "2");
        hashMap.put("parentldn", EQUIP_LDN);
        hashMap.put("froid", Integer.toString(2));
        hashMap.put("parentRefExists", Boolean.FALSE.toString());
        hashMap.put(ECBUS_ATT_CONNECTION_TYPE, CONNECTION_TYPE_VALUE_AUX);
        hashMap.put(ECBUS_ATT_CONNECTOR_REF, string2);
        logger.traceGeneral(THIS_CLASS, "getProductNameFromManagedElementMO(): Create EcBus in FRO layer");
        this.addMoTypeSpecificAttributes(hashMap, froAttributesArray);
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(hashMap);
        createOneInstanceAction.convert(aueContext);
    }

    private void addMoTypeSpecificAttributes(Map map, FroAttributes[] froAttributesArray) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
        StringBuffer stringBuffer = new StringBuffer("<attributes>");
        for (int i = 0; i < froAttributesArray.length; ++i) {
            String string = froAttributesArray[i].attrName;
            stringBuffer.append("<attr name=\"" + string + "\" type=\"" + froAttributesArray[i].attrType + "\" value=\"" + map.get(string) + "\" />");
        }
        stringBuffer.append("</attributes>");
        map.put("childAttributes", stringBuffer.toString());
        logger.traceReturn(THIS_CLASS, "addMoTypeSpecificAttributesAsChildAttributes()");
    }

    private void createDualBoxCabinet(AueContext aueContext) throws CrbsAueException {
        String string;
        String string2;
        Object object;
        TableData tableData;
        Object object2;
        logger.traceEnter(THIS_CLASS, "createDualBoxCabinet()");
        String string3 = "";
        String string4 = "";
        String string5 = "";
        string3 = FALSE;
        string4 = FALSE;
        string5 = FALSE;
        try {
            object2 = tableHandler.getTableData(CABINET_MO_TYPE);
            if (object2.getNumberOfRecords() < 2) {
                object2.setAttributeValue(0, CABINET_ATT_CLIMATE_SYSTEM, (Object)CLIMATE_SYSTEM_STANDARD);
                string3 = TRUE;
                tableData = new HashMap();
                FroAttributes[] froAttributesArray = this.getCabinetFroAttributes();
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Set parameters for Cabinet");
                tableData.put("name", CABINET_MO_TYPE);
                tableData.put("frotype", Integer.toString(0x7040000));
                tableData.put("rdnValue", "2");
                tableData.put("parentldn", EQUIP_LDN);
                tableData.put("froid", Integer.toString(1));
                tableData.put("parentRefExists", Boolean.FALSE.toString());
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): get Specific Mo Attributes ");
                this.getAttributeValuesFromCabinetOne((Map)tableData);
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Add Specific Mo Attributes ");
                this.addMoTypeSpecificAttributes((Map)tableData, froAttributesArray);
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Create Cabinet in FRO layer ");
                object = new CreateOneInstanceAction();
                object.setMoActionArgs((Map)tableData);
                object.convert(aueContext);
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Store cabinetParameters in AUE persistency to be set in MAO (step2) ");
                CabinetParametersHelper cabinetParametersHelper = new CabinetParametersHelper();
                string2 = cabinetParametersHelper.getStandardParameters(aueContext);
                string = cabinetParametersHelper.getExtendedParameters(aueContext);
                if (string2 != null) {
                    tableHandler.storeInAuePersistency(DUALBOX_CABINET_LDN, CABINET_ATT_CABPARAM_STANDARD, string2);
                }
                if (string != null) {
                    tableHandler.storeInAuePersistency(DUALBOX_CABINET_LDN, CABINET_ATT_CABPARAM_EXTENDED, string);
                }
            }
            tableHandler.storeInAuePersistency("", CABINET_IS_CREATED, string3);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read Cabinet tabledata.", (Throwable)tableDataException);
        }
        try {
            object2 = tableHandler.getTableData(CABINET_MO_TYPE);
            tableData = object2.getAttributeValues(CABINET_ATT_CLIMATE_SYSTEM);
            for (int i = 0; i < ((Object[])tableData).length; ++i) {
                object = tableData[i].toString();
                if (!((String)object).equals("1")) continue;
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): set value:climateSystem to: 0");
                object2.setAttributeValue(i, CABINET_ATT_CLIMATE_SYSTEM, (Object)CLIMATE_SYSTEM_STANDARD);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read Cabinet tabledata when trying to change climateSystem.", (Throwable)tableDataException);
        }
        try {
            tableData = tableHandler.getTableData(FANGROUP_MO_TYPE);
            if (tableData != null && tableData.isNotEmpty()) {
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): FanGroupTableData is ok");
                ArrayList<String> arrayList = new ArrayList<String>();
                object = new ArrayList();
                logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Looping over " + Integer.toString(tableData.getNumberOfRecords()) + " fangroups");
                for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
                    try {
                        logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Extract data from Fangroup");
                        object2 = tableData.getRecordMap(i);
                    }
                    catch (TableDataException tableDataException) {
                        throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
                    }
                    string2 = (String)object2.get("ldn");
                    string = string2.substring(0, string2.indexOf(FANGROUP_MO_TYPE) - 1);
                    logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): Add to list of FanGroup devided on parent cabinet");
                    if (string.equals(DEFAULT_CABINET_LDN)) {
                        arrayList.add(string2);
                        continue;
                    }
                    if (!string2.equals(DUALBOX_CABINET_LDN)) continue;
                    ((ArrayList)object).add(string2);
                }
                if (arrayList.size() == 2) {
                    logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): FanGroups under Cabinet=1 equals 2, delete Fangroup with RDN = 2 ");
                    string5 = TRUE;
                    tableData.deleteRowData(1);
                }
                if (((ArrayList)object).isEmpty()) {
                    logger.traceGeneral(THIS_CLASS, "createDualBoxCabinet(): FanGroups under Cabinet=2 equals 0, Create Fangroup with RDN = 1 ");
                    string4 = TRUE;
                    this.createFanGroupAction(aueContext);
                }
            } else {
                logger.traceError(THIS_CLASS, "fanGroupTableData is null");
            }
            tableHandler.storeInAuePersistency("", FANGROUP_IS_CREATED, string4);
            tableHandler.storeInAuePersistency("", FANGROUP_IS_DELETED, string5);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read FanGroup tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "createDualBoxCabinet()");
    }

    private void getAttributeValuesFromCabinetOne(Map map) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getAttributeValuesFromCabinetOne()");
        try {
            logger.traceGeneral(THIS_CLASS, "getAttributeValuesFromCabinetOne(): Get Cabinet table Data ");
            TableData tableData = tableHandler.getTableData(CABINET_MO_TYPE);
            if (tableData != null && tableData.isNotEmpty()) {
                logger.traceGeneral(THIS_CLASS, "getAttributeValuesFromCabinetOne(): set parameterMap with values from Cabinet=1 ");
                Map map2 = tableData.getRecordMap(0);
                map.put(CABINET_ATT_CABINET_PARAMETERS, map2.get(CABINET_ATT_CABINET_PARAMETERS).toString());
                map.put(CABINET_ATT_CLIMATE_CONTROL_MODE, map2.get(CABINET_ATT_CLIMATE_CONTROL_MODE).toString());
                map.put(CABINET_ATT_CLIMATE_SYSTEM, CLIMATE_SYSTEM_STANDARD);
                map.put(CABINET_ATT_PRODUCT_DATA, this.getPid());
                map.put(CABINET_ATT_SHARED_CABINET_IDENTIFIER, "");
                map.put(CABINET_ATT_SMOKE_DETECTOR, map2.get(CABINET_ATT_SMOKE_DETECTOR).toString());
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "getAttributeValuesFromCabinetOne()");
    }

    public void createFanGroupAction(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createFanGroupAction()");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        logger.traceGeneral(THIS_CLASS, "createFanGroupAction(): Set parameters for FanGroup ");
        hashMap.put("name", FANGROUP_MO_TYPE);
        hashMap.put("frotype", Integer.toString(117702657));
        hashMap.put("rdnValue", "1");
        hashMap.put("parentldn", DUALBOX_CABINET_LDN);
        hashMap.put("froid", Integer.toString(1));
        hashMap.put("parentRefExists", Boolean.FALSE.toString());
        logger.traceGeneral(THIS_CLASS, "createFanGroupAction(): Create FanGroup Mo ");
        CreateOneInstanceAction createOneInstanceAction = new CreateOneInstanceAction();
        createOneInstanceAction.setMoActionArgs(hashMap);
        createOneInstanceAction.convert(aueContext);
        logger.traceReturn(THIS_CLASS, "createFanGroupAction()");
    }

    private void updateEcPorts(TableHandler tableHandler) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "updateEcPorts()");
        logger.traceGeneral(THIS_CLASS, "updateEcPorts(): Get all EcPorts ");
        try {
            TableData tableData = tableHandler.getTableData(ECPORT_MO_TYPE);
            logger.traceGeneral(THIS_CLASS, "updateEcPorts(): Get all HubPositions ");
            Object[] objectArray = tableData.getAttributeValues(ECPORT_ATT_HUBPOSITION);
            Object[] objectArray2 = tableData.getAttributeValues("ldn");
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString();
                if (!"AUX NA".equals(string)) continue;
                logger.traceGeneral(THIS_CLASS, "updateEcPorts(): HubPosition equals AUX NA, Change to NA ");
                String string2 = this.getFroId(Integer.toString(117702672), DUALBOX_ECBUS_LDN, tableHandler);
                String string3 = this.getMoRef(ECPORT_ATT_ECBUS_REF, DUALBOX_ECBUS_LDN, Integer.toString(117702672), string2);
                tableHandler.storeInAuePersistency("", AUX_SUP_LDN, objectArray2[i].toString());
                tableData.setAttributeValue(i, ECPORT_ATT_ECBUS_REF, (Object)string3);
                tableData.setAttributeValue(i, ECPORT_ATT_HUBPOSITION, (Object)"NA");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to find read EcPort tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "updateEcPorts()");
    }

    private String getFroId(String string, String string2, TableHandler tableHandler) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFroId()");
        String string3 = null;
        try {
            logger.traceGeneral(THIS_CLASS, "getFroId(): Get " + string + " table data");
            TableData tableData = tableHandler.getTableData(string);
            logger.traceGeneral(THIS_CLASS, "getFroId(): FroId");
            if (tableData.getNumberOfRecords() == 0) {
                string3 = CLIMATE_SYSTEM_STANDARD;
            } else {
                Object[] objectArray = tableData.getAttributeValues("ldn");
                Object[] objectArray2 = tableData.getAttributeValues("froid");
                logger.traceGeneral(THIS_CLASS, "getFroId(): Find FroId for ldn: " + string2);
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].toString().equals(string2)) continue;
                    string3 = objectArray2[i].toString();
                }
            }
            if (string3 == null) {
                throw new CrbsAueException("The froId for MO " + string + " could not be found in the database");
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("Failed to read " + string + " tabledata.", (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "getFroId()");
        return string3;
    }

    private String getMoRef(String string, String string2, String string3, String string4) {
        logger.traceEnter(THIS_CLASS, "getMoRef()");
        String string5 = "<moref name=\"" + string + "\">" + "<attr name=\"ldn\" type=\"STRING\" value=\"" + string2 + "\"/>" + "<attr name=\"froType\" type=\"S32\" value=\"" + string3 + "\"/>" + "<attr name=\"froId\" type=\"S32\" value=\"" + string4 + "\"/>" + "</moref>";
        logger.traceReturn(THIS_CLASS, "getMoRef()");
        return string5;
    }

    private String getPiuFroId(String string) {
        logger.traceEnter(THIS_CLASS, "getPiuFroId ");
        MoRepositoryWrapper moRepositoryWrapper = MoRepositoryWrapperFactory.getMoRepositoryWrapper();
        MoIterator moIterator = moRepositoryWrapper.lookupType(PLUG_IN_UNIT_MO_TYPE);
        String string2 = null;
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!managedObject.getLocalDistinguishedName().equals(string)) continue;
            try {
                Integer n = (Integer)managedObject.getAttribute(PLUG_IN_UNIT_FRO_ID_ATTR_NAME, null);
                string2 = String.valueOf(n);
                break;
            }
            catch (MoAccessException moAccessException) {
            }
        }
        logger.traceReturn(THIS_CLASS, "getPiuFroId()");
        return string2;
    }

    private FroAttributes[] getEcBusFroAttributes() {
        logger.traceEnter(THIS_CLASS, "getFroAttributes() invoked");
        ArrayList<FroAttributes> arrayList = new ArrayList<FroAttributes>();
        arrayList.add(new FroAttributes(117702672, ECBUS_ATT_CONNECTION_TYPE, new String("string")));
        arrayList.add(new FroAttributes(117702672, ECBUS_ATT_CONNECTOR_REF, new String("moRef")));
        FroAttributes[] froAttributesArray = arrayList.toArray(new FroAttributes[arrayList.size()]);
        logger.traceReturn(THIS_CLASS, "ecBusFroAttributes() executed");
        return froAttributesArray;
    }

    private FroAttributes[] getCabinetFroAttributes() {
        logger.traceEnter(THIS_CLASS, "getCabinetFroAttributes() invoked");
        ArrayList<FroAttributes> arrayList = new ArrayList<FroAttributes>();
        arrayList.add(new FroAttributes(0x7040000, CABINET_ATT_CLIMATE_CONTROL_MODE, new String("S32")));
        arrayList.add(new FroAttributes(0x7040000, CABINET_ATT_CLIMATE_SYSTEM, new String("S32")));
        arrayList.add(new FroAttributes(0x7040000, CABINET_ATT_PRODUCT_DATA, new String("struct")));
        arrayList.add(new FroAttributes(0x7040000, CABINET_ATT_SHARED_CABINET_IDENTIFIER, new String("string")));
        arrayList.add(new FroAttributes(0x7040000, CABINET_ATT_SMOKE_DETECTOR, new String("S32")));
        arrayList.add(new FroAttributes(0x7040000, CABINET_ATT_CABINET_PARAMETERS, new String("string")));
        FroAttributes[] froAttributesArray = arrayList.toArray(new FroAttributes[arrayList.size()]);
        logger.traceReturn(THIS_CLASS, "getCabinetFroAttributes() executed");
        return froAttributesArray;
    }

    private void setPosRefOnSUPs(TableHandler tableHandler) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "setPosRefOnSUPs()");
        try {
            TableData tableData = tableHandler.getTableData(HW_UNIT);
            Object[] objectArray = tableData.getAttributeValues(HWUNIT_ATT_HWUTYPE);
            Object[] objectArray2 = tableData.getAttributeValues("ldn");
            for (int i = 0; i < objectArray.length; ++i) {
                String string = objectArray[i].toString();
                if ("SUP".equals(string) || "SCU".equals(string)) {
                    String string2;
                    String string3;
                    logger.traceGeneral(THIS_CLASS, "setPosRefOnSUPs(): hwUnitType is equal SUP or SCu LDN: " + objectArray2[i].toString());
                    if (objectArray2[i].toString().equals("ManagedElement=1,Equipment=1,HwUnit=SUP-1")) {
                        string3 = this.getMoRef(HWUNIT_ATT_POSREF, DEFAULT_CABINET_LDN, Integer.toString(0x7040000), Integer.toString(0));
                        logger.traceGeneral(THIS_CLASS, "setPosRefOnSUPs(): Inside First loop");
                        string2 = TableDataUtil.getLdnFromMoRef((String)string3);
                        tableHandler.storeInAuePersistency(objectArray2[i].toString(), HWUNIT_ATT_POSREF, string2);
                        tableData.setAttributeValue(i, HWUNIT_ATT_POSREF, (Object)string3);
                        continue;
                    }
                    if (objectArray2[i].toString().equals("ManagedElement=1,Equipment=1,HwUnit=SUP-2")) {
                        string3 = this.getMoRef(HWUNIT_ATT_POSREF, DUALBOX_CABINET_LDN, Integer.toString(0x7040000), Integer.toString(1));
                        string2 = TableDataUtil.getLdnFromMoRef((String)string3);
                        tableHandler.storeInAuePersistency(objectArray2[i].toString(), HWUNIT_ATT_POSREF, string2);
                        tableData.setAttributeValue(i, HWUNIT_ATT_POSREF, (Object)string3);
                        continue;
                    }
                    logger.traceGeneral(THIS_CLASS, "setPosRefOnSUPs(): If not SUP-1 or SUP-2: Ldn= " + objectArray2[i].toString());
                    tableHandler.storeInAuePersistency(objectArray2[i].toString(), HWUNIT_ATT_POSREF, EMPTY_LDN);
                    continue;
                }
                logger.traceGeneral(THIS_CLASS, "setPosRefOnSUPs(): Else: Ldn= " + objectArray2[i].toString());
                tableHandler.storeInAuePersistency(objectArray2[i].toString(), HWUNIT_ATT_POSREF, EMPTY_LDN);
            }
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
        logger.traceReturn(THIS_CLASS, "setPosRefOnSUPs()");
    }

    static {
        logger = LoggingService.getLogger((String)THIS_CLASS.getName());
        PLUG_IN_UNIT_FRO_TYPE = Integer.toString(0);
    }

    private class FroAttributes {
        private final int froTypeId;
        private final String attrName;
        private final String attrType;

        FroAttributes(int n, String string, String string2) {
            this.froTypeId = n;
            this.attrName = string;
            this.attrType = string2;
        }
    }
}

