/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step1.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.aueframework.common.AueContext;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.LdnUtil;
import se.ericsson.crbs.omf.aue.step1.actions.AbstractConversionAction;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableData;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandler;

public class RemoveUnusedFunctionalMosAction
extends AbstractConversionAction {
    private static final Class THIS_CLASS = RemoveUnusedFunctionalMosAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public void convert(AueContext aueContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "convert()");
        ArrayList arrayList = new ArrayList();
        TableHandler tableHandler = (TableHandler)aueContext.getAttribute("CURRENT_TABLE_HANDLER");
        TableData tableData = this.getTableData(tableHandler, "hwUnit");
        this.removeUnusedBatteryBackup(tableHandler, tableData, arrayList);
        this.informStep2(arrayList, tableHandler);
        logger.traceReturn(THIS_CLASS, "convert()");
    }

    private void removeUnusedBatteryBackup(TableHandler tableHandler, TableData tableData, List list) throws CrbsAueException {
        if (this.findNoHwus(tableData, "BFU") == 0 && this.findNoHwus(tableData, "PDU") == 0) {
            TableData tableData2 = this.getTableData(tableHandler, "batteryBackup");
            for (int i = 0; i < tableData2.getNumberOfRecords(); ++i) {
                try {
                    Map map = tableData2.getRecordMap(i);
                    String string = (String)map.get("ldn");
                    list.add(string);
                    continue;
                }
                catch (TableDataException tableDataException) {
                    throw new CrbsAueException("It is not possible to get the table data: ", (Throwable)tableDataException);
                }
            }
        }
    }

    private TableData getTableData(TableHandler tableHandler, String string) throws CrbsAueException {
        TableData tableData;
        try {
            tableData = tableHandler.getTableData(string);
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException("It is not possible to get the table data: " + string, (Throwable)tableDataException);
        }
        return tableData;
    }

    private int findNoHwus(TableData tableData, String string) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "findNoHwus()");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < tableData.getNumberOfRecords(); ++i) {
            Map map;
            try {
                map = tableData.getRecordMap(i);
            }
            catch (TableDataException tableDataException) {
                throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
            }
            String string2 = (String)map.get("unitType");
            if (!string2.equals(string)) continue;
            String string3 = (String)map.get("ldn");
            arrayList.add(string3);
        }
        logger.info(THIS_CLASS, "findNoHwus(): hwuArrayList.size: " + arrayList.size());
        logger.traceReturn(THIS_CLASS, "findNoHwus()");
        return arrayList.size();
    }

    private void informStep2(ArrayList arrayList, TableHandler tableHandler) throws CrbsAueException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        String string2 = "";
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            string2 = LdnUtil.getRdnValue((String)string);
            stringBuffer.append((stringBuffer.length() > 0 ? " " : "") + string2);
        }
        try {
            logger.info(THIS_CLASS, "informStep2, storeing in Auepersistency: " + stringBuffer.toString());
            tableHandler.storeInAuePersistency("", "mosToRemove", stringBuffer.toString());
        }
        catch (TableDataException tableDataException) {
            throw new CrbsAueException(tableDataException.getMessage(), (Throwable)tableDataException);
        }
    }
}

