/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.view.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class LeftDotRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1881731976025016056L;

    LeftDotRenderer() {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int availableWidth = table.getColumnModel().getColumn(column).getWidth();
        availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
        Insets borderInsets = this.getBorder().getBorderInsets(this);
        String cellText = this.getText();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
            int nChars;
            String dots = "...";
            int textWidth = fm.stringWidth(dots);
            for (nChars = cellText.length() - 1; nChars > 0 && (textWidth += fm.charWidth(cellText.charAt(nChars))) <= availableWidth; --nChars) {
            }
            this.setText(dots + cellText.substring(nChars + 1));
        }
        return this;
    }
}

