/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.proxy;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SignalHelper;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.proxy.OseSenderReceiver;
import se.ericsson.lte.rbs.omf.common.proxy.SignalException;

public class OseSenderReceiverImpl
implements OseSenderReceiver {
    private static final Class THIS_CLASS = OseSenderReceiverImpl.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public InSignal receiveSignal(SignalRegistry signalRegistry, int n) {
        InSignal inSignal = ThisProcess.receive((SignalRegistry)signalRegistry, (int)n);
        if (inSignal != null) {
            logger.traceDebug(THIS_CLASS, "Got signal " + Integer.toString(inSignal.getSigNo()));
        }
        return inSignal;
    }

    public void sendSignal(OseProcess oseProcess, OseProcess oseProcess2, Signal signal) throws SignalException {
        if (signal == null) {
            logger.traceError(THIS_CLASS, "No signal specified !");
            throw new SignalException("No signal specified !");
        }
        if (oseProcess == null) {
            String string = "No sender specified. Failed to send signal [" + signal.getClass().getName() + "]";
            logger.traceError(THIS_CLASS, string);
            throw new SignalException(string);
        }
        if (oseProcess2 == null) {
            String string = "No receiver specified. Failed to send signal [" + signal.getClass().getName() + "]";
            logger.traceError(THIS_CLASS, string);
            throw new SignalException(string);
        }
        logger.traceGeneral(THIS_CLASS, "Sending signal " + signal.getClass().getName() + " (" + signal.getSigNo() + ") to PID " + oseProcess2.getPID());
        SignalHelper.sendWithSender((OseProcess)oseProcess2, (OseProcess)oseProcess, (Signal)signal);
    }

    public OseProcess getThisProcess() {
        return ThisProcess.getThisProcess();
    }

    public OseProcess getSender(InSignal inSignal) {
        return inSignal.getSender();
    }

    public void addServiceToOseNameServer(String string) {
        OseNameServer.addService((String)string);
    }

    public void removeServiceFromOseNameServer(String string) {
        OseNameServer.removeService((String)string);
    }
}

