/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AttributeValidator;

public abstract class AbstractAttributeValidator
implements AttributeValidator {
    private static final Class THIS_CLASS = AbstractAttributeValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    protected String attributeName;
    private final String subClassName;
    private final boolean shouldValidateAtCreate;
    private final boolean shouldValidateAtPrepare;
    private final boolean shouldValidateAtDelete;

    public AbstractAttributeValidator(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        logger.traceEnter(THIS_CLASS, "constructor(attribute[" + string2 + "], validateAtCreate[" + bl + "], validateAtPrepare[" + bl2 + "], validateAtDelete[" + bl3 + "])");
        this.subClassName = string;
        this.attributeName = string2;
        this.shouldValidateAtCreate = bl;
        this.shouldValidateAtPrepare = bl2;
        this.shouldValidateAtDelete = bl3;
        logger.traceReturn(THIS_CLASS, "constructor()");
    }

    protected abstract void validate(ManagedObject var1, Coordinator var2) throws PrepareFailedException, MoAccessException;

    protected void logAndThrowPrepareFailedException(String string) throws PrepareFailedException {
        this.logMessage(string);
        throw new PrepareFailedException(string);
    }

    protected void logMessage(String string) {
        logger.info(THIS_CLASS, string);
    }

    public void handlePostSet(ManagedObject managedObject, String string, Object object) throws MoAccessException {
        logger.traceEnter(THIS_CLASS, "handlePostSet(ManagedObject " + managedObject + ", attribute " + string + ", value " + object + ")");
        logger.traceReturn(THIS_CLASS, "handlePostSet(ManagedObject " + managedObject + ")");
    }

    public void validateAtCreate(ManagedObject managedObject, Object object, AttrList attrList, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtCreate(ManagedObject " + managedObject + " ,...)");
        if (this.shouldValidateAtCreate) {
            try {
                this.validate(managedObject, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new PrepareFailedException("Got exception at validateAtCreate for validator " + this.subClassName + " [" + THIS_CLASS.getName() + "], exception: " + (Object)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "validateAtCreate()");
    }

    public void validateAtPrepare(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ", shouldValidateAtPrepare " + this.shouldValidateAtPrepare + ")");
        if (this.shouldValidateAtPrepare) {
            try {
                this.validate(managedObject, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new PrepareFailedException("Got exception at validateAtPrepare for validator " + this.subClassName + " [" + THIS_CLASS.getName() + "], exception: " + (Object)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
    }

    public void validateAtDelete(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtDelete(ManagedObject " + managedObject + ", shouldValidateAtDelete " + this.shouldValidateAtDelete + ")");
        if (this.shouldValidateAtDelete) {
            try {
                this.validate(managedObject, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new PrepareFailedException("Got exception at validateAtDelete for validator " + this.subClassName + " [" + THIS_CLASS.getName() + "], exception: " + (Object)((Object)moAccessException));
            }
        }
        logger.traceReturn(THIS_CLASS, "validateAtDelete(ManagedObject " + managedObject + ")");
    }
}

