/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class ArfcnValueAndBandIndicatorValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = ArfcnValueAndBandIndicatorValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final int BAND_GSM450_LOWER_LIMIT = 259;
    private static final int BAND_GSM450_UPPER_LIMIT = 293;
    private static final int BAND_GSM480_LOWER_LIMIT = 306;
    private static final int BAND_GSM480_UPPER_LIMIT = 340;
    private static final int BAND_GSM750_LOWER_LIMIT = 438;
    private static final int BAND_GSM750_UPPER_LIMIT = 511;
    private static final int BAND_GSM850_LOWER_LIMIT = 128;
    private static final int BAND_GSM850_UPPER_LIMIT = 251;
    private static final int BAND_1_GSM900_LOWER_LIMIT = 0;
    private static final int BAND_1_GSM900_UPPER_LIMIT = 124;
    private static final int BAND_2_GSM900_LOWER_LIMIT = 955;
    private static final int BAND_2_GSM900_UPPER_LIMIT = 1023;
    private static final int BAND_GSM1800_LOWER_LIMIT = 512;
    private static final int BAND_GSM1800_UPPER_LIMIT = 885;
    private static final int BAND_GSM1900_LOWER_LIMIT = 512;
    private static final int BAND_GSM1900_UPPER_LIMIT = 810;
    private static final String BAND_GSM500 = "GSM500";
    private static final String BAND_GSM700 = "GSM700";
    private static final String BAND_GSM850 = "GSM850";
    private static final String BAND_GSM900 = "GSM900";
    private static final String BAND_GSM1800 = "GSM1800";
    private static final String BAND_GSM1900 = "GSM1900";
    private static final String NO_VALID_BAND = "No valid band";
    private static final Integer BAND_INDICATOR_DCS_1800 = new Integer(0);
    private static final Integer BAND_INDICATOR_PCS_1900 = new Integer(1);
    private static final String BAND_INDICATOR = "bandIndicator";
    private static final String ARFCN_VALUE_GERAN_DL = "arfcnValueGeranDl";
    private static final String GERAN_FREQ_GROUP_REF = "geranFreqGroupRef";
    private static final String RESERVED_BY = "reservedBy";
    private static final String GERAN_FREQUENCY_TYPE = "GeranFrequency";

    public ArfcnValueAndBandIndicatorValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
        Integer n = (Integer)managedObject.getAttribute(BAND_INDICATOR, coordinator);
        Integer n2 = (Integer)managedObject.getAttribute(ARFCN_VALUE_GERAN_DL, coordinator);
        this.validateArfcnValueAndBandIndicator(managedObject, n2, n, coordinator);
        logger.traceReturn(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
    }

    private void validateArfcnValueAndBandIndicator(ManagedObject managedObject, int n, Integer n2, Coordinator coordinator) throws PrepareFailedException, NoSuchAttributeException, MoAccessException {
        String string = this.findBandName(n, n2);
        if (this.bandName1800or1900(string)) {
            ManagedObject[] managedObjectArray = (ManagedObject[])managedObject.getAttribute(GERAN_FREQ_GROUP_REF, coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ManagedObject[] managedObjectArray2 = (ManagedObject[])managedObjectArray[i].getAttribute(RESERVED_BY, coordinator);
                List list = this.extractGeranFrequencies(managedObjectArray2);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ManagedObject managedObject2 = (ManagedObject)iterator.next();
                    if (!this.isMoValid(managedObject, managedObject2)) continue;
                    int n3 = (Integer)managedObject2.getAttribute(ARFCN_VALUE_GERAN_DL, coordinator);
                    Integer n4 = (Integer)managedObject2.getAttribute(BAND_INDICATOR, coordinator);
                    String string2 = this.findBandName(n3, n4);
                    this.validateCombinationOfBands(string, string2);
                }
            }
        }
    }

    private List extractGeranFrequencies(ManagedObject[] managedObjectArray) {
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (!GERAN_FREQUENCY_TYPE.equals(managedObjectArray[i].getType())) continue;
            arrayList.add(managedObjectArray[i]);
        }
        return arrayList;
    }

    private boolean isMoValid(ManagedObject managedObject, ManagedObject managedObject2) {
        return MoCheck.isMoReadable(managedObject2) && !managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName());
    }

    private String findBandName(int n, Integer n2) throws PrepareFailedException, NoSuchAttributeException, MoAccessException {
        String string;
        if (this.isArfcnValueInRange(n, 259, 293, 306, 340)) {
            string = BAND_GSM500;
        } else if (this.isArfcnValueInRange(n, 438, 511)) {
            string = BAND_GSM700;
        } else if (this.isArfcnValueInRange(n, 128, 251)) {
            string = BAND_GSM850;
        } else if (this.isArfcnValueInRange(n, 0, 124, 955, 1023)) {
            string = BAND_GSM900;
        } else if (this.isArfcnValueInRange(n, 512, 885)) {
            string = this.findBandName1800or1900(n, n2);
        } else {
            string = NO_VALID_BAND;
            this.logAndThrowPrepareFailedException("No valid band name found for this GeranFrequency MO. Invalid arcfnValueGeranDl value.");
        }
        return string;
    }

    private String findBandName1800or1900(int n, Integer n2) throws PrepareFailedException, NoSuchAttributeException, MoAccessException {
        String string;
        if (this.isArfcnValueInRange(n, 512, 810) && n2.equals(BAND_INDICATOR_PCS_1900)) {
            string = BAND_GSM1900;
        } else if (n2.equals(BAND_INDICATOR_DCS_1800)) {
            string = BAND_GSM1800;
        } else {
            string = NO_VALID_BAND;
            this.logAndThrowPrepareFailedException("Invalid combination of arcfnValueGeranDl (GSM1800) and bandIndicator (PCS_1900).");
        }
        return string;
    }

    private boolean bandName1800or1900(String string) {
        return string.equals(BAND_GSM1900) || string.equals(BAND_GSM1800);
    }

    private void validateCombinationOfBands(String string, String string2) throws PrepareFailedException {
        if (this.bandName1800or1900(string2) && !string.equals(string2)) {
            this.logAndThrowPrepareFailedException("Not possible to include Geran Frequencies from both band 1800 and 1900 within the same GeranFreqGroup.");
        }
    }

    private boolean isArfcnValueInRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    private boolean isArfcnValueInRange(int n, int n2, int n3, int n4, int n5) {
        return n >= n2 && n <= n3 || n >= n4 && n <= n5;
    }
}

