/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class AttributesCorrelationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = AttributesCorrelationValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private final String[] CorrelationAttributesNames;

    public AttributesCorrelationValidator(String string, String[] stringArray) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.CorrelationAttributesNames = stringArray;
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        if (this.attributeName.equalsIgnoreCase("qQualMin")) {
            this.validateQqualMin(managedObject, coordinator);
        } else if (this.attributeName.equalsIgnoreCase("systemInformationBlock3")) {
            this.validateThservingLowQ(managedObject, coordinator);
        }
    }

    private void validateQqualMin(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        Integer n = (Integer)managedObject.getAttribute(this.attributeName, coordinator);
        Struct struct = (Struct)managedObject.getAttribute(this.CorrelationAttributesNames[0], coordinator);
        String[] stringArray = struct.getNames();
        Object[] objectArray = struct.getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"threshServingLowQ".equals(stringArray[i])) continue;
            Integer n2 = (Integer)objectArray[i];
            logger.traceAbnormal(THIS_CLASS, "come in threshServingLowQ=" + n2);
            logger.traceAbnormal(THIS_CLASS, "come in QqualMin=" + n);
            if (n2 == 1000 || 0 != n) break;
            this.logAndThrowPrepareFailedException("When threshServingLowQ is exist ,QqualMin Should not be set to 0");
            break;
        }
    }

    private void validateThservingLowQ(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        Integer n = (Integer)managedObject.getAttribute(this.CorrelationAttributesNames[0], coordinator);
        Struct struct = (Struct)managedObject.getAttribute(this.attributeName, coordinator);
        logger.traceAbnormal(THIS_CLASS, "validate the SYSTEM_INFORMATION_BLOCK3_ATTRIBUTE  threshServingLowQ");
        String[] stringArray = struct.getNames();
        Object[] objectArray = struct.getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"threshServingLowQ".equals(stringArray[i])) continue;
            Integer n2 = (Integer)objectArray[i];
            if (n2 == 1000 || 0 != n) break;
            this.logAndThrowPrepareFailedException("When  threshServingLowQ  exist, qQualMin Should  exist ,");
            break;
        }
    }
}

