/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.NotHandledAttributeTypeException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class CellReselectionPrioValidator
extends AbstractAttributeValidator {
    private static final String CELL_RESELECTION_PRIORITY = "cellReselectionPriority";
    private static final int VALUE_TO_IGNORE = -1000;
    private static final Class THIS_CLASS = CellReselectionPrioValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public CellReselectionPrioValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
        Struct[] structArray = (Struct[])managedObject.getAttribute(this.attributeName, coordinator);
        String[] stringArray = new String[]{"freqPrioListUTRA", "bandClassPrioListCDMA2000", "freqPrioListEUTRA", "freqGroupPrioListGERAN"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.attributeName.equals(stringArray[i])) continue;
            Struct[] structArray2 = (Struct[])managedObject.getAttribute(stringArray[i], coordinator);
            for (int j = 0; j < structArray.length; ++j) {
                Struct struct = structArray[j];
                Integer n = (Integer)struct.getValue(CELL_RESELECTION_PRIORITY);
                this.conflictingCellReselectionPrio(structArray2, n);
            }
        }
        logger.traceReturn(THIS_CLASS, "validateAtPrepare(ManagedObject " + managedObject + ")");
    }

    private void conflictingCellReselectionPrio(Struct[] structArray, Integer n) throws NotHandledAttributeTypeException, NoSuchFieldException, MoNotFoundException, PrepareFailedException {
        if (n != -1000) {
            for (int i = 0; i < structArray.length; ++i) {
                Integer n2 = (Integer)structArray[i].getValue(CELL_RESELECTION_PRIORITY);
                if (!n2.equals(n)) continue;
                String string = "The cellReselectionPriority [" + n + "] must be unique between RATs.";
                this.logAndThrowPrepareFailedException(string);
            }
        }
    }
}

