/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class CommonSrPeriodicityVsDlChannelBandwidthValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = CommonSrPeriodicityVsDlChannelBandwidthValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String COMMON_SR_PERIODICITY = "commonSrPeriodicity";
    private static final String DL_CHANNEL_BANDWIDTH = "dlChannelBandwidth";

    public CommonSrPeriodicityVsDlChannelBandwidthValidator(String string) {
        super(THIS_CLASS.getName(), string, true, true, false);
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate(ManagedObject " + managedObject + ")");
        Integer n = (Integer)managedObject.getAttribute(DL_CHANNEL_BANDWIDTH, coordinator);
        Integer n2 = (Integer)managedObject.getAttribute(COMMON_SR_PERIODICITY, coordinator);
        if (n2 == 5 && n == 1400) {
            this.logAndThrowPrepareFailedException("The combination of commonSrPeriodicity = " + n2 + " and dlChannelBandwidth = " + n + " is not a valid combination");
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }
}

