/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class CorrectCdma2000FreqRefValidator
extends AbstractAttributeValidator {
    private static final String CDMA2000_FREQ_BAND_REF = "cdma2000FreqBandRef";
    private static final String CDMA2000_FREQ_REF = "cdma2000FreqRef";
    private static final Class THIS_CLASS = CorrectCdma2000FreqRefValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public CorrectCdma2000FreqRefValidator(String string) {
        super(THIS_CLASS.getName(), string, true, false, false);
        logger.traceEnter(THIS_CLASS, "CorrectCdma2000FreqRef()");
        logger.traceReturn(THIS_CLASS, "CorrectCdma2000FreqRef()");
    }

    public void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validateAtCreate()");
        ManagedObject managedObject2 = ((ManagedObject)managedObject.getAttribute(CDMA2000_FREQ_REF, coordinator)).getParent();
        ManagedObject managedObject3 = (ManagedObject)managedObject.getParent().getAttribute(CDMA2000_FREQ_BAND_REF, coordinator);
        if (!managedObject2.getLocalDistinguishedName().equals(managedObject3.getLocalDistinguishedName())) {
            String string = "The " + managedObject.getType() + " with LDN " + managedObject.getLocalDistinguishedName() + " can not be created due to a consistency check failure! The " + managedObject.getType() + " references to a Cdma2000Freq" + " which has a Cdma2000FreqBand as parent." + " This MO (Cdma2000FreqBand) must be the same as the parent of the " + managedObject.getType() + " (" + managedObject.getParent().getType() + ") reference to the Cdma2000FreqBand.";
            this.logAndThrowPrepareFailedException(string);
        }
        logger.traceReturn(THIS_CLASS, "validateAtCreate()");
    }
}

