/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.genericmo.GenericMaoContext;
import se.ericsson.lte.rbs.omf.common.attributehandling.MoCheck;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class DrxProfileValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = DrxProfileValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String DRX_PRIORITY = "drxPriority";
    private static final String DRX_PROFILE_REF = "drxProfileRef";
    private final String[] moTypes;
    private final GenericMaoContext genericMaoContext;

    public DrxProfileValidator(String string, String[] stringArray, GenericMaoContext genericMaoContext) {
        super(THIS_CLASS.getName(), string, false, true, false);
        this.moTypes = stringArray;
        this.genericMaoContext = genericMaoContext;
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws PrepareFailedException, MoAccessException {
        logger.traceEnter(THIS_CLASS, "validate()");
        Object object = managedObject.getAttribute(DRX_PRIORITY, coordinator);
        ManagedObject managedObject2 = (ManagedObject)managedObject.getAttribute(DRX_PROFILE_REF, coordinator);
        for (int i = 0; i < this.moTypes.length; ++i) {
            MoIterator moIterator = this.genericMaoContext.getMoRepositoryWrapper().lookupType(this.moTypes[i]);
            this.checkAttributes(object, managedObject2, moIterator, managedObject, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void checkAttributes(Object object, ManagedObject managedObject, MoIterator moIterator, ManagedObject managedObject2, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "checkAttributes()");
        while (moIterator != null && moIterator.hasMoreElements()) {
            Object object2;
            ManagedObject managedObject3;
            ManagedObject managedObject4 = moIterator.nextMo();
            if (MoCheck.isMoNotReadable(managedObject4) || managedObject2.equals(managedObject4) || !this.shouldCompareValues(managedObject, managedObject3 = (ManagedObject)managedObject4.getAttribute(DRX_PROFILE_REF, coordinator)) || !(object2 = managedObject4.getAttribute(DRX_PRIORITY, coordinator)).equals(object)) continue;
            String string = "The drxPriority [" + object + "] has to be unique across all the configured QciProfilePredefined and " + "QciProfileOperatorDefined MOC instances except for instances where the drxProfileId is the same";
            this.logAndThrowPrepareFailedException(string);
        }
        logger.traceReturn(THIS_CLASS, "checkAttributes()");
    }

    private boolean shouldCompareValues(ManagedObject managedObject, ManagedObject managedObject2) {
        logger.traceEnter(THIS_CLASS, "shouldCompareValues()");
        boolean bl = true;
        if (managedObject == null && managedObject2 == null) {
            bl = false;
        }
        if (managedObject != null && managedObject2 != null && managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
            bl = false;
        }
        logger.traceReturn(THIS_CLASS, "shouldCompareValues(result=" + bl + ")");
        return bl;
    }
}

