/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;

public class EUtranFreqRelationDeleteValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = EUtranFreqRelationDeleteValidator.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ARFCN_VALUE_EUTRAN_DL_ATTR_NAME = "arfcnValueEUtranDl";
    private static final String EUTRAN_FREQUENCY_REF_ATTR_NAME = "eutranFrequencyRef";
    private static final String ADMIN_STATE_ATTR_NAME = "administrativeState";
    private static final String MO_ATTR_IDLE_MODE_PRIO_AT_RELEASE_REF = "idleModePrioAtReleaseRef";
    private static final Integer UNLOCKED = new Integer(1);

    public EUtranFreqRelationDeleteValidator(String string) {
        super(THIS_CLASS.getName(), string, false, false, true);
        logger.traceEnter(THIS_CLASS, "EUtranFreqRelationDeleteValidator()");
        logger.traceReturn(THIS_CLASS, "EUtranFreqRelationDeleteValidator()");
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        ManagedObject managedObject2 = this.getEutranFrequencyRef(managedObject, coordinator);
        if (managedObject2 != null) {
            ManagedObject managedObject3 = managedObject.getParent();
            String string = this.attributeName;
            Integer n = (Integer)managedObject2.getAttribute(ARFCN_VALUE_EUTRAN_DL_ATTR_NAME, coordinator);
            Integer n2 = (Integer)managedObject3.getAttribute(string, coordinator);
            Integer n3 = (Integer)managedObject3.getAttribute(ADMIN_STATE_ATTR_NAME, coordinator);
            if (n3.equals(UNLOCKED) && n2.equals(n)) {
                String string2 = "It is only allowed to remove the EUtranFreqRelation, referring to the same frequency [" + managedObject2.getLocalDistinguishedName() + "] as the parent MO EUtranCellFDD/EUtranCellTDD [" + managedObject3.getLocalDistinguishedName() + "] has, when the EUtranCellFDD/EUtranCellTDD is locked.";
                this.logAndThrowPrepareFailedException(string2);
            }
            this.validateWithIdleModePrioAtRelease(managedObject3, managedObject2, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }

    private void validateWithIdleModePrioAtRelease(ManagedObject managedObject, ManagedObject managedObject2, Coordinator coordinator) throws PrepareFailedException, NoSuchAttributeException, MoAccessException {
        ManagedObject managedObject3 = (ManagedObject)managedObject.getAttribute(MO_ATTR_IDLE_MODE_PRIO_AT_RELEASE_REF, coordinator);
        if (managedObject3 != null) {
            ManagedObject[] managedObjectArray = (ManagedObject[])managedObject2.getAttribute("reservedBy", coordinator);
            for (int i = 0; i < managedObjectArray.length; ++i) {
                if (!managedObjectArray[i].equals(managedObject3)) continue;
                String string = "It is not allowed to remove the EUtranFreqRelation, referring to the frequency [" + managedObject2.getLocalDistinguishedName() + "], since the frequency " + "is still reserved by the IdleModePrioAtRelease MO [" + managedObject3.getLocalDistinguishedName() + "], which the parent MO EUtranCellFDD/EUtranCellTDD [" + managedObject.getLocalDistinguishedName() + "] points out via idleModePrioAtReleaseRef. Change it to continue.";
                this.logAndThrowPrepareFailedException(string);
            }
        }
    }

    private ManagedObject getEutranFrequencyRef(ManagedObject managedObject, Coordinator coordinator) throws NoSuchAttributeException, MoAccessException {
        ManagedObject managedObject2 = null;
        try {
            managedObject2 = (ManagedObject)managedObject.getAttribute(EUTRAN_FREQUENCY_REF_ATTR_NAME, coordinator);
        }
        catch (MoRemovedException moRemovedException) {
            String string = "Cannot validate due to exception: " + (Object)((Object)moRemovedException);
            this.logMessage(string);
        }
        return managedObject2;
    }
}

