/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.lte.rbs.omf.common.validator;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.PrepareFailedException;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.lte.rbs.omf.common.validator.AbstractAttributeValidator;
import se.ericsson.lte.rbs.omf.mao.qciprofileoperatordefined.QciProfileOperatorDefinedMaoImpl;
import se.ericsson.lte.rbs.omf.mao.qciprofilepredefined.QciProfilePredefinedMaoImpl;

public class EUtranFreqToQciProfileRelationValidator
extends AbstractAttributeValidator {
    private static final Class THIS_CLASS = EUtranFreqToQciProfileRelationValidator.class;
    private static final String E_UTRAN_FREQ_TO_QCI_PROFILE_RELATION = "eutranFreqToQciProfileRelation";
    private static final String QCI_PROFILE_REF = "qciProfileRef";
    private static final String MESSAGE = "qciProfileRef can not be null";
    private static final String WRONG_TYPE_MESSAGE = "Parameter qciProfileRef is of wrong type,qciProfileRef type need to be QciProfilePredefined or QciProfileOperatorDefined";
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());

    public EUtranFreqToQciProfileRelationValidator(String string) {
        super(THIS_CLASS.getName(), string, false, true, false);
    }

    protected void validate(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, PrepareFailedException {
        logger.traceEnter(THIS_CLASS, "validate()");
        Struct[] structArray = (Struct[])managedObject.getAttribute(E_UTRAN_FREQ_TO_QCI_PROFILE_RELATION, coordinator);
        if (structArray != null) {
            for (int i = 0; i < structArray.length; ++i) {
                Struct struct = structArray[i];
                Object object = struct.getValue(QCI_PROFILE_REF);
                if (object == null) {
                    this.logAndThrowPrepareFailedException(MESSAGE);
                    continue;
                }
                if (object instanceof QciProfilePredefinedMaoImpl || object instanceof QciProfileOperatorDefinedMaoImpl) continue;
                throw new WrongAttributeTypeException(QCI_PROFILE_REF, WRONG_TYPE_MESSAGE);
            }
        }
        logger.traceReturn(THIS_CLASS, "validate()");
    }
}

